/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Collection;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.validators.OracleTableValidator;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ViewValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterializedViewValidator
extends OracleTableValidator<MaterializedView> {
    public MaterializedViewValidator(DBObjectProvider prov) {
        super(prov);
    }

    protected void validateNameInUse(MaterializedView object) throws NameInUseException {
        if (object.getOnPrebuilt() == MaterializedView.PrebuiltType.NONE) {
            super.validateNameInUse((DBObject)object);
        }
    }

    @DBObjectValidator.PropertyValidator(value={"SQLQuery"})
    public void validateQuery(MaterializedView original, MaterializedView mview) throws ValidationException {
        ViewValidator.validateQuery((SQLQueryOwner)mview, this.getProvider());
    }

    @DBObjectValidator.PropertyValidator(value={"buildType"})
    public void validateBuildType(MaterializedView original, MaterializedView mview) throws ValidationException {
        if (mview.getBuildType() == null) {
            throw new ValidationException((DBObject)mview, APIBundle.get((String)"MVIEW_ERROR_MISSING_BUILD_TYPE"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"keyType"})
    public void validateKeyType(MaterializedView original, MaterializedView mview) throws ValidationException {
        SQLQuery query;
        if (MaterializedView.RefreshWith.ROWID.equals((Object)mview.getKeyType()) && (query = mview.getSQLQuery()) != null && query.getFromObjects().length > 0) {
            boolean ok = true;
            if (query.getFromObjects().length != 1 || query.getFromObjects()[0].getExpression() instanceof JoinObject || query.getGroupByObject() != null || query.getHierarchicalQueryObject() != null || query.getSetOperator() != null) {
                ok = false;
            }
            if (ok) {
                for (SelectObject so : query.getSelectObjects()) {
                    Function func;
                    boolean i = false;
                    if (!(so.getExpression() instanceof Function) || !(func = (Function)so.getExpression()).isDistinct() && !func.isGrouping()) continue;
                    ok = false;
                    break;
                }
            }
            if (!ok) {
                throw new ValidationException((DBObject)mview, APIBundle.get((String)"MVIEW_ERROR_INVALID_KEY_TYPE_ROWID"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"onPrebuilt"})
    public void validateOnPrebuilt(MaterializedView original, MaterializedView mview) throws ValidationException {
        if (mview.getOnPrebuilt() == null) {
            throw new ValidationException((DBObject)mview, APIBundle.get((String)"MVIEW_ERROR_MISSING_PREBUILT"));
        }
        if (original == null && mview.getOnPrebuilt() != MaterializedView.PrebuiltType.NONE) {
            Column[] mviewCols;
            if (Boolean.TRUE.equals(mview.getProperty("PARTITIONED TABLE"))) {
                throw new ValidationException((DBObject)mview, APIBundle.get((String)"MVIEW_ERROR_PARTITIONS_AND_PREBUILT"));
            }
            DBObjectCriteria criteria = new DBObjectCriteria(Table.class, new String[]{"TABLE", "MATERIALIZED VIEW"});
            criteria.setSchema(DBUtil.getSchema((DBObject)mview));
            criteria.setName(mview.getName());
            Collection baseTables = null;
            try {
                baseTables = this.getProvider().listObjects(criteria);
            }
            catch (DBException dbe) {
                // empty catch block
            }
            if (baseTables == null || baseTables.size() != 1) {
                throw new ValidationException((DBObject)mview, APIBundle.get((String)"MVIEW_ERROR_NO_PREBUILT_TABLE"));
            }
            Table base = (Table)baseTables.iterator().next();
            for (Column mviewCol : mviewCols = mview.getColumns()) {
                Column baseCol = base.getColumn(mviewCol.getName());
                if (baseCol != null) continue;
                throw new ValidationException((DBObject)mview, APIBundle.format((String)"MVIEW_ERROR_NO_MATCHING_COLUMN", (Object[])new Object[]{mviewCol.getName()}));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"refreshMethod"})
    public void validateRefreshMethod(MaterializedView original, MaterializedView mview) throws ValidationException {
        MaterializedView.RefreshMethod rm = mview.getRefreshMethod();
        if (rm == MaterializedView.RefreshMethod.NEVER || rm == MaterializedView.RefreshMethod.NA) {
            throw new ValidationException((DBObject)mview, APIBundle.get((String)"MVIEW_ERROR_UNSUPPORTED_REFRESH_METHOD"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"refreshMode"})
    public void validateRefreshMode(MaterializedView original, MaterializedView mview) throws ValidationException {
        if (mview.getRefreshMode() == null) {
            throw new ValidationException((DBObject)mview, APIBundle.get((String)"MVIEW_ERROR_MISSING_REFRESH_MODE"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"usingConstraints"})
    public void validateUsingConstraints(MaterializedView original, MaterializedView mview) throws ValidationException {
        if (this.getProvider().getDescriptor().getDatabaseVersion() >= 100 && mview.getUsingConstraints() == null) {
            throw new ValidationException((DBObject)mview, APIBundle.get((String)"MVIEW_ERROR_MISSING_CONSTRAINTS"));
        }
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection ret = super.listAlwaysValidProperties();
        ret.add("cache");
        ret.add("interval");
        ret.add("firstRefresh");
        ret.add("lastRefreshDate");
        ret.add("nextRefreshDate");
        ret.add("rewrite");
        ret.add("staleness");
        ret.add("useNoIndex");
        ret.add("rollbackSegmentType");
        ret.add("rollbackSegmentName");
        return ret;
    }

    @Override
    public CascadeAction cascadeDelete(DBObject removed, MaterializedView obj) {
        CascadeAction retval = CascadeAction.NONE;
        retval = this.checkSchemaDelete(removed, (SchemaObject)obj) ? CascadeAction.DELETE : ViewValidator.cascadeDelete(removed, (SQLQueryOwner)obj, this.getProvider());
        return retval;
    }

    public CascadeAction cascadeUpdate(Difference objDiff, MaterializedView obj) {
        CascadeAction retval = super.cascadeUpdate(objDiff, (DBObject)obj);
        if (retval == CascadeAction.UPDATE) {
            ViewValidator.resetDeclarativeQueryString((SQLQueryOwner)obj);
        }
        return retval;
    }
}

