/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Arrays;
import java.util.HashSet;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.ora.Indextype;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentExpressionBuilder;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.IndexValidator;
import oracle.javatools.db.validators.ValidationException;

public class OracleIndexValidator
extends IndexValidator {
    private static final HashSet INVALID_INDEX_DATATYPES = new HashSet<String>(Arrays.asList("LONG", "LONG RAW", "LOB", "BLOB", "CLOB", "NCLOB", "BFILE", "REF"));
    private static final HashSet VALID_TEXT_INDEX_DATATYPES = new HashSet<String>(Arrays.asList("XMLTYPE", "URITYPE", "BLOB", "BFILE"));

    public OracleIndexValidator(DBObjectProvider prov) {
        super(prov);
    }

    @DBObjectValidator.PropertyValidator(value={"columnExpressions"})
    public void validateExpressions(Index original, Index index) throws ValidationException {
        super.validateExpressions(original, index);
        Index.IndexType type = index.getIndexType();
        IndexObject[] ios = index.getColumnExpressions();
        if (type == Index.IndexType.DOMAIN) {
            if (ios.length != 1) {
                throw new ValidationException((DBObject)index, APIBundle.get((String)"ORACLE_INDEX_ERROR_TOO_MANY_COLUMNS"));
            }
        } else if (type == Index.IndexType.BITMAP) {
            if (ios.length > 30) {
                throw new ValidationException((DBObject)index, APIBundle.get((String)"BIT_INDEX_ERROR_TOO_MANY_COLUMN_EXPR"));
            }
        } else if (ios.length > 32) {
            throw new ValidationException((DBObject)index, APIBundle.get((String)"INDEX_ERROR_TOO_MANY_COLUMN_EXPR"));
        }
        this.checkInvalidFunctions(index);
    }

    @DBObjectValidator.PropertyValidator(value={"keyCompression"})
    public void validateKeyCompression(Index original, Index index) throws ValidationException {
        IndexObject[] ios = index.getColumnExpressions();
        Integer keyComp = index.getKeyCompression();
        if (keyComp != null) {
            if (keyComp < 0) {
                throw new ValidationException((DBObject)index, APIBundle.get((String)"INDEX_ERROR_KEY_COMPRESSION_TOO_SMALL"));
            }
            if (index.getIndexType() == Index.IndexType.DOMAIN) {
                throw new ValidationException((DBObject)index, APIBundle.get((String)"INDEX_ERROR_KEY_COMPRESSION_NOT_FOR_DOMAIN_INDEX"));
            }
            if (index.getIndexType() == Index.IndexType.UNIQUE && keyComp > ios.length - 1) {
                throw new ValidationException((DBObject)index, APIBundle.get((String)"INDEX_ERROR_KEY_COMPRESSION_TOO_BIG_UNIQUE"));
            }
            if (index.getIndexType() == Index.IndexType.NORMAL && keyComp > ios.length) {
                throw new ValidationException((DBObject)index, APIBundle.get((String)"INDEX_ERROR_KEY_COMPRESSION_TOO_BIG_NON_UNIQUE"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"table"})
    public void validateTable(Index original, Index index) throws ValidationException {
        if (index.getTable() == null) {
            throw new ValidationException((DBObject)index, APIBundle.get((String)"INDEX_ERROR_ORPHANED_INDEX"));
        }
        Table table = index.getTable();
        if (table.getProperty("TableType") == Table.TableType.EXTERNAL) {
            throw new ValidationException((DBObject)index, APIBundle.get((String)"ORACLE_INDEX_ERROR_EXTERNAL_TABLE"));
        }
    }

    protected void validateColumnType(Index index, Column col) throws ValidationException {
        super.validateColumnType(index, col);
        String err = null;
        DataType dt = null;
        try {
            DataTypeUsage dtu = col.getDataTypeUsage();
            if (dtu != null) {
                dt = DataTypeHelper.getDataType((DataTypeUsage)dtu);
                err = this.isValidDatatype(index, dt);
            }
        }
        catch (DBException dbe) {
            err = "INDEX_ERROR_INVALID_COLUMN_TYPE";
        }
        if (err != null) {
            throw new ValidationException((DBObject)col, "dataTypeUsage", APIBundle.format((String)err, (Object[])new Object[]{index.getName(), col.getName(), dt == null ? null : dt.getName()}));
        }
    }

    private String isValidDatatype(Index index, DataType dt) {
        String retval = null;
        if (dt == null) {
            retval = "INDEX_ERROR_INVALID_COLUMN_TYPE";
        } else {
            String dtName = dt.getName();
            if (index.getIndexType() == Index.IndexType.DOMAIN) {
                BaseObjectID id;
                boolean textIndex = false;
                if (index.getDomainIndextype() instanceof BaseObjectID && "CTXSYS".equals((id = (BaseObjectID)index.getDomainIndextype()).getSchemaName()) && "CONTEXT".equals(id.getName())) {
                    textIndex = true;
                }
                if (textIndex && !PredefinedDataType.ValueType.CHAR.equals((Object)DataTypeHelper.getValueType((DataType)dt)) && !VALID_TEXT_INDEX_DATATYPES.contains(dtName)) {
                    retval = "ORACLE_INDEX_ERROR_INVALID_TEXT_COLUMN_TYPE";
                }
            } else if (INVALID_INDEX_DATATYPES.contains(dtName) || dt instanceof Type) {
                retval = "INDEX_ERROR_INVALID_COLUMN_TYPE";
            }
        }
        return retval;
    }

    protected boolean columnMustBeUnique(Table table, Index index, IndexObject indexObject) {
        String columnName = this.getProvider().getInternalName(indexObject.getExpressionSource());
        return table.getColumn(columnName) != null && !IndexObject.OrderType.DESC.equals((Object)indexObject.getOrderType());
    }

    @DBObjectValidator.PropertyValidator(value={"domainIndextype"})
    public void validateDomainIndextype(Index original, Index index) throws ValidationException {
        if (index.getIndexType() != Index.IndexType.DOMAIN) {
            return;
        }
        DBObjectID indextypeID = index.getDomainIndextype();
        if (indextypeID == null) {
            throw new ValidationException((DBObject)index, APIBundle.format((String)"ORACLE_INDEX_ERROR_MISSING_INDEXTYPE", (Object[])new Object[]{index.getName()}));
        }
        String schemaName = null;
        if (indextypeID instanceof ReferenceID) {
            schemaName = ((ReferenceID)indextypeID).getSchemaName();
        } else {
            try {
                DBObject indextype;
                DBObject dBObject = indextype = indextypeID != null ? indextypeID.resolveID() : null;
                if (!(indextype instanceof Indextype)) {
                    throw new ValidationException((DBObject)index, APIBundle.format((String)"ORACLE_INDEX_ERROR_MISSING_INDEXTYPE", (Object[])new Object[]{index}));
                }
                Schema schema = ((Indextype)indextype).getSchema();
                schemaName = schema != null ? schema.getName() : null;
            }
            catch (DBException e) {
                DBLog.getLogger((Object)((Object)this)).warning("Couldn't resolve indextype for index validation: " + e.getMessage());
            }
        }
    }

    protected void checkInvalidFunctions(Index index) throws ValidationException {
        IndexObject[] ios = index.getColumnExpressions();
        for (int i = 0; i < ios.length; ++i) {
            SQLFragment expression = ios[i].getExpression();
            if (expression == null) continue;
            String exprText = expression.getSQLText();
            Relation rel = (Relation)index.getParent();
            SQLFragment sf = SQLFragmentExpressionBuilder.getExpression((DBObjectProvider)this.getProvider(), (Relation)rel, (SQLFragmentExpressionBuilder.ExpressionType)SQLFragmentExpressionBuilder.ExpressionType.ITEM, (String)exprText);
            this.checkInvalidFunctionsInFragment(sf, ios[i]);
        }
    }

    private void checkInvalidFunctionsInFragment(SQLFragment frag, IndexObject io) throws ValidationException {
        if (frag instanceof Function && ((Function)frag).isGrouping()) {
            throw new ValidationException((DBObject)io, APIBundle.format((String)"ORACLE_INDEX_ERROR_INVALID_FUNCION", (Object[])new Object[]{io.getSQLText()}));
        }
        if (frag instanceof Operation) {
            SQLFragment[] args = ((Operation)frag).getArguments();
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                this.checkInvalidFunctionsInFragment(args[i], io);
            }
        }
        String fnName = null;
        if (frag instanceof Function) {
            fnName = ((Function)frag).getFunction();
        } else if (frag != null) {
            fnName = frag.getSQLText();
        }
        if (fnName != null && "USER".equalsIgnoreCase(fnName) || "ROWNUM".equalsIgnoreCase(fnName) || "SYSDATE".equalsIgnoreCase(fnName) || "SYSTIMESTAMP".equalsIgnoreCase(fnName) || "CURRENT_DATE".equalsIgnoreCase(fnName) || "CURRENT_TIMESTAMP".equalsIgnoreCase(fnName)) {
            throw new ValidationException((DBObject)io, APIBundle.format((String)"ORACLE_INDEX_ERROR_INVALID_FUNCION", (Object[])new Object[]{io.getSQLText()}));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"indexType"})
    public void validateIndexType(Index original, Index index) throws ValidationException {
        OracleIndexOrganizedTableProperties oiotProps;
        Table table;
        if (!(Index.IndexType.BITMAP != index.getIndexType() || Table.TableType.INDEX_ORGANIZED != (table = index.getTable()).getProperty("TableType") || (oiotProps = (OracleIndexOrganizedTableProperties)table.getProperty("OracleIndexOrganizedTableProperties")) != null && oiotProps.isMapped())) {
            throw new ValidationException((DBObject)index, APIBundle.format((String)"ORACLE_INDEX_ERROR_BITMAP_WITHOUT_MAPPING_TABLE", (Object[])new Object[]{table, index}));
        }
    }
}

