/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleTablePropertiesValidator
extends AbstractChildDBObjectValidator<OracleTableProperties> {
    public OracleTablePropertiesValidator(DBObjectProvider prov) {
        super(prov);
    }

    @DBObjectValidator.PropertyValidator(value={"parallelDegree"})
    public void validateParallelDegree(OracleTableProperties original, OracleTableProperties otp) throws ValidationException {
        if (otp.getParallelDegree() != null && otp.getParallelDegree() < 0) {
            throw new ValidationException((DBObject)otp, APIBundle.get((String)"OTP_ERROR_INVALID_PARALLEL"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"tableCompression"})
    public void validateCompression(OracleTableProperties original, OracleTableProperties otp) throws ValidationException {
        if (otp.getParent() instanceof TablePartition) {
            TablePartition tp = (TablePartition)otp.getParent();
            OracleTablePartitions.PartitionType partitionType = tp.getPartitionType();
            OracleTablePartitions.ObjectType objectType = tp.getObjectType();
            OracleTableProperties.OracleTableCompression compression = (OracleTableProperties.OracleTableCompression)otp.getProperty("tableCompression");
            if (compression != null && !compression.equals((Object)OracleTableProperties.OracleTableCompression.NOCOMPRESS) && (objectType != OracleTablePartitions.ObjectType.PARTITION || partitionType == OracleTablePartitions.PartitionType.HASH && objectType == OracleTablePartitions.ObjectType.PARTITION)) {
                throw new ValidationException((DBObject)tp, APIBundle.format((String)"TABLE_PARTITION_DESCRIPTION_ERROR_INVALID_PROPERTY", (Object[])new Object[]{"COMPRESS"}));
            }
        }
    }

    protected boolean canHaveEmptyName() {
        return true;
    }
}

