/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.validators.ExternalTablePropsValidator;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.MissingValidatorException;
import oracle.javatools.db.validators.TableValidator;
import oracle.javatools.db.validators.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleTableValidator<T extends Table>
extends TableValidator<T> {
    public OracleTableValidator(DBObjectProvider prov) {
        super(prov);
    }

    @DBObjectValidator.PropertyValidator(value={"OracleIndexOrganizedTableProperties"})
    public void validateIOTProperties(T original, T updated) throws ValidationException {
        OracleIndexOrganizedTableProperties properties;
        Table.TableType tableType = (Table.TableType)updated.getProperty("TableType");
        if (tableType == Table.TableType.INDEX_ORGANIZED && (properties = (OracleIndexOrganizedTableProperties)updated.getProperty("OracleIndexOrganizedTableProperties")) != null) {
            try {
                this.getProvider().validateObject((DBObject)properties);
            }
            catch (MissingValidatorException mve) {
                throw new ValidationException(updated, APIBundle.get((String)"IOT_PROPERTY_NOT_SUPPORTED"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"OracleExternalTableProperties"})
    public void validateExternalTableProperties(T original, T updated) throws ValidationException {
        Table.TableType tableType = (Table.TableType)updated.getProperty("TableType");
        if (tableType == Table.TableType.EXTERNAL) {
            OracleExternalTableProperties properties = (OracleExternalTableProperties)updated.getProperty("OracleExternalTableProperties");
            if (properties == null) {
                ValidationException ve = new ValidationException(updated, Property.createPath((String[])new String[]{"OracleExternalTableProperties", "defaultDirectory"}), APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_MISSING_DEFAULT_DIR"));
                ve.setNextException((DBException)((Object)new ValidationException(updated, Property.createPath((String[])new String[]{"OracleExternalTableProperties", "locationSpecifiers"}), APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_MISSING_LOCATION"))));
                throw ve;
            }
            this.getProvider().validateObject((DBObject)properties);
        }
    }

    @DBObjectValidator.PropertyValidator(value={"OracleTablePartitions"})
    public void validatePartitions(T original, T updated) throws ValidationException {
        OracleTablePartitions partitions;
        boolean isPartitioned = Boolean.TRUE.equals(updated.getProperty("PARTITIONED TABLE"));
        if (isPartitioned && (partitions = (OracleTablePartitions)updated.getProperty("OracleTablePartitions")) != null) {
            try {
                this.getProvider().validateObject((DBObject)partitions);
            }
            catch (MissingValidatorException mve) {
                throw new ValidationException(updated, APIBundle.get((String)"TABLE_PARTITION_NOT_SUPPORTED"));
            }
        }
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"TableType"})
    public void validateTableType(T original, T updated) throws ValidationException {
        Table.TableType tableType = (Table.TableType)updated.getProperty("TableType");
        if (tableType == Table.TableType.EXTERNAL) {
            if (this.getProvider() instanceof Database) {
                this.validateExternalTableProperties(original, updated);
            }
            ExternalTablePropsValidator.validateTable(updated);
        } else if (tableType == Table.TableType.SESSION_TEMP || tableType == Table.TableType.TRANSACTION_TEMP) {
            boolean isPartitioned;
            boolean bl = isPartitioned = updated.getProperty("PARTITIONED TABLE") == Boolean.TRUE;
            if (isPartitioned) {
                throw new ValidationException(updated, APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_TEMPORARY"), APIBundle.get((String)"TABLE_PROPERTY_PARTITIONS")}));
            }
            for (Constraint constraint : updated.getConstraints()) {
                if (!(constraint instanceof FKConstraint)) continue;
                throw new ValidationException(updated, APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_TEMPORARY"), APIBundle.get((String)"TABLE_PROPERTY_FKS")}));
            }
            for (Constraint constraint : updated.getColumns()) {
                OracleColumnProperties ocp = (OracleColumnProperties)constraint.getProperty("OracleColumnProperties");
                if (ocp == null || ocp.getNestedTableProperties() == null) continue;
                throw new ValidationException((DBObject)constraint, APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_TEMPORARY"), APIBundle.get((String)"TABLE_PROPERTY_NESTED_TABLES")}));
            }
        } else if (tableType.equals((Object)Table.TableType.INDEX_ORGANIZED) && (this.getProvider() instanceof Database || original != null)) {
            this.validatePKForIOTable(original, updated);
        }
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"columns"})
    public void validateColumns(T original, T updated) throws ValidationException {
        Column[] cols = updated.getColumns();
        int realColCount = 0;
        if (cols != null && cols.length > 0) {
            for (Column col : cols) {
                if (col.getVirtualExpressionSource() != null) continue;
                ++realColCount;
                break;
            }
        }
        if (realColCount == 0) {
            throw new ValidationException(updated, APIBundle.format((String)"COLUMN_ERROR_NEED_REAL_COLUMN", (Object[])new Object[]{updated.getName()}));
        }
        super.validateColumns(original, updated);
    }

    private void validatePKForIOTable(T original, T updated) throws ValidationException {
        Table.TableType tableType = (Table.TableType)updated.getProperty("TableType");
        if (tableType == Table.TableType.INDEX_ORGANIZED) {
            PKConstraint pk = PKConstraint.getPrimaryKey(updated);
            if (pk == null) {
                throw new ValidationException(updated, "constraints", APIBundle.get((String)"IOT_PROPERTY_ERROR_MISSING_PRIMARY_KEY"));
            }
            if (!pk.isEnabled()) {
                throw new ValidationException((DBObject)pk, "enabled", APIBundle.get((String)"IOT_PROPERTY_ERROR_DISABLED_PRIMARY_KEY"));
            }
        }
    }
}

