/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleTablespaceValidator
extends DBObjectValidator<Tablespace> {
    public OracleTablespaceValidator(DBObjectProvider prov) {
        super(prov);
    }

    @DBObjectValidator.PropertyValidator(value={"TablespaceType"})
    public void validateTablespaceType(Tablespace original, Tablespace updated) throws ValidationException {
        if (original != null) {
            Tablespace.TablespaceType origTbspType = (Tablespace.TablespaceType)original.getProperty("TablespaceType");
            Tablespace.TablespaceType updTbspType = (Tablespace.TablespaceType)updated.getProperty("TablespaceType");
            if (origTbspType != null && updTbspType != null && !origTbspType.equals((Object)updTbspType) && updTbspType.equals((Object)Tablespace.TablespaceType.UNDO)) {
                throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_ERROR_TYPE_UPDATE"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"fileType"})
    public void validateFileTypeUpdate(Tablespace original, Tablespace updated) throws ValidationException {
        if (original != null) {
            if (original.getFileType() != null && original.getFileType().equals((Object)Tablespace.FileType.SMALLFILE) && updated.getFileType() != null && updated.getFileType().equals((Object)Tablespace.FileType.BIGFILE) && updated.getFileSpecifications() != null && updated.getFileSpecifications().length > 1) {
                throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_ERROR_FILE_TYPE_UPDATE"));
            }
        } else if (updated.getFileType() != null && updated.getFileType().equals((Object)Tablespace.FileType.BIGFILE) && updated.getFileSpecifications() != null && updated.getFileSpecifications().length > 1) {
            throw new ValidationException((DBObject)updated, APIBundle.get((String)"TABLESPACE_ERROR_FILE_TYPE"));
        }
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.TYPE;
    }
}

