/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.ArrayList;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablePartitionValidator
extends AbstractChildDBObjectValidator<TablePartition> {
    public TablePartitionValidator(DBObjectProvider pro) {
        super(pro);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    @Override
    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.TYPE_PARENT;
    }

    public void validateObject(TablePartition original, TablePartition tp) throws ValidationException {
        String name = tp.getName();
        OracleTablePartitions.ObjectType objectType = tp.getObjectType();
        if (name == null && objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
            throw new ValidationException((DBObject)tp, APIBundle.get((String)"TABLE_SUBPARTITION_TEMPLATE_ERROR_MISSING_NAME"));
        }
        OracleTablePartitions partitions = (OracleTablePartitions)tp.getParent();
        if (partitions == null) {
            throw new ValidationException((DBObject)tp, "A Table Partition must have a valid parent partition model.");
        }
        super.validateObject((DBObject)original, (DBObject)tp);
    }

    @DBObjectValidator.PropertyValidator(value={"values"})
    public void validateValues(TablePartition original, TablePartition tp) throws ValidationException {
        this.validateTypes(tp);
        OracleTablePartitions.PartitionType partitionType = tp.getPartitionType();
        if (partitionType == OracleTablePartitions.PartitionType.RANGE) {
            this.validateRangeValues(tp);
        } else if (partitionType == OracleTablePartitions.PartitionType.LIST) {
            this.validateListValues(tp);
        } else if (partitionType == OracleTablePartitions.PartitionType.HASH && tp.getValues().length > 0) {
            throw new ValidationException((DBObject)tp, APIBundle.get((String)"TABLE_HASH_PARTITION_INVALID_VALUES"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"partitionLevelSubpartitions"})
    public void validatePartitionLevelSubpartitions(TablePartition original, TablePartition tp) throws ValidationException {
        this.validateTypes(tp);
        OracleTablePartitions partitionLevelSubpartitions = tp.getPartitionLevelSubpartitions();
        if (partitionLevelSubpartitions != null) {
            if (!(tp.getPartitionType() == OracleTablePartitions.PartitionType.RANGE || this.allowSubPartitionedLists() && tp.getPartitionType() == OracleTablePartitions.PartitionType.LIST)) {
                throw new ValidationException((DBObject)tp, APIBundle.get((String)"TABLE_RANGE_PARTITION_ERROR_INVALID_PARTITION_LEVEL_SUBPARTITION"));
            }
            this.getProvider().validateObject((DBObject)partitionLevelSubpartitions);
        }
    }

    @DBObjectValidator.PropertyValidator(value={"segmentAttributes"})
    public void validateSegmentAttributes(TablePartition original, TablePartition tp) throws ValidationException {
        OracleStorageProperties segmentAttributes = tp.getSegmentAttributes();
        if (segmentAttributes != null) {
            this.getProvider().validateObject((DBObject)segmentAttributes);
        }
    }

    @DBObjectValidator.PropertyValidator(value={"LOBDescriptors"})
    public void validateLOBDescriptors(TablePartition original, TablePartition tp) throws ValidationException {
        this.validateOwnedObjects((DBObject[])tp.getLOBDescriptors());
    }

    private void validateTypes(TablePartition tp) throws ValidationException {
        OracleTablePartitions.PartitionType partitionType = tp.getPartitionType();
        if (partitionType == null) {
            throw new ValidationException((DBObject)tp, APIBundle.get((String)"TABLE_PARTITION_ERROR_MISSING_PARTITION_TYPE"));
        }
        OracleTablePartitions.ObjectType objectType = tp.getObjectType();
        if (objectType == null) {
            throw new ValidationException((DBObject)tp, APIBundle.get((String)"TABLE_PARTITION_ERROR_MISSING_OBJECT_TYPE"));
        }
    }

    private void validateRangeValues(TablePartition tp) throws ValidationException {
        Object[] values = tp.getValues();
        boolean columnCount = false;
        OracleTablePartitions partitions = this.getOracleTablePartitions(tp);
        if (partitions != null) {
            DBObjectID[] columnIDs = partitions.getPartitionColumns();
            ArrayList<Object> parsedValues = new ArrayList<Object>();
            for (Object value : values) {
                if (value instanceof String) {
                    parsedValues.addAll(TablePartition.splitValues((String)((String)value)));
                    continue;
                }
                parsedValues.add(value);
            }
            if (columnIDs.length != parsedValues.size()) {
                throw new ValidationException((DBObject)tp, APIBundle.get((String)"TABLE_RANGE_PARTITION_ERROR_MISSING_RANGE_VALUES"));
            }
            for (int index = 0; index < columnIDs.length; ++index) {
                Column dummyCol;
                Object value = parsedValues.get(index);
                if (TablePartition.RangeValue.MAXVALUE == value || (dummyCol = this.createDummyColumn(tp, columnIDs[index])) == null) continue;
                this.validationPartitionValue(tp, dummyCol, parsedValues.get(index));
            }
        }
    }

    private void validateListValues(TablePartition tp) throws ValidationException {
        Column dummyCol;
        DBObjectID[] columnIDs;
        Object[] values = tp.getValues();
        if (values.length < 1) {
            throw new ValidationException((DBObject)tp, APIBundle.get((String)"TABLE_LIST_PARTITION_ERROR_MISSING_LIST_VALUES"));
        }
        OracleTablePartitions partitions = this.getOracleTablePartitions(tp);
        if (partitions != null && (columnIDs = partitions.getPartitionColumns()) != null && columnIDs.length == 1 && (dummyCol = this.createDummyColumn(tp, columnIDs[0])) != null) {
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                if (value != null && value == TablePartition.ListValue.DEFAULT && values.length > 1) {
                    throw new ValidationException((DBObject)tp, APIBundle.get((String)"TABLE_PARTITION_ERROR_INVALID_LIST_VALUES_LIST"));
                }
                if (value == null || value == TablePartition.ListValue.DEFAULT || value == TablePartition.ListValue.NULL) continue;
                this.validationPartitionValue(tp, dummyCol, value);
            }
        }
    }

    private OracleTablePartitions getOracleTablePartitions(TablePartition tp) {
        OracleTablePartitions partitions;
        DBObject greatGrandparent;
        OracleTablePartitions.ObjectType type = tp.getObjectType();
        DBObject parent = tp.getParent();
        DBObject grandparent = parent != null ? parent.getParent() : null;
        DBObject dBObject = greatGrandparent = grandparent != null ? grandparent.getParent() : null;
        if (type == OracleTablePartitions.ObjectType.PARTITION || type == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
            partitions = (OracleTablePartitions)parent;
        } else if (type == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) {
            if (parent != null && grandparent != null && greatGrandparent instanceof OracleTablePartitions) {
                partitions = ((OracleTablePartitions)greatGrandparent).getSubpartitionModel();
            } else {
                partitions = null;
                DBLog.getLogger((Object)((Object)this)).warning(APIBundle.get((String)"TABLE_PARTITION_ERROR_INVALID_MODEL"));
            }
        } else {
            partitions = null;
        }
        return partitions;
    }

    private Column createDummyColumn(TablePartition tp, DBObjectID colID) {
        Relation parent = (Relation)DBUtil.findParentOfType((DBObject)tp, Relation.class);
        Column col = null;
        if (parent != null) {
            col = (Column)parent.findOwnedObject(colID);
        }
        Column dummyCol = null;
        if (col != null) {
            dummyCol = new Column();
            col.copyTo((DBObject)dummyCol, true);
        }
        return dummyCol;
    }

    private void validationPartitionValue(TablePartition tp, Column dummyCol, Object value) throws ValidationException {
        dummyCol.setDefault(value);
        try {
            this.getProvider().validateObject((DBObject)dummyCol, "default");
        }
        catch (ValidationException ve) {
            throw new ValidationException((DBObject)tp, "values", ve.getMessage());
        }
    }

    private boolean allowSubPartitionedLists() {
        return this.is11g();
    }

    private boolean is11g() {
        return "Oracle Database".equals(this.getProvider().getDescriptor().getDatabaseType()) && this.getProvider().getDescriptor().getDatabaseVersion() >= 110;
    }
}

