/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Collection;
import java.util.HashMap;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablePartitionsValidator
extends AbstractChildDBObjectValidator<OracleTablePartitions> {
    public TablePartitionsValidator(DBObjectProvider pro) {
        super(pro);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection ret = super.listAlwaysValidProperties();
        ret.add("partitionType");
        return ret;
    }

    public void validateObject(OracleTablePartitions original, OracleTablePartitions parts) throws ValidationException {
        DBObject par = parts.getParent();
        if (par instanceof Table) {
            this.validateAll(parts);
        }
        super.validateObject((DBObject)original, (DBObject)parts);
    }

    private void validateAll(OracleTablePartitions parts) throws ValidationException {
        OracleTablePartitions subpartitionModel = parts.getSubpartitionModel();
        if (subpartitionModel != null) {
            for (TablePartition partition : parts.getPartitions()) {
                OracleTablePartitions subpartitions = partition.getPartitionLevelSubpartitions();
                if (subpartitions != null && subpartitions.getHashQuantity() != null && subpartitionModel.getPartitionType() == OracleTablePartitions.PartitionType.HASH && subpartitionModel.getObjectType() == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
                    throw new ValidationException((DBObject)parts, APIBundle.get((String)"TABLE_PARTITION_ERROR_INVALID_PLS_QUANTITY"));
                }
                if (subpartitionModel.getPartitions().length <= 0 || subpartitions != null && subpartitions.getPartitions().length != 0) continue;
                int partitionNameLength = partition.getName() != null ? partition.getName().length() : 0;
                for (TablePartition template : subpartitionModel.getPartitions()) {
                    int length = partitionNameLength + template.getName().length() + 1;
                    if (length <= 30) continue;
                    throw new ValidationException((DBObject)parts, APIBundle.format((String)"TABLE_SUBPARTITION_ERROR_NAME_TOO_LONG", (Object[])new Object[]{partition.getName() + '_' + template.getName(), partition.getName(), template.getName()}));
                }
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"partitionColumns"})
    public void validateColumns(OracleTablePartitions original, OracleTablePartitions parts) throws ValidationException {
        this.validateTypes(parts);
        OracleTablePartitions.PartitionType partitionType = parts.getPartitionType();
        OracleTablePartitions.ObjectType objectType = parts.getObjectType();
        DBObjectID[] partitionColumns = parts.getPartitionColumns();
        if (objectType == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) {
            if (partitionColumns.length > 0) {
                throw new ValidationException((DBObject)parts, APIBundle.get((String)"TABLE_PARTITION_LEVEL_SUBPARTITION_ERROR_INVALID_COLUMN_COUNT"));
            }
        } else {
            if (partitionType == OracleTablePartitions.PartitionType.LIST) {
                if (partitionColumns.length != 1 || partitionColumns.length == 1 && LOBDescriptor.isLOBColumn((DBObjectID)partitionColumns[0], (DBObject)parts)) {
                    throw new ValidationException((DBObject)parts, APIBundle.get((String)"TABLE_LIST_PARTITION_ERROR_INVALID_COLUMN_COUNT"));
                }
            } else {
                if (partitionColumns.length < 1) {
                    throw new ValidationException((DBObject)parts, APIBundle.get((String)"TABLE_PARTITION_ERROR_INVALID_COLUMN_COUNT"));
                }
                if (partitionType == OracleTablePartitions.PartitionType.HASH && partitionColumns.length > 16) {
                    throw new ValidationException((DBObject)parts, APIBundle.get((String)"TABLE_HASH_PARTITION_ERROR_TOO_MANY_COLUMNS"));
                }
            }
            for (DBObjectID columnID : partitionColumns) {
                if (!this.isInvalidColumn(columnID)) continue;
                throw new ValidationException((DBObject)parts, APIBundle.get((String)"TABLE_PARTITION_ERROR_INVALID_COLUMN_TYPE"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"hashQuantity"})
    public void validateHashQuantity(OracleTablePartitions original, OracleTablePartitions parts) throws ValidationException {
        this.validateTypes(parts);
        OracleTablePartitions.PartitionType partitionType = parts.getPartitionType();
        OracleTablePartitions.ObjectType objectType = parts.getObjectType();
        TablePartition[] partitions = parts.getPartitions();
        Integer hashQuantity = parts.getHashQuantity();
        DBObjectID[] hashQuantityTablespaces = parts.getHashQuantityTablespaceIds();
        if (partitionType == OracleTablePartitions.PartitionType.HASH) {
            if (partitions.length != 0 && hashQuantity != null) {
                throw new ValidationException((DBObject)parts, APIBundle.get((String)"TABLE_HASH_PARTITION_ERROR_INVALID_COMBINATION"));
            }
            if (objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE && partitions.length == 0 && hashQuantity == null) {
                throw new ValidationException((DBObject)parts, APIBundle.get((String)"TABLE_HASH_SUBPARTITION_TEMPLATE_ERROR_MISSING_DEFINITION"));
            }
        } else if (hashQuantity != null || hashQuantityTablespaces.length != 0) {
            throw new ValidationException((DBObject)parts, APIBundle.get((String)"TABLE_PARTITION_ERROR_INVALID_PROPERTIES"));
        }
        if (hashQuantity == null && hashQuantityTablespaces.length != 0) {
            throw new ValidationException((DBObject)parts, APIBundle.get((String)"TABLE_HASH_PARTITION_ERROR_INVALID_TABLESPACES"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"partitions"})
    public void validatePartitions(OracleTablePartitions original, OracleTablePartitions parts) throws ValidationException {
        this.validateHashQuantity(original, parts);
        OracleTablePartitions.PartitionType partitionType = parts.getPartitionType();
        OracleTablePartitions.ObjectType objectType = parts.getObjectType();
        TablePartition[] partitions = parts.getPartitions();
        if (partitionType != OracleTablePartitions.PartitionType.HASH && objectType == OracleTablePartitions.ObjectType.PARTITION && partitions.length < 1) {
            throw new ValidationException((DBObject)parts, APIBundle.format((String)"TABLE_PARTITION_ERROR_INVALID_PARTITION_COUNT", (Object[])new Object[]{partitionType}));
        }
        if (partitionType == OracleTablePartitions.PartitionType.LIST && (objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE || objectType == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) && partitions.length < 1) {
            throw new ValidationException((DBObject)parts, APIBundle.get((String)"TABLE_LIST_SUBPARTITION_ERROR_MISSING_SUBPARTITIONS"));
        }
        HashMap<String, TablePartition> map = new HashMap<String, TablePartition>();
        for (TablePartition partition : partitions) {
            if (partition.getPartitionType() == partitionType) {
                this.getProvider().validateObject((DBObject)partition);
                OracleTablePartitions otp = partition.getPartitionLevelSubpartitions();
                if (otp == null || otp.getPartitions() == null) continue;
                for (TablePartition subPartition : otp.getPartitions()) {
                    String name = subPartition.getName();
                    if (map.get(name) != null) {
                        throw new NameInUseException((DBObject)subPartition, (DBObject)map.get(name));
                    }
                    map.put(name, subPartition);
                }
                continue;
            }
            throw new ValidationException((DBObject)parts, APIBundle.format((String)"TABLE_PARTITION_ERROR_INVALID_PARTITION_TYPES", (Object[])new Object[]{partitionType}));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"subpartitionModel"})
    public void validateSubpartitionModel(OracleTablePartitions original, OracleTablePartitions parts) throws ValidationException {
        OracleTablePartitions subpartitionModel = parts.getSubpartitionModel();
        if (subpartitionModel != null) {
            this.validateTypes(parts);
            OracleTablePartitions.PartitionType subpartitionType = subpartitionModel.getPartitionType();
            Collection allowVals = this.getProvider().getPropertyManager().getAllowedPropertyValues((DBObject)(original == null ? null : original.getSubpartitionModel()), (DBObject)subpartitionModel, "partitionType");
            if (allowVals != null && allowVals.contains(subpartitionType)) {
                this.getProvider().validateObject((DBObject)subpartitionModel);
            } else {
                throw new ValidationException((DBObject)parts, APIBundle.format((String)"TABLE_PARTITION_ERROR_INVALID_SUBPARTITIONS", (Object[])new Object[]{parts.getPartitionType()}));
            }
        }
    }

    private void validateTypes(OracleTablePartitions parts) throws ValidationException {
        OracleTablePartitions.PartitionType partitionType = parts.getPartitionType();
        if (partitionType == null) {
            throw new ValidationException((DBObject)parts, APIBundle.get((String)"TABLE_PARTITION_ERROR_MISSING_PARTITION_TYPE"));
        }
        OracleTablePartitions.ObjectType objectType = parts.getObjectType();
        if (objectType == null) {
            throw new ValidationException((DBObject)parts, APIBundle.get((String)"TABLE_PARTITION_ERROR_MISSING_OBJECT_TYPE"));
        }
    }

    private boolean isInvalidColumn(DBObjectID colID) {
        try {
            Column col = (Column)colID.resolveID();
            if (col != null) {
                DataType dataType = DataTypeHelper.getDataType((DataTypeUsage)col.getDataTypeUsage());
                if (dataType instanceof Type) {
                    return true;
                }
                if (dataType != null) {
                    String dataTypeName = dataType.getName();
                    return "LONG".equalsIgnoreCase(dataTypeName) || "LONG RAW".equalsIgnoreCase(dataTypeName) || "ROWID".equalsIgnoreCase(dataTypeName) || "UROWID".equalsIgnoreCase(dataTypeName) || "BLOB".equalsIgnoreCase(dataTypeName) || "CLOB".equalsIgnoreCase(dataTypeName) || "NCLOB".equalsIgnoreCase(dataTypeName) || "BFILE".equalsIgnoreCase(dataTypeName);
                }
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return false;
    }

    private boolean allowSubPartitionedLists() {
        return this.is11g();
    }

    private boolean is11g() {
        return "Oracle Database".equals(this.getProvider().getDescriptor().getDatabaseType()) && this.getProvider().getDescriptor().getDatabaseVersion() >= 110;
    }
}

