/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ora.XMLTypeColumnProperties;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLTypeColumnPropertiesValidator
extends AbstractChildDBObjectValidator<XMLTypeColumnProperties> {
    public XMLTypeColumnPropertiesValidator(DBObjectProvider prov) {
        super(prov);
    }

    @DBObjectValidator.PropertyValidator(value={"storeAs"})
    public void validateStoreAs(XMLTypeColumnProperties original, XMLTypeColumnProperties props) throws ValidationException {
    }

    @DBObjectValidator.PropertyValidator(value={"allowAnySchema"})
    public void validateAllowAnySchema(XMLTypeColumnProperties original, XMLTypeColumnProperties props) throws ValidationException {
        if (props.getElementID() != null && props.isAllowAnySchema()) {
            throw new ValidationException((DBObject)props, APIBundle.get((String)"XMLTYPE_COLPROPS_XMLSCHEMA_AND_ANY_SCHEMA_ERROR"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"allowNonSchema"})
    public void validateAllowNonSchema(XMLTypeColumnProperties original, XMLTypeColumnProperties props) throws ValidationException {
        if (props.getStoreAs() == XMLTypeColumnProperties.StoreAs.BINARY_XML && props.getElementID() == null && !props.isAllowAnySchema() && !props.isAllowNonSchema()) {
            throw new ValidationException((DBObject)props, APIBundle.get((String)"XMLTYPE_COLPROPS_XMLSCHEMA_OR_NON_SCHEMA_ERROR"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"elementID"})
    public void validateElement(XMLTypeColumnProperties original, XMLTypeColumnProperties props) throws ValidationException {
        DBObjectID elementID = props.getElementID();
        if (elementID == null) {
            if (props.getStoreAs() == XMLTypeColumnProperties.StoreAs.OBJECT_RELATIONAL) {
                throw new ValidationException((DBObject)props, APIBundle.get((String)"XMLTYPE_COLPROPS_ELEMENT_MISSING_ERROR"));
            }
        } else {
            if (elementID.getParent() == null) {
                throw new ValidationException((DBObject)props, APIBundle.get((String)"XMLTYPE_COLPROPS_ELEMENT_PARENT_ERROR"));
            }
            if (elementID.getParent() instanceof BaseObjectID && !ModelUtil.hasLength((String)((BaseObjectID)elementID.getParent()).getSchemaName())) {
                throw new ValidationException((DBObject)props, APIBundle.get((String)"XMLTYPE_COLPROPS_ELEMENT_PARENT_ERROR"));
            }
        }
    }

    protected boolean canHaveEmptyName() {
        return true;
    }
}

