/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.Function;
import oracle.javatools.db.plsql.Package;
import oracle.javatools.db.plsql.PackageBody;
import oracle.javatools.db.plsql.PlSqlBlock;
import oracle.javatools.db.plsql.PlSqlComment;
import oracle.javatools.db.plsql.PlSqlDatatype;
import oracle.javatools.db.plsql.PlSqlDerivedPropertySupport;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlInterrogatorFactory;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSchemaObject;
import oracle.javatools.db.plsql.PlSqlSchemaObjectBody;
import oracle.javatools.db.plsql.PlSqlSchemaObjectSpec;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlVariable;
import oracle.javatools.db.plsql.Procedure;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.TypeBody;
import oracle.javatools.db.sql.SqlAliasExpander;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlSqlDerivedPropertyBuilderImpl {
    private final Set<String> m_predfinedDataTypes = new HashSet<String>();
    private final DBObjectProvider m_provider;
    private final PlSqlSourceObject m_sourceObject;
    private final DBObjectPlSqlFragment m_sourceAsFrag;
    private final PlSqlSearch m_paramSearch;
    private final PlSqlSearch m_datatypeSearch;
    private final PlSqlSearch m_variableSearch;
    private final SqlAliasExpander m_sqlAliasExpander;
    private PlSqlSearch m_subProgramSearch;
    protected PlSqlSearch m_selfSearch;
    private String m_triggerNew = "";
    private String m_triggerOld = "";
    private PlSqlDerivedPropertySupport.PlSqlDerivedPropertyBuilder m_dpb;

    protected PlSqlDerivedPropertyBuilderImpl(PlSqlSourceObject sourceObject, DBObjectProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider should not be null");
        }
        if (sourceObject == null) {
            throw new IllegalArgumentException("sourceObject should not be null");
        }
        this.m_provider = provider;
        this.m_sourceObject = sourceObject;
        this.m_sourceAsFrag = sourceObject instanceof DBObjectPlSqlFragment ? (DBObjectPlSqlFragment)sourceObject : null;
        this.m_subProgramSearch = new PlSqlSearch("<type {PROCEDURE|FUNCTION}> <signature {^{RETURN|AS|IS|;}}... [RETURN <datatype ?%>]>");
        this.m_paramSearch = new PlSqlSearch("<param ?> [<mode {IN OUT|OUT|IN}>] [<nocopy NOCOPY>] <datatype ?%> [{DEFAULT|:=} <default ?.[(...)]>]");
        this.m_datatypeSearch = new PlSqlSearch("<type {PROCEDURE|FUNCTION}> <signature {^{RETURN|AS|IS|;}}... [RETURN <datatype ?%>]>");
        this.m_variableSearch = new PlSqlSearch("<var ?> [CONSTANT] <datatype ?%>");
        this.m_selfSearch = null;
        this.m_sqlAliasExpander = this.m_provider.getDescriptor().getSqlAliasExpander(this.m_provider, this.m_sourceObject.getSchema());
        ArrayList ds = new ArrayList();
        ds.addAll(this.getProvider().getDescriptor().listSupportedDataTypes());
        for (DataType d : ds) {
            if (!(d instanceof PredefinedDataType)) continue;
            this.m_predfinedDataTypes.add(d.getName());
        }
    }

    protected final void buildProperties(PlSqlDerivedPropertySupport.PlSqlDerivedPropertyBuilder dpb) throws CancelledException {
        this.m_dpb = dpb;
        PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)this.m_sourceObject, dpb.getInterrogator());
        if (pi != null) {
            if (pi.isCurrentBuildCancelled() || Thread.interrupted()) {
                throw new CancelledException();
            }
            if (pi.getRoot() != null) {
                String name;
                if (this.m_sourceAsFrag != null) {
                    this.m_sourceAsFrag.setStartOffset(Integer.valueOf(0));
                    this.m_sourceAsFrag.setEndOffset(Integer.valueOf(this.m_sourceObject.getSource().length() - 1));
                }
                if (ModelUtil.hasLength((String)(name = this.getProvider().getInternalName(pi.getName()))) && !ModelUtil.hasLength((String)this.m_sourceObject.getName())) {
                    this.m_sourceObject.setName(name);
                }
                if (this.m_sourceObject instanceof PlSqlBlock) {
                    PlSqlBlock block = (PlSqlBlock)this.m_sourceObject;
                    if (block instanceof TypeBody) {
                        this.m_subProgramSearch = new PlSqlSearch("[overriding] [{map|order}] {member|static} [[final][instantiable]constructor] <type {PROCEDURE|FUNCTION}> <signature {^{RETURN|AS|IS|;}}... [RETURN <datatype {SELF AS RESULT|?%}>]>");
                    }
                    if (block instanceof PlSqlSchemaObject) {
                        String otherType = this.getCompanionObjectType((PlSqlSchemaObject)block);
                        if (otherType != null) {
                            PlSqlSchemaObject other = null;
                            try {
                                other = (PlSqlSchemaObject)this.getProvider().getObject(otherType, this.m_sourceObject.getSchema(), this.m_sourceObject.getName());
                            }
                            catch (DBException e) {
                                DBLog.getLogger().log(Level.WARNING, "failed to find spec for " + this.m_sourceObject.getName() + " body");
                            }
                            if (other instanceof PlSqlSchemaObjectSpec) {
                                ((PlSqlSchemaObjectBody)block).setSpecID(other.getID());
                            } else if (other instanceof PlSqlSchemaObjectBody) {
                                ((PlSqlSchemaObjectSpec)block).setBodyID(other.getID());
                            }
                        }
                        block.setBlocks(null);
                        block.setComments(null);
                        block.setDatatypes(null);
                        block.setReferences(null);
                        block.setSubPrograms(null);
                        block.setVariables(null);
                    }
                    if (pi.isWrapped()) {
                        return;
                    }
                    if (this.m_sourceObject instanceof Trigger) {
                        Trigger trig = (Trigger)this.m_sourceObject;
                        this.m_triggerNew = trig.getReferencingNewAs();
                        if (!ModelUtil.hasLength((String)this.m_triggerNew)) {
                            this.m_triggerNew = "NEW";
                        }
                        this.m_triggerOld = trig.getReferencingOldAs();
                        if (!ModelUtil.hasLength((String)this.m_triggerOld)) {
                            this.m_triggerOld = "OLD";
                        }
                    }
                    ArrayList<String> names = new ArrayList<String>();
                    names.add(block.getName());
                    PlSqlSearch search = new PlSqlSearch("[create [or replace]] ? [body] <name ?.>");
                    if (search.matches(pi.getRoot().getFirstToken())) {
                        PlSqlToken nameTk = search.getEndToken();
                        this.buildReference(block, names, nameTk.getStart(), nameTk.getEnd());
                    }
                    if (this.m_sourceObject instanceof Function) {
                        this.buildReturnType((PlSqlSubProgram)((Function)this.m_sourceObject), pi.getRoot().getChildren()[0]);
                    }
                    this.buildTypeSpecificProps();
                    PlSqlToken tk = pi.getRoot().getLastToken();
                    if (tk.getPrevCodeToken().matches(block.getName())) {
                        tk = tk.getPrevCodeToken();
                        if (block instanceof Procedure) {
                            if (block.getBlocks().length > 0) {
                                this.buildReference(block.getBlocks()[0], names, tk.getStart(), tk.getEnd());
                            }
                        } else {
                            this.buildReference(block, names, tk.getStart(), tk.getEnd());
                        }
                    }
                    for (tk = pi.getRoot().getFirstToken().getTokenAt(0); tk != null && tk.getType() != PlSqlToken.Type.END_MARKER; tk = tk.getNextToken()) {
                        Integer start = null;
                        Integer end = null;
                        if (tk.getType() == PlSqlToken.Type.MULTI_LINE_COMMENT) {
                            start = tk.getStart();
                            end = tk.getEnd();
                        } else if (tk.getType() == PlSqlToken.Type.SINGLE_LINE_COMMENT) {
                            start = tk.getStart();
                            end = tk.getEnd();
                            PlSqlToken tk2 = tk.getNextToken();
                            int line = pi.getLineNumber(end.intValue());
                            while (true) {
                                if (tk2.getType() == PlSqlToken.Type.SINGLE_LINE_COMMENT) {
                                    int line2 = pi.getLineNumber(tk2.getEnd());
                                    if (line2 != line + 1) break;
                                    end = tk2.getEnd();
                                    tk = tk2;
                                    line = line2;
                                } else if (tk2.getType() != PlSqlToken.Type.WHITESPACE) break;
                                tk2 = tk2.getNextToken();
                            }
                        }
                        if (start == null) continue;
                        PlSqlComment comment = new PlSqlComment();
                        block.addComment(comment);
                        String cname = String.valueOf(block.getComments().length);
                        this.setCommon((DBObjectPlSqlFragment)comment, cname, start, end, null);
                        comment.setText(this.m_sourceObject.getSource().substring(start, end + 1));
                    }
                }
            }
        }
    }

    protected void buildTypeSpecificProps() throws CancelledException {
        PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)this.m_sourceObject);
        PlSqlFragment root = pi.getRoot();
        if (root != null) {
            this.buildProperties(root, (DBObjectPlSqlFragment)this.m_sourceObject, true);
        }
    }

    private void buildProperties(PlSqlFragment plsqlFrag, DBObjectPlSqlFragment dboFrag, boolean deep) throws CancelledException {
        PlSqlToken firstTokenOfChild;
        PlSqlToken token = plsqlFrag.getFirstToken();
        PlSqlToken endToken = token.getPrevToken();
        if (plsqlFrag.getFragmentType() == PlSqlFragment.Type.STATEMENT) {
            endToken = plsqlFrag.getLastToken();
        } else if (plsqlFrag.getChildren().length > 0 && (firstTokenOfChild = plsqlFrag.getChildren()[0].getFirstToken()).getStart() > token.getStart()) {
            switch (plsqlFrag.getFragmentType()) {
                case LOOP: 
                case CASE: 
                case CASE_WHEN: 
                case CASE_ELSE: {
                    endToken = firstTokenOfChild.getPrevCodeToken();
                    break;
                }
                case FOR_LOOP: 
                case WHILE_LOOP: 
                case IF: 
                case ELSIF: 
                case EX_WHEN: {
                    token = token.getNextCodeToken();
                    endToken = firstTokenOfChild.getPrevCodeToken().getPrevCodeToken();
                    break;
                }
            }
        }
        while (token != null && token.getStart() <= endToken.getStart()) {
            token = this.buildReferences(token, endToken, dboFrag);
        }
        for (PlSqlFragment childPlSqlFrag : plsqlFrag.getChildren()) {
            PlSqlBlock childDboFrag = null;
            PlSqlFragment.Type fragType = childPlSqlFrag.getFragmentType();
            if (fragType == PlSqlFragment.Type.BEGIN && (childPlSqlFrag.getParent().getFragmentType() == PlSqlFragment.Type.PROCEDURE || childPlSqlFrag.getParent().getFragmentType() == PlSqlFragment.Type.FUNCTION)) {
                fragType = PlSqlFragment.Type.PLSQL_BLOCK;
            }
            switch (fragType) {
                case PROCEDURE: 
                case FUNCTION: 
                case PROCEDURE_FD: 
                case FUNCTION_FD: {
                    if (plsqlFrag.getFragmentType() == PlSqlFragment.Type.ROOT) break;
                    childDboFrag = new PlSqlSubProgram();
                    if (!(dboFrag instanceof PlSqlBlock)) break;
                    ((PlSqlBlock)dboFrag).addSubProgram((PlSqlSubProgram)childDboFrag);
                    this.buildSubProgram((PlSqlSubProgram)childDboFrag, childPlSqlFrag);
                    break;
                }
                case FOR_LOOP: 
                case PLSQL_BLOCK: {
                    childDboFrag = new PlSqlBlock();
                    if (!(dboFrag instanceof PlSqlBlock)) break;
                    ((PlSqlBlock)dboFrag).addBlock(childDboFrag);
                    this.buildBlock(childDboFrag, childPlSqlFrag);
                    break;
                }
                case DECLARATION: {
                    if (childPlSqlFrag.getFirstToken().matches("TYPE") || childPlSqlFrag.getFirstToken().matches("SUBTYPE")) {
                        childDboFrag = new PlSqlDatatype();
                        if (!(dboFrag instanceof PlSqlBlock)) break;
                        ((PlSqlBlock)dboFrag).addDatatype((PlSqlDatatype)childDboFrag);
                        this.buildDatatype((PlSqlDatatype)childDboFrag, childPlSqlFrag);
                        break;
                    }
                    childDboFrag = new PlSqlVariable();
                    if (!(dboFrag instanceof PlSqlBlock)) break;
                    ((PlSqlBlock)dboFrag).addVariable((PlSqlVariable)childDboFrag);
                    this.buildVariable((PlSqlVariable)childDboFrag, childPlSqlFrag);
                    break;
                }
                case PARAMETER: {
                    childDboFrag = new PlSqlParameter();
                    if (!(dboFrag instanceof PlSqlSubProgram)) break;
                    ((PlSqlSubProgram)dboFrag).addParameter((PlSqlParameter)childDboFrag);
                    this.buildParameter((PlSqlParameter)childDboFrag, childPlSqlFrag);
                    break;
                }
                case CURSOR: {
                    childDboFrag = new PlSqlSubProgram();
                    if (!(dboFrag instanceof PlSqlBlock)) break;
                    ((PlSqlBlock)dboFrag).addSubProgram((PlSqlSubProgram)childDboFrag);
                    this.buildCursor((PlSqlSubProgram)childDboFrag, childPlSqlFrag);
                    break;
                }
            }
            if (childDboFrag == null) {
                childDboFrag = dboFrag;
            } else {
                if (childDboFrag.getStartOffset() == null) {
                    childDboFrag.setStartOffset(Integer.valueOf(childPlSqlFrag.getStartOffset()));
                }
                if (childDboFrag.getEndOffset() == null) {
                    childDboFrag.setEndOffset(Integer.valueOf(childPlSqlFrag.getEndOffset()));
                }
            }
            if (!deep && childDboFrag != dboFrag) continue;
            this.buildProperties(childPlSqlFrag, (DBObjectPlSqlFragment)childDboFrag, deep);
        }
    }

    private PlSqlToken buildReferences(PlSqlToken startToken, PlSqlToken endToken, DBObjectPlSqlFragment dboFrag) throws CancelledException {
        PlSqlToken tk = startToken;
        PlSqlToken endTk = endToken;
        if (endTk.matches(";")) {
            endTk = endTk.getPrevCodeToken();
        }
        if (tk.matches("select")) {
            if (startToken.getPrevCodeToken().matches("(")) {
                endTk = startToken;
                int parens = 1;
                while (parens > 0) {
                    if (endTk.matches("(")) {
                        ++parens;
                    } else if (endTk.matches(")")) {
                        --parens;
                    }
                    endTk = endTk.getNextCodeToken();
                }
                endTk = endTk.getPrevCodeToken();
                endTk = endTk.getPrevCodeToken();
            } else {
                PlSqlSearch intoSearch = new PlSqlSearch("select {^{into|from}}... into <intoClause {^from}...>");
                if (intoSearch.matches(startToken, endToken)) {
                    PlSqlToken intoStartTK = intoSearch.getNamedMatchStartToken("intoClause");
                    PlSqlToken intoEndTK = intoSearch.getNamedMatchEndToken("intoClause");
                    PlSqlToken intoItemStart = intoStartTK;
                    while (intoItemStart.isCode() && intoItemStart.getStart() < intoEndTK.getEnd()) {
                        intoItemStart = this.buildReferences(intoItemStart, intoEndTK, dboFrag);
                        intoItemStart = intoItemStart.getNextCodeToken();
                    }
                }
            }
            tk = this.buildReferencesInSQL(tk, endTk, (PlSqlBlock)dboFrag);
        } else if (tk.matches("insert")) {
            tk = this.buildReferencesInSQL(tk, endTk, (PlSqlBlock)dboFrag);
        } else if (tk.matches("update")) {
            tk = this.buildReferencesInSQL(tk, endTk, (PlSqlBlock)dboFrag);
        } else if (tk.matches("delete")) {
            tk = this.buildReferencesInSQL(tk, endTk, (PlSqlBlock)dboFrag);
        } else {
            if (tk.getType() != PlSqlToken.Type.ALPHANUMERIC && tk.getType() != PlSqlToken.Type.DOUBLE_QUOTED_STRING && !tk.matches(":")) {
                return tk.getNextCodeToken();
            }
            if (tk.getNextCodeToken().matches("=>")) {
                return tk.getNextCodeToken(2);
            }
            ArrayList<PlSqlToken> tokens = new ArrayList<PlSqlToken>();
            ArrayList<String> names = new ArrayList<String>();
            tk = this.buildNameAndTokenLists(tk, endToken, true, tokens, names);
            if (names.size() > 0 && dboFrag instanceof PlSqlBlock) {
                int end = tokens.size() - 1;
                boolean addNames = false;
                if (((String)names.get(names.size() - 1)).startsWith("(")) {
                    end = names.size() - 2;
                    addNames = true;
                }
                if (tokens == null || tokens.size() == 0 || tokens.size() < end + 1 || tokens.get(0) == null || tokens.get(end) == null) {
                    boolean debug = false;
                }
                this.buildReference((PlSqlBlock)dboFrag, names, ((PlSqlToken)tokens.get(0)).getStart(), ((PlSqlToken)tokens.get(end)).getEnd());
                if (addNames) {
                    for (int i = end + 1; i < tokens.size(); ++i) {
                        if (tokens.get(i) == null) continue;
                        ArrayList<String> names2 = new ArrayList<String>();
                        names2.addAll(names);
                        names2.add(((PlSqlToken)tokens.get(i)).getSource(true));
                        this.buildReference((PlSqlBlock)dboFrag, names2, ((PlSqlToken)tokens.get(i)).getStart(), ((PlSqlToken)tokens.get(i)).getEnd());
                    }
                }
            }
        }
        return tk;
    }

    private PlSqlToken buildNameAndTokenLists(PlSqlToken startToken, PlSqlToken endToken, boolean includeParens, List<PlSqlToken> tokens, List<String> names) {
        PlSqlToken tk = startToken;
        if (!tk.isCode()) {
            tk = tk.getNextCodeToken();
        }
        String name = null;
        if (names.size() == 0 && this.m_sourceObject instanceof Trigger && tk.matches(":") && (tk.getNextToken().matches(this.m_triggerNew) || tk.getNextToken().matches(this.m_triggerOld))) {
            tk = tk.getNextToken();
            name = DBUtil.getDBObjectName((DBObjectID)((Trigger)this.m_sourceObject).getBaseObjectID());
        } else if (tk.getType() == PlSqlToken.Type.ALPHANUMERIC) {
            try {
                Float.valueOf(tk.getSource());
            }
            catch (NumberFormatException nfe) {
                name = tk.getSource(true);
            }
        } else if (tk.getType() == PlSqlToken.Type.DOUBLE_QUOTED_STRING) {
            name = tk.getSource(false);
            name = name.substring(1, name.length() - 1);
        }
        if (name != null) {
            tokens.add(tk);
            names.add(name);
            tk = tk.getNextCodeToken();
            if (tk.getStart() <= endToken.getEnd()) {
                if (tk.matches(".")) {
                    tk = tk.getNextCodeToken();
                    tk = this.buildNameAndTokenLists(tk, endToken, includeParens, tokens, names);
                } else if (tk.matches("(") && includeParens) {
                    String sep = "(";
                    StringBuilder sb = new StringBuilder();
                    int parens = 1;
                    PlSqlToken tk2 = tk.getNextCodeToken();
                    if (tk2.matches(")")) {
                        --parens;
                    }
                    boolean newArg = true;
                    while (parens > 0) {
                        if (parens == 1 && newArg) {
                            sb.append(sep);
                            sep = ",";
                            if (tk2.getNextCodeToken().matches("=>")) {
                                sb.append(tk2.getSource(true));
                                tokens.add(tk2);
                                tk2 = tk2.getNextCodeToken(2);
                            } else {
                                sb.append("?");
                                tokens.add(null);
                            }
                            newArg = tk2.matches(",");
                        } else if (parens == 1 && tk2.matches(",")) {
                            newArg = true;
                        } else if (tk2.matches("(")) {
                            ++parens;
                        }
                        if (tk2.matches(")") && --parens == 0) {
                            sb.append(")");
                            names.add(sb.toString());
                        }
                        if (!(tk2 = tk2.getNextCodeToken()).isEndMarker() && tk2.getStart() <= endToken.getEnd()) continue;
                        if (parens > 0) {
                            sb.append(")");
                            names.add(sb.toString());
                        }
                        break;
                    }
                }
            }
        } else {
            tk = tk.getNextCodeToken();
        }
        return tk;
    }

    protected boolean ignoreToken(String token) {
        return PlSqlToken.isKeyWord((String)token) || this.m_predfinedDataTypes.contains(token);
    }

    private PlSqlToken buildReferencesInSQL(PlSqlToken startToken, PlSqlToken endToken, PlSqlBlock block) throws CancelledException {
        for (SqlAliasExpander.Usage u : this.m_sqlAliasExpander.getUsages(startToken, endToken)) {
            List names = u.getTokens();
            if (names.size() > 0 && this.m_sourceObject instanceof Trigger) {
                PlSqlToken tk = startToken.getTokenAt(u.getStartOffset());
                tk = tk.getPrevCodeToken();
                while (tk.matches(".")) {
                    tk = tk.getPrevCodeToken();
                    tk = tk.getPrevCodeToken();
                }
                if (tk.matches(":") && (tk.getNextToken().matches(this.m_triggerNew) || tk.getNextToken().matches(this.m_triggerOld))) {
                    names.remove(0);
                    names.add(0, DBUtil.getDBObjectName((DBObjectID)((Trigger)this.m_sourceObject).getBaseObjectID()));
                }
            }
            this.buildReference(block, names, u.getStartOffset(), u.getEndOffset());
        }
        return endToken.getNextCodeToken();
    }

    private void buildSubProgram(PlSqlSubProgram subProg, PlSqlFragment frag) throws CancelledException {
        if (!this.m_subProgramSearch.matches(frag.getFirstToken())) {
            this.setCommon((DBObjectPlSqlFragment)subProg, null, frag.getStartOffset(), frag.getEndOffset(), null);
        } else {
            String signature;
            PlSqlToken sigStartTk = this.m_subProgramSearch.getNamedMatchStartToken("signature");
            String name = sigStartTk.getSource(true);
            PlSqlFragment[] fragKids = frag.getChildren();
            StringBuilder sb = null;
            if (fragKids != null && fragKids.length > 0) {
                sb = new StringBuilder(name);
                PlSqlFragment child = fragKids[0];
                String sep = "(";
                if (child.getFragmentType() == PlSqlFragment.Type.PARAMETER_LIST) {
                    for (PlSqlFragment pfrag : child.getChildren()) {
                        sb.append(sep);
                        sep = ",";
                        PlSqlParameter p = new PlSqlParameter();
                        this.buildParameter(p, pfrag);
                        sb.append(p.getName());
                        PlSqlParameter.Mode mode = p.getMode();
                        if (mode == null) {
                            mode = PlSqlParameter.Mode.IN;
                        }
                        sb.append(" ");
                        sb.append(mode.toString());
                        sb.append(" ");
                        PlSqlReference ref = p.getDataTypeReference();
                        if (ref == null) continue;
                        sb.append(ref.getDataTypeUsageSource());
                    }
                    if (",".equals(sep)) {
                        sb.append(")");
                    }
                }
            }
            if (sb != null) {
                signature = sb.toString();
            } else {
                PlSqlToken sigEndTk = this.m_subProgramSearch.getNamedMatchEndToken("signature");
                PlSqlToken dtTk = this.m_subProgramSearch.getNamedMatchStartToken("datatype");
                if (dtTk != null) {
                    sigEndTk = dtTk;
                    sigEndTk = sigEndTk.getPrevCodeToken();
                    sigEndTk = sigEndTk.getPrevCodeToken();
                }
                signature = sigStartTk.getSource(true, sigEndTk);
            }
            this.setCommon((DBObjectPlSqlFragment)subProg, signature, frag.getStartOffset(), frag.getEndOffset(), sigStartTk);
            this.checkForEndLabel(subProg, frag, name, signature);
            this.buildReturnType(subProg, frag);
        }
    }

    private void buildReturnType(PlSqlSubProgram subProg, PlSqlFragment frag) throws CancelledException {
        if (this.m_subProgramSearch.matches(frag.getFirstToken()) && "FUNCTION".equals(this.m_subProgramSearch.getNamedMatch("type", true)) && this.m_subProgramSearch.getNamedMatchStartToken("datatype") != null) {
            PlSqlToken startTk = this.m_subProgramSearch.getNamedMatchStartToken("datatype");
            PlSqlToken endTk = this.m_subProgramSearch.getNamedMatchEndToken("datatype");
            PlSqlReference ref = this.findDataTypeReference(startTk, endTk, subProg.getParent());
            subProg.setReturnTypeReference(ref);
        }
    }

    private void checkForEndLabel(PlSqlSubProgram dboFrag, PlSqlFragment frag, String name, String signature) throws CancelledException {
        PlSqlToken n = frag.getLastToken();
        PlSqlToken nMinus1 = n.getPrevCodeToken();
        PlSqlToken nMinus2 = nMinus1.getPrevCodeToken();
        if (nMinus2.matches("END") && nMinus1.matches(name) && n.matches(";") && dboFrag.getParent() instanceof DBObjectPlSqlFragment) {
            ArrayList<String> names = new ArrayList<String>();
            names.add(signature);
            this.buildReference((PlSqlBlock)dboFrag.getParent(), names, nMinus1.getStart(), nMinus1.getEnd());
        }
    }

    private void buildCursor(PlSqlSubProgram subProg, PlSqlFragment frag) throws CancelledException {
        PlSqlToken nameToken = frag.getFirstToken().getNextCodeToken();
        String name = nameToken.getSource(true);
        this.setCommon((DBObjectPlSqlFragment)subProg, name, frag.getStartOffset(), frag.getEndOffset(), nameToken);
        PlSqlToken tk = frag.getFirstToken();
        boolean inSelectList = false;
        while (tk.getEnd() <= frag.getEndOffset()) {
            if (tk.matches("select")) {
                inSelectList = true;
            } else {
                if (tk.matches("from")) break;
                if (inSelectList && (tk.getNextCodeToken().matches(",") || tk.getNextCodeToken().matches("from"))) {
                    PlSqlVariable v = new PlSqlVariable();
                    subProg.addVariable(v);
                    this.setCommon((DBObjectPlSqlFragment)v, tk.getSource(true), tk.getStart(), tk.getEnd(), tk);
                }
            }
            tk = tk.getNextCodeToken();
        }
    }

    private void buildBlock(PlSqlBlock block, PlSqlFragment frag) throws CancelledException {
        PlSqlToken varTk;
        int blockCount = 0;
        String blockLabel = null;
        PlSqlFragment parentFrag = frag.getParent();
        PlSqlToken nameToken = null;
        for (PlSqlFragment child : parentFrag.getChildren()) {
            if (child.getFragmentType() == PlSqlFragment.Type.LABEL) {
                nameToken = child.getFirstToken().getNextCodeToken();
                blockLabel = nameToken.getSource(true);
                continue;
            }
            if (child.getFragmentType() == PlSqlFragment.Type.PLSQL_BLOCK || child.getFragmentType() == PlSqlFragment.Type.BEGIN) {
                ++blockCount;
                if (child == frag) {
                    if (blockLabel != null) break;
                    blockLabel = String.valueOf(blockCount);
                    break;
                }
                blockLabel = null;
                continue;
            }
            blockLabel = null;
        }
        this.setCommon((DBObjectPlSqlFragment)block, blockLabel, frag.getStartOffset(), frag.getEndOffset(), nameToken);
        if (frag.getFragmentType() == PlSqlFragment.Type.FOR_LOOP && (varTk = frag.getFirstToken().getNextCodeToken()) != null) {
            PlSqlVariable var = new PlSqlVariable();
            block.addVariable(var);
            PlSqlToken nextTk = varTk.getNextCodeToken();
            PlSqlReference ref = new PlSqlReference();
            ref.setReferenceType(PlSqlReference.ReferenceType.DIRECT);
            ref.setStartOffset(Integer.valueOf(nextTk.getStart()));
            ref.setEndOffset(Integer.valueOf(nextTk.getStart()));
            var.setDataTypeReference(ref);
            this.setCommon((DBObjectPlSqlFragment)var, varTk.getSource(true), varTk.getStart(), varTk.getEnd(), varTk);
        }
    }

    protected void buildParameter(PlSqlParameter param, PlSqlFragment frag) throws CancelledException {
        PlSqlParameter.Mode mode = PlSqlParameter.Mode.IN;
        if (!this.m_paramSearch.matches(frag.getFirstToken())) {
            this.setCommon((DBObjectPlSqlFragment)param, null, frag.getFirstToken().getStart(), frag.getLastToken().getEnd(), null);
        } else {
            String name = this.getProvider().getInternalName(this.m_paramSearch.getNamedMatch("param"));
            this.setCommon((DBObjectPlSqlFragment)param, name, frag.getFirstToken().getStart(), frag.getLastToken().getEnd(), this.m_paramSearch.getNamedMatchStartToken("param"));
            String modeStr = this.m_paramSearch.getNamedMatch("mode");
            if (modeStr != null) {
                if (modeStr.equals("OUT")) {
                    mode = PlSqlParameter.Mode.OUT;
                } else if (modeStr.equals("IN OUT")) {
                    mode = PlSqlParameter.Mode.INOUT;
                }
            }
            param.setMode(mode);
            String defVal = this.m_paramSearch.getNamedMatch("default");
            if (defVal != null) {
                param.setDefaultValue(defVal);
                PlSqlToken x = this.buildReferences(this.m_paramSearch.getNamedMatchStartToken("default"), this.m_paramSearch.getNamedMatchEndToken("default"), (DBObjectPlSqlFragment)param.getParent());
            }
            param.setNoCopy(this.m_paramSearch.getNamedMatch("nocopy") != null);
            PlSqlToken startTk = this.m_paramSearch.getNamedMatchStartToken("datatype");
            PlSqlToken endTk = this.m_paramSearch.getNamedMatchEndToken("datatype");
            PlSqlReference ref = this.findDataTypeReference(startTk, endTk, param.getParent());
            param.setDataTypeReference(ref);
            startTk = endTk.getNextCodeToken();
            endTk = frag.getLastToken();
            while (startTk.getStart() < endTk.getStart()) {
                startTk = this.buildReferences(startTk, endTk, (DBObjectPlSqlFragment)param.getParent());
            }
        }
    }

    private void buildVariable(PlSqlVariable variable, PlSqlFragment frag) throws CancelledException {
        PlSqlToken endTk;
        PlSqlToken startTk = frag.getFirstToken();
        if (!this.m_variableSearch.matches(startTk, endTk = frag.getLastToken())) {
            this.setCommon((DBObjectPlSqlFragment)variable, null, frag.getFirstToken().getStart(), frag.getFirstToken().getEnd(), null);
        } else {
            String name = this.getProvider().getInternalName(this.m_variableSearch.getNamedMatch("var"));
            this.setCommon((DBObjectPlSqlFragment)variable, name, frag.getFirstToken().getStart(), frag.getFirstToken().getEnd(), this.m_variableSearch.getNamedMatchStartToken("var"));
            startTk = this.m_variableSearch.getNamedMatchStartToken("datatype");
            endTk = this.m_variableSearch.getNamedMatchEndToken("datatype");
            PlSqlReference ref = this.findDataTypeReference(startTk, endTk, variable.getParent());
            variable.setDataTypeReference(ref);
            startTk = endTk.getNextCodeToken();
            endTk = frag.getLastToken();
            while (startTk.getStart() < endTk.getStart()) {
                startTk = this.buildReferences(startTk, endTk, (DBObjectPlSqlFragment)variable.getParent());
            }
        }
    }

    private void buildDatatype(PlSqlDatatype datatype, PlSqlFragment frag) throws CancelledException {
        PlSqlToken tk = frag.getFirstToken();
        if (!this.m_datatypeSearch.matches(tk)) {
            this.setCommon((DBObjectPlSqlFragment)datatype, null, tk.getStart(), tk.getNextCodeToken().getEnd(), null);
        } else {
            PlSqlDatatype.Structure struct;
            datatype.setSubType(this.m_datatypeSearch.getNamedMatch("type").equals("SUBTYPE"));
            String name = this.getProvider().getInternalName(this.m_datatypeSearch.getNamedMatch("name"));
            try {
                struct = PlSqlDatatype.Structure.valueOf((String)this.m_datatypeSearch.getNamedMatch("structure"));
            }
            catch (Exception e) {
                struct = PlSqlDatatype.Structure.SCALAR;
            }
            datatype.setStructure(struct);
            this.setCommon((DBObjectPlSqlFragment)datatype, name, tk.getStart(), tk.getNextCodeToken().getEnd(), this.m_datatypeSearch.getNamedMatchStartToken("name"));
            tk = tk.getNextCodeToken();
            if (struct != PlSqlDatatype.Structure.RECORD) {
                PlSqlToken endTk;
                tk = tk.getNextCodeToken();
                if (struct == PlSqlDatatype.Structure.TABLE) {
                    tk = tk.getNextCodeToken(2);
                } else if (struct == PlSqlDatatype.Structure.VARRAY) {
                    tk = tk.getNextCodeToken(3);
                    Integer limit = null;
                    try {
                        limit = Integer.valueOf(tk.getSource());
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    datatype.setLimit(limit);
                    tk = tk.getNextCodeToken(2);
                }
                tk = tk.getNextCodeToken();
                for (endTk = frag.getLastToken(); endTk != tk && endTk.getType() == PlSqlToken.Type.PUNCTUATION && !endTk.matches(")"); endTk = endTk.getPrevCodeToken()) {
                }
                PlSqlReference ref = this.findDataTypeReference(tk, endTk, datatype.getParent());
                if (ref != null) {
                    PlSqlDatatype par;
                    for (par = datatype; par != null && !(par instanceof PlSqlBlock); par = par.getParent()) {
                    }
                    if (par instanceof PlSqlBlock) {
                        ((PlSqlBlock)par).addReference(ref);
                        datatype.setBaseTypeID(ref.getReferenceID());
                    }
                }
            }
        }
    }

    protected void setCommon(DBObjectPlSqlFragment dboFrag, String name, int start, int end, PlSqlToken nameToken) throws CancelledException {
        this.m_dpb.checkInterruptOrCancel((PlSqlBlock)this.m_sourceObject);
        dboFrag.setID(TemporaryObjectID.createID((DBObject)dboFrag));
        dboFrag.setName(name);
        dboFrag.setStartOffset(Integer.valueOf(start));
        dboFrag.setEndOffset(Integer.valueOf(end));
        if (dboFrag.getParent() instanceof PlSqlBlock && !(dboFrag instanceof PlSqlReference) && nameToken != null) {
            this.buildReference((PlSqlBlock)dboFrag.getParent(), Collections.singletonList(name), nameToken.getStart(), nameToken.getEnd());
        }
    }

    protected void buildReference(PlSqlBlock block, List<String> names, int start, int end) throws CancelledException {
        int size = names.size();
        if (size > 0) {
            String name = String.valueOf(block.getReferences() == null ? 0 : block.getReferences().length);
            PlSqlReference ref = new PlSqlReference();
            ref.setReferenceNames(names.toArray(new String[names.size()]));
            this.setCommon((DBObjectPlSqlFragment)ref, name, start, end, null);
            block.addReference(ref);
        }
    }

    protected final DBObjectProvider getProvider() {
        return this.m_provider;
    }

    protected PlSqlReference findDataTypeReference(PlSqlToken start, PlSqlToken end, DBObject dbo) throws CancelledException {
        PlSqlToken lastTk;
        PlSqlReference retval = new PlSqlReference();
        PlSqlReference.ReferenceType refType = PlSqlReference.ReferenceType.DIRECT;
        if (start.matches("ref") && !start.getNextCodeToken().matches(".")) {
            start = start.getNextCodeToken();
            refType = PlSqlReference.ReferenceType.REF;
        }
        ArrayList<PlSqlToken> tokens = new ArrayList<PlSqlToken>();
        ArrayList<String> names = new ArrayList<String>();
        this.buildNameAndTokenLists(start, end, false, tokens, names);
        if (names.size() > 0 && refType != PlSqlReference.ReferenceType.REF && (lastTk = (PlSqlToken)tokens.get(tokens.size() - 1)).getNextCodeToken() != null && lastTk.getNextCodeToken().matches("%")) {
            if ((lastTk = lastTk.getNextCodeToken()).getNextCodeToken() != null && lastTk.getNextCodeToken().matches("type")) {
                refType = PlSqlReference.ReferenceType.PCT_TYPE;
            } else if (lastTk.getNextCodeToken() != null && lastTk.getNextCodeToken().matches("rowtype")) {
                refType = PlSqlReference.ReferenceType.PCT_ROWTYPE;
            }
        }
        retval.setReferenceType(refType);
        if ((refType == PlSqlReference.ReferenceType.DIRECT || refType == PlSqlReference.ReferenceType.REF) && this.m_selfSearch != null && this.m_selfSearch.matches(start, end)) {
            retval.setReferences(new DBObjectID[]{this.m_sourceObject.getID()});
        } else {
            if (refType == PlSqlReference.ReferenceType.DIRECT) {
                retval.setDataTypeUsageSource(start.getSource(true, end));
            }
            retval.setReferenceNames(names.toArray(new String[names.size()]));
        }
        this.setCommon((DBObjectPlSqlFragment)retval, "DataType", start.getStart(), end.getEnd(), null);
        return retval;
    }

    protected final PlSqlSourceObject getPlSqlSourceObject() {
        return this.m_sourceObject;
    }

    private String getCompanionObjectType(PlSqlSchemaObject obj) {
        String otherType = obj instanceof Package ? "PACKAGE BODY" : (obj instanceof Type ? "TYPE BODY" : (obj instanceof PackageBody ? "PACKAGE" : (obj instanceof TypeBody ? "TYPE" : null)));
        return otherType;
    }
}

