/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlBlock;
import oracle.javatools.db.plsql.PlSqlDerivedPropertyBuilderImpl;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.TriggerDerivedPropertyBuilder;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.TypeDerivedPropertyBuilder;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class PlSqlDerivedPropertySupport {
    public static DerivedPropertyBuilder getPlSqlDerivedPropertyBuilder(DBObjectProvider pro, String type) {
        Class clz = Metadata.getInstance().getObjectClass(type);
        if (!PlSqlBlock.class.isAssignableFrom(clz)) {
            throw new IllegalArgumentException(type + " not a subclass of PlSqlBlock");
        }
        if (!PlSqlSourceObject.class.isAssignableFrom(clz)) {
            throw new IllegalArgumentException(type + "type does not implement PlSqlSourceObject");
        }
        PlSqlDerivedPropertySupport.checkProvider(pro);
        return new PlSqlDerivedPropertyBuilder((AbstractDBObjectProvider)pro, type);
    }

    private static void checkProvider(DBObjectProvider pro) {
        if (!(pro instanceof AbstractDBObjectProvider)) {
            throw new IllegalArgumentException("pro not an AbstractDBObjectProvider");
        }
    }

    public static DerivedPropertyBuilder getPlSqlReferenceDerivedPropertyBuilder(DBObjectProvider pro) {
        PlSqlDerivedPropertySupport.checkProvider(pro);
        return new PlSqlReferenceDerivedPropertyBuilder((AbstractDBObjectProvider)pro);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PlSqlReferenceDerivedPropertyBuilder
    extends DerivedPropertyBuilder<PlSqlReference> {
        private PlSqlReferenceDerivedPropertyBuilder(AbstractDBObjectProvider pro) {
            super(pro, "PlSqlReference");
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"references"})
        public void buildReferences(PlSqlReference ref) {
            String[] names = ref.getReferenceNames();
            DBObject context = ref.getParent();
            if (context != null && names != null && names.length > 0) {
                List<DBObjectID> ids = PlSqlUtil.findReferences(Arrays.asList(names), (DBObjectProvider)this.getProvider(), context);
                ref.setReferences(ids.toArray(new DBObjectID[ids.size()]));
            }
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"dataTypeUsage"})
        public void buildTypeUsage(PlSqlReference ref) {
            String dtuString = ref.getDataTypeUsageSource();
            if (dtuString != null) {
                DataType dt;
                DataTypeUsage dtu;
                AbstractDBObjectProvider pro = this.getProvider();
                PlSqlSourceObject so = (PlSqlSourceObject)DBUtil.findParentOfType((DBObject)ref, PlSqlSourceObject.class);
                Schema schema = DBUtil.getSchema((DBObject)so);
                if (schema == null) {
                    try {
                        schema = pro.getDefaultSchema();
                    }
                    catch (DBException e) {
                        schema = null;
                    }
                }
                if ((dtu = DataTypeHelper.getDataTypeUsageForString((DBObjectProvider)pro, (Schema)schema, (String)dtuString)) == null && (dt = pro.getDataType(dtuString)) != null) {
                    dtu = dt.createDefaultUsage();
                }
                ref.setDataTypeUsage(dtu);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PlSqlDerivedPropertyBuilder<T extends PlSqlBlock>
    extends DerivedPropertyBuilder<T> {
        private final Holder<PlSqlInterrogator> m_holder = new Holder();

        private PlSqlDerivedPropertyBuilder(AbstractDBObjectProvider pro, String type) {
            super(pro, type);
        }

        public Collection<String> clearDerivedProperties(T obj, DBObjectChange change) {
            Collection<String> ret;
            block8: {
                ret = Collections.emptyList();
                Collection derivedPropNames = this.getDerivedProperties("source");
                boolean anyDerivedPropsBuilt = false;
                for (String prop : derivedPropNames) {
                    if (DBUtil.needsBuilding(obj, (String)prop)) continue;
                    anyDerivedPropsBuilt = true;
                    break;
                }
                if (!anyDerivedPropsBuilt) break block8;
                PropertyChangeEvent sourceEvent = change.getPropertyChange("source");
                if (sourceEvent != null) {
                    ret = super.clearDerivedProperties(obj, "source", change);
                } else {
                    Map childMap = change.getOwnedObjectsUpdated();
                    PlSqlSourceObject so = (PlSqlSourceObject)obj;
                    if (childMap == null || childMap.isEmpty()) {
                        Collection props = change.getAllChangedProperties();
                        String currentSource = ((PlSqlSourceObject)obj).getSource();
                        for (String property : props) {
                            if (!"name".equals(property) && !this.getDerivedProperties("source").contains(property)) continue;
                            this.updateSource(so, (DBObject)so, property, change);
                        }
                    } else {
                        for (Map.Entry entry : childMap.entrySet()) {
                            DBObject changed = (DBObject)entry.getKey();
                            if (!(changed instanceof PlSqlParameter)) continue;
                            Collection props = ((DBObjectChange)entry.getValue()).getAllChangedProperties();
                            for (String property : props) {
                                this.updateSource(so, changed, property, (DBObjectChange)entry.getValue());
                            }
                        }
                    }
                }
            }
            return ret;
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"source"}, derived=true)
        public boolean buildAllProperties(T obj) throws DBException {
            PlSqlSourceObject sourceObject = (PlSqlSourceObject)obj;
            AbstractDBObjectProvider pro = this.getProvider();
            if (sourceObject instanceof DBObjectPlSqlFragment && ModelUtil.hasLength((String)sourceObject.getSource())) {
                if (SwingUtilities.isEventDispatchThread()) {
                    DBLog.getLogger((Object)((Object)this)).log(Level.SEVERE, "Building PL/SQL derived properties on EDT", new IllegalStateException());
                }
                PlSqlDerivedPropertyBuilderImpl propBuilder = sourceObject instanceof Trigger ? new TriggerDerivedPropertyBuilder(sourceObject, (DBObjectProvider)pro) : (sourceObject instanceof Type ? new TypeDerivedPropertyBuilder(sourceObject, (DBObjectProvider)pro) : new PlSqlDerivedPropertyBuilderImpl(sourceObject, (DBObjectProvider)pro));
                try {
                    propBuilder.buildProperties(this);
                }
                catch (CancelledException ce) {
                    throw ce;
                }
                catch (Throwable t) {
                    this.getLogger().log(Level.SEVERE, t.getMessage(), t);
                }
                String s = sourceObject.getSource();
                sourceObject.setProperty("startOffset", (Object)0);
                sourceObject.setProperty("endOffset", (Object)(s == null ? 0 : s.length()));
            }
            return true;
        }

        public void cancelCurrentBuild(T object) {
            PlSqlInterrogator pi = (PlSqlInterrogator)this.m_holder.get();
            if (pi != null) {
                pi.cancelCurrentBuild();
            }
            super.cancelCurrentBuild(object);
        }

        protected void checkInterruptOrCancel(T object) throws CancelledException {
            super.checkInterruptOrCancel(object);
        }

        protected Holder<PlSqlInterrogator> getInterrogator() {
            return this.m_holder;
        }

        private void updateSource(PlSqlSourceObject so, DBObject referencedObject, String propName, DBObjectChange change) {
            Object oldVal = "name".equals(propName) || "schema".equals(propName) ? change.getPropertyChange(propName).getOldValue() : null;
            PlSqlUtil.updateSoureForPropertyChange(so, (DBObjectProvider)this.getProvider(), referencedObject, propName, oldVal, true);
        }
    }
}

