/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.StackParser;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlInterrogatorFactory;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlSqlParserHelper {
    public static final List<Issue> getIssues(PlSqlSourceObject so) {
        String text;
        PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)so);
        if (ModelUtil.hasLength((String)pi.getCollectionType()) || pi.isWrapped()) {
            text = "begin null; end;";
        } else {
            StringBuilder sb = new StringBuilder();
            PlSqlFragment frag = pi.getRoot();
            if (frag != null) {
                PlSqlFragment tableFrag;
                PlSqlFragment blockFrag;
                PlSqlToken firstTk = pi.getTokenAtOffset(0);
                PlSqlToken lastTk = frag.getLastToken();
                if (pi.isEvolvedType()) {
                    frag = pi.getRoot().getChildren()[0];
                    lastTk = frag.getLastToken();
                } else if (so instanceof Trigger && (blockFrag = frag.findChild(PlSqlFragment.Type.PLSQL_BLOCK, true)) != null) {
                    lastTk = blockFrag.getLastToken();
                }
                sb.append(firstTk.getSource(false, lastTk));
                if (so instanceof Trigger && (tableFrag = frag.findChild(PlSqlFragment.Type.TRIGGER_TABLE, true)) != null) {
                    PlSqlToken endTk = tableFrag.getLastToken();
                    for (PlSqlToken tk = tableFrag.getFirstToken(); tk != endTk; tk = tk.getNextCodeToken()) {
                        for (int i = tk.getStart(); i <= tk.getEnd(); ++i) {
                            sb.replace(i, i + 1, " ");
                        }
                    }
                }
                if (!firstTk.isCode()) {
                    firstTk = firstTk.getNextCodeToken();
                }
                if (!firstTk.matches("CREATE")) {
                    sb.insert(0, "CREATE\n");
                }
                if (!lastTk.matches(";")) {
                    sb.append(";");
                }
            }
            text = sb.toString();
        }
        return PlSqlParserHelper.getIssues(text);
    }

    public static final List<Issue> getIssues(String text) {
        ArrayList<Issue> ret = new ArrayList<Issue>();
        try {
            List src = LexerToken.parse((String)text);
            LazyNode root = StackParser.getInstance().parse(src);
            int pos = LexerToken.scanner2parserOffset((List)src, (int)text.length());
            if (root != null) {
                for (ParseNode n : root.ancestors(pos)) {
                    if (!(n instanceof LazyNode)) continue;
                    LazyNode node = (LazyNode)n;
                    if (node.to - node.from < 4 || !node.isDDL(null) && !node.isDML(null) && !node.isProcedure() && !node.isStmt(root) && node != root || node == root && node.from + 1000 < node.to || node.from + 2000 < node.to) continue;
                    LinkedList fragment = node.getSrcFragment();
                    SqlEarley earley = SqlEarley.getInstance();
                    Matrix matrix = new Matrix((Parser)earley);
                    earley.parse((List)fragment, matrix);
                    LexerToken startToken = (LexerToken)src.get(n.from);
                    SyntaxError err = SyntaxError.checkSyntax((String)text.substring(startToken.begin, ((LexerToken)src.get((int)(n.to - 1))).end), (String[])new String[]{"sql_statements", "subprg_body"}, (List)fragment, (Earley)earley, (Matrix)matrix);
                    if (err == null) continue;
                    ++err.line;
                    err.end = err.end;
                    int begin = startToken.begin + err.end;
                    int end = begin + 3;
                    if (text.length() < end) {
                        end = text.length();
                    }
                    ret.add(new IssueImpl(begin, end, Severity.ERROR, err.getMessage()));
                }
            }
        }
        catch (Exception e) {
            ret.add(new IssueImpl(0, 1, Severity.ERROR, e.getMessage()));
        }
        return ret;
    }

    private static class IssueImpl
    implements Issue {
        private final int m_start;
        private final int m_end;
        private final Severity m_sev;
        private final String m_mess;

        private IssueImpl(int start, int end, Severity sev, String message) {
            this.m_start = start;
            this.m_end = end;
            this.m_sev = sev;
            this.m_mess = message;
        }

        public int getStartOffset() {
            return this.m_start;
        }

        public int getEndOffset() {
            return this.m_end;
        }

        public Severity getSeverity() {
            return this.m_sev;
        }

        public String getMessage() {
            return this.m_mess;
        }
    }

    public static interface Issue {
        public int getStartOffset();

        public int getEndOffset();

        public Severity getSeverity();

        public String getMessage();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        ERROR,
        WARNING,
        INFO;

    }
}

