/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.Index;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.DefaultSourceOptions;
import oracle.javatools.db.plsql.Package;
import oracle.javatools.db.plsql.PackageBody;
import oracle.javatools.db.plsql.PlSqlBlock;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlInterrogatorFactory;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlReferenceResolver;
import oracle.javatools.db.plsql.PlSqlSchemaObject;
import oracle.javatools.db.plsql.PlSqlSchemaObjectBody;
import oracle.javatools.db.plsql.PlSqlSchemaObjectSpec;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.PlSqlUtilCore;
import oracle.javatools.db.plsql.Procedure;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.TypeBody;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlSqlUtil
extends PlSqlUtilCore {
    public static final String SUBPROGRAM_SEARCH = "<type {PROCEDURE|FUNCTION}> <signature {^{RETURN|AS|IS|;}}... [RETURN <datatype ?%>]>";
    public static final String METHOD_SEARCH = "[overriding] [{map|order}] {member|static} [[final][instantiable]constructor] <type {PROCEDURE|FUNCTION}> <signature {^{RETURN|AS|IS|;}}... [RETURN <datatype {SELF AS RESULT|?%}>]>";
    public static final String PARAMETER_SEARCH = "<param ?> [<mode {IN OUT|OUT|IN}>] [<nocopy NOCOPY>] <datatype ?%> [{DEFAULT|:=} <default ?.[(...)]>]";
    public static final String DATATYPE_SEARCH = "<type {PROCEDURE|FUNCTION}> <signature {^{RETURN|AS|IS|;}}... [RETURN <datatype ?%>]>";
    public static final String VARIABLE_SEARCH = "<var ?> [CONSTANT] <datatype ?%>";
    public static final String INTO_SEARCH = "select {^{into|from}}... into <intoClause {^from}...>";
    private static final String SP = " ";
    private static final String SP2 = "  ";
    private static final String SP4 = "    ";
    private static final String NEWLINE = "\n";
    private static final String SEMICOLON = ";";
    private static final String AS = "AS";
    private static final String IS = "IS";
    private static final String BEGIN = "BEGIN";
    private static final String CREATE_OR_REPLACE = "CREATE OR REPLACE";
    private static final String BODY = "BODY";
    private static final String END = "END";
    private static final String NULL = "NULL";
    private static final String RETURN = "RETURN";
    private static final String SELECT = "SELECT * FROM DUAL;";

    private PlSqlUtil() {
    }

    protected PlSqlSubProgram findPlSqlSubProgramImpl(String callSignature, PlSqlBlock block) {
        String[] bits;
        ArrayList<String> names = new ArrayList<String>();
        for (String bit : bits = callSignature.replace("(", ".(").split("\\.")) {
            names.add(bit);
        }
        return PlSqlUtil.findPlSqlSubProgram(names, block);
    }

    protected List<DBObject> getPlSqlFragmentReferersImpl(PlSqlSourceObject so, DBObjectID to) {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        if (to != null) {
            String name = DBUtil.getDBObjectName((DBObjectID)to);
            String type = to.getType();
            Class clz = Metadata.getInstance().getObjectClass(type);
            boolean ok = SchemaObject.class.isAssignableFrom(clz) && Index.class != clz || DBObjectPlSqlFragment.class.isAssignableFrom(clz) || Column.class == clz;
            if (name != null && ok && so.getSource() != null) {
                PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)so);
                String search = name.contains("(") ? name.substring(0, name.indexOf("(")) : name;
                for (Integer pos : pi.getLocationOffsets(search)) {
                    DBObjectPlSqlFragment f = so.getReferenceAtOffset(pos.intValue());
                    if (f == null) continue;
                    PlSqlUtil.addRefs((DBObject)f, to, list);
                }
            }
        }
        return list;
    }

    protected String getNameFromSourceImpl(String source) {
        return PlSqlUtil.getTypeAndNameFromSource((String)source, null).m_name;
    }

    public static void registerPlSqlUtil() {
        PlSqlUtil utils = new PlSqlUtil();
        PlSqlUtil.setInstance((PlSqlUtilCore)utils);
    }

    public static PlSqlSubProgram findPlSqlSubProgram(List<String> names, PlSqlBlock block) {
        String name;
        if (names.size() > 2 || names.size() == 2 && !names.get(1).startsWith("(")) {
            return null;
        }
        ArrayList<PlSqlSubProgram> candidates = new ArrayList<PlSqlSubProgram>();
        ArrayList<String> args = new ArrayList<String>();
        if (names.get(names.size() - 1).startsWith("(")) {
            name = names.get(names.size() - 2);
            StringTokenizer tok = new StringTokenizer(names.get(names.size() - 1), "(),", false);
            while (tok.hasMoreTokens()) {
                args.add(tok.nextToken());
            }
        } else {
            name = names.get(names.size() - 1);
        }
        PlSqlSubProgram firstMatchByName = null;
        for (PlSqlSubProgram prog : block.getSubPrograms()) {
            String progName;
            String pname = prog.getName();
            String string = progName = pname == null ? null : prog.getName().split("[\\( ]")[0];
            if (!name.equals(progName)) continue;
            if (firstMatchByName == null) {
                firstMatchByName = prog;
            }
            if (args.size() > prog.getParameters().length) continue;
            boolean unmatchedArg = false;
            for (String arg : args) {
                PlSqlParameter p;
                if ("?".equals(arg) || (p = prog.getParameter(arg)) != null) continue;
                unmatchedArg = true;
                break;
            }
            if (unmatchedArg) continue;
            candidates.add(prog);
        }
        if (candidates.size() == 0) {
            return firstMatchByName;
        }
        for (int i = candidates.size() - 1; i >= 0; --i) {
            ArrayList<PlSqlParameter> params = new ArrayList<PlSqlParameter>();
            boolean delete = false;
            for (PlSqlParameter param : ((PlSqlSubProgram)candidates.get(i)).getParameters()) {
                params.add(param);
            }
            boolean nameRequired = false;
            for (int j = 0; j < args.size(); ++j) {
                if (nameRequired && "?".equals(args.get(j))) {
                    delete = true;
                    break;
                }
                if ("?".equals(args.get(j))) {
                    params.set(j, null);
                    continue;
                }
                for (int k = 0; k < params.size(); ++k) {
                    if (params.get(k) == null || !((String)args.get(j)).equals(((PlSqlParameter)params.get(k)).getName())) continue;
                    params.set(k, null);
                    break;
                }
                nameRequired = true;
            }
            for (int k = 0; k < params.size(); ++k) {
                if (params.get(k) == null || ((PlSqlParameter)params.get(k)).getMode() != PlSqlParameter.Mode.OUT && ((PlSqlParameter)params.get(k)).getMode() != PlSqlParameter.Mode.INOUT && ((PlSqlParameter)params.get(k)).getDefaultValue() != null) continue;
                delete = true;
                break;
            }
            if (!delete) continue;
            candidates.remove(i);
        }
        if (candidates.size() < 2) {
            return candidates.size() == 0 ? firstMatchByName : (PlSqlSubProgram)candidates.get(0);
        }
        return (PlSqlSubProgram)candidates.get(0);
    }

    public static List<DBObject> getPlSqlFragmentReferers(PlSqlSourceObject so, DBObjectID to) {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        if (to != null) {
            String name = DBUtil.getDBObjectName((DBObjectID)to);
            String type = to.getType();
            Class clz = Metadata.getInstance().getObjectClass(type);
            boolean ok = SchemaObject.class.isAssignableFrom(clz) && Index.class != clz || DBObjectPlSqlFragment.class.isAssignableFrom(clz) || Column.class == clz;
            if (name != null && ok && so.getSource() != null) {
                PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)so);
                String search = name.contains("(") ? name.substring(0, name.indexOf("(")) : name;
                for (Integer pos : pi.getLocationOffsets(search)) {
                    DBObjectPlSqlFragment f = ((DBObjectPlSqlFragment)so).getReferenceAtOffset(pos.intValue());
                    if (f == null) continue;
                    PlSqlUtil.addRefs((DBObject)f, to, list);
                }
            }
        }
        return list;
    }

    private static void addRefs(DBObject obj, DBObjectID to, List<DBObject> list) {
        DBObjectID[] ids = obj instanceof PlSqlReference ? ((PlSqlReference)obj).getReferences() : obj.getReferenceIDs();
        for (DBObjectID dBObjectID : ids) {
            if (!DBUtil.isSameOrChildOf((DBObjectID)dBObjectID, (DBObjectID)to, (boolean)false)) continue;
            list.add(obj);
            break;
        }
        for (DBObjectID dBObjectID : obj.getOwnedObjects()) {
            PlSqlUtil.addRefs((DBObject)dBObjectID, to, list);
        }
    }

    public static boolean updateSoureForPropertyChange(PlSqlSourceObject so, DBObjectProvider pro, DBObject referencedObject, String propName, Object newValue) {
        return PlSqlUtil.updateSoureForPropertyChange(so, pro, referencedObject, propName, newValue, false);
    }

    private static String getName(String propName, Object value) {
        String name;
        if ("schema".equals(propName)) {
            name = ((Schema)value).getName();
        } else if (((String)value).contains("(")) {
            String justname = (String)value;
            name = justname = justname.substring(0, justname.indexOf("("));
        } else {
            name = (String)value;
        }
        return name;
    }

    public static boolean updateSoureForPropertyChange(PlSqlSourceObject so, DBObjectProvider pro, DBObject referencedObject, String propName, Object value, boolean changeMade) {
        boolean retval = false;
        if (ModelUtil.hasLength((String)so.getSource())) {
            if ("name".equals(propName) || "schema".equals(propName)) {
                PlSqlInterrogator pi;
                Object newValue;
                Object oldValue;
                DBObjectID origID = referencedObject.getID();
                if (changeMade) {
                    oldValue = value;
                    newValue = referencedObject.getProperty(propName);
                } else {
                    newValue = value;
                    oldValue = referencedObject.getProperty(propName);
                }
                String newName = PlSqlUtil.getName(propName, newValue);
                if (PlSqlUtil.isBodyOf(referencedObject, (DBObject)so)) {
                    PlSqlInterrogator pi2 = PlSqlInterrogatorFactory.getInterrogator((SourceObject)so);
                    String renamed = pi2.getRenamedSource(newName);
                    so.setSource(renamed);
                    pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)so);
                    retval = true;
                } else {
                    pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)so);
                }
                String name = PlSqlUtil.getName(propName, oldValue);
                List list = pi.getLocationOffsets(name);
                if (so == referencedObject && !pi.getName().equals(name)) {
                    list.add(pi.getNameOffset());
                }
                Object[] sorted = list.toArray(new Integer[list.size()]);
                Arrays.sort(sorted);
                ArrayList<PlSqlReference> refs = new ArrayList<PlSqlReference>();
                for (Object i : sorted) {
                    DBObjectPlSqlFragment f = ((DBObjectPlSqlFragment)so).getReferenceAtOffset(((Integer)i).intValue());
                    if (f instanceof PlSqlReference) {
                        refs.add((PlSqlReference)f);
                        continue;
                    }
                    if (f == null || !origID.equals(f.getID(), false)) continue;
                    PlSqlReference selfRef = new PlSqlReference();
                    DBObjectID[] references = new DBObjectID[]{f.getID()};
                    selfRef.setReferences(references);
                    if (referencedObject instanceof PlSqlSubProgram) {
                        PlSqlToken tk = pi.getTokenAtOffset(f.getStartOffset().intValue());
                        tk = tk.getNextCodeToken();
                        selfRef.setStartOffset(Integer.valueOf(tk.getStart()));
                        selfRef.setEndOffset(Integer.valueOf(tk.getEnd()));
                    } else {
                        selfRef.setStartOffset(f.getStartOffset());
                        selfRef.setEndOffset(f.getEndOffset());
                    }
                    refs.add(selfRef);
                }
                StringBuilder sb = new StringBuilder();
                String source = so.getSource();
                int lastOffset = source.length();
                block6: for (int i = refs.size() - 1; i >= 0; --i) {
                    PlSqlReference ref = (PlSqlReference)refs.get(i);
                    DBObjectID[] arr$ = ref.getReferences();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        DBObjectID id;
                        DBObjectID refID = id = arr$[i$];
                        PlSqlToken startTk = pi.getTokenAtOffset(ref.getStartOffset().intValue());
                        PlSqlToken endTk = pi.getTokenAtOffset(ref.getEndOffset().intValue());
                        PlSqlToken tk = startTk;
                        if (ref.getReferenceType() == PlSqlReference.ReferenceType.PCT_TYPE || ref.getReferenceType() == PlSqlReference.ReferenceType.PCT_ROWTYPE) {
                            endTk = endTk.getPrevToken().getPrevToken();
                        } else if (origID.equals(refID, false) && referencedObject instanceof PlSqlParameter) {
                            endTk = startTk;
                        }
                        while (refID != null) {
                            boolean selfRef = false;
                            if (changeMade && refID instanceof TemporaryObjectID) {
                                DBObject x = null;
                                try {
                                    x = refID.resolveID();
                                    if (x == referencedObject) {
                                        selfRef = true;
                                    }
                                }
                                catch (DBException e) {
                                    // empty catch block
                                }
                            }
                            if (selfRef || origID.equals(refID, false)) {
                                tk = endTk;
                                break;
                            }
                            if ((refID = refID.getParent()) == null) continue;
                            if (endTk.getEnd() != startTk.getEnd() && endTk.getPrevToken().matches(".")) {
                                endTk = endTk.getPrevToken().getPrevToken();
                                continue;
                            }
                            refID = null;
                        }
                        if (refID == null) continue;
                        retval = true;
                        sb.insert(0, source.substring(tk.getEnd() + 1, lastOffset));
                        lastOffset = tk.getStart();
                        if ("schema".equals(propName)) {
                            sb.insert(0, tk.getSource());
                            if (!tk.getPrevCodeToken().matches(".")) {
                                sb.insert(0, ".");
                            } else {
                                tk = tk.getPrevCodeToken().getPrevCodeToken();
                                lastOffset = tk.getStart();
                                if (so.getSchema().getName().equals(newName)) continue;
                                sb.insert(0, ".");
                            }
                        }
                        String newExtName = pro.getExternalName(newName);
                        String tkStr = tk.getSource();
                        if (!newName.equals(newExtName)) {
                            sb.insert(0, newExtName);
                            continue block6;
                        }
                        if (tk.getType() == PlSqlToken.Type.DOUBLE_QUOTED_STRING && !pro.getExternalName(pro.getInternalName(tkStr)).equals(tkStr)) {
                            sb.insert(0, "\"");
                            sb.insert(0, newName);
                            sb.insert(0, "\"");
                            continue block6;
                        }
                        if (tkStr.toLowerCase().equals(tkStr)) {
                            sb.insert(0, newName.toLowerCase());
                            continue block6;
                        }
                        sb.insert(0, newName);
                        continue block6;
                    }
                }
                if (retval) {
                    sb.insert(0, source.substring(0, lastOffset));
                    so.setSource(sb.toString());
                }
            } else if (referencedObject == so || referencedObject instanceof PlSqlParameter && referencedObject.getParent() == so) {
                PlSqlInterrogator piOrig = PlSqlInterrogatorFactory.getInterrogator((SourceObject)so);
                PlSqlToken tk = piOrig.getRoot().getFirstToken();
                while (tk.getType() != PlSqlToken.Type.ALPHANUMERIC && tk.getType() != PlSqlToken.Type.END_MARKER) {
                    tk = tk.getNextToken();
                }
                boolean lower = false;
                if (tk.getType() == PlSqlToken.Type.ALPHANUMERIC) {
                    String tkStr = tk.getSource();
                    lower = tkStr.equals(tkStr.toLowerCase());
                }
                if (so instanceof Procedure) {
                    Procedure upd = null;
                    try {
                        upd = (Procedure)so.getClass().newInstance();
                        upd = (Procedure)so.copyTo((Object)upd);
                        upd.setSource(null);
                    }
                    catch (IllegalAccessException e) {
                        DBLog.getLogger(PlSqlUtil.class).warning("Failed to create copy: " + e.getMessage());
                    }
                    catch (InstantiationException e) {
                        DBLog.getLogger(PlSqlUtil.class).warning("Failed to create copy: " + e.getMessage());
                    }
                    String source = PlSqlUtil.getDefaultSource(pro, (PlSqlSourceObject)upd, lower);
                    upd.setSource(source);
                    PlSqlInterrogator piUpd = PlSqlInterrogatorFactory.getInterrogator((SourceObject)upd);
                    Pair<PlSqlToken, PlSqlToken> origLimits = PlSqlUtil.getParameterLimits(piOrig.getRoot().getFirstToken());
                    Pair<PlSqlToken, PlSqlToken> updLimits = PlSqlUtil.getParameterLimits(piUpd.getRoot().getFirstToken());
                    StringBuilder sb = new StringBuilder();
                    sb.append(so.getSource().substring(0, ((PlSqlToken)origLimits.first).getStart()));
                    sb.append(upd.getSource().substring(((PlSqlToken)updLimits.first).getStart(), ((PlSqlToken)updLimits.second).getStart()));
                    sb.append(so.getSource().substring(((PlSqlToken)origLimits.second).getStart()));
                    so.setSource(sb.toString());
                } else if (so instanceof Trigger) {
                    Trigger trig2 = new Trigger();
                    for (Map.Entry e : so.getProperties().entrySet()) {
                        if ("source".equals(e.getKey())) continue;
                        trig2.setProperty((String)e.getKey(), e.getValue());
                    }
                    trig2.setSchema(so.getSchema());
                    StringBuilder sb = new StringBuilder(PlSqlUtil.getDefaultSource(pro, (PlSqlSourceObject)trig2, lower));
                    PlSqlToken tk2 = tk.getTokenAt(0);
                    if (!tk2.isCode()) {
                        PlSqlToken tk3 = tk2.getNextCodeToken().getPrevToken();
                        sb.insert(0, tk2.getSource(false, tk3));
                    }
                    so.setSource(sb.toString());
                }
            }
        }
        return retval;
    }

    public static boolean isBodyOf(DBObject spec, DBObject body) {
        DBObjectID bodySpecID;
        boolean retval = false;
        if (spec instanceof PlSqlSchemaObjectSpec && body instanceof PlSqlSchemaObjectBody && (bodySpecID = ((PlSqlSchemaObjectBody)body).getSpecID()) != null) {
            retval = bodySpecID.equals(spec.getID(), false);
        }
        return retval;
    }

    @Deprecated
    public static void rebuildSource(DBObjectProvider pro, PlSqlSourceObject obj) {
    }

    public static String getDefaultSource(DBObjectProvider pro, PlSqlSourceObject obj) {
        boolean lower = false;
        GlobalSettings settings = GlobalSettings.getInstance();
        if (settings != null) {
            lower = settings.isNewPlSqlLowerCase();
        }
        return PlSqlUtil.getDefaultSource(pro, obj, lower);
    }

    @Deprecated
    public static String getDefaultSource(DBObjectProvider pro, PlSqlSourceObject obj, DDLGenerator gen) {
        return PlSqlUtil.getDefaultSource(pro, obj);
    }

    private static String getDefaultSource(DBObjectProvider pro, PlSqlSourceObject obj, boolean lower) {
        DatabaseDescriptor desc = pro.getDescriptor();
        DefaultSourceOptions srcOpts = desc.getDefaultSourceOptions();
        boolean disableTrigger = false;
        if (obj instanceof Trigger) {
            Trigger trig = (Trigger)obj;
            if ("".equals(trig.getWhenClause())) {
                trig.setWhenClause(null);
            }
            if (!trig.isEnabled() && srcOpts.isEnableTriggers()) {
                disableTrigger = true;
                trig.setEnabled(true);
            }
        }
        DDLOptions options = new DDLOptions(srcOpts.isUseCreateOrReplace(), false);
        DDLGenerator gen = pro.getDDLGenerator();
        String source = gen.getCreateDDL(options, new DBObject[]{obj}).toString(srcOpts.isIncludeTerminators());
        if (lower) {
            StringBuilder sb = new StringBuilder();
            PlSqlInterrogator pi = PlSqlInterrogator.findOrCreate((String)source);
            PlSqlToken tk = pi.getRoot().getFirstToken();
            while (tk.getType() != PlSqlToken.Type.END_MARKER) {
                tk = tk.getPrevToken();
            }
            tk = tk.getNextToken();
            while (tk.getType() != PlSqlToken.Type.END_MARKER) {
                if (tk.isCode() && !tk.getSource().startsWith("\"")) {
                    sb.append(tk.getSource().toLowerCase());
                } else {
                    sb.append(tk.getSource());
                }
                tk = tk.getNextToken();
            }
            source = sb.toString();
        }
        if (disableTrigger) {
            ((Trigger)obj).setEnabled(false);
        }
        return source;
    }

    @Deprecated
    public static void setSource(PlSqlSourceObject sourceObject, String source, boolean clearDerived) {
    }

    @Deprecated
    public static void clearDerivedProperties(SourceObject sourceObject) {
    }

    @Deprecated
    public static boolean isDerivedPropsBuilt(DBObjectPlSqlFragment frag) {
        return !DBUtil.needsDerivedPropertiesBuilding((DBObject)frag);
    }

    private static Pair<PlSqlToken, PlSqlToken> getParameterLimits(PlSqlToken startTk) {
        Pair ret = new Pair();
        PlSqlSearch head = new PlSqlSearch("{procedure|function} ?.");
        PlSqlSearch tail = new PlSqlSearch("[return ?%] {is|as}");
        PlSqlToken tk = startTk;
        if (head.isWithin(tk)) {
            tk = head.getEndToken();
            tk = tk.getNextToken();
            ret.first = tk;
            if ((tk = tk.getNextCodeToken()).matches("(")) {
                int parens = 1;
                tk = tk.getNextCodeToken();
                while (parens > 0 && tk.getType() != PlSqlToken.Type.END_MARKER) {
                    if (tk.matches("(")) {
                        ++parens;
                    } else if (tk.matches(")")) {
                        --parens;
                    }
                    tk = tk.getNextToken();
                }
            }
            if (tail.isWithin(tk)) {
                tk = tail.getEndToken();
                tk = tk.getPrevToken();
                ret.second = tk;
            }
        }
        return ret;
    }

    public static TypeAndNameInfo getTypeAndNameFromSource(PlSqlSourceObject so, DatabaseDescriptor dd) {
        return PlSqlUtil.getTypeAndNameFromSource(so == null ? null : so.getSource(), dd);
    }

    public static TypeAndNameInfo getTypeAndNameFromSource(String source, DatabaseDescriptor dd) {
        PlSqlToken tk;
        TypeAndNameInfo res = new TypeAndNameInfo();
        PlSqlSearch search = new PlSqlSearch("[create [or replace]] <type {package [body]|type [body]|?}> <name ?.>");
        if (source != null && search.matches(tk = PlSqlTokenizer.tokenize((Reader)new StringReader(source), (Integer)10, (String[])new String[0]))) {
            res.m_type = search.getNamedMatch("type", true);
            res.m_typeStart = search.getNamedMatchStartToken("type").getStart();
            res.m_typeEnd = search.getNamedMatchEndToken("type").getEnd();
            res.m_name = dd == null ? search.getNamedMatchEndToken("name").getSource(true) : dd.getInternalName(search.getNamedMatchEndToken("name").getSource(), res.m_type);
            res.m_nameStart = search.getNamedMatchStartToken("name").getStart();
            res.m_nameEnd = search.getNamedMatchEndToken("name").getEnd();
        }
        return res;
    }

    @Deprecated
    public static boolean containsUnResolvedReferences(PlSqlSourceObject obj, DBObjectProvider pro) {
        return false;
    }

    public static String getDefaultBodyForSpec(PlSqlSourceObject obj, String externalName) {
        StringBuilder body = new StringBuilder();
        if (obj != null) {
            body.append(PlSqlUtil.getDefaultBodyHeaderForSpec(obj, externalName));
            PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)obj);
            PlSqlFragment frag = pi.getRoot();
            if (frag != null && frag.getChildren() != null) {
                frag = frag.getChildren()[0];
            }
            if (frag != null) {
                for (PlSqlFragment subFrag : frag.getChildren()) {
                    if (subFrag.getFragmentType() != PlSqlFragment.Type.PROCEDURE_FD && subFrag.getFragmentType() != PlSqlFragment.Type.FUNCTION_FD && subFrag.getFragmentType() != PlSqlFragment.Type.CURSOR) continue;
                    body.append(PlSqlUtil.getDefaultImplementation(obj, subFrag));
                }
            }
            body.append(PlSqlUtil.getDefaultBodyFooterForSpec(obj, externalName));
        }
        return body.toString();
    }

    private static String getDefaultBodyHeaderForSpec(PlSqlSourceObject obj, String externalName) {
        StringBuilder body = new StringBuilder();
        if (obj != null) {
            body.append(CREATE_OR_REPLACE).append(NEWLINE);
            body.append(obj.getType()).append(SP).append(BODY).append(SP).append(externalName).append(SP).append(AS).append(NEWLINE).append(NEWLINE);
        }
        return PlSqlUtil.toLowerIfNeeded(body.toString());
    }

    private static String getDefaultBodyFooterForSpec(PlSqlSourceObject obj, String externalName) {
        StringBuilder body = new StringBuilder();
        if (obj != null) {
            body.append(END);
            if (!(obj instanceof Type)) {
                body.append(SP).append(externalName);
            }
            body.append(SEMICOLON);
        }
        return PlSqlUtil.toLowerIfNeeded(body.toString());
    }

    public static String getDefaultImplementation(PlSqlSourceObject obj, PlSqlFragment frag) {
        StringBuilder sb = new StringBuilder();
        if (frag.getFragmentType() == PlSqlFragment.Type.PROCEDURE_FD || frag.getFragmentType() == PlSqlFragment.Type.FUNCTION_FD || frag.getFragmentType() == PlSqlFragment.Type.CURSOR) {
            PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)obj);
            PlSqlToken tok = frag.getFirstToken();
            while (!(tok.matches("FUNCTION") || tok.matches("PROCEDURE") || tok.matches("CURSOR"))) {
                tok = tok.getNextCodeToken();
            }
            String type = tok.getSource();
            tok = tok.getNextCodeToken();
            String name = tok.getSource();
            if (frag.getFragmentType() == PlSqlFragment.Type.PROCEDURE_FD || frag.getFragmentType() == PlSqlFragment.Type.FUNCTION_FD) {
                String fd = frag.getSource();
                int pos = fd.length();
                if (obj.getType().equals("PACKAGE")) {
                    pos = fd.lastIndexOf(SEMICOLON);
                }
                sb.append(SP2);
                sb.append(fd.substring(0, pos)).append(SP).append(AS);
                sb.append(NEWLINE).append(SP2).append(BEGIN);
                sb.append(NEWLINE).append(SP4).append(APIBundle.format((String)"NEW_SOURCE_TODO_IMPLEMENTATION_REQD", (Object[])new Object[]{type, pi.getName(), name}));
                sb.append(NEWLINE).append(SP4);
                if (frag.getFragmentType() == PlSqlFragment.Type.FUNCTION_FD) {
                    sb.append(RETURN).append(SP);
                }
                sb.append(NULL).append(SEMICOLON);
                sb.append(NEWLINE).append(SP2).append(END).append(SP).append(name).append(SEMICOLON);
                sb.append(NEWLINE).append(NEWLINE);
            } else if (frag.getFragmentType() == PlSqlFragment.Type.CURSOR) {
                sb.append(SP2);
                PlSqlToken end = frag.getLastToken();
                if (end.matches(SEMICOLON)) {
                    end = end.getPrevCodeToken();
                    sb.append(frag.getFirstToken().getSource(false, end)).append(SP).append(IS);
                    sb.append(NEWLINE).append(SP4).append(APIBundle.format((String)"NEW_SOURCE_TODO_IMPLEMENTATION_REQD", (Object[])new Object[]{type, pi.getName(), name}));
                    sb.append(NEWLINE).append(SP4).append(SELECT);
                }
                sb.append(NEWLINE).append(NEWLINE);
            }
        }
        return PlSqlUtil.toLowerIfNeeded(sb.toString());
    }

    public static String toLowerIfNeeded(String source) {
        boolean lowercasePlSql;
        GlobalSettings settings = GlobalSettings.getInstance();
        boolean bl = lowercasePlSql = settings != null && settings.isNewPlSqlLowerCase();
        if (source != null && lowercasePlSql) {
            StringBuilder sb = new StringBuilder();
            PlSqlToken tk = PlSqlTokenizer.tokenize((String)source, (String[])new String[0]);
            while (tk.getType() != PlSqlToken.Type.END_MARKER) {
                if (tk.isCode(true) && !tk.getSource().startsWith("\"")) {
                    sb.append(tk.getSource().toLowerCase());
                } else {
                    sb.append(tk.getSource());
                }
                tk = tk.getNextToken();
            }
            source = sb.toString();
        }
        return source;
    }

    public static PlSqlSchemaObject getCompanionObject(PlSqlSchemaObject obj, DBObjectProvider pro) {
        PlSqlSchemaObject otherObject = null;
        try {
            if (obj != null) {
                DBObjectID otherID = null;
                if (obj instanceof PlSqlSchemaObjectSpec) {
                    otherID = ((PlSqlSchemaObjectSpec)obj).getBodyID();
                } else if (obj instanceof PlSqlSchemaObjectBody) {
                    otherID = ((PlSqlSchemaObjectBody)obj).getSpecID();
                }
                otherObject = otherID != null ? (PlSqlSchemaObject)otherID.resolveID() : (PlSqlSchemaObject)pro.getObject(PlSqlUtil.getCompanionObjectType(obj), obj.getSchema(), obj.getName());
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return otherObject;
    }

    public static String getCompanionObjectType(PlSqlSchemaObject obj) {
        String otherType = obj instanceof Package ? "PACKAGE BODY" : (obj instanceof Type ? "TYPE BODY" : (obj instanceof PackageBody ? "PACKAGE" : (obj instanceof TypeBody ? "TYPE" : null)));
        return otherType;
    }

    public static List<Pair<PlSqlFragment, PlSqlFragment>> getTopLevelPlSqlFragments(PlSqlSchemaObject obj, PlSqlSchemaObject otherObject) {
        PlSqlFragment[] rootKids;
        if (obj == null) {
            throw new IllegalArgumentException("obj is null");
        }
        ArrayList<Pair<PlSqlFragment, PlSqlFragment>> ret = new ArrayList<Pair<PlSqlFragment, PlSqlFragment>>();
        HashMap<String, PlSqlFragment> otherTopLevelObjects = new HashMap<String, PlSqlFragment>();
        PlSqlInterrogator objPi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)obj);
        if (objPi.isWrapped() || objPi.getRoot() == null) {
            return ret;
        }
        if (otherObject != null) {
            PlSqlFragment[] otherRootKids;
            PlSqlInterrogator otherPi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)otherObject);
            if (otherPi.isWrapped()) {
                return ret;
            }
            if (otherPi.getRoot() != null && (otherRootKids = otherPi.getRoot().getChildren()).length == 1) {
                for (PlSqlFragment child : otherRootKids[0].getChildren()) {
                    String sig;
                    if (otherObject instanceof PlSqlSchemaObjectBody && (child.getFragmentType() == PlSqlFragment.Type.FUNCTION_FD || child.getFragmentType() == PlSqlFragment.Type.PROCEDURE_FD) || !ModelUtil.hasLength((String)(sig = PlSqlUtil.getSignature(child)))) continue;
                    otherTopLevelObjects.put(sig, child);
                }
            }
        }
        if ((rootKids = objPi.getRoot().getChildren()).length == 1) {
            for (PlSqlFragment child : rootKids[0].getChildren()) {
                String sig;
                if (obj instanceof PlSqlSchemaObjectBody && (child.getFragmentType() == PlSqlFragment.Type.FUNCTION_FD || child.getFragmentType() == PlSqlFragment.Type.PROCEDURE_FD) || !ModelUtil.hasLength((String)(sig = PlSqlUtil.getSignature(child)))) continue;
                ret.add((Pair<PlSqlFragment, PlSqlFragment>)new Pair((Object)child, otherTopLevelObjects.get(sig)));
            }
        }
        return ret;
    }

    public static String getSignature(PlSqlFragment frag) {
        StringBuilder sb = new StringBuilder();
        if (frag.getFragmentType() == PlSqlFragment.Type.FUNCTION || frag.getFragmentType() == PlSqlFragment.Type.PROCEDURE || frag.getFragmentType() == PlSqlFragment.Type.FUNCTION_FD || frag.getFragmentType() == PlSqlFragment.Type.PROCEDURE_FD) {
            PlSqlSearch search = new PlSqlSearch("<ni[not instantiable]> [{^{procedure|function}}...] {procedure|function} <sig {^{return|is|as|;}}>");
            PlSqlSearch paramSearch = new PlSqlSearch(PARAMETER_SEARCH);
            if (search.matches(frag.getFirstToken(), frag.getLastToken()) && search.getNamedMatchStartToken("ni") == null) {
                String sep = "(";
                String end = "";
                sb.append(search.getNamedMatchStartToken("sig").getSource(true));
                for (PlSqlFragment kid : frag.getChildren()) {
                    if (kid.getFragmentType() != PlSqlFragment.Type.PARAMETER_LIST) continue;
                    for (PlSqlFragment gkid : kid.getChildren()) {
                        if (gkid.getFragmentType() != PlSqlFragment.Type.PARAMETER || !paramSearch.matches(gkid.getFirstToken(), gkid.getLastToken())) continue;
                        sb.append(sep);
                        sb.append(paramSearch.getNamedMatch("param", true));
                        sb.append("=>");
                        sb.append(paramSearch.getNamedMatch("datatype", true));
                        sep = ",";
                        end = ")";
                    }
                    sb.append(end);
                    break;
                }
            }
        } else if (frag.getFragmentType() == PlSqlFragment.Type.CURSOR) {
            PlSqlToken nameTk;
            PlSqlToken first = frag.getFirstToken();
            PlSqlToken plSqlToken = nameTk = first == null ? null : first.getNextCodeToken();
            if (nameTk != null) {
                sb.append(nameTk.getSource(true));
            }
        }
        return sb.toString();
    }

    public static List<DBObjectID> findReferences(List<String> nameList, DBObjectProvider pro, DBObject context) {
        return PlSqlReferenceResolver.findReferences(nameList, pro, context);
    }

    public static class TypeAndNameInfo {
        public String m_type;
        public int m_typeStart;
        public int m_typeEnd;
        public String m_name;
        public int m_nameStart;
        public int m_nameEnd;
    }
}

