/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.plsql.PlSqlBlock;
import oracle.javatools.db.plsql.PlSqlDerivedPropertyBuilderImpl;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlInterrogatorFactory;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.validators.ValidationException;

class TriggerDerivedPropertyBuilder
extends PlSqlDerivedPropertyBuilderImpl {
    static final Collection<String> s_refProps = new HashSet<String>();
    static final Collection<String> s_triggerProps;

    protected TriggerDerivedPropertyBuilder(PlSqlSourceObject sourceObject, DBObjectProvider provider) {
        super(sourceObject, provider);
    }

    protected void buildTypeSpecificProps() throws CancelledException {
        Trigger trigger = (Trigger)this.getPlSqlSourceObject();
        String code = null;
        ArrayList<String> events = new ArrayList<String>();
        String refOldAs = null;
        String refNewAs = null;
        Trigger.Timing timing = null;
        String whenClause = null;
        boolean statementLevel = true;
        PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)trigger);
        try {
            this.extractReferences(trigger);
        }
        catch (ValidationException e) {
            // empty catch block
        }
        ArrayList frags = this.getFragList(pi.getRoot());
        block10: for (int i = 0; i < frags.size(); ++i) {
            PlSqlFragment frag = (PlSqlFragment)frags.get(i);
            switch (frag.getFragmentType()) {
                case TRIGGER_TIMING: {
                    if (frag.getFirstToken().matches("BEFORE")) {
                        timing = Trigger.Timing.BEFORE;
                        continue block10;
                    }
                    if (frag.getFirstToken().matches("AFTER")) {
                        timing = Trigger.Timing.AFTER;
                        continue block10;
                    }
                    if (!frag.getFirstToken().matches("INSTEAD")) continue block10;
                    timing = Trigger.Timing.INSTEAD_OF;
                    continue block10;
                }
                case TRIGGER_EVENTS: {
                    PlSqlToken tk;
                    String eventName = "";
                    for (tk = frag.getFirstToken(); tk != null && tk.getType() != PlSqlToken.Type.END_MARKER && tk.getStart() <= frag.getLastToken().getStart(); tk = tk.getNextCodeToken()) {
                        if (tk.matches("UPDATE") && tk.getNextCodeToken().matches("OF")) {
                            eventName = tk.getSource().toUpperCase();
                            events.add(eventName);
                            eventName = "";
                            while (tk != frag.getLastToken() && !tk.getNextCodeToken().matches("OR")) {
                                tk = tk.getNextCodeToken();
                            }
                            continue;
                        }
                        if (tk == frag.getLastToken() || tk.getNextCodeToken().matches("OR")) {
                            eventName = eventName + tk.getSource().toUpperCase();
                            events.add(eventName);
                            eventName = "";
                            continue;
                        }
                        if (tk.matches("OR")) continue;
                        eventName = eventName + tk.getSource().toUpperCase() + " ";
                    }
                    continue block10;
                }
                case TRIGGER_REFERENCING: {
                    PlSqlToken tk = frag.getFirstToken();
                    while (tk.getStart() <= frag.getLastToken().getStart() && tk.getNextCodeToken(2) != null) {
                        if (tk.matches("OLD") && tk.getNextCodeToken().matches("AS")) {
                            if (!PlSqlToken.isReservedWord((PlSqlToken)(tk = tk.getNextCodeToken().getNextCodeToken()))) {
                                refOldAs = this.getProvider().getInternalName(tk.getSource());
                            }
                        } else if (tk.matches("NEW") && tk.getNextCodeToken().matches("AS") && !PlSqlToken.isReservedWord((PlSqlToken)(tk = tk.getNextCodeToken().getNextCodeToken()))) {
                            refNewAs = this.getProvider().getInternalName(tk.getSource());
                        }
                        tk = tk.getNextCodeToken();
                    }
                    continue block10;
                }
                case TRIGGER_ROW_LEVEL: {
                    statementLevel = false;
                    continue block10;
                }
                case TRIGGER_WHEN: {
                    whenClause = frag.getSource();
                    if (!this.getProvider().getDescriptor().getDatabaseType().equals("Oracle Database")) continue block10;
                    PlSqlToken first = frag.getFirstToken();
                    PlSqlToken last = frag.getLastToken();
                    if (!first.matches("(") || !last.matches(")") || first.getNextCodeToken() == last) continue block10;
                    first = first.getNextCodeToken();
                    last = last.getPrevCodeToken();
                    whenClause = first.getSource(false, last);
                    continue block10;
                }
                case PLSQL_BLOCK: {
                    code = trigger.getSource().substring(frag.getFirstToken().getStart());
                    if (code == null) continue block10;
                    code = code.trim();
                }
            }
        }
        trigger.setCode(code);
        trigger.setEvents(events.toArray(new String[events.size()]));
        trigger.setReferencingOldAs(refOldAs);
        trigger.setReferencingNewAs(refNewAs);
        trigger.setStatementLevel(statementLevel);
        trigger.setTiming(timing);
        trigger.setWhenClause(whenClause);
        super.buildTypeSpecificProps();
    }

    private void extractReferences(Trigger trigger) throws ValidationException, CancelledException {
        PlSqlToken tk;
        PlSqlFragment frag;
        int i;
        PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)trigger);
        Trigger.BaseType baseType = null;
        Schema baseSchema = null;
        DBObjectID baseObjectID = null;
        ArrayList<ReferenceID> columnIDs = new ArrayList<ReferenceID>();
        ArrayList frags = this.getFragList(pi.getRoot());
        String tableName = null;
        Relation rel = null;
        ArrayList<String> names = new ArrayList<String>();
        PlSqlFragment timingFrag = null;
        for (i = 0; i < frags.size(); ++i) {
            frag = (PlSqlFragment)frags.get(i);
            if (frag.getFragmentType() == PlSqlFragment.Type.TRIGGER_TIMING) {
                timingFrag = frag;
                continue;
            }
            if (frag.getFragmentType() != PlSqlFragment.Type.TRIGGER_TABLE) continue;
            String nestedTableToCheck = null;
            baseType = null;
            tk = frag.getFirstToken();
            if (tk.matches("NESTED")) {
                tk = tk.getNextCodeToken(2);
                nestedTableToCheck = this.getProvider().getInternalName(tk.getSource());
                tk = tk.getNextCodeToken(2);
            }
            if (tk.getNextCodeToken() != null && tk.getNextCodeToken().matches(".")) {
                String name = this.getProvider().getInternalName(tk.getSource());
                try {
                    baseSchema = this.getProvider().getSchema(name);
                }
                catch (DBException e) {
                    // empty catch block
                }
                if (baseSchema == null) {
                    baseSchema = new Schema(name);
                    baseSchema.setID((DBObjectID)new ReferenceID((DBObject)baseSchema));
                }
                names.add(baseSchema.getName());
                tk = tk.getNextCodeToken(2);
            } else {
                baseSchema = trigger.getSchema();
            }
            if (tk.matches("SCHEMA")) {
                baseType = Trigger.BaseType.SCHEMA;
                baseObjectID = baseSchema == null ? null : baseSchema.getID();
                this.buildReference((PlSqlBlock)trigger, names, tk.getStart(), tk.getEnd());
                continue;
            }
            if (tk.matches("DATABASE")) {
                baseType = Trigger.BaseType.DATABASE;
                baseObjectID = null;
                continue;
            }
            tableName = this.getProvider().getInternalName(tk.getSource());
            try {
                rel = (Relation)this.getProvider().getObject("TABLE", baseSchema, tableName);
                if (rel == null) {
                    rel = (Relation)this.getProvider().getObject("VIEW", baseSchema, tableName);
                }
            }
            catch (DBException e) {
                // empty catch block
            }
            if (rel == null && trigger.getBaseObjectID() instanceof TemporaryObjectID) {
                DBObject obj = null;
                try {
                    obj = trigger.getBaseObjectID().resolveID();
                    if (obj != null && obj.getName().equals(tableName) && ("TABLE".equals(obj.getType()) || "VIEW".equals(obj.getType()))) {
                        rel = (Relation)obj;
                    }
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
            if (rel == null) {
                String type;
                if (timingFrag != null && timingFrag.getFirstToken().matches("INSTEAD")) {
                    baseType = Trigger.BaseType.VIEW;
                    type = "VIEW";
                } else {
                    baseType = Trigger.BaseType.TABLE;
                    type = "TABLE";
                }
                baseObjectID = new ReferenceID(type, baseSchema, tableName);
            } else {
                baseObjectID = rel.getID();
                baseType = rel instanceof Table ? Trigger.BaseType.TABLE : Trigger.BaseType.VIEW;
            }
            names.add(tableName);
            this.buildReference((PlSqlBlock)trigger, names, tk.getStart(), tk.getEnd());
        }
        for (i = 0; i < frags.size(); ++i) {
            frag = (PlSqlFragment)frags.get(i);
            if (frag.getFragmentType() != PlSqlFragment.Type.TRIGGER_COLUMNS) continue;
            String lastColToken = ",";
            tk = frag.getFirstToken();
            while (tk.getStart() <= frag.getLastToken().getStart()) {
                if (lastColToken.equals(",")) {
                    Column col;
                    String colName = this.getProvider().getInternalName(tk.getSource());
                    ReferenceID colID = null;
                    if (rel != null && (col = (Column)DBUtil.findChildByName(rel, (String)"columns", (String)colName, (DBObjectProvider)this.getProvider())) != null) {
                        colID = col.getID();
                        names.clear();
                        names.add(tableName);
                        names.add(col.getName());
                        this.buildReference((PlSqlBlock)trigger, names, tk.getStart(), tk.getEnd());
                    }
                    if (colID == null) {
                        colID = new ReferenceID("COLUMN", baseObjectID, colName, null, null);
                    }
                    columnIDs.add(colID);
                }
                lastColToken = tk.getSource();
                tk = tk.getNextCodeToken();
            }
        }
        trigger.setBaseType(baseType);
        trigger.setBaseObjectID(baseObjectID);
        trigger.setColumnIDs(columnIDs.toArray(new DBObjectID[columnIDs.size()]));
    }

    private ArrayList getFragList(PlSqlFragment frg) {
        ArrayList<Object> retVal = new ArrayList<Object>();
        if (frg != null) {
            retVal.add(frg);
            if (frg.getFragmentType() != PlSqlFragment.Type.PLSQL_BLOCK) {
                for (int i = 0; i < frg.getChildren().length; ++i) {
                    ArrayList children = this.getFragList(frg.getChildren()[i]);
                    for (int j = 0; j < children.size(); ++j) {
                        retVal.add(children.get(j));
                    }
                }
            }
        }
        return retVal;
    }

    static {
        s_refProps.add("baseType");
        s_refProps.add("baseObjectID");
        s_refProps.add("columnIDs");
        s_triggerProps = new HashSet<String>();
        s_triggerProps.addAll(s_refProps);
        s_triggerProps.add("code");
        s_triggerProps.add("statementLevel");
        s_triggerProps.add("events");
        s_triggerProps.add("timing");
        s_triggerProps.add("referencingNewAs");
        s_triggerProps.add("referencingOldAs");
        s_triggerProps.add("whenClause");
    }
}

