/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.ArrayList;
import java.util.logging.Level;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlAttribute;
import oracle.javatools.db.plsql.PlSqlDerivedPropertyBuilderImpl;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlInterrogatorFactory;
import oracle.javatools.db.plsql.PlSqlMethod;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlVariable;
import oracle.javatools.db.plsql.Type;

class TypeDerivedPropertyBuilder
extends PlSqlDerivedPropertyBuilderImpl {
    private Type m_type;
    private PlSqlSearch m_collTypeSearch;
    private PlSqlSearch m_objTypeSearch;
    private PlSqlSearch m_attributeSearch;
    private PlSqlSearch m_methodSearch;
    private PlSqlSearch m_paramSearch;
    private PlSqlSearch m_dependantHandlingSearch;
    private PlSqlSearch m_alterCollectionSearch;
    private PlSqlSearch m_alterFinalInstantiableSearch;

    protected TypeDerivedPropertyBuilder(PlSqlSourceObject sourceObject, DBObjectProvider provider) {
        super(sourceObject, provider);
    }

    protected void buildTypeSpecificProps() throws CancelledException {
        if (this.getPlSqlSourceObject() instanceof Type) {
            this.m_type = (Type)this.getPlSqlSourceObject();
            PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)this.m_type);
            PlSqlFragment root = pi.getRoot();
            if (!pi.isWrapped() && root != null) {
                if (pi.isEvolvedType()) {
                    root = root.getChildren()[0];
                }
                this.m_type.setTypeCode(pi.getTypeCode());
                this.m_type.setCollectionType(pi.getCollectionType());
                StringBuffer sb = new StringBuffer("{<ref [REF]> ");
                if (this.m_type.getSchema() != null) {
                    sb.append("[").append(this.m_type.getSchema().getName()).append(" .]");
                }
                sb.append(this.m_type.getName()).append("|SELF AS RESULT}");
                this.m_selfSearch = new PlSqlSearch(sb.toString());
                if ("OBJECT".equals(pi.getTypeCode())) {
                    this.deriveObjectProperties(root);
                } else {
                    this.deriveCollectionProperties(root);
                }
                if (pi.isEvolvedType()) {
                    for (int i = 1; i < pi.getRoot().getChildren().length; ++i) {
                        PlSqlFragment alterFrag = pi.getRoot().getChildren()[i];
                        this.processAlterFragment(alterFrag);
                    }
                }
            }
        }
    }

    private void deriveObjectProperties(PlSqlFragment root) throws CancelledException {
        boolean isFinal = true;
        boolean isInstantiable = true;
        if (this.getObjTypeSearch().matches(root.getFirstToken())) {
            this.m_type.setOID(this.getObjTypeSearch().getNamedMatch("oid"));
            boolean authidCurrentUser = "CURRENT_USER".equalsIgnoreCase(this.getObjTypeSearch().getNamedMatch("authid"));
            this.m_type.setAuthidCurrentUser(authidCurrentUser);
            if (this.getObjTypeSearch().getNamedMatch("under") != null) {
                PlSqlToken start = this.getObjTypeSearch().getNamedMatchStartToken("under");
                PlSqlToken end = this.getObjTypeSearch().getNamedMatchEndToken("under");
                PlSqlReference ref = this.findDataTypeReference(start, end, (DBObject)this.m_type);
                this.m_type.setUnderTypeReference(ref);
            }
            this.m_type.setSqljExternalName(this.getNameSearchStripQuotes(this.getObjTypeSearch(), "extname"));
            if (this.m_type.getSqljExternalName() != null) {
                Type.SQLJUsingType sqljUsing = null;
                String using = this.getObjTypeSearch().getNamedMatch("using");
                if ("SQLData".equalsIgnoreCase(using)) {
                    sqljUsing = Type.SQLJUsingType.SQLData;
                } else if ("OraData".equalsIgnoreCase(using)) {
                    sqljUsing = Type.SQLJUsingType.OraData;
                }
                if ("CustomDatum".equalsIgnoreCase(using)) {
                    sqljUsing = Type.SQLJUsingType.CustomDatum;
                }
                this.m_type.setSqljUsing(sqljUsing);
            }
            PlSqlToken tk = root.getLastToken();
            while (!tk.isCode() || tk.matches(";") || tk.matches("/")) {
                tk = tk.getPrevCodeToken();
            }
            if (tk.matches("INSTANTIABLE") && (tk = tk.getPrevCodeToken()).matches("NOT")) {
                isInstantiable = false;
                tk = tk.getPrevCodeToken();
            }
            if (tk.matches("FINAL") && (tk = tk.getPrevCodeToken()).matches("NOT")) {
                isFinal = false;
            }
            this.m_type.setFinal(isFinal);
            this.m_type.setInstantiable(isInstantiable);
            PlSqlFragment typeSpecFrag = root.findChild(PlSqlFragment.Type.TYPE_SPEC, true);
            if (typeSpecFrag != null) {
                for (PlSqlFragment f : typeSpecFrag.getChildren()) {
                    if (f.getFragmentType().equals((Object)PlSqlFragment.Type.DECLARATION)) {
                        this.processAttributeFragment(f);
                        continue;
                    }
                    if (!f.getFragmentType().equals((Object)PlSqlFragment.Type.PROCEDURE_FD) && !f.getFragmentType().equals((Object)PlSqlFragment.Type.FUNCTION_FD)) continue;
                    this.processMethodFragment(f);
                }
            }
        }
    }

    private void deriveCollectionProperties(PlSqlFragment root) throws CancelledException {
        if (this.getCollTypeSearch().matches(root.getFirstToken())) {
            this.m_type.setOID(this.getCollTypeSearch().getNamedMatch("oid"));
            this.m_type.setLimit(this.getIntegerNamedMatch(this.getCollTypeSearch(), "limit"));
            PlSqlToken start = this.getCollTypeSearch().getNamedMatchStartToken("datatype");
            PlSqlToken end = this.getCollTypeSearch().getNamedMatchEndToken("datatype");
            PlSqlReference ref = this.findDataTypeReference(start, end, (DBObject)this.m_type);
            this.m_type.setOfTypeUsageReference(ref);
        }
    }

    private void processAlterFragment(PlSqlFragment alterFrag) throws CancelledException {
        if (alterFrag.getChildren() != null && alterFrag.getChildren().length > 0 && alterFrag.getAlterSubType() == null) {
            for (PlSqlFragment childFrag : alterFrag.getChildren()) {
                this.processAlterFragment(childFrag);
            }
        } else {
            PlSqlToken tk = alterFrag.getFirstToken();
            PlSqlToken endToken = alterFrag.getLastToken();
            if (this.getDependantHandlingSearch().isWithin(tk, endToken)) {
                endToken = this.getDependantHandlingSearch().getStartToken().getPrevCodeToken();
            }
            if (alterFrag.getAlterSubType() != null) {
                PlSqlFragment.AlterSubType action = alterFrag.getAlterSubType();
                switch (action) {
                    case ADD_ATTRIBUTE: 
                    case MODIFY_ATTRIBUTE: 
                    case DROP_ATTRIBUTE: {
                        this.processAlterAttributeFragment(action, tk, endToken);
                        break;
                    }
                    case ADD_METHOD: {
                        this.processMethodFragment(alterFrag);
                        break;
                    }
                    case DROP_METHOD: {
                        this.processDropMethodFragment(alterFrag);
                    }
                }
            } else if (this.getAlterCollectionSearch().matches(tk, endToken)) {
                String datatype = this.getAlterCollectionSearch().getNamedMatch("datatype");
                if (datatype != null) {
                    PlSqlToken start = this.getAlterCollectionSearch().getNamedMatchStartToken("datatype");
                    PlSqlToken end = this.getAlterCollectionSearch().getNamedMatchEndToken("datatype");
                    PlSqlReference ref = this.findDataTypeReference(start, end, (DBObject)this.m_type);
                    this.m_type.setOfTypeUsageReference(ref);
                } else {
                    this.m_type.setLimit(this.getIntegerNamedMatch(this.getAlterCollectionSearch(), "limit"));
                }
            } else if (this.getAlterFinalInstantiableSearch().matches(tk, endToken)) {
                if (this.getAlterFinalInstantiableSearch().getNamedMatch("notInst") != null) {
                    this.m_type.setInstantiable(false);
                } else if (this.getAlterFinalInstantiableSearch().getNamedMatch("inst") != null) {
                    this.m_type.setInstantiable(true);
                }
                if (this.getAlterFinalInstantiableSearch().getNamedMatch("notFinal") != null) {
                    this.m_type.setFinal(false);
                } else if (this.getAlterFinalInstantiableSearch().getNamedMatch("final") != null) {
                    this.m_type.setFinal(true);
                }
            }
        }
    }

    private void processAttributeFragment(PlSqlFragment attrFrag) throws CancelledException {
        PlSqlAttribute attr = null;
        if (!attrFrag.getFirstToken().matches("PRAGMA") && (attr = this.getAttribute(attrFrag.getFirstToken(), null)) != null) {
            this.m_type.addVariable((PlSqlVariable)attr);
        }
    }

    private PlSqlAttribute getAttribute(PlSqlToken startToken, PlSqlToken endToken) throws CancelledException {
        PlSqlAttribute attr = null;
        if (this.getAttributeSearch().matches(startToken, endToken)) {
            PlSqlToken nameTk = this.getAttributeSearch().getNamedMatchStartToken("name");
            String name = this.getProvider().getInternalName(nameTk.getSource());
            attr = new PlSqlAttribute();
            attr.setParent((DBObject)this.m_type);
            this.setCommon((DBObjectPlSqlFragment)attr, name, nameTk.getStart(), nameTk.getEnd(), nameTk);
            PlSqlToken startTk = this.getAttributeSearch().getNamedMatchStartToken("datatype");
            PlSqlToken endTk = this.getAttributeSearch().getNamedMatchEndToken("datatype");
            PlSqlReference ref = this.findDataTypeReference(startTk, endTk, attr.getParent());
            attr.setDataTypeReference(ref);
            attr.setSqljExternalName(this.getNameSearchStripQuotes(this.getAttributeSearch(), "extname"));
        }
        return attr;
    }

    private void processMethodFragment(PlSqlFragment methodFrag) throws CancelledException {
        PlSqlMethod method = this.getMethod(methodFrag);
        if (method != null) {
            this.m_type.addSubProgram((PlSqlSubProgram)method);
        }
    }

    private PlSqlMethod getMethod(PlSqlFragment methodFrag) throws CancelledException {
        PlSqlMethod method = null;
        if (this.getMethodSearch().matches(methodFrag.getFirstToken())) {
            method = new PlSqlMethod();
            method.setFinal(this.getMethodSearch().getNamedMatch("final") != null);
            method.setOverriding(this.getMethodSearch().getNamedMatch("over") != null);
            method.setInstantiable(this.getMethodSearch().getNamedMatch("notInst") == null);
            String methodTypeStr = this.getMethodSearch().getNamedMatch("methodType");
            methodTypeStr = methodTypeStr.replace(" ", "_");
            try {
                method.setMethodType(PlSqlMethod.MethodType.valueOf((String)methodTypeStr));
            }
            catch (Exception e) {
                method.setMethodType(PlSqlMethod.MethodType.MEMBER);
            }
            PlSqlToken sigStartTk = this.getMethodSearch().getNamedMatchStartToken("signature");
            PlSqlToken sigEndTk = this.getMethodSearch().getNamedMatchEndToken("signature");
            PlSqlToken dtTk = this.getMethodSearch().getNamedMatchStartToken("datatype");
            if (dtTk != null) {
                sigEndTk = dtTk;
                sigEndTk = sigEndTk.getPrevCodeToken();
                sigEndTk = sigEndTk.getPrevCodeToken();
            }
            String signature = sigStartTk.getSource(true, sigEndTk);
            this.setCommon((DBObjectPlSqlFragment)method, signature, methodFrag.getStartOffset(), methodFrag.getEndOffset(), sigStartTk);
            if (dtTk != null) {
                PlSqlToken endTk = this.getMethodSearch().getNamedMatchEndToken("datatype");
                PlSqlReference ref = this.findDataTypeReference(dtTk, endTk, method.getParent());
                method.setReturnTypeReference(ref);
            }
            String javaName = this.getNameSearchStripQuotes(this.getMethodSearch(), "javaname");
            String cLibName = this.getNameSearchStripQuotes(this.getMethodSearch(), "clibname");
            if (javaName != null) {
                method.setCallSpecLanguage(PlSqlMethod.CallSpecLanguage.JAVA);
                method.setCallSpecName(javaName);
            } else if (cLibName != null) {
                method.setCallSpecLanguage(PlSqlMethod.CallSpecLanguage.C);
                method.setCallSpecName(this.getNameSearchStripQuotes(this.getMethodSearch(), "cname"));
                method.setCallSpecLibName(cLibName);
                method.setCallSpecWithContext(this.getMethodSearch().getNamedMatch("ccontext") != null);
            }
            String extname = this.getNameSearchStripQuotes(this.getMethodSearch(), "extname");
            String extvarname = this.getNameSearchStripQuotes(this.getMethodSearch(), "extvarname");
            if (extname != null) {
                method.setSqljSigName(extname);
            } else if (extvarname != null) {
                method.setSqljSigVarName(extvarname);
            }
            ArrayList<PlSqlParameter> params = new ArrayList<PlSqlParameter>();
            PlSqlFragment paramListFrag = methodFrag.findChild(PlSqlFragment.Type.PARAMETER_LIST, false);
            if (paramListFrag != null) {
                for (PlSqlFragment paramFrag : paramListFrag.getChildren()) {
                    PlSqlParameter param = new PlSqlParameter();
                    this.buildParameter(param, paramFrag);
                    params.add(param);
                }
                method.setParameters(params.toArray(new PlSqlParameter[params.size()]));
            }
        }
        return method;
    }

    private void processAlterAttributeFragment(PlSqlFragment.AlterSubType action, PlSqlToken startTk, PlSqlToken endToken) throws CancelledException {
        PlSqlToken startToken = startTk;
        boolean last = true;
        if (startToken.matches("(")) {
            last = false;
            startToken = startToken.getNextCodeToken();
        }
        do {
            if (action == PlSqlFragment.AlterSubType.DROP_ATTRIBUTE) {
                PlSqlAttribute oldAttr = this.m_type.getAttribute(startToken.getSource(true));
                if (oldAttr != null) {
                    this.m_type.removeAttribute(oldAttr);
                }
            } else {
                PlSqlAttribute attr = this.getAttribute(startToken, endToken);
                if (attr != null) {
                    if (action == PlSqlFragment.AlterSubType.ADD_ATTRIBUTE) {
                        this.m_type.addVariable((PlSqlVariable)attr);
                    } else {
                        PlSqlAttribute oldAttr = this.m_type.getAttribute(attr.getName());
                        attr.copyTo((Object)oldAttr);
                    }
                }
            }
            if (last) continue;
            if (action != PlSqlFragment.AlterSubType.DROP_ATTRIBUTE) {
                startToken = this.getAttributeSearch().getEndToken();
            }
            if ((startToken = startToken.getNextCodeToken()).matches(",")) {
                startToken = startToken.getNextCodeToken();
                continue;
            }
            last = true;
        } while (!last);
    }

    private void processDropMethodFragment(PlSqlFragment methodFrag) throws CancelledException {
        PlSqlMethod method = this.getMethod(methodFrag);
        if (method != null) {
            String sig = method.getSignature();
            PlSqlMethod delMethod = null;
            for (PlSqlMethod m : this.m_type.getMethods()) {
                if (!sig.equals(m.getSignature())) continue;
                delMethod = m;
                break;
            }
            if (delMethod != null) {
                this.m_type.removeMethod(delMethod);
            }
        }
    }

    private Integer getIntegerNamedMatch(PlSqlSearch search, String name) {
        Integer retval = null;
        String strVal = search.getNamedMatch(name);
        if (strVal != null) {
            try {
                retval = Integer.valueOf(strVal);
            }
            catch (NumberFormatException e) {
                retval = null;
            }
        }
        return retval;
    }

    private String getNameSearchStripQuotes(PlSqlSearch search, String name) {
        String retval = search.getNamedMatch(name);
        if (retval != null && (retval.startsWith("'") && retval.endsWith("'") || retval.startsWith("\"") && retval.endsWith("\""))) {
            retval = retval.substring(1, retval.length() - 1);
        }
        return retval;
    }

    private final PlSqlSearch getCollTypeSearch() {
        if (this.m_collTypeSearch == null) {
            try {
                this.m_collTypeSearch = new PlSqlSearch("TYPE ?. [FORCE] [OID <oid ?>] {IS|AS} { {VARRAY | VARYING ARRAY} ( <limit ?> ) |   TABLE } OF <datatype ?%> [NOT NULL]");
            }
            catch (IllegalArgumentException e) {
                DBLog.getLogger().log(Level.SEVERE, "failed to contruct PlSqlSearch: " + e.getMessage());
            }
        }
        return this.m_collTypeSearch;
    }

    private final PlSqlSearch getObjTypeSearch() {
        if (this.m_objTypeSearch == null) {
            try {
                this.m_objTypeSearch = new PlSqlSearch("TYPE ?. [FORCE] [OID <oid ?>] [AUTHID <authid ?>] {{IS|AS}OBJECT|UNDER <under ?.>|{IS|AS}OPAQUE VARYING (*) USING LIBRARY ?} [EXTERNAL NAME <extname ?> LANGUAGE JAVA USING <using ?>]");
            }
            catch (IllegalArgumentException e) {
                DBLog.getLogger().log(Level.SEVERE, "failed to contruct PlSqlSearch: " + e.getMessage());
            }
        }
        return this.m_objTypeSearch;
    }

    private final PlSqlSearch getAttributeSearch() {
        if (this.m_attributeSearch == null) {
            try {
                this.m_attributeSearch = new PlSqlSearch("<name ?> <datatype ?%> [EXTERNAL NAME <extname ?>]");
            }
            catch (IllegalArgumentException e) {
                DBLog.getLogger().log(Level.SEVERE, "failed to contruct PlSqlSearch: " + e.getMessage());
            }
        }
        return this.m_attributeSearch;
    }

    private final PlSqlSearch getMethodSearch() {
        if (this.m_methodSearch == null) {
            try {
                this.m_methodSearch = new PlSqlSearch("[ { NOT FINAL | <final FINAL> |     NOT OVERRIDING | <over OVERRIDING> |     <notInst  NOT INSTANTIABLE> | INSTANTIABLE }...] <methodType {MEMBER|STATIC|CONSTRUCTOR|MAP MEMBER|ORDER MEMBER}> {FUNCTION|PROCEDURE} <signature {^{RETURN|AS|IS|;}}... [RETURN <datatype {SELF AS RESULT|?%}>]> [EXTERNAL {NAME <extname ?> | VARIABLE NAME <extvarname ?> } ][{DETERMINISTIC|PIPELINED|RESULT_CACHE}...][ {IS|AS} LANGUAGE     { JAVA NAME <javaname ?>     | C [NAME <cname ?>] LIBRARY <clibname ?.>       [AGENT IN ({^)}...) ]       [WITH <ccontext CONTEXT>]       [PARAMETERS ({^)}...) ]     } ]");
            }
            catch (IllegalArgumentException e) {
                DBLog.getLogger().log(Level.SEVERE, "failed to contruct PlSqlSearch: " + e.getMessage());
            }
        }
        return this.m_methodSearch;
    }

    private final PlSqlSearch getParamSearch() {
        if (this.m_paramSearch == null) {
            try {
                this.m_paramSearch = new PlSqlSearch("<param ?> [<mode {IN OUT|OUT|IN}>] [<nocopy NOCOPY>] <datatype ?%> [{DEFAULT|:=} <default ?>]");
            }
            catch (IllegalArgumentException e) {
                DBLog.getLogger().log(Level.SEVERE, "failed to contruct PlSqlSearch: " + e.getMessage());
            }
        }
        return this.m_paramSearch;
    }

    private final PlSqlSearch getDependantHandlingSearch() {
        if (this.m_dependantHandlingSearch == null) {
            try {
                this.m_dependantHandlingSearch = new PlSqlSearch("{INVALIDATE|CASCADE}");
            }
            catch (IllegalArgumentException e) {
                DBLog.getLogger().log(Level.SEVERE, "failed to contruct PlSqlSearch: " + e.getMessage());
            }
        }
        return this.m_dependantHandlingSearch;
    }

    private final PlSqlSearch getAlterCollectionSearch() {
        if (this.m_alterCollectionSearch == null) {
            try {
                this.m_alterCollectionSearch = new PlSqlSearch("ALTER TYPE ?. MODIFY {LIMIT <limit ?>|ELEMENT TYPE <datatype ?%>}");
            }
            catch (IllegalArgumentException e) {
                DBLog.getLogger().log(Level.SEVERE, "failed to contruct PlSqlSearch: " + e.getMessage());
            }
        }
        return this.m_alterCollectionSearch;
    }

    private final PlSqlSearch getAlterFinalInstantiableSearch() {
        if (this.m_alterFinalInstantiableSearch == null) {
            try {
                this.m_alterFinalInstantiableSearch = new PlSqlSearch("ALTER TYPE ?.  { <notInst NOT INSTANTIABLE>|   <inst INSTANTIABLE>|   <notFinal NOT FINAL>|   <final FINAL>}...");
            }
            catch (IllegalArgumentException e) {
                DBLog.getLogger().log(Level.SEVERE, "failed to contruct PlSqlSearch: " + e.getMessage());
            }
        }
        return this.m_alterFinalInstantiableSearch;
    }
}

