/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.plsql.PlSqlComparator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.sql.AbstractSQLQueryBuilder;
import oracle.javatools.db.sql.ColumnKeywordUsage;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentExpressionBuilder;
import oracle.javatools.db.sql.SQLFragmentUtils;
import oracle.javatools.db.sql.SQLFragmentWithDatatype;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.util.DBObjectSet;
import oracle.javatools.util.ModelUtil;

public class SQLDerivedPropertySupport {
    public static DerivedPropertyBuilder createCheckConstraintBuilder(DBObjectProvider pro) {
        return new CheckConstraintConditionBuilder((AbstractDBObjectProvider)pro);
    }

    public static DerivedPropertyBuilder createVirtualExpressionBuilder(DBObjectProvider pro) {
        return new VirtualExpressionBuilder((AbstractDBObjectProvider)pro);
    }

    public static DerivedPropertyBuilder createIndexExpressionBuilder(DBObjectProvider pro) {
        return new IndexExpressionBuilder((AbstractDBObjectProvider)pro);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SQLQueryViewColumnDTUBuilder
    extends DerivedPropertyBuilder<Column> {
        private static final String BIND_DEFAULT = "'99'";
        private SQLQuery m_sqlQuery;
        private int m_columnIndex;

        public SQLQueryViewColumnDTUBuilder(AbstractDBObjectProvider pro, SQLQuery sqlQuery, int columnIndex) {
            super(pro, "COLUMN");
            this.m_sqlQuery = sqlQuery;
            this.m_columnIndex = columnIndex;
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"dataTypeUsage"})
        public void buildDataTypeUsage(Column col) throws SQLQueryException {
            if (col != null) {
                DBObject par = col.getParent();
                AbstractDBObjectProvider pro = this.getProvider();
                if (pro instanceof Database) {
                    ArrayList dtus = new ArrayList();
                    String query = this.m_sqlQuery.getSQLText();
                    if (query != null) {
                        QueryWrapper qw = new QueryWrapper((Database)pro, this.convertBindValues(query));
                        try {
                            qw.executeQuery(1, new QueryWrapper.QueryRunnable((DBObjectProvider)pro, dtus, qw){
                                final /* synthetic */ DBObjectProvider val$pro;
                                final /* synthetic */ List val$dtus;
                                final /* synthetic */ QueryWrapper val$qw;
                                {
                                    this.val$pro = dBObjectProvider;
                                    this.val$dtus = list;
                                    this.val$qw = queryWrapper;
                                }

                                public void processResultSet(ResultSet rs) throws DBException {
                                    try {
                                        ResultSetMetaData md = rs.getMetaData();
                                        int columnCount = md.getColumnCount();
                                        for (int i = 0; i < columnCount; ++i) {
                                            int sqlIndex = i + 1;
                                            String typeName = md.getColumnTypeName(sqlIndex);
                                            int precision = md.getPrecision(sqlIndex);
                                            int scale = md.getScale(sqlIndex);
                                            int size = precision;
                                            DataTypeUsage dtu = DataTypeHelper.getDataTypeUsage((DBObjectProvider)this.val$pro, null, (String)typeName, (int)size, (int)precision, (int)scale);
                                            this.val$dtus.add(dtu);
                                        }
                                    }
                                    catch (SQLException sqe) {
                                        this.val$qw.throwDBException(sqe);
                                    }
                                }
                            });
                        }
                        catch (DBException e) {
                            DBLog.getLogger((Object)((Object)this)).log(Level.WARNING, "Failed to query DataTypeUsages", e);
                        }
                        if (par instanceof Relation) {
                            Column[] cols = ((Relation)par).getColumns();
                            if (cols.length != dtus.size()) {
                                throw new IllegalStateException("Mismatch of columns");
                            }
                            for (int i = 0; i < cols.length; ++i) {
                                cols[i].setDataTypeUsage((DataTypeUsage)dtus.get(i));
                            }
                        } else if (this.m_columnIndex < dtus.size()) {
                            col.setDataTypeUsage((DataTypeUsage)dtus.get(this.m_columnIndex));
                        } else {
                            col.setDataTypeUsage(new DataTypeUsage());
                        }
                    }
                } else {
                    List sels;
                    SelectObject[] sos = this.m_sqlQuery.getSelectObjects();
                    boolean needToExpand = true;
                    for (int i = 0; i < sos.length; ++i) {
                        needToExpand = false;
                        if (!(sos[i].getExpression() instanceof ColumnKeywordUsage)) continue;
                        needToExpand = true;
                        break;
                    }
                    if (this.m_columnIndex < (sels = needToExpand ? SQLFragmentUtils.expandStarColumns((SQLQuery)this.m_sqlQuery) : Arrays.asList(sos)).size()) {
                        SQLFragmentWithDatatype frag;
                        DBObjectID dtID;
                        SQLFragment expr = ((SelectObject)sels.get(this.m_columnIndex)).getExpression();
                        if (expr instanceof ColumnUsage) {
                            ColumnUsage cu = (ColumnUsage)expr;
                            try {
                                DataTypeUsage dtu = null;
                                Column refCol = (Column)cu.getObjectID().resolveID();
                                if (refCol != null && (dtu = refCol.getDataTypeUsage()) != null) {
                                    dtu = (DataTypeUsage)dtu.copyTo(null);
                                    dtu.setID(TemporaryObjectID.createID((DBObject)dtu));
                                }
                                col.setDataTypeUsage(dtu);
                            }
                            catch (DBException e) {}
                        } else if (expr instanceof SQLFragmentWithDatatype && (dtID = (frag = (SQLFragmentWithDatatype)expr).getDataTypeID()) != null) {
                            DataTypeUsage dtu;
                            DBObject dt;
                            try {
                                dt = dtID.resolveID();
                            }
                            catch (DBException e) {
                                dt = null;
                            }
                            if (dt instanceof DataType) {
                                dtu = ((DataType)dt).createDefaultUsage();
                            } else {
                                dtu = new DataTypeUsage();
                                dtu.setDataTypeID(dtID);
                            }
                            col.setDataTypeUsage(dtu);
                        }
                    }
                }
            }
        }

        private String convertBindValues(String sqlText) {
            PlSqlToken tk = PlSqlTokenizer.tokenize((String)sqlText, (String[])new String[0]);
            StringBuffer sb = new StringBuffer();
            while (tk.getType() != PlSqlToken.Type.END_MARKER) {
                if (tk.matches(":") && tk.getNextToken().isCode()) {
                    sb.append(BIND_DEFAULT);
                    tk = tk.getNextToken();
                } else {
                    sb.append(tk.getSource());
                }
                tk = tk.getNextToken();
            }
            return sb.toString().trim();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SQLQueryColumnsBuilder
    extends DerivedPropertyBuilder<Relation> {
        private final DBObjectSet<Column> m_colCache = new DBObjectSet();

        public SQLQueryColumnsBuilder(AbstractDBObjectProvider pro, String type) {
            super(pro, type);
        }

        public Collection<String> clearDerivedProperties(Relation obj, String property, DBObjectChange change) {
            if (!DBUtil.needsBuilding((DBObject)obj, (String)"columns")) {
                for (Column col : obj.getColumns()) {
                    this.m_colCache.add((Object)col);
                }
            }
            return super.clearDerivedProperties((AbstractBuildableObject)obj, property, change);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @AbstractDBObjectBuilder.PropertyBuilder(value={"columns"})
        public void buildColumns(Relation rel) throws SQLQueryException {
            block19: {
                ArrayList<Column> columns = new ArrayList<Column>();
                try {
                    SQLQueryBuilder b;
                    SQLQuery query;
                    Column[] colsFromQuery = null;
                    Column[] colsFromOrigRelation = null;
                    List qcis = null;
                    List origQcis = null;
                    if (rel instanceof SQLQueryOwner && (query = ((SQLQueryOwner)rel).getSQLQuery()) != null && (b = SQLQueryBuilderFactory.findOrCreateBuilder((SQLQuery)query, (DBObjectProvider)this.getProvider())) instanceof AbstractSQLQueryBuilder) {
                        try {
                            AbstractSQLQueryBuilder builder = (AbstractSQLQueryBuilder)b;
                            colsFromQuery = builder.getColumns();
                            qcis = builder.getQueryColumnInfos();
                        }
                        catch (SQLQueryException sqlqe) {
                            qcis = null;
                        }
                    }
                    if (colsFromQuery == null) break block19;
                    boolean checkOrigRelColumns = false;
                    for (int i = 0; i < colsFromQuery.length; ++i) {
                        if (colsFromQuery[i].getName() != null) continue;
                        checkOrigRelColumns = true;
                        break;
                    }
                    if (checkOrigRelColumns) {
                        Relation origRel = (Relation)TemporaryObjectID.findOriginalObject((DBObject)rel);
                        if (origRel instanceof SQLQueryOwner) {
                            SQLQueryBuilder b2;
                            colsFromOrigRelation = origRel.getColumns();
                            SQLQuery query2 = ((SQLQueryOwner)origRel).getSQLQuery();
                            if (query2 != null && (b2 = SQLQueryBuilderFactory.findOrCreateBuilder((SQLQuery)query2, (DBObjectProvider)this.getProvider())) instanceof AbstractSQLQueryBuilder) {
                                try {
                                    AbstractSQLQueryBuilder builder = (AbstractSQLQueryBuilder)b2;
                                    origQcis = builder.getQueryColumnInfos();
                                }
                                catch (SQLQueryException sqlqe) {
                                    origQcis = null;
                                }
                            }
                        }
                        if (colsFromOrigRelation != null && origQcis != null) {
                            PlSqlComparator comp = new PlSqlComparator();
                            block10: for (int i = 0; i < colsFromQuery.length; ++i) {
                                if (colsFromQuery[i].getName() != null) continue;
                                AbstractSQLQueryBuilder.QueryColumnInfo qci = (AbstractSQLQueryBuilder.QueryColumnInfo)qcis.get(i);
                                for (int j = 0; j < origQcis.size(); ++j) {
                                    AbstractSQLQueryBuilder.QueryColumnInfo origQci = (AbstractSQLQueryBuilder.QueryColumnInfo)origQcis.get(j);
                                    if (origQci.getName() != null || comp.compare(qci.getExpression(), origQci.getExpression()) != 0) continue;
                                    colsFromQuery[i].setName(colsFromOrigRelation[j].getName());
                                    continue block10;
                                }
                            }
                        }
                    }
                    for (int i = 0; i < colsFromQuery.length; ++i) {
                        Column colToUse = colsFromQuery[i];
                        for (Column col : this.m_colCache) {
                            if (col.getName() == null || !col.getName().equals(colToUse.getName())) continue;
                            colToUse = col;
                            this.m_colCache.remove((Object)col);
                            break;
                        }
                        columns.add(colToUse);
                    }
                }
                catch (DBException e) {
                    columns.clear();
                    DBLog.getLogger((Object)((Object)this)).log(Level.WARNING, "Failed to build View/MView columns", e);
                }
                finally {
                    rel.setColumns(columns.toArray(new Column[columns.size()]));
                    this.m_colCache.clear();
                }
            }
            this.maintainConstraints(rel);
        }

        private void maintainConstraints(Relation rel) {
            Constraint[] cons = rel.getConstraints();
            if (cons != null && cons.length > 0) {
                Column[] cols = rel.getColumns();
                HashSet<String> colnames = new HashSet<String>();
                for (Column col : cols) {
                    colnames.add(col.getName());
                }
                DBObjectSet newCons = new DBObjectSet();
                for (Constraint c : cons) {
                    if (c instanceof ColumnConstraint) {
                        ArrayList<DBObjectID> colIDs = new ArrayList<DBObjectID>();
                        for (DBObjectID colID : ((ColumnConstraint)c).getColumnIDs()) {
                            if (!colnames.contains(DBUtil.getDBObjectName((DBObjectID)colID))) continue;
                            colIDs.add(colID);
                        }
                        if (colIDs.size() <= 0) continue;
                        ((ColumnConstraint)c).setColumnIDs(colIDs.toArray(new DBObjectID[colIDs.size()]));
                        newCons.add(c);
                        continue;
                    }
                    newCons.add(c);
                }
                rel.setConstraints(newCons.toArray(new Constraint[newCons.size()]));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IndexExpressionBuilder
    extends DerivedPropertyBuilder<IndexObject> {
        private IndexExpressionBuilder(AbstractDBObjectProvider pro) {
            super(pro, "IndexObject");
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"expression"})
        public boolean buildColumnExpression(IndexObject idxObj) throws SQLQueryException {
            String source;
            Table tab;
            boolean retval = false;
            Index idx = (Index)idxObj.getParent();
            if (idx != null && (tab = idx.getTable()) != null && ModelUtil.hasLength((String)(source = idxObj.getExpressionSource()))) {
                retval = true;
                SQLFragment newfrag = SQLFragmentExpressionBuilder.getExpressionOrFail((DBObjectProvider)this.getProvider(), (Relation)tab, (SQLFragmentExpressionBuilder.ExpressionType)SQLFragmentExpressionBuilder.ExpressionType.ITEM, (String)source);
                idxObj.setExpression(newfrag);
            }
            return retval;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CheckConstraintConditionBuilder
    extends DerivedPropertyBuilder<CheckConstraint> {
        private CheckConstraintConditionBuilder(AbstractDBObjectProvider pro) {
            super(pro, "CONSTRAINT");
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"checkConditionFragment"})
        public boolean buildConditionFragment(CheckConstraint cc) throws SQLQueryException {
            String condition;
            boolean retval = false;
            Relation rel = cc.getRelation();
            if (rel != null && ModelUtil.hasLength((String)(condition = cc.getCheckCondition()))) {
                retval = true;
                SQLFragment newfrag = SQLFragmentExpressionBuilder.getExpressionOrFail((DBObjectProvider)this.getProvider(), (Relation)rel, (SQLFragmentExpressionBuilder.ExpressionType)SQLFragmentExpressionBuilder.ExpressionType.CONDITION, (String)condition);
                cc.setCheckConditionFragment(newfrag);
            }
            return retval;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VirtualExpressionBuilder
    extends DerivedPropertyBuilder<Column> {
        private VirtualExpressionBuilder(AbstractDBObjectProvider pro) {
            super(pro, "COLUMN");
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"virtualExpression"})
        public boolean buildVirtualExpression(Column col) throws SQLQueryException {
            String source;
            boolean retval = false;
            Relation rel = col.getRelation();
            if (rel != null && ModelUtil.hasLength((String)(source = col.getVirtualExpressionSource()))) {
                retval = true;
                SQLFragment newfrag = SQLFragmentExpressionBuilder.getExpressionOrFail((DBObjectProvider)this.getProvider(), (Relation)rel, (SQLFragmentExpressionBuilder.ExpressionType)SQLFragmentExpressionBuilder.ExpressionType.ITEM, (String)source);
                if (newfrag != null) {
                    for (ColumnUsage cu : DBUtil.findChildren((DBObject)newfrag, ColumnUsage.class)) {
                        cu.setAlwaysQuote(true);
                    }
                }
                col.setVirtualExpression(newfrag);
            }
            return retval;
        }
    }
}

