/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sqlite;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SQLiteBuilderHelper {
    private final Database m_db;

    SQLiteBuilderHelper(Database db) {
        this.m_db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getSQL(String type, String name) {
        String retval = null;
        if (ModelUtil.hasLength((String)name)) {
            SQLiteBuilderHelper sQLiteBuilderHelper = this;
            synchronized (sQLiteBuilderHelper) {
                final Holder holder = new Holder();
                final QueryWrapper wrap = new QueryWrapper(this.m_db, "SELECT SQL FROM SQLITE_MASTER WHERE TYPE= ? AND UPPER(NAME) = ?", new Object[]{type.toLowerCase(), name.toUpperCase()});
                QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet rs) throws DBException {
                        try {
                            while (rs.next()) {
                                holder.set((Object)rs.getString(1));
                            }
                        }
                        catch (SQLException e) {
                            wrap.throwDBException(e);
                        }
                    }
                };
                try {
                    wrap.executeQuery(r);
                }
                catch (DBException dbe) {
                    DBLog.getLogger().log(Level.WARNING, "", dbe);
                }
                retval = (String)holder.get();
            }
        }
        return retval;
    }

    PlSqlToken getSQLFirstToken(String type, String name) {
        PlSqlToken retval = null;
        String sql = this.getSQL(type, name);
        if (sql != null) {
            retval = PlSqlTokenizer.tokenize((String)sql, (String[])new String[0]);
        }
        return retval;
    }

    Collection<String> getTriggersForTable(String tableName) throws DBException {
        final HashSet<String> retval = new HashSet<String>();
        final QueryWrapper wrap = new QueryWrapper(this.m_db, "SELECT NAME FROM SQLITE_MASTER WHERE TYPE='trigger' AND UPPER(TBL_NAME) LIKE ?", new Object[]{tableName.toUpperCase()});
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        retval.add(rs.getString(1));
                    }
                }
                catch (SQLException e) {
                    wrap.throwDBException(e);
                }
            }
        };
        wrap.executeQuery(r);
        return retval;
    }
}

