/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sqlite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;
import oracle.javatools.db.ora.OracleNumberDataType;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilder;
import oracle.javatools.db.plsql.DefaultSourceOptions;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.property.PropertyInitializer;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sqlite.SQLiteBuilderHelper;
import oracle.javatools.db.sqlite.SQLiteDDLGenerator;
import oracle.javatools.db.sqlite.SQLiteDatabase;
import oracle.javatools.db.sqlite.SQLiteTriggerValidator;
import oracle.javatools.db.validators.DBObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteDatabaseDescriptor
extends JdbcDatabaseDescriptor {
    public static final char QUOTE_IDENTIFIER = '\"';
    public static final int MAX_NAME_LENGTH = 1000;
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ADD", "ALL", "ALTER", "AND", "AS", "AUTOINCREMENT", "BETWEEN", "CASE", "CHECK", "COLLATE", "COMMIT", "CONSTRAINT", "CREATE", "CROSS", "DEFAULT", "DEFERRABLE", "DELETE", "DISTINCT", "DROP", "ELSE", "ESCAPE", "EXCEPT", "EXISTS", "FOREIGN", "FROM", "FULL", "GROUP", "HAVING", "IN", "INDEX", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "LEFT", "LIMIT", "NATURAL", "NOT", "NOTNULL", "NULL", "ON", "OR", "ORDER", "OUTER", "PRIMARY", "REFERENCES", "RIGHT", "ROLLBACK", "SELECT", "SET", "TABLE", "THEN", "TO", "TRANSACTION", "UNION", "UNIQUE", "UPDATE", "USING", "VALUES", "WHEN", "WHERE", "_ROWID_", "MAIN", "OID", "ROWID", "SQLITE_MASTER", "SQLITE_SEQUENCE", "SQLITE_TEMP_MASTER", "TEMP"));
    private static final Set NON_RESERVED_KEYWORDS = new HashSet<String>(Arrays.asList("ABORT", "AFTER", "ANALYZE", "ASC", "ATTACH", "BEFORE", "BEGIN", "BY", "CASCADE", "CAST", "COLUMN", "CONFLICT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DATABASE", "DEFERRED", "DESC", "DETACH", "EACH", "END", "EXCLUSIVE", "EXPLAIN", "FAIL", "FOR", "GLOB", "IF", "IGNORE", "IMMEDIATE", "INDEXED", "INITIALLY", "INSTEAD", "KEY", "LIKE", "MATCH", "OF", "OFFSET", "PLAN", "PRAGMA", "QUERY", "RAISE", "REGEXP", "REINDEX", "RELEASE", "RENAME", "REPLACE", "RESTRICT", "ROW", "SAVEPOINT", "TEMP", "TEMPORARY", "TRIGGER", "VACUUM", "VIEW", "VIRTUAL"));
    private static final Set KEYWORDS = new HashSet();

    public SQLiteDatabaseDescriptor(Class<? extends SQLiteDatabase> clz) {
        super(clz);
    }

    @Override
    public String getDatabaseType() {
        return "SQLite";
    }

    @Override
    public int getDatabaseVersion() {
        return 30620;
    }

    @Override
    public int getCasePolicy() {
        return 0;
    }

    @Override
    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    @Override
    public int getMaxNameLength(String type) {
        return 1000;
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        return new SQLiteDDLGenerator(this.getDatabaseClass(), pro);
    }

    @Override
    public void validateName(String type, String name) throws InvalidNameException {
        SQLiteDatabaseDescriptor.validateIdentifier((String)name, (char)'\"', (int)1000, (String)"_$@", (boolean)false, (Set)RESERVED_WORDS, (int)this.getCasePolicy());
        char firstChar = name.charAt(0);
        if (firstChar != '\"' && !Character.isLetter(firstChar) && firstChar != '_' && firstChar != '@') {
            throw new InvalidNameException(null, APIBundle.get((String)"INVALID_IDENTIFIER_ILLEGAL_CHARACTER"));
        }
    }

    @Override
    public Collection<String> getReservedWords() {
        return RESERVED_WORDS;
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider pro) {
        Map<String, DBObjectValidator> v = super.getValidators(pro);
        v.put("TRIGGER", (DBObjectValidator)new SQLiteTriggerValidator(pro));
        return v;
    }

    protected void initialiseDefaultSourceOptions(DefaultSourceOptions opts) {
        opts.setUseCreateOrReplace(false);
        opts.setIncludeTerminators(true);
        opts.setEnableTriggers(false);
    }

    @Override
    public SQLQueryBuilderFactory getSQLQueryBuilderFactory() {
        return new SQLQueryBuilderFactory(){

            protected SQLQueryBuilder createBuilderImpl(DBObjectProvider pro, Schema schema) {
                return new OracleSQLQueryBuilder(pro, schema);
            }
        };
    }

    @Override
    public List<PropertyInitializer> getPropertyInitializers(DBObjectProvider pro) {
        List<PropertyInitializer> pdpList = super.getPropertyInitializers(pro);
        pdpList.add(new SQLiteDefaultsInitializer(pro));
        return pdpList;
    }

    public DBObjectLister getTriggerLister(DBObjectProvider pro) {
        return new SQLiteTriggerLister((SQLiteDatabase)pro);
    }

    @Override
    protected void registerDataTypes(DataTypeCache cache) {
        if (this.getDatabaseVersion() == 30620) {
            cache.registerDataType("BFILE");
            cache.registerDataType("BINARY_DOUBLE");
            cache.registerDataType("BINARY_FLOAT");
            cache.registerDataType("BLOB");
            cache.registerDataType("CHAR");
            cache.registerDataType("CLOB");
            cache.registerDataType("DATE");
            cache.registerDataType("DOUBLE PRECISION");
            cache.registerDataType("FLOAT");
            cache.registerDataType("INT");
            cache.registerDataType("INTEGER");
            cache.registerDataType("LONG RAW");
            cache.registerDataType("LONG");
            cache.registerDataType("NCHAR");
            cache.registerDataType("NCLOB");
            cache.registerDataType("NVARCHAR2");
            cache.registerDataType((DataType)new OracleNumberDataType(0));
            cache.registerDataType("RAW");
            cache.registerDataType("REAL");
            cache.registerDataType("ROWID");
            cache.registerDataType("SMALLINT");
            cache.registerDataType("TIMESTAMP");
            cache.registerDataType("UROWID");
            cache.registerDataType("VARCHAR2");
            cache.registerDataTypeSynonym("CHARACTER", "CHAR");
            cache.registerDataTypeSynonym("CHAR VARYING", "VARCHAR2");
            cache.registerDataTypeSynonym("CHARACTER VARYING", "VARCHAR2");
            cache.registerDataTypeSynonym("LONG VARCHAR", "LONG");
            cache.registerDataTypeSynonym("VARCHAR", "VARCHAR2");
            cache.registerDataTypeSynonym("DEC", "NUMBER");
            cache.registerDataTypeSynonym("DECIMAL", "NUMBER");
            cache.registerDataTypeSynonym("NUMERIC", "NUMBER");
            cache.registerDataTypeSynonym("NATIONAL CHAR", "NCHAR");
            cache.registerDataTypeSynonym("NATIONAL CHAR VARYING", "NVARCHAR2");
            cache.registerDataTypeSynonym("NATIONAL CHARACTER", "NCHAR");
            cache.registerDataTypeSynonym("NATIONAL CHARACTER VARYING", "NVARCHAR2");
            cache.registerDataTypeSynonym("NCHAR VARYING", "NVARCHAR2");
        }
    }

    static {
        KEYWORDS.addAll(NON_RESERVED_KEYWORDS);
        KEYWORDS.addAll(RESERVED_WORDS);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SQLiteTriggerLister
    extends DBObjectLister {
        public SQLiteTriggerLister(SQLiteDatabase db) {
            super((DBObjectProvider)db);
        }

        public Collection<DBObjectLister.ObjectInfo> listObjects(DBObjectCriteria criteria) throws DBException {
            ArrayList<DBObjectLister.ObjectInfo> infos = new ArrayList<DBObjectLister.ObjectInfo>();
            SQLiteBuilderHelper helper = new SQLiteBuilderHelper((Database)this.getProvider());
            Schema schema = this.getProvider().getSchema(criteria.getSchemaName());
            for (String name : helper.getTriggersForTable(criteria.getNameLike())) {
                infos.add(new DBObjectLister.ObjectInfo("TRIGGER", schema, name));
            }
            return infos;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SQLiteDefaultsInitializer
    extends PropertyInitializer {
        private static String[] s_names = new String[]{"statementLevel"};
        private static String[] s_empty = new String[0];

        SQLiteDefaultsInitializer(DBObjectProvider pro) {
            super(pro);
        }

        public String[] getPropertyNames(Class<? extends DBObject> clz) {
            if (Trigger.class.isAssignableFrom(clz)) {
                return s_names;
            }
            return s_empty;
        }

        public Object getPropertyInitialValue(DBObject obj, String propertyName) throws PropertyInitializer.InitializationVeto {
            Boolean retval = null;
            if (obj instanceof Trigger && "statementLevel".equals(propertyName)) {
                retval = false;
            }
            return retval;
        }
    }
}

