/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sqlite;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sqlite.SQLiteDatabase;
import oracle.javatools.db.sqlite.SQLiteTableBuilder;
import oracle.javatools.db.sqlite.SQLiteTriggerBuilder;
import oracle.javatools.db.sqlite.SQLiteViewBuilder;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteDatabaseImpl
extends JdbcDDLDatabase
implements SQLiteDatabase {
    private static final String METADATA_CLASSNAME = "org.sqlite.MetaData";
    private static final String NYI = "not yet implemented";
    static final String SQLITE_BLOB = "BLOB";
    static final String SQLITE_BFILE = "BFILE";
    static final String SQLITE_BINARY_DOUBLE = "BINARY_DOUBLE";
    static final String SQLITE_BINARY_FLOAT = "BINARY_FLOAT";
    static final String SQLITE_CHAR = "CHAR";
    static final String SQLITE_CHAR_VARYING = "CHAR VARYING";
    static final String SQLITE_CHARACTER = "CHARACTER";
    static final String SQLITE_CHARACTER_VARYING = "CHARACTER VARYING";
    static final String SQLITE_CLOB = "CLOB";
    static final String SQLITE_DATE = "DATE";
    static final String SQLITE_DEC = "DEC";
    static final String SQLITE_DECIMAL = "DECIMAL";
    static final String SQLITE_DOUBLE_PRECISION = "DOUBLE PRECISION";
    static final String SQLITE_FLOAT = "FLOAT";
    static final String SQLITE_INT = "INT";
    static final String SQLITE_INTEGER = "INTEGER";
    static final String SQLITE_LONG = "LONG";
    static final String SQLITE_LONG_RAW = "LONG RAW";
    static final String SQLITE_LONG_VARCHAR = "LONG VARCHAR";
    static final String SQLITE_NATIONAL_CHAR = "NATIONAL CHAR";
    static final String SQLITE_NATIONAL_CHAR_VARYING = "NATIONAL CHAR VARYING";
    static final String SQLITE_NATIONAL_CHARACTER = "NATIONAL CHARACTER";
    static final String SQLITE_NATIONAL_CHARACTER_VARYING = "NATIONAL CHARACTER VARYING";
    static final String SQLITE_NCHAR = "NCHAR";
    static final String SQLITE_NCHAR_VARYING = "NCHAR VARYING";
    static final String SQLITE_NCLOB = "NCLOB";
    static final String SQLITE_NUMBER = "NUMBER";
    static final String SQLITE_NUMERIC = "NUMERIC";
    static final String SQLITE_NVARCHAR2 = "NVARCHAR2";
    static final String SQLITE_RAW = "RAW";
    static final String SQLITE_REAL = "REAL";
    static final String SQLITE_ROWID = "ROWID";
    static final String SQLITE_SMALLINT = "SMALLINT";
    static final String SQLITE_TIMESTAMP = "TIMESTAMP";
    static final String SQLITE_UROWID = "UROWID";
    static final String SQLITE_VARCHAR = "VARCHAR";
    static final String SQLITE_VARCHAR2 = "VARCHAR2";
    private String m_defaultSchemaName;

    public SQLiteDatabaseImpl(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    protected void processDeleteException(DBException dbe, SystemObject object) throws DBException {
        if (object instanceof Trigger && dbe.getMessage().contains(object.getName())) {
            return;
        }
        throw dbe;
    }

    protected String queryCurrentUserName() throws DBException {
        ConnectionWrapper wrap = new ConnectionWrapper((Database)this, APIBundle.get((String)"GET_USER_NAME"));
        String defaultSchemaName = (String)wrap.call((ConnectionWrapper.SQLCallable)new ConnectionWrapper.SQLCallable<String>(wrap){

            public String call() throws SQLException {
                String url;
                Connection c = this.getConnection();
                DatabaseMetaData m = c.getMetaData();
                String retval = null;
                if (m != null && (url = c.getMetaData().getURL()) != null) {
                    String[] bits = url.split("[\\\\/:]");
                    retval = bits[bits.length - 1];
                    if (retval.contains(".")) {
                        retval = retval.substring(0, retval.indexOf("."));
                    }
                    retval = retval.toUpperCase();
                }
                return retval;
            }
        });
        String retval = defaultSchemaName == null || defaultSchemaName.length() == 0 ? "SQLite".toUpperCase() : defaultSchemaName;
        return retval;
    }

    protected String queryCatalog() {
        return this.getUserName();
    }

    @Override
    protected void registerBuilders(Collection<String> types, String catalog) {
        this.registerBuilder("TABLE", (DBObjectBuilder)new SQLiteTableBuilder(this, catalog));
        this.registerBuilder("VIEW", (DBObjectBuilder)new SQLiteViewBuilder(this, catalog));
        this.registerBuilder("TRIGGER", (DBObjectBuilder)new SQLiteTriggerBuilder(this));
    }

    @Override
    protected boolean tableMatches(String ref, String rsName) {
        return super.tableMatches(this.getUpperName(ref), this.getUpperName(rsName));
    }

    protected boolean isRequestedObject(SystemObject object, String type, Schema schema, String name) {
        return ModelUtil.areEqual((Object)object.getType(), (Object)type) && ModelUtil.areEqual((Object)this.getUpperName(object.getName()), (Object)this.getUpperName(name));
    }

    private String getUpperName(String name) {
        if (name == null || name.startsWith("\"")) {
            return name;
        }
        return name.toUpperCase();
    }

    public boolean isUnsupportedOperation(SQLException sqe) {
        return super.isUnsupportedOperation(sqe) || METADATA_CLASSNAME.equals(sqe.getStackTrace()[0].getClassName()) && NYI.equals(sqe.getMessage());
    }
}

