/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sqlite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.jdbc.JdbcTableBuilder;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.sqlite.SQLiteBuilderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteTableBuilder
extends JdbcTableBuilder<Table> {
    private static final String COMMENT_HEADER = "/*COMMENT=\n";
    private final SQLiteBuilderHelper m_helper;
    private final PlSqlSearch m_pkUkSearch = new PlSqlSearch(", CONSTRAINT <name ?> <type {PRIMARY KEY | UNIQUE}>");
    private final PlSqlSearch m_fkSearch = new PlSqlSearch(", CONSTRAINT <name ?> FOREIGN KEY (...) REFERENCES <refTable ?.> [<refCols (...)>]");
    private final PlSqlSearch m_fkDelSearch = new PlSqlSearch("ON DELETE <action {SET NULL|SET DEFAULT|CASCADE|RESTRICT|NO ACTION}>");
    private final PlSqlSearch m_fkDefSearch = new PlSqlSearch("<not [NOT]> DEFERRABLE [INITIALLY <initially {IMMEDIATE|DEFERRED}>]");
    private final PlSqlSearch m_ccSearch = new PlSqlSearch(", CONSTRAINT <name ?> CHECK <cond (...)>");
    private final PlSqlSearch m_colDefSearch = new PlSqlSearch("<name ?> {^DEFAULT}... {DEFAULT <defVal {(...)|?}>}");

    public SQLiteTableBuilder(JdbcDatabase db, String catalog) {
        super(db, catalog);
        this.m_helper = new SQLiteBuilderHelper((Database)db);
    }

    @Override
    protected Map<String, Object> createDataTypeAttributes(Table rel, Column column, DataType dataType, Long size, Long scale, String jdbcTypeName) {
        return null;
    }

    @Override
    protected void buildPK(Table rel) throws DBException {
        this.buildPKUKs(rel, true);
    }

    @Override
    protected void buildUKs(Table rel) throws DBException {
        this.buildPKUKs(rel, false);
    }

    private void buildPKUKs(Table rel, boolean buildPk) {
        Map<String, List<String>> map = this.getPKUKColumns(rel.getName(), buildPk, !buildPk);
        for (Map.Entry<String, List<String>> e : map.entrySet()) {
            String name = e.getKey();
            List<String> cols = e.getValue();
            if (cols.size() <= 0) continue;
            PKConstraint uk = buildPk ? new PKConstraint(name, (Relation)rel) : new UniqueConstraint(name, (Relation)rel);
            this.setID((ChildDBObject)uk);
            for (String col : cols) {
                uk.addColumn(rel.getColumn(col));
            }
            rel.addConstraint((Constraint)uk);
        }
    }

    @Override
    protected void buildFKs(Table rel) throws DBException {
        PlSqlToken tk = this.m_helper.getSQLFirstToken("TABLE", rel.getName());
        String schemaName = rel.getSchema().getName();
        while (this.m_fkSearch.isWithin(tk)) {
            tk = this.m_fkSearch.getStartToken();
            List<String> cols = this.getFKColumnList(tk);
            PlSqlToken refColTk = this.m_fkSearch.getNamedMatchStartToken("refCols");
            List<Object> refCols = refColTk == null ? new ArrayList() : this.getFKColumnList(refColTk);
            if (cols.size() > 0) {
                FKConstraint fk = new FKConstraint(this.m_fkSearch.getNamedMatch("name"), (Relation)rel);
                this.setID((ChildDBObject)fk);
                for (String col : cols) {
                    fk.addColumn(rel.getColumn(col));
                }
                fk.setReferenceID(this.getRefConstraintID(this.m_fkSearch.getNamedMatch("refTable"), schemaName, cols, refCols));
                if (this.m_fkDelSearch.isWithin(tk)) {
                    PlSqlToken actionToken = this.m_fkDelSearch.getNamedMatchStartToken("action");
                    FKConstraint.ReferentialAction action = FKConstraint.ReferentialAction.RESTRICT;
                    if (actionToken.matches("RESTRICT")) {
                        action = FKConstraint.ReferentialAction.RESTRICT;
                    } else if (actionToken.matches("CASCADE")) {
                        action = FKConstraint.ReferentialAction.CASCADE;
                    } else if (actionToken.matches("NO") && actionToken.getNextCodeToken().matches("ACTION")) {
                        action = FKConstraint.ReferentialAction.NO_ACTION;
                    } else if (actionToken.matches("SET") && actionToken.getNextCodeToken().matches("NULL")) {
                        action = FKConstraint.ReferentialAction.SET_NULL;
                    } else if (actionToken.matches("SET") && actionToken.getNextCodeToken().matches("DEFAULT")) {
                        action = FKConstraint.ReferentialAction.SET_DEFAULT;
                    }
                    fk.setOnDeleteAction(action);
                }
                if (this.m_fkDefSearch.isWithin(tk)) {
                    PlSqlToken notToken = this.m_fkDefSearch.getNamedMatchStartToken("not");
                    PlSqlToken initiallyToken = this.m_fkDefSearch.getNamedMatchStartToken("initially");
                    Constraint.DeferrableState defState = null;
                    if (notToken == null) {
                        defState = initiallyToken != null && initiallyToken.matches("IMMEDIATE") ? Constraint.DeferrableState.DEFER_INIT_IMMEDIATE : Constraint.DeferrableState.DEFER_INIT_DEFERRED;
                    }
                    fk.setDeferrableState(defState);
                }
                rel.addConstraint((Constraint)fk);
            }
            tk = this.m_fkSearch.getEndToken();
        }
    }

    @Override
    protected void buildCCs(Table rel) throws DBException {
        PlSqlToken tk = this.m_helper.getSQLFirstToken("TABLE", rel.getName());
        while (this.m_ccSearch.isWithin(tk)) {
            tk = this.m_ccSearch.getStartToken();
            PlSqlToken condStart = this.m_ccSearch.getNamedMatchStartToken("cond");
            PlSqlToken condEnd = this.m_ccSearch.getNamedMatchEndToken("cond");
            CheckConstraint cc = (CheckConstraint)this.newObject(CheckConstraint.class, this.m_ccSearch.getNamedMatch("name"));
            cc.setRelation((Relation)rel);
            this.setID((ChildDBObject)cc);
            String cond = condStart.getNextCodeToken().getSource(true, condEnd.getPrevToken());
            cc.setCheckCondition(cond);
            rel.addConstraint((Constraint)cc);
            tk = this.m_ccSearch.getEndToken();
        }
    }

    private Map<String, List<String>> getPKUKColumns(String tablename, boolean pk, boolean uk) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        PlSqlToken tk = this.m_helper.getSQLFirstToken("TABLE", tablename);
        while (this.m_pkUkSearch.isWithin(tk)) {
            tk = this.m_pkUkSearch.getNamedMatchStartToken("type");
            if (pk && tk.matches("PRIMARY") || uk && tk.matches("UNIQUE")) {
                List<String> cols = this.getFKColumnList(tk);
                map.put(this.m_pkUkSearch.getNamedMatch("name"), cols);
            }
            tk = this.m_pkUkSearch.getEndToken();
        }
        return map;
    }

    private List<String> getFKColumnList(PlSqlToken tk) {
        PlSqlToken tk2 = tk;
        ArrayList<String> ret = new ArrayList<String>();
        while (tk2.isCode() && !tk2.matches("(")) {
            tk2 = tk2.getNextCodeToken();
        }
        while (tk2.matches("(") || tk2.matches(",")) {
            tk2 = tk2.getNextCodeToken();
            ret.add(tk2.getSource());
            tk2 = tk2.getNextCodeToken();
        }
        return ret;
    }

    private List<String> getColumnList(PlSqlToken tk) {
        PlSqlToken tk2 = tk;
        ArrayList<String> ret = new ArrayList<String>();
        while (tk2.isCode() && !tk2.matches("(")) {
            tk2 = tk2.getNextCodeToken();
        }
        while (tk2.matches("(") || tk2.matches(",")) {
            PlSqlToken start = tk2 = tk2.getNextCodeToken();
            int paren = 0;
            while (paren >= 0 && (paren != 0 || !tk2.matches(",") && !tk2.matches(")"))) {
                if (tk2.matches("(")) {
                    ++paren;
                } else if (tk2.matches(")")) {
                    --paren;
                }
                tk2 = tk2.getNextCodeToken();
            }
            ret.add(start.getSource(false, tk2.getPrevCodeToken()));
        }
        return ret;
    }

    private DBObjectID getRefConstraintID(String tableName, String schemaName, List<String> fkCols, List<String> refCols) throws DBException {
        int numFKCols = fkCols.size();
        int numRefCols = refCols.size();
        NameBasedID parID = new NameBasedID("TABLE", schemaName, tableName);
        parID.setProvider((DBObjectProvider)this.getDatabase());
        Map<String, List<String>> map = numRefCols == 0 ? this.getPKUKColumns(tableName, true, false) : (numRefCols == numFKCols ? this.getPKUKColumns(tableName, true, true) : new HashMap<String, List<String>>());
        for (Map.Entry<String, List<String>> e : map.entrySet()) {
            String name = e.getKey();
            List<String> colList = e.getValue();
            if (colList.size() != fkCols.size()) continue;
            if (numRefCols == 0) {
                NameBasedID id = new NameBasedID("CONSTRAINT", name, (DBObjectID)parID);
                id.setProvider((DBObjectProvider)this.getDatabase());
                return id;
            }
            boolean found = true;
            for (String refCol : refCols) {
                if (colList.contains(refCol)) continue;
                found = false;
                break;
            }
            if (!found) continue;
            NameBasedID id = new NameBasedID("CONSTRAINT", name, (DBObjectID)parID);
            id.setProvider((DBObjectProvider)this.getDatabase());
            return id;
        }
        return null;
    }

    @Override
    protected void loadAndBuildIndexes(Table table) throws DBException {
        super.loadAndBuildIndexes(table);
        ArrayList<String> toDel = new ArrayList<String>();
        for (Index i : table.getIndexes()) {
            String name = i.getName();
            if (name == null || !name.startsWith("sqlite_autoindex_")) continue;
            toDel.add(name);
        }
        for (String name : toDel) {
            table.removeIndex(table.getIndex(name));
        }
    }

    private void setID(ChildDBObject obj) {
        obj.setID((DBObjectID)new NameBasedID(obj.getType(), obj.getName(), obj.getParent().getID()));
    }

    @Override
    protected void addExtraColumnAttributes(Table rel) {
        PlSqlToken tk = this.m_helper.getSQLFirstToken("TABLE", rel.getName());
        List<String> colList = this.getColumnList(tk);
        for (String colDef : colList) {
            if (!this.m_colDefSearch.matches(colDef)) continue;
            Column col = (Column)DBUtil.findChildByName((DBObject)rel, (String)"columns", (String)this.m_colDefSearch.getNamedMatch("name"), (DBObjectProvider)this.getProvider());
            String defaultValue = this.m_colDefSearch.getNamedMatch("defVal");
            col.setDefault((Object)defaultValue);
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"Comment"})
    public void fillInComment(Table rel) throws DBException {
        PlSqlToken tk = this.m_helper.getSQLFirstToken("TABLE", rel.getName());
        while (!tk.isCode() || !tk.matches("(")) {
            tk = tk.getNextCodeToken();
        }
        if (tk.matches("(")) {
            String comment;
            tk = tk.getNextToken();
            while (tk.getType() == PlSqlToken.Type.WHITESPACE) {
                tk = tk.getNextToken();
            }
            if (tk.getType() == PlSqlToken.Type.MULTI_LINE_COMMENT && (comment = tk.getSource()).startsWith(COMMENT_HEADER)) {
                String tableComment = comment.substring(COMMENT_HEADER.length(), comment.length() - 3);
                rel.setProperty("Comment", (Object)tableComment);
            }
        }
    }
}

