/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sybase;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.logging.Level;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.sybase.AdaptiveServerDatabaseImpl;
import oracle.javatools.db.sybase.AdaptiveServerEnterpriseDatabase;
import oracle.javatools.db.sybase.AdaptiveServerEnterpriseTableBuilder;
import oracle.javatools.db.sybase.AdaptiveServerEnterpriseViewBuilder;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptiveServerEnterpriseDatabaseImpl
extends AdaptiveServerDatabaseImpl
implements AdaptiveServerEnterpriseDatabase {
    private static final String SELECT_SCHEMAS = "select name from sysusers where suid > -2 ";

    protected AdaptiveServerEnterpriseDatabaseImpl(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    @Override
    protected void registerBuilders(Collection<String> types, String catalog) {
        super.registerBuilders(types, catalog);
        if (types.contains("TABLE")) {
            this.registerBuilder("TABLE", (DBObjectBuilder)new AdaptiveServerEnterpriseTableBuilder(this, catalog));
        }
        if (types.contains("VIEW")) {
            this.registerBuilder("VIEW", (DBObjectBuilder)new AdaptiveServerEnterpriseViewBuilder(this, catalog));
        }
    }

    protected void processDeleteException(DBException dbe, SystemObject obj) throws DBException {
        int code;
        Throwable cause = dbe.getCause();
        if (cause instanceof SQLException && (code = ((SQLException)cause).getErrorCode()) == 3712) {
            throw new CascadeRequiredException((DBObject)obj, ((SQLException)cause).getMessage());
        }
        throw dbe;
    }

    @Override
    protected void populateSchemas() throws SQLException {
        final QueryWrapper wrap = new QueryWrapper((Database)this, SELECT_SCHEMAS);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        String name = rs.getString(1);
                        String schemaName = ModelUtil.hasLength((String)name) ? name : "<null>";
                        String catalogName = AdaptiveServerEnterpriseDatabaseImpl.this.getCatalog();
                        AdaptiveServerEnterpriseDatabaseImpl.this.createAndCacheSchema(schemaName, catalogName, name);
                    }
                }
                catch (SQLException e) {
                    wrap.throwDBException(e);
                }
            }
        };
        try {
            wrap.executeQuery(r);
        }
        catch (DBException dbe) {
            DBLog.getLogger().log(Level.WARNING, "Cannot query schemas for database " + this.getConnectionName(), dbe);
        }
    }
}

