/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTypeUsageValidator
extends AbstractChildDBObjectValidator<DataTypeUsage> {
    public DataTypeUsageValidator(DBObjectProvider pro) {
        super(pro);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    public void validateObjectProperty(DataTypeUsage original, DataTypeUsage updated, String property) throws ValidationException {
        String[] props = Property.getProperties((String)property);
        if (props.length == 2 && props[0].equals("attributeValues")) {
            DataTypeAttribute attribute;
            DataType dataType = this.getDataType(updated, false);
            if (dataType != null && (attribute = dataType.getDataTypeAttribute(props[1])) != null) {
                Object attributeValue = updated.getAttributeValue(props[1]);
                this.validateAttributeUsage(attribute, attributeValue, dataType, updated);
            }
        } else {
            super.validateObjectProperty((DBObject)original, (DBObject)updated, property);
        }
    }

    @DBObjectValidator.PropertyValidator(value={"dataTypeID"})
    public void validateDataTypeID(DataTypeUsage orig, DataTypeUsage updated) throws ValidationException {
        this.getDataType(updated, true);
    }

    private DataType getDataType(DataTypeUsage dtu, boolean throwIfMissing) throws ValidationException {
        DataType retval = null;
        DBObjectID dataTypeID = dtu.getDataTypeID();
        if (!(dataTypeID instanceof ReferenceID && "DATATYPE".equals(dataTypeID.getType()) && this.getProvider() instanceof Database)) {
            try {
                retval = DataTypeHelper.getDataType((DataTypeUsage)dtu);
            }
            catch (DBException dbe) {
                // empty catch block
            }
            if (throwIfMissing && retval == null) {
                throw new ValidationException((DBObject)dtu, "dataTypeID", APIBundle.format((String)"COLUMN_ERROR_MISSING_TYPE", (Object[])new Object[]{DBUtil.getFullyQualifiedName((DBObject)dtu.getParent())}));
            }
        }
        return retval;
    }

    @DBObjectValidator.PropertyValidator(value={"dataTypeAttributes"})
    public void validateAttributes(DataTypeUsage orig, DataTypeUsage dataTypeUsage) throws ValidationException {
        DataType dataType = this.getDataType(dataTypeUsage, false);
        if (dataType != null) {
            this.validateAttributes(dataTypeUsage, dataType);
        }
    }

    protected void validateAttributes(DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        if (DataTypeHelper.isTypeOf((DataType)dataType, PredefinedDataType.class)) {
            for (DataTypeAttribute attribute : dataType.getDataTypeAttributes()) {
                Object attributeValue = dataTypeUsage.getAttributeValue(attribute.getName());
                this.validateAttributeUsage(attribute, attributeValue, dataType, dataTypeUsage);
            }
            DataTypeAttribute precisionAttr = dataType.getDataTypeAttribute("precision");
            DataTypeAttribute scaleAttr = dataType.getDataTypeAttribute("scale");
            this.validatePrecisionAndScale(dataTypeUsage, precisionAttr, scaleAttr);
        }
    }

    protected void validatePrecisionAndScale(DataTypeUsage dataTypeUsage, DataTypeAttribute precisionAttr, DataTypeAttribute scaleAttr) throws ValidationException {
        if (precisionAttr != null && scaleAttr != null && scaleAttr.isDeclarable() && dataTypeUsage.hasAttributeValue("scale")) {
            Long precisionVal = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"precision");
            if (precisionVal == null) {
                precisionVal = (Long)precisionAttr.getDefaultValue();
            }
            if (scaleAttr.getMaxValue() == null) {
                Long scaleVal;
                if (precisionVal == null) {
                    this.throwAttributeValueInvalid(dataTypeUsage, precisionAttr, APIBundle.format((String)"DATATYPE_ERROR_INVALID_SCALE1", (Object[])new Object[]{scaleAttr.getMinValue()}));
                }
                if ((scaleVal = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"scale")) != null && scaleVal.compareTo(precisionVal) > 0) {
                    this.throwAttributeValueInvalid(dataTypeUsage, scaleAttr, APIBundle.format((String)"DATATYPE_ERROR_INVALID_SCALE2", (Object[])new Object[]{precisionVal}));
                }
            }
        }
    }

    protected void validateAttributeUsage(DataTypeAttribute attribute, Object attributeValue, DataType dataType, DataTypeUsage dataTypeUsage) throws ValidationException {
        if (attribute.isMandatory() && (attributeValue == null || "".equals(attributeValue))) {
            this.throwAttributeValueInvalid(dataTypeUsage, attribute, APIBundle.format((String)"DATATYPE_ERROR_MISSING_MANDATORY", (Object[])new Object[]{DataTypeHelper.getNameFromLabel((String)attribute.getLabel())}));
        }
        if (attribute.isDeclarable()) {
            int valueType = attribute.getValueType();
            if (valueType == 0) {
                String usageValue = DataTypeHelper.toString((Object)attributeValue);
                String[] allowableValues = attribute.getValues();
                if (usageValue != null && allowableValues != null && !attribute.isExtensible()) {
                    boolean isValidValue = false;
                    for (int j = 0; j < allowableValues.length; ++j) {
                        if (allowableValues[j].compareToIgnoreCase(usageValue) != 0) continue;
                        isValidValue = true;
                        break;
                    }
                    if (!isValidValue) {
                        this.throwAttributeValueInvalid(dataTypeUsage, attribute, APIBundle.format((String)"DATATYPE_ERROR_INVALID_STRING_VALUE", (Object[])new Object[]{usageValue, DataTypeHelper.getNameFromLabel((String)attribute.getLabel())}));
                    }
                }
            } else if (valueType == 1) {
                this.validateLongDataTypeAttribute(attribute, attributeValue, dataTypeUsage);
            } else if (valueType == 2) {
                String usageValue = DataTypeHelper.toString((Object)attributeValue);
                String[] vals = attribute.getValues();
                if (vals != null && vals.length > 0) {
                    boolean isValidValue = false;
                    for (String val : vals) {
                        if (!val.equalsIgnoreCase(usageValue)) continue;
                        isValidValue = true;
                        break;
                    }
                    if (!isValidValue) {
                        this.validateLongDataTypeAttribute(attribute, attributeValue, dataTypeUsage);
                    }
                }
            } else {
                DBLog.getLogger((Object)((Object)this)).severe("Unrecognized value type " + valueType + " for attribute value " + attribute.getName());
            }
        }
    }

    private void validateLongDataTypeAttribute(DataTypeAttribute attribute, Object attributeValue, DataTypeUsage dataTypeUsage) throws ValidationException {
        Long usageValue = DataTypeHelper.toLong((Object)attributeValue);
        Long minValue = attribute.getMinValue();
        Long maxValue = attribute.getMaxValue();
        if (usageValue != null) {
            if (usageValue.compareTo(minValue) < 0) {
                this.throwAttributeValueInvalid(dataTypeUsage, attribute, APIBundle.format((String)"DATATYPE_ERROR_INVALID_NUMERIC_VALUE1", (Object[])new Object[]{DataTypeHelper.getNameFromLabel((String)attribute.getLabel()), minValue}));
            }
            if (maxValue != null && usageValue.compareTo(maxValue) > 0) {
                this.throwAttributeValueInvalid(dataTypeUsage, attribute, APIBundle.format((String)"DATATYPE_ERROR_INVALID_NUMERIC_VALUE2", (Object[])new Object[]{DataTypeHelper.getNameFromLabel((String)attribute.getLabel()), maxValue}));
            }
        }
    }

    protected void throwAttributeValueInvalid(DataTypeUsage dataTypeUsage, DataTypeAttribute attribute, String message) throws ValidationException {
        this.throwAttributeValueInvalid(dataTypeUsage, attribute.getName(), message);
    }

    protected void throwAttributeValueInvalid(DataTypeUsage dataTypeUsage, String attributeName, String message) throws ValidationException {
        throw new ValidationException((DBObject)dataTypeUsage, Property.createPath((String[])new String[]{"attributeValues", attributeName}), message);
    }
}

