/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.text.MessageFormat;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.IdentityColumnProperties;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractIncrementerValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityColumnPropertiesValidator
extends AbstractIncrementerValidator<IdentityColumnProperties> {
    public IdentityColumnPropertiesValidator(DBObjectProvider prov) {
        super(prov);
    }

    @DBObjectValidator.PropertyValidator(value={"generated"})
    public void validateGenerated(IdentityColumnProperties original, IdentityColumnProperties props) throws ValidationException {
        if (props.getGenerated() == null && props.getParent() != null) {
            throw new ValidationException((DBObject)props, MessageFormat.format(APIBundle.get((String)"IDENTITY_COL_PROPS_GENERATED_NULL_ERROR"), props.getParent().getName()));
        }
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"incrementBy"})
    @DBObjectValidator.PropertyDependency(value={"minValue", "maxValue"})
    public void validateIncrement(IdentityColumnProperties original, IdentityColumnProperties props) throws ValidationException {
        super.validateIncrement(original, props);
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"startWith"})
    @DBObjectValidator.PropertyDependency(value={"minValue", "maxValue"})
    public void validateStartWith(IdentityColumnProperties original, IdentityColumnProperties props) throws ValidationException {
        super.validateStartWith(original, props);
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"minValue"})
    @DBObjectValidator.PropertyDependency(value={"startWith", "maxValue"})
    public void validateMinValue(IdentityColumnProperties original, IdentityColumnProperties props) throws ValidationException {
        super.validateMinValue(original, props);
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"maxValue"})
    @DBObjectValidator.PropertyDependency(value={"minValue", "startWith", "incrementBy", "cycleFlag"})
    public void validateMaxValue(IdentityColumnProperties original, IdentityColumnProperties props) throws ValidationException {
        super.validateMaxValue(original, props);
    }

    @Override
    @DBObjectValidator.PropertyValidator(value={"cacheFlag", "cacheSize"})
    @DBObjectValidator.PropertyDependency(value={"minValue", "maxValue", "startWith", "incrementBy"})
    public void validateCache(IdentityColumnProperties original, IdentityColumnProperties props) throws ValidationException {
        super.validateCache(original, props);
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return super.getNamespaceType();
    }

    protected boolean canHaveEmptyName() {
        return true;
    }
}

