/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.plsql.PlSqlParserHelper;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.SourceValidationException;
import oracle.javatools.db.validators.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlSqlValidator<T extends PlSqlSourceObject>
extends SchemaObjectValidator<T> {
    private static PlSqlSearch s_typeAndNameSearch = new PlSqlSearch("[create [or replace]] <type ? [body]> <name ?.>");
    private boolean m_isBody;

    public PlSqlValidator(DBObjectProvider prov) {
        this(prov, false);
    }

    public PlSqlValidator(DBObjectProvider prov, boolean isBody) {
        super(prov);
        this.m_isBody = isBody;
    }

    @DBObjectValidator.PropertyValidator(value={"source"})
    public void validateSource(T original, T updated) throws ValidationException {
        ValidationException ex = null;
        if (this.isCheckPlSqlSyntax() && updated != null && updated.getSource() != null) {
            for (PlSqlParserHelper.Issue issue : PlSqlParserHelper.getIssues(updated)) {
                ex = this.addException(ex, updated, SourceValidationException.ErrorType.SYNTAX, issue.getStartOffset(), issue.getEndOffset(), issue.getMessage());
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    protected boolean isCheckPlSqlSyntax() {
        return true;
    }

    protected final ValidationException addException(ValidationException ex, T updated, SourceValidationException.ErrorType type, int start, int end, String message) {
        SourceValidationException sve = new SourceValidationException(updated, type, start, end, message);
        return (ValidationException)((Object)ValidationException.append((DBException)((Object)ex), (DBException)sve));
    }

    public CascadeAction cascadeDelete(DBObject removed, T obj) {
        CascadeAction retval = CascadeAction.NONE;
        if (PlSqlUtil.isBodyOf(removed, obj) || this.checkSchemaDelete(removed, (SchemaObject)obj)) {
            retval = CascadeAction.DELETE;
        }
        return retval;
    }

    protected CascadeAction cascadePropertyChange(Difference objDiff, String propName, Object oldValue, Object newValue, T obj) {
        CascadeAction retval = CascadeAction.NONE;
        if ("name".equals(propName) || "schema".equals(propName)) {
            DBObject origObj = (DBObject)objDiff.getOriginalObject();
            DBObject updateObj = (DBObject)objDiff.getUpdatedObject();
            if (!(updateObj.getID() instanceof TemporaryObjectID)) {
                DBLog.getLogger(PlSqlUtil.class).warning("Cascading a rename but the new object doesn't have a temp id");
            }
            boolean changed = PlSqlUtil.updateSoureForPropertyChange(obj, this.getProvider(), origObj, propName, newValue);
            boolean moved = this.checkSchemaRename(objDiff, propName, (SchemaObject)obj);
            if (changed || moved) {
                PlSqlToken tk;
                retval = CascadeAction.UPDATE;
                String source = obj.getSource();
                if (source != null && s_typeAndNameSearch.matches(tk = PlSqlTokenizer.tokenize((Reader)new StringReader(source), (Integer)10, (String[])new String[0]))) {
                    PlSqlToken nameTk = s_typeAndNameSearch.getNamedMatchEndToken("name");
                    obj.setName(this.getProvider().getInternalName(nameTk.getSource()));
                }
            }
        }
        return retval;
    }

    public Collection<String> listAlwaysValidProperties() {
        Collection retval = super.listAlwaysValidProperties();
        retval.add("returnTypeReference");
        return retval;
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return this.m_isBody ? DBObjectValidator.NamespaceType.NONE : DBObjectValidator.NamespaceType.SCHEMA;
    }
}

