/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Relation;
import oracle.javatools.db.View;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.ConstraintValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationValidator<T extends Relation>
extends SchemaObjectValidator<T> {
    public RelationValidator(DBObjectProvider prov) {
        super(prov);
    }

    @DBObjectValidator.PropertyValidator(value={"constraints"})
    public void validateConstraints(T original, T updated) throws ValidationException {
        Constraint[] cons = updated.getConstraints();
        ConstraintValidator.validateOnePK(cons);
        this.validateOwnedObjects((DBObject[])cons);
    }

    @DBObjectValidator.PropertyValidator(value={"columns"})
    public void validateColumns(T original, T updated) throws ValidationException {
        Object[] cols = updated.getColumns();
        if (this.enforceOneColumnExists(original == null) && !ModelUtil.hasNonNullElement((Object[])cols) && !(updated instanceof View)) {
            throw new ValidationException(updated, APIBundle.format((String)"COLUMN_ERROR_NEED_COLUMN", (Object[])new Object[]{updated.getName()}));
        }
        this.validateOwnedObjects((DBObject[])cols);
    }

    protected boolean enforceOneColumnExists(boolean creating) {
        return this.getProvider() instanceof Database;
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.SCHEMA;
    }
}

