/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.util.Collection;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.validators.AbstractIncrementerValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceValidator
extends SchemaObjectValidator<Sequence> {
    private final AbstractIncrementerValidator<Sequence> m_delegate;

    public SequenceValidator(DBObjectProvider prov) {
        super(prov);
        this.m_delegate = new AbstractIncrementerValidator(prov);
    }

    protected Collection<String> listAlwaysValidProperties() {
        return this.m_delegate.listAlwaysValidProperties();
    }

    @DBObjectValidator.PropertyValidator(value={"incrementBy"})
    @DBObjectValidator.PropertyDependency(value={"minValue", "maxValue"})
    public void validateIncrement(Sequence original, Sequence seq) throws ValidationException {
        this.m_delegate.validateIncrement(original, seq);
    }

    @DBObjectValidator.PropertyValidator(value={"startWith"})
    @DBObjectValidator.PropertyDependency(value={"minValue", "maxValue"})
    public void validateStartWith(Sequence original, Sequence seq) throws ValidationException {
        this.m_delegate.validateStartWith(original, seq);
    }

    @DBObjectValidator.PropertyValidator(value={"minValue"})
    @DBObjectValidator.PropertyDependency(value={"startWith", "maxValue"})
    public void validateMinValue(Sequence original, Sequence seq) throws ValidationException {
        this.m_delegate.validateMinValue(original, seq);
    }

    @DBObjectValidator.PropertyValidator(value={"maxValue"})
    @DBObjectValidator.PropertyDependency(value={"minValue", "startWith", "incrementBy", "cycleFlag"})
    public void validateMaxValue(Sequence original, Sequence seq) throws ValidationException {
        this.m_delegate.validateMaxValue(original, seq);
    }

    @DBObjectValidator.PropertyValidator(value={"cacheFlag", "cacheSize"})
    @DBObjectValidator.PropertyDependency(value={"minValue", "maxValue", "startWith", "incrementBy"})
    public void validateCache(Sequence original, Sequence seq) throws ValidationException {
        this.m_delegate.validateCache(original, seq);
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.SCHEMA;
    }
}

