/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;
import sun.awt.AppContext;
import sun.awt.dnd.SunDragSourceContextPeer;

public final class PlasticTreeUI
extends BasicTreeUI {
    private boolean linesEnabled = true;
    private PropertyChangeListener lineStyleHandler;
    private static boolean _sIsAtLeastJava16 = false;
    private static boolean _sIsAtLeastJava17 = false;
    private static DragRecognitionSupport _sDragSupport;
    private boolean _expansionCheck;
    private ValidateListener _vListener;

    public static ComponentUI createUI(JComponent b) {
        return new PlasticTreeUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.updateLineStyle(c.getClientProperty("JTree.lineStyle"));
        this.lineStyleHandler = new LineStyleHandler();
        c.addPropertyChangeListener(this.lineStyleHandler);
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.lineStyleHandler);
        super.uninstallUI(c);
    }

    @Override
    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
        if (this.linesEnabled) {
            this.drawDashedVerticalLine(g, x, top, bottom);
        }
    }

    @Override
    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
        if (this.linesEnabled) {
            this.drawDashedHorizontalLine(g, y, left, right);
        }
    }

    @Override
    protected void drawCentered(Component c, Graphics graphics, Icon icon, int x, int y) {
        icon.paintIcon(c, graphics, x - icon.getIconWidth() / 2 - 1, y - icon.getIconHeight() / 2);
    }

    private void updateLineStyle(Object lineStyle) {
        this.linesEnabled = !"None".equals(lineStyle);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (_sIsAtLeastJava16) {
            this.tree.addMouseListener(PlasticTreeUI._sGetDragSupportListener());
            this.tree.addMouseMotionListener(PlasticTreeUI._sGetDragSupportListener());
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (_sIsAtLeastJava16) {
            this.tree.removeMouseListener(PlasticTreeUI._sGetDragSupportListener());
            this.tree.removeMouseMotionListener(PlasticTreeUI._sGetDragSupportListener());
        }
    }

    @Override
    protected boolean startEditing(TreePath path, MouseEvent event) {
        if (_sIsAtLeastJava17) {
            ValidateListener vListener = this._getValidateListener();
            vListener.setTreePath(path);
            this.tree.addContainerListener(vListener);
        }
        boolean value = super.startEditing(path, event);
        if (_sIsAtLeastJava17) {
            ValidateListener vListener = this._getValidateListener();
            vListener.setTreePath(null);
            this.tree.removeContainerListener(vListener);
        }
        return value;
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    private ValidateListener _getValidateListener() {
        if (this._vListener == null) {
            this._vListener = new ValidateListener();
        }
        return this._vListener;
    }

    private static DragRecognitionSupport _sGetDragSupportListener() {
        if (_sDragSupport == null) {
            _sDragSupport = new DragRecognitionSupport();
        }
        return _sDragSupport;
    }

    static {
        String version = null;
        try {
            version = System.getProperty("java.version", "1.0");
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            version = "1.0";
        }
        _sIsAtLeastJava16 = !version.startsWith("1.0") && !version.startsWith("1.1") && !version.startsWith("1.2") && !version.startsWith("1.3") && !version.startsWith("1.4") && !version.startsWith("1.5");
        _sIsAtLeastJava17 = _sIsAtLeastJava16 && !version.startsWith("1.6");
    }

    private static class DragRecognitionSupport
    implements MouseListener,
    MouseMotionListener {
        private int motionThreshold;
        private MouseEvent dndArmedEvent;
        private JComponent component;

        private DragRecognitionSupport() {
        }

        public static DragRecognitionSupport getDragRecognitionSupport() {
            DragRecognitionSupport support = (DragRecognitionSupport)AppContext.getAppContext().get(DragRecognitionSupport.class);
            if (support == null) {
                support = new DragRecognitionSupport();
                AppContext.getAppContext().put(DragRecognitionSupport.class, support);
            }
            return support;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            DragRecognitionSupport.getDragRecognitionSupport().mousePressedImpl(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            DragRecognitionSupport.getDragRecognitionSupport().mouseReleasedImpl(e);
        }

        @Override
        public void mouseClicked(MouseEvent p1) {
        }

        @Override
        public void mouseEntered(MouseEvent p1) {
        }

        @Override
        public void mouseExited(MouseEvent p1) {
        }

        @Override
        public void mouseMoved(MouseEvent p1) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            DragRecognitionSupport.getDragRecognitionSupport().mouseDraggedImpl(e);
        }

        public JComponent getComponent(MouseEvent e) {
            Object src = e.getSource();
            if (src instanceof JComponent) {
                JComponent c = (JComponent)src;
                return c;
            }
            return null;
        }

        public void clearState() {
            this.dndArmedEvent = null;
            this.component = null;
        }

        public int mapDragOperationFromModifiers(MouseEvent me, TransferHandler th) {
            if (th == null || !SwingUtilities.isLeftMouseButton(me)) {
                return 0;
            }
            return SunDragSourceContextPeer.convertModifiersToDropAction(me.getModifiersEx(), th.getSourceActions(this.component));
        }

        public boolean isDragPossible(MouseEvent e) {
            TreeUI ui;
            TreePath path;
            JTree tree;
            boolean check;
            JComponent c = this.getComponent(e);
            boolean bl = c == null ? true : (check = c.getTransferHandler() != null);
            return check && (tree = (JTree)this.getComponent(e)).getDragEnabled() && (path = (ui = tree.getUI()).getClosestPathForLocation(tree, e.getX(), e.getY())) != null && tree.isPathSelected(path);
        }

        public void mousePressedImpl(MouseEvent me) {
            if (!this.isDragPossible(me)) {
                return;
            }
            this.component = (JComponent)me.getSource();
            if (this.mapDragOperationFromModifiers(me, this.component.getTransferHandler()) != 0) {
                this.motionThreshold = DragSource.getDragThreshold();
                this.dndArmedEvent = me;
            } else {
                this.clearState();
            }
        }

        public void mouseReleasedImpl(MouseEvent me) {
            this.clearState();
        }

        public void mouseDraggedImpl(MouseEvent me) {
            TransferHandler th;
            int action;
            if (this.dndArmedEvent == null) {
                return;
            }
            if (me.getSource() != this.component) {
                this.clearState();
                return;
            }
            int dx = Math.abs(me.getX() - this.dndArmedEvent.getX());
            int dy = Math.abs(me.getY() - this.dndArmedEvent.getY());
            if ((dx > this.motionThreshold || dy > this.motionThreshold) && (action = this.mapDragOperationFromModifiers(me, th = this.component.getTransferHandler())) != 0) {
                th.exportAsDrag(this.component, this.dndArmedEvent, action);
                this.clearState();
            }
        }
    }

    private final class MouseHandler
    extends MouseAdapter {
        private TreePath lastSelectedPath = null;

        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (PlasticTreeUI.this.tree != null && PlasticTreeUI.this.tree.isEnabled()) {
                PlasticTreeUI.this.tree.requestFocus();
                TreePath path = PlasticTreeUI.this.getClosestPathForLocation(PlasticTreeUI.this.tree, event.getX(), event.getY());
                if (path != null) {
                    Rectangle bounds = PlasticTreeUI.this.getPathBounds(PlasticTreeUI.this.tree, path);
                    if (event.getY() > bounds.y + bounds.height) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(event)) {
                        PlasticTreeUI.this.checkForClickInExpandControl(path, event.getX(), event.getY());
                    }
                    if (!PlasticTreeUI.this.startEditing(path, event) && !PlasticTreeUI.this.isLocationInExpandControl(path, event.getX(), event.getY())) {
                        if (PlasticTreeUI.this.tree.isPathSelected(path)) {
                            this.lastSelectedPath = path;
                            if (!Boolean.TRUE.equals(PlasticTreeUI.this.tree.getClientProperty("JTree.expandOnMouseRelease")) && SwingUtilities.isLeftMouseButton(event) && PlasticTreeUI.this.isToggleEvent(event)) {
                                PlasticTreeUI.this.toggleExpandState(path);
                                PlasticTreeUI.this._expansionCheck = true;
                            }
                        } else {
                            this.lastSelectedPath = null;
                            PlasticTreeUI.this.selectPathForEvent(path, event);
                        }
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            TreePath path;
            if (PlasticTreeUI.this.tree != null && PlasticTreeUI.this.tree.isEnabled() && (path = PlasticTreeUI.this.getClosestPathForLocation(PlasticTreeUI.this.tree, event.getX(), event.getY())) != null) {
                Rectangle bounds = PlasticTreeUI.this.getPathBounds(PlasticTreeUI.this.tree, path);
                if (event.getY() > bounds.y + bounds.height) {
                    return;
                }
                if (path.equals(this.lastSelectedPath) && !PlasticTreeUI.this._expansionCheck) {
                    PlasticTreeUI.this.selectPathForEvent(path, event);
                }
            }
            this.lastSelectedPath = null;
            PlasticTreeUI.this._expansionCheck = false;
        }
    }

    private class ValidateListener
    extends ContainerAdapter {
        private TreePath _path;

        private ValidateListener() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            if (this._path != null && PlasticTreeUI.this.editingComponent != null) {
                Rectangle nodeBounds = PlasticTreeUI.this.getPathBounds(PlasticTreeUI.this.tree, this._path);
                PlasticTreeUI.this.editingComponent.setBounds(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                PlasticTreeUI.this.editingComponent.validate();
            }
        }

        public void setTreePath(TreePath path) {
            this._path = path;
        }
    }

    private class LineStyleHandler
    implements PropertyChangeListener {
        private LineStyleHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            Object value = e.getNewValue();
            if (name.equals("JTree.lineStyle")) {
                PlasticTreeUI.this.updateLineStyle(value);
            }
        }
    }
}

