/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.WritableConnectionStore;

public final class PropertiesConnectionStore
implements WritableConnectionStore {
    private static final String DEFAULT_FILE = "connections.properties";
    private final String fName;
    private final boolean isAbsolutePath;

    public PropertiesConnectionStore() {
        this("/connections.properties", false);
    }

    public PropertiesConnectionStore(String fName, boolean isAbsolutePath) {
        this.fName = fName;
        this.isAbsolutePath = isAbsolutePath;
    }

    @Override
    public final void write(String outputFile, List descriptors, boolean stripPasswords) throws CMException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outputFile);
            Properties p = new Properties();
            Iterator iter = descriptors.iterator();
            int i = 0;
            while (iter.hasNext()) {
                ConnectionDescriptor desc = (ConnectionDescriptor)((ConnectionDescriptor)iter.next()).clone();
                if (stripPasswords && !desc.isDeployPassword()) {
                    desc.remove("password");
                }
                String flattened = this.flattenConnectionDescriptor(desc);
                p.put("CM_Connection" + ++i, flattened);
            }
            p.put("CM_NumConnections", new Integer(i).toString());
            p.put("CM_Version", "50");
            p.store(fos, "Oracle JDeveloper 5.0 Connection List");
            fos.close();
        }
        catch (FileNotFoundException fnfEx) {
            throw new CMException(fnfEx);
        }
        catch (IOException ioEx) {
            throw new CMException(ioEx);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List read() {
        List list;
        InputStream is = null;
        try {
            InputStream inputStream = is = this.isAbsolutePath ? new FileInputStream(this.fName) : ConnectionManager.getInputStream(this.getClass(), this.fName);
            if (null == is) {
                List list2 = null;
                return list2;
            }
            Properties p = new Properties();
            p.load(is);
            list = this.loadConnectionDescriptorsFromProperties(p);
        }
        catch (IOException ioEx) {
            List list3 = null;
            return list3;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return list;
    }

    private final List loadConnectionDescriptorsFromProperties(Properties p) throws IOException {
        ArrayList<ConnectionDescriptor> list = null;
        String numConn = p.getProperty("CM_NumConnections");
        if (null != numConn) {
            int numConnections = Integer.parseInt(numConn);
            list = new ArrayList<ConnectionDescriptor>(numConnections);
            for (int i = 1; i <= numConnections; ++i) {
                String pVal = p.getProperty("CM_Connection" + i);
                ByteArrayInputStream pStream = new ByteArrayInputStream(pVal.replace(',', '\n').getBytes());
                ConnectionDescriptor cDesc = new ConnectionDescriptor();
                cDesc.load(pStream);
                list.add(cDesc);
            }
        }
        return list;
    }

    private final String flattenConnectionDescriptor(ConnectionDescriptor cDesc) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            cDesc.store(os, null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        String str = os.toString();
        return str.substring(str.indexOf(10)).trim().replace('\n', ',');
    }
}

