/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.hypergraph.internal;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.hypergraph.edgeconnector.IlvHyperGrapherPin;

public class IlvGeometryUtil {
    public static int getSide(IlvRect ilvRect, IlvPoint ilvPoint) {
        float f;
        float f2;
        float f3;
        if (ilvPoint == null) {
            return 1;
        }
        if (ilvRect == null) {
            return 1;
        }
        float f4 = ilvRect.x - ilvPoint.x;
        if (f4 < 0.0f) {
            f4 = -f4;
        }
        if ((f3 = ilvRect.x + ilvRect.width - ilvPoint.x) < 0.0f) {
            f3 = -f3;
        }
        if ((f2 = ilvRect.y - ilvPoint.y) < 0.0f) {
            f2 = -f2;
        }
        if ((f = ilvRect.y + ilvRect.height - ilvPoint.y) < 0.0f) {
            f = -f;
        }
        if (ilvRect.inside(ilvPoint.x, ilvPoint.y)) {
            if (f4 < f3) {
                if (f2 < f) {
                    if (f4 < f2) {
                        return 1;
                    }
                    return 4;
                }
                if (f4 < f) {
                    return 1;
                }
                return 8;
            }
            if (f2 < f) {
                if (f3 < f2) {
                    return 2;
                }
                return 4;
            }
            if (f3 < f) {
                return 2;
            }
            return 8;
        }
        if (ilvRect.x <= ilvPoint.x && ilvPoint.x <= ilvRect.x + ilvRect.width) {
            if (ilvPoint.y < ilvRect.y + 0.5f * ilvRect.height) {
                return 4;
            }
            return 8;
        }
        if (ilvRect.y <= ilvPoint.y && ilvPoint.y <= ilvRect.y + ilvRect.height) {
            if (ilvPoint.x < ilvRect.x + 0.5f * ilvRect.width) {
                return 1;
            }
            return 2;
        }
        if (f4 < f3) {
            if (f2 < f) {
                if (f4 < f2) {
                    return 4;
                }
                return 1;
            }
            if (f4 < f) {
                return 8;
            }
            return 1;
        }
        if (f2 < f) {
            if (f3 < f2) {
                return 4;
            }
            return 2;
        }
        if (f3 < f) {
            return 8;
        }
        return 2;
    }

    public static IlvTransformer getTransformerFromTo(IlvGraphic ilvGraphic, IlvTransformer ilvTransformer, IlvGraphic ilvGraphic2) {
        IlvTransformer ilvTransformer2 = IlvGeometryUtil.getTransformerFromTo(ilvGraphic2, ilvGraphic);
        if (ilvTransformer2 == null) {
            ilvTransformer2 = ilvTransformer;
        } else if (ilvTransformer != null) {
            ilvTransformer2.compose(ilvTransformer);
        }
        return ilvTransformer2;
    }

    public static IlvTransformer getManagerTransformerFromTo(IlvManager ilvManager, IlvTransformer ilvTransformer, IlvManager ilvManager2) {
        IlvTransformer ilvTransformer2 = IlvGeometryUtil.getManagerTransformerFromTo(ilvManager2, ilvManager);
        if (ilvTransformer2 == null) {
            ilvTransformer2 = ilvTransformer;
        } else if (ilvTransformer != null) {
            ilvTransformer2.compose(ilvTransformer);
        }
        return ilvTransformer2;
    }

    public static IlvTransformer getTransformerFromTo(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2) {
        IlvManager ilvManager = (IlvManager)ilvGraphic.getGraphicBag();
        IlvManager ilvManager2 = (IlvManager)ilvGraphic2.getGraphicBag();
        return IlvGeometryUtil.getManagerTransformerFromTo(ilvManager, ilvManager2);
    }

    public static IlvTransformer getManagerTransformerFromTo(IlvManager ilvManager, IlvManager ilvManager2) {
        if (ilvManager == null || ilvManager2 == null || ilvManager == ilvManager2) {
            return null;
        }
        IlvTransformer ilvTransformer = ilvManager.getTopLevelTransformer();
        IlvTransformer ilvTransformer2 = ilvManager2.getTopLevelTransformer();
        IlvTransformer ilvTransformer3 = new IlvTransformer();
        ilvTransformer2.computeInverse(ilvTransformer3);
        ilvTransformer.compose(ilvTransformer3);
        return ilvTransformer;
    }

    public static boolean isEqualTransformer(IlvTransformer ilvTransformer, IlvTransformer ilvTransformer2) {
        if (ilvTransformer == ilvTransformer2) {
            return true;
        }
        if (ilvTransformer == null) {
            return ilvTransformer2.isIdentity();
        }
        if (ilvTransformer2 == null) {
            return ilvTransformer.isIdentity();
        }
        return ilvTransformer.equals((Object)ilvTransformer2);
    }

    public static void snapPinToNodeBorder(IlvHyperGrapherPin ilvHyperGrapherPin, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint3 = ilvHyperGrapherPin.getProportionalOffset();
        float f = IlvGeometryUtil.a(ilvPoint3, ilvPoint2);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.deltaApply(ilvPoint2);
        }
        float f2 = IlvGeometryUtil.a(ilvPoint3, ilvPoint2);
        IlvRect ilvRect = ilvHyperGrapherPin.getNodeBoundingBox(ilvTransformer);
        double d = ((double)(ilvPoint.x - ilvRect.x) - 0.5 * (double)ilvRect.width) / (0.5 * (double)ilvRect.width);
        double d2 = ((double)(ilvPoint.y - ilvRect.y) - 0.5 * (double)ilvRect.height) / (0.5 * (double)ilvRect.height);
        if (d * d > d2 * d2) {
            ilvPoint2.y = 0.0f;
            if (d > 0.0) {
                ilvPoint.x = ilvRect.x + ilvRect.width + f2;
                ilvPoint2.x = f;
            } else {
                ilvPoint.x = ilvRect.x - f2;
                ilvPoint2.x = -f;
            }
            ilvPoint.y = Math.max(ilvPoint.y, ilvRect.y - f2);
            ilvPoint.y = Math.min(ilvPoint.y, ilvRect.y + ilvRect.height + f2);
        } else {
            ilvPoint2.x = 0.0f;
            if (d2 > 0.0) {
                ilvPoint.y = ilvRect.y + ilvRect.height + f2;
                ilvPoint2.y = f;
            } else {
                ilvPoint.y = ilvRect.y - f2;
                ilvPoint2.y = -f;
            }
            ilvPoint.x = Math.max(ilvPoint.x, ilvRect.x - f2);
            ilvPoint.x = Math.min(ilvPoint.x, ilvRect.x + ilvRect.width + f2);
        }
    }

    private static float a(IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        float f;
        double d = (double)ilvPoint.x - 0.5;
        double d2 = (double)ilvPoint.y - 0.5;
        float f2 = ilvPoint2.x >= 0.0f ? ilvPoint2.x : -ilvPoint2.x;
        float f3 = f = ilvPoint2.y >= 0.0f ? ilvPoint2.y : -ilvPoint2.y;
        if (f2 > f) {
            if (d > 0.0) {
                return ilvPoint2.x;
            }
            return -ilvPoint2.x;
        }
        if (d2 > 0.0) {
            return ilvPoint2.y;
        }
        return -ilvPoint2.y;
    }

    public static double getDistance(IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        double d = ilvPoint.x - ilvPoint2.x;
        double d2 = ilvPoint.y - ilvPoint2.y;
        return Math.sqrt(d * d + d2 * d2);
    }
}

