/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.graphic;

import ilog.views.IlvDrawSelection;
import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.graphic.IlvLine;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.sdm.graphic.IlvGeneralNode;
import java.io.IOException;

public class IlvDefaultLaneGraphic
extends IlvGeneralNode {
    private IlvLine a;
    private boolean b;
    private boolean c;

    public IlvDefaultLaneGraphic() {
        this.setLabelPosition(16);
        this.setLabelMode(2);
    }

    public IlvDefaultLaneGraphic(IlvDefaultLaneGraphic ilvDefaultLaneGraphic) {
        super(ilvDefaultLaneGraphic);
        this.b = ilvDefaultLaneGraphic.b;
        this.c = ilvDefaultLaneGraphic.c;
    }

    public IlvDefaultLaneGraphic(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.b = ilvInputStream.readBoolean("horizontal");
        this.c = ilvInputStream.readBoolean("separator");
    }

    public IlvGraphic copy() {
        return new IlvDefaultLaneGraphic(this);
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("horizontal", this.b);
        ilvOutputStream.write("separator", this.c);
    }

    public boolean isHorizontal() {
        return this.b;
    }

    public void setHorizontal(boolean bl) {
        if (bl != this.b) {
            this.b = bl;
            this.layoutNeeded = true;
        }
    }

    public boolean isSeparatorVisible() {
        return this.c;
    }

    public void setSeparatorVisible(boolean bl) {
        if (bl != this.c) {
            this.c = bl;
            this.realizeNeeded = true;
        }
    }

    protected void realize() {
        super.realize();
        if (this.c) {
            this.a = new IlvLine(0.0f, 0.0f, 0.0f, 0.0f);
            this.a.setForeground(this.getStrokeColor());
            this.addObject((IlvGraphic)this.a, false);
        } else {
            this.a = null;
        }
    }

    protected void doLayout() {
        super.doLayout();
        IlvRect ilvRect = this.getLabelBBox(null);
        IlvRect ilvRect2 = this.getShapeBBox();
        IlvPoint ilvPoint = new IlvPoint(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height / 2.0f);
        float f = this.getLabelSpacing();
        if (this.isHorizontal()) {
            for (int i = 0; i < this.labels.length; ++i) {
                IlvGraphic ilvGraphic = this.labels[i];
                ilvGraphic.rotate(ilvPoint, -90.0);
            }
            if (this.getLabelPosition() == 16) {
                this.moveLabel(ilvRect2.x + f, ilvRect2.y + ilvRect2.height / 2.0f - ilvRect.width / 2.0f, null);
                if (this.a != null) {
                    this.a.setFrom(new IlvPoint(ilvRect2.x + ilvRect.height + 2.0f * f, ilvRect2.y));
                    this.a.setTo(new IlvPoint(ilvRect2.x + ilvRect.height + 2.0f * f, ilvRect2.y + ilvRect2.height));
                }
            } else {
                this.moveLabel(ilvRect2.x - ilvRect.height - f, ilvRect2.y + ilvRect2.height / 2.0f - ilvRect.width / 2.0f, null);
            }
        } else if (this.getLabelPosition() == 16) {
            this.moveLabel(ilvRect2.x + ilvRect2.width / 2.0f - ilvRect.width / 2.0f, ilvRect2.y + f, null);
            if (this.a != null) {
                this.a.setFrom(new IlvPoint(ilvRect2.x, ilvRect2.y + ilvRect.height + 2.0f * f));
                this.a.setTo(new IlvPoint(ilvRect2.x + ilvRect2.width, ilvRect2.y + ilvRect.height + 2.0f * f));
            }
        } else {
            this.moveLabel(ilvRect2.x + ilvRect2.width / 2.0f - ilvRect.width / 2.0f, ilvRect2.y - ilvRect2.height - f, null);
        }
    }

    public IlvSelection makeSelection() {
        LaneSelection laneSelection = new LaneSelection((IlvGraphic)this);
        return laneSelection;
    }

    float a() {
        if (this.isHorizontal()) {
            return this.getShapeHeight();
        }
        return super.a();
    }

    private static class LaneSelection
    extends IlvDrawSelection {
        public LaneSelection(IlvGraphic ilvGraphic) {
            super(ilvGraphic);
        }

        public String getDefaultInteractor() {
            return "ilog.views.sdm.renderer.IlvLaneRenderer$ResizeLaneSelection";
        }
    }
}

