/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.renderer.graphlayout;

import ilog.views.IlvGraphic;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.circular.IlvCircularLayout;
import ilog.views.graphlayout.circular.IlvClusterId;
import ilog.views.graphlayout.circular.IlvClusterName;
import ilog.views.prototypes.IlvValueConverter;
import ilog.views.prototypes.IlvValueFilter;
import ilog.views.sdm.renderer.graphlayout.IlvGraphLayoutParameters;
import ilog.views.sdm.renderer.graphlayout.IlvGraphLayoutRenderer;

class IlvCircularLayoutParameters
extends IlvGraphLayoutParameters {
    private static final String a = "sdm.circular.rootClusterIds".intern();

    IlvCircularLayoutParameters() {
    }

    void d(IlvGraphLayout ilvGraphLayout) {
        IlvCircularLayout ilvCircularLayout = (IlvCircularLayout)ilvGraphLayout;
        IlvClusterId[] ilvClusterIdArray = (IlvClusterId[])ilvCircularLayout.getProperty(a);
        if (ilvClusterIdArray != null) {
            ilvCircularLayout.setRootClusterIds(ilvClusterIdArray);
        }
        ilvCircularLayout.setProperty(a, null);
    }

    void c(IlvGraphLayout ilvGraphLayout) {
        IlvCircularLayout ilvCircularLayout = (IlvCircularLayout)ilvGraphLayout;
        IlvClusterId[] ilvClusterIdArray = ilvCircularLayout.getRootClusterIds();
        ilvCircularLayout.setProperty(a, ilvClusterIdArray);
    }

    static {
        IlvValueConverter.registerFilter((IlvValueFilter)new StringToClusterIdFilter());
        IlvGraphLayoutRenderer.addParameterSetter(new LayoutClusterSetter());
        IlvGraphLayoutRenderer.addParameterSetter(new LayoutStarCenterSetter());
        IlvGraphLayoutRenderer.addParameterSetter(new ClusterIdSetter());
    }

    private static class LayoutStarCenterSetter
    extends IlvGraphLayoutRenderer.ParameterSetter {
        LayoutStarCenterSetter() {
            Class[] classArray = new Class[2];
            classArray[0] = IlvGraphic.class;
            classArray[1] = Boolean.class;
            super("LayoutStarCenter", classArray, IlvCircularLayout.class);
        }

        public void set(Object object, Object[] objectArray) throws Exception {
            IlvCircularLayout ilvCircularLayout = (IlvCircularLayout)object;
            Object object2 = objectArray[0];
            boolean bl = (Boolean)objectArray[1];
            ilvCircularLayout.setStarCenter(object2, bl);
        }

        public String toString() {
            return "call setStarCenter directly";
        }
    }

    private static class ClusterIdSetter
    extends IlvGraphLayoutRenderer.ParameterSetter {
        ClusterIdSetter() {
            Class[] classArray = new Class[3];
            classArray[0] = IlvGraphic.class;
            classArray[1] = IlvClusterId.class;
            classArray[2] = Integer.class;
            super("ClusterId", classArray, IlvCircularLayout.class);
        }

        public void beforeSet(Object object, Object object2) {
            IlvCircularLayout ilvCircularLayout = (IlvCircularLayout)object;
            ilvCircularLayout.removeAllClusterIds(object2);
        }

        public void set(Object object, Object[] objectArray) throws Exception {
            IlvCircularLayout ilvCircularLayout = (IlvCircularLayout)object;
            Object object2 = objectArray[0];
            IlvClusterId ilvClusterId = (IlvClusterId)objectArray[1];
            if (objectArray[2] != null) {
                int n = (Integer)objectArray[2];
                ilvCircularLayout.addClusterId(object2, ilvClusterId, n);
            } else {
                ilvCircularLayout.addClusterId(object2, ilvClusterId);
            }
        }

        public String toString() {
            return "call addClusterId";
        }
    }

    private static class LayoutClusterSetter
    extends IlvGraphLayoutRenderer.ParameterSetter {
        LayoutClusterSetter() {
            Class[] classArray = new Class[2];
            classArray[0] = IlvGraphic.class;
            classArray[1] = IlvClusterId.class;
            super("LayoutCluster", classArray, IlvCircularLayout.class);
        }

        public void set(Object object, Object[] objectArray) throws Exception {
            IlvCircularLayout ilvCircularLayout = (IlvCircularLayout)object;
            Object object2 = objectArray[0];
            IlvClusterId ilvClusterId = (IlvClusterId)objectArray[1];
            ilvCircularLayout.setClusterId(object2, ilvClusterId);
        }

        public String toString() {
            return "call setClusterId directly";
        }
    }

    private static class StringToClusterIdFilter
    implements IlvValueFilter {
        private StringToClusterIdFilter() {
        }

        public Class[] fromTypes() {
            Class[] classArray = new Class[1];
            classArray[0] = String.class;
            return classArray;
        }

        public Class[] toTypes() {
            Class[] classArray = new Class[1];
            classArray[0] = IlvClusterId.class;
            return classArray;
        }

        public Object convert(Object object, Class clazz) {
            return new IlvClusterName((String)object);
        }
    }
}

