/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.util.ArrayList;
import oracle.dss.dataView.BasePayloadHelper;
import oracle.dss.dataView.DataUpdateCache;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.Utility;

public class DataHintEncoder {
    protected BasePayloadHelper m_payloadHelper;
    private ErrorHandler m_eh;
    private static final String ELEM_PPR = "ppr";
    public static final String ELEM_PPR_REPAINT = "<animate/>";
    public static final String ELEM_PPR_HINT = "<ppr/>";
    private static final String ELEM_NO_CHANGES = "";

    public DataHintEncoder(ErrorHandler eh) {
        this.m_eh = eh;
    }

    public boolean isUpdatesOnly() {
        return this.m_payloadHelper.isUpdatesOnly();
    }

    public String calcDataUpdateHint(DataUpdateCache daCache, DataAccess da2) {
        this.m_payloadHelper = new BasePayloadHelper();
        if (daCache == null || da2 == null) {
            return null;
        }
        try {
            ArrayList<Pair> rowPairs = this._calcInsertsAndDeletes(1, daCache, da2);
            ArrayList<Pair> colPairs = this._calcInsertsAndDeletes(0, daCache, da2);
            int rowSlices1 = daCache.getRowIds().size();
            int rowSlices2 = da2.getEdgeExtent(1);
            int colSlices1 = daCache.getColumnIds().size();
            int colSlices2 = da2.getEdgeExtent(0);
            int rowSlices = Math.max(rowSlices1, rowSlices2);
            int colSlices = Math.max(colSlices1, colSlices2);
            if (rowPairs.size() < 1 || colPairs.size() < 1) {
                return ELEM_PPR_REPAINT;
            }
            this._calcDataValueUpdates(daCache, da2, rowPairs, colPairs);
        }
        catch (Throwable t) {
            this.m_eh.trace(t.getLocalizedMessage(), DataHintEncoder.class.toString(), "calcDataUpdateHint");
            return ELEM_PPR_REPAINT;
        }
        if (this.m_payloadHelper.hasChanges()) {
            return this.m_payloadHelper.getPayloadString(ELEM_PPR);
        }
        return ELEM_NO_CHANGES;
    }

    private ArrayList<Pair> _calcInsertsAndDeletes(int edge, DataUpdateCache daCache, DataAccess da2) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        ArrayList<Pair> edgePairs = new ArrayList<Pair>();
        ArrayList edgeSlices = edge == 1 ? daCache.getRowIds() : daCache.getColumnIds();
        if (edgeSlices == null) {
            return edgePairs;
        }
        int edgeExtent1 = edgeSlices.size();
        int edgeExtent2 = da2.getEdgeExtent(edge);
        int doneA = -1;
        int doneB = -1;
        int currA = 0;
        int currB = 0;
        while (doneA < edgeExtent1 - 1 || doneB < edgeExtent2 - 1) {
            Object oldMember;
            Object newMember;
            if (currA >= edgeExtent1) {
                newMember = da2.getSliceLabel(edge, currB, "value");
                this._addInserts(edge, (String)newMember, da2);
                doneB = currB++;
                continue;
            }
            if (currB >= edgeExtent2) {
                oldMember = edgeSlices.get(currA);
                this._addDeletes(edge, (String)oldMember, daCache);
                ++doneA;
                ++currA;
                currB = doneB + 1;
                continue;
            }
            oldMember = edgeSlices.get(currA);
            if (!oldMember.equals(newMember = da2.getSliceLabel(edge, currB, "value"))) {
                ++currB;
                continue;
            }
            edgePairs.add(new Pair(currA, currB));
            for (int i = doneB + 1; i < currB; ++i) {
                newMember = da2.getSliceLabel(edge, i, "value");
                this._addInserts(edge, (String)newMember, da2);
            }
            doneA = currA;
            doneB = currB;
            currA = doneA + 1;
            currB = doneB + 1;
        }
        return edgePairs;
    }

    private void _calcDataValueUpdates(DataUpdateCache daCache, DataAccess da2, ArrayList<Pair> rowPairs, ArrayList<Pair> colPairs) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, RowOutOfRangeException, ColumnOutOfRangeException {
        ArrayList rowMembers = daCache.getRowIds();
        ArrayList colMembers = daCache.getColumnIds();
        Object[][] data = daCache.getDataValues();
        if (rowMembers == null || colMembers == null || data == null) {
            return;
        }
        for (Pair row : rowPairs) {
            for (Pair col : colPairs) {
                String rowLabel = (String)rowMembers.get(row.first);
                String colLabel = (String)colMembers.get(col.first);
                Object oldValue = data[row.first][col.first];
                Object newValue = da2.getValue(row.second, col.second, "dataValue");
                if (oldValue == null && newValue != null) {
                    this.m_payloadHelper.addInsert(rowLabel, colLabel);
                    continue;
                }
                if (oldValue != null && newValue == null) {
                    this.m_payloadHelper.addDelete(rowLabel, colLabel);
                    continue;
                }
                int comparison = Utility.compareAsNumbers((Object)newValue, (Object)oldValue);
                if (comparison == 0) continue;
                boolean increase = comparison > 0;
                this.m_payloadHelper.addUpdate(rowLabel, colLabel, increase, newValue.toString());
            }
        }
    }

    private void _addInserts(int edge, String newMember, DataAccess da2) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        int otherEdge = edge == 1 ? 0 : 1;
        int edgeExtent = da2.getEdgeExtent(otherEdge);
        for (int i = 0; i < edgeExtent; ++i) {
            String otherMember = (String)da2.getSliceLabel(otherEdge, i, "value");
            if (edge == 1) {
                this.m_payloadHelper.addInsert(newMember, otherMember);
                continue;
            }
            this.m_payloadHelper.addInsert(otherMember, newMember);
        }
    }

    private void _addDeletes(int edge, String oldMember, DataUpdateCache daCache) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        ArrayList edgeMembers = edge == 1 ? daCache.getColumnIds() : daCache.getRowIds();
        int edgeExtent = edgeMembers.size();
        for (int i = 0; i < edgeExtent; ++i) {
            String otherMember = (String)edgeMembers.get(i);
            if (edge == 1) {
                this.m_payloadHelper.addDelete(oldMember, otherMember);
                continue;
            }
            this.m_payloadHelper.addDelete(otherMember, oldMember);
        }
    }

    class Pair {
        int first;
        int second;

        Pair(int a, int b) {
            this.first = a;
            this.second = b;
        }

        void setValue(int a, int b) {
            this.first = a;
            this.second = b;
        }
    }
}

