/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.XMLWriterCallback;
import oracle.dss.presutil.GradientObj;
import oracle.dss.presutil.GradientStopObj;
import oracle.dss.presutil.PresUtils;
import oracle.dss.presutil.XMLWriter;
import oracle.dss.util.ErrorHandler;

public class ImageViewExportXMLWriter
extends XMLWriter {
    public static final String ELEM_CIRCLE = "c";
    public static final String ELEM_CLIP_PATH = "clipPath";
    public static final String ELEM_DATA_BLOCK = "data";
    public static final String ELEM_FONT = "f";
    public static final String ELEM_GRAD = "g";
    public static final String ELEM_HANDLE = "h";
    public static final String ELEM_IMAGE = "img";
    public static final String ELEM_LINE = "l";
    public static final String ELEM_LINEGRAD = "lg";
    public static final String ELEM_LINE_MARKER = "lm";
    public static final String ELEM_METADATA = "md";
    public static final String ELEM_MENU = "me";
    public static final String ELEM_MENU_ITEM = "mi";
    public static final String ELEM_OVAL = "o";
    public static final String ELEM_PATH = "p";
    public static final String ELEM_POLYGON = "pg";
    public static final String ELEM_POLYLINE = "pl";
    public static final String ELEM_RECT = "r";
    public static final String ELEM_ROOT = "root";
    public static final String ELEM_SHAPE_ATTRIBUTES = "sa";
    public static final String ELEM_STOP = "s";
    public static final String ELEM_PIE_SLICE = "sl";
    public static final String ELEM_PIE_SLICE_LABEL = "psl";
    public static final String ELEM_TEXT = "t";
    public static final String ELEM_TOOLTIP_FORMAT = "ttf";
    public static final String ELEM_DATATIP_FORMAT = "dtf";
    public static final String ATTR_ADS = "ads";
    public static final String ATTR_ALT = "alt";
    public static final String ATTR_ANGLE = "a";
    public static final String ATTR_ANG = "ang";
    public static final String ATTR_ANIMATION_DOWN_COLOR = "aD";
    public static final String ATTR_ANIMATION_DURATION = "aDu";
    public static final String ATTR_ANIMATION_INDICATORS = "aI";
    public static final String ATTR_ANIMATION_UP_COLOR = "aU";
    public static final String ATTR_ANIMATION_ON_DATA_CHANGE = "aDC";
    public static final String ATTR_ANIMATION_ON_DISPLAY = "aDi";
    public static final String ATTR_ATTACHMENT_MODE = "att";
    public static final String ATTR_BC = "bc";
    public static final String ATTR_BEVEL = "bv";
    public static final String ATTR_BOUNDING_BOX = "b";
    public static final String ATTR_BW = "bw";
    public static final String ATTR_CLICK_ACTION = "clickAction";
    public static final String ATTR_CLICK_EVENT_JS = "Ce";
    public static final String ATTR_CLICK_LISTENER = "clickListener";
    public static final String ATTR_CLICKABLE = "clickable";
    public static final String ATTR_CLIP = "clip";
    public static final String ATTR_CLOSURE_TYPE = "ct";
    public static final String ATTR_COLOR = "c";
    public static final String ATTR_CX = "cx";
    public static final String ATTR_CY = "cy";
    public static final String ATTR_D = "d";
    public static final String ATTR_DRAG = "drag";
    public static final String ATTR_DIR = "dir";
    public static final String ATTR_DRILL_JS = "drillJs";
    public static final String ATTR_FULL_TEXT = "ut";
    public static final String ATTR_FC = "fc";
    public static final String ATTR_FP = "fp";
    public static final String ATTR_FT = "ft";
    public static final String ATTR_METADATA_FONT = "f";
    public static final String ATTR_FONT = "font";
    private static final String ATTR_FONT_INDEX = "fid";
    private static final String ATTR_FONT_MAP = "fontMap";
    private static final String ATTR_LOCALE_CJK = "cjk";
    private static final String ATTR_BIDI = "bidi";
    public static final String ATTR_G_ID = "G";
    public static final String ATTR_GLOW = "gl";
    public static final String ATTR_G_ID_LIST = "groups";
    public static final String ATTR_H = "h";
    public static final String ATTR_HIDE_SHOW_SERIES_USE_NEW_BEHAVIOR = "hsnb";
    public static final String ATTR_HREF = "href";
    public static final String ATTR_ID = "id";
    public static final String ATTR_JUSTIFICATION = "j";
    public static final String ATTR_LS = "ls";
    public static final String ATTR_LW = "lw";
    public static final String ATTR_LINK = "link";
    protected static final String ATTR_LINK_TEXT_COLOR = "linkColor";
    public static final String ATTR_M_ID = "M";
    public static final String ATTR_MOUSE_TRANSPARENT = "go";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_NOHREF = "nohref";
    public static final String ATTR_OBJECT_ID = "O";
    public static final String ATTR_ON_BLUR = "onBlur";
    public static final String ATTR_ON_CLICK = "onClick";
    public static final String ATTR_ON_DBL_CLICK = "onDblClick";
    public static final String ATTR_ON_FOCUS = "onFocus";
    public static final String ATTR_ON_KEY_DOWN = "onKeyDown";
    public static final String ATTR_ON_KEY_PRESS = "onKeyPress";
    public static final String ATTR_ON_KEY_UP = "onKeyUp";
    public static final String ATTR_ON_MOUSE_DOWN = "onMouseDown";
    public static final String ATTR_ON_MOUSE_MOVE = "onMouseMove";
    public static final String ATTR_ON_MOUSE_OUT = "onMouseOut";
    public static final String ATTR_ON_MOUSE_OVER = "onMouseOver";
    public static final String ATTR_ON_MOUSE_UP = "onMouseUp";
    public static final String ATTR_ON_SELECT = "selJS";
    public static final String ATTR_P = "p";
    public static final String ATTR_GRADIENT_DIR_POINTS = "pts";
    public static final String ATTR_POINTS = "points";
    public static final String ATTR_POSITION = "p";
    public static final String ATTR_R = "r";
    public static final String ATTR_RX = "rx";
    public static final String ATTR_RY = "ry";
    public static final String ATTR_S_ID = "S";
    public static final String ATTR_S_ID_LIST = "series";
    public static final String ATTR_SHADOW = "sh";
    public static final String ATTR_ST_ID = "stId";
    public static final String ATTR_TABINDEX = "tabindex";
    public static final String ATTR_TARGET = "target";
    public static final String ATTR_TEXTURE_DISPLAY_MODE = "TDM";
    public static final String ATTR_TEXTURE_URL = "tURL";
    public static final String ATTR_TITLE = "title";
    public static final String ATTR_TOOLTIP = "t";
    public static final String ATTR_USE_TOOLTIP_TEMPLATE = "tt";
    public static final String ATTR_URL = "url";
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_VISIBILITY = "v";
    public static final String ATTR_W = "w";
    public static final String ATTR_X = "x";
    public static final String ATTR_X1 = "x1";
    public static final String ATTR_X2 = "x2";
    public static final String ATTR_Y = "y";
    public static final String ATTR_Y1 = "y1";
    public static final String ATTR_Y2 = "y2";
    public static final String ATTR_CUSTOM_PROPERTY = "Z";
    public static final String VAL_TRUE = "t";
    public static final String VAL_FALSE = "f";
    public static final String VAL_ANIMATION_ON_DISPLAY_AUTO = "AUTO";
    public static final String VAL_ADS_ON = "on";
    public static final String VAL_FT_COLOR = "ftC";
    public static final String VAL_FT_GRADIENT = "ftG";
    public static final String VAL_FT_TEXTURE = "ftT";
    public static final String VAL_FT_PATTERN = "ftP";
    public static final String VAL_GD_RADIAL = "gdR";
    public static final String VAL_GD_RIGHT = "gdRi";
    public static final String VAL_GD_DOWN = "gdD";
    public static final String VAL_GD_DIAGONAL_45 = "gdD45";
    public static final String VAL_GD_DIAGONAL_135 = "gdD135";
    public static final String VAL_GD_CUSTOM = "gdC";
    public static final String VAL_HIDDEN = "h";
    public static final String VAL_NONE = "";
    public static final String VAL_DRAG_BOUNDED = "bounded";
    public static final String VAL_JUSTIFICATION_LEFT = "l";
    public static final String VAL_JUSTIFICATION_RIGHT = "r";
    public static final String VAL_JUSTIFICATION_CENTER = "c";
    public static final Color DEFAULT_SHADOW_COLOR = new Color(51, 51, 51, 89);
    public static final double DEFAULT_SHADOW_DISTANCE = 4.0;
    public static final double DEFAULT_SHADOW_STRENGTH = 1.0;
    public static final double DEFAULT_SHADOW_ANGLE = 45.0;
    public static final double DEFAULT_SHADOW_BLURX = 4.0;
    public static final double DEFAULT_SHADOW_BLURY = 4.0;
    public static final int DEFAULT_SHADOW_QUALITY = 1;
    public static final int DEFAULT_SHADOW_INNER = 0;
    public static final int DEFAULT_SHADOW_KNOCKOUT = 0;
    public static final int DEFAULT_SHADOW_HIDE = 0;
    public static final Color DEFAULT_BEVEL_HIGHLIGHT_COLOR = new Color(255, 255, 255, 255);
    public static final Color DEFAULT_BEVEL_SHADOW_COLOR = new Color(0, 0, 0, 255);
    public static final double DEFAULT_BEVEL_DISTANCE = 4.0;
    public static final double DEFAULT_BEVEL_STRENGTH = 1.0;
    public static final double DEFAULT_BEVEL_ANGLE = 45.0;
    public static final double DEFAULT_BEVEL_BLURX = 4.0;
    public static final double DEFAULT_BEVEL_BLURY = 4.0;
    public static final int DEFAULT_BEVEL_QUALITY = 1;
    public static final String DEFAULT_BEVEL_TYPE = "i";
    public static final Color DEFAULT_GLOW_HIGHLIGHT_COLOR = new Color(0, 0, 0, 255);
    public static final double DEFAULT_GLOW_STRENGTH = 2.0;
    public static final double DEFAULT_GLOW_BLURX = 6.0;
    public static final double DEFAULT_GLOW_BLURY = 6.0;
    public static final int DEFAULT_GLOW_QUALITY = 1;
    public static final int DEFAULT_GLOW_INNER = 0;
    public static final int DEFAULT_GLOW_KNOCKOUT = 0;
    private XMLWriterCallback m_xmlCallback;
    private boolean m_bOldAutomaticNewlines = true;
    private boolean m_bUseDataIds = false;
    protected List<String> m_fontIndex;
    private int m_currFontIndex = -1;
    private Map<String, String> m_cachedMap = new HashMap<String, String>();
    private static ConcurrentHashMap<Font, FontMetrics> fontMetricsMap = new ConcurrentHashMap();

    public ImageViewExportXMLWriter(OutputStream os, ErrorHandler eh, String charEnc) {
        super(os, eh, charEnc);
        this.m_fontIndex = new ArrayList<String>();
    }

    public ImageViewExportXMLWriter(OutputStream os, ErrorHandler eh) {
        this(os, eh, null);
    }

    public ImageViewExportXMLWriter(Writer writer, ErrorHandler eh, String charEnc) {
        super(writer, eh, charEnc);
        this.m_fontIndex = new ArrayList<String>();
    }

    public ImageViewExportXMLWriter(Writer writer, ErrorHandler eh) {
        this(writer, eh, null);
    }

    protected void initXMLWriterCallback(XMLWriterCallback callback) {
        this.m_xmlCallback = callback;
        if (this.m_xmlCallback != null) {
            this.setAutomaticNewlines(this.m_xmlCallback.isAutomaticNewLines());
        }
    }

    public boolean startRootElement() throws IOException, Exception {
        boolean isBidi;
        Locale loc;
        this.startElement(ELEM_ROOT);
        this.writeAttribute(ATTR_VERSION, "1.0");
        String fontMap = this.getFontMap();
        if (fontMap != null && fontMap.length() > 0) {
            this.writeAttribute(ATTR_FONT_MAP, fontMap);
        }
        if ((loc = this.getLocale()) != null && (loc.getLanguage().equals("zh") || loc.getLanguage().equals("ja") || loc.getLanguage().equals("ko"))) {
            this.writeAttribute(ATTR_LOCALE_CJK, "t");
        }
        if (isBidi = this.isBIDILocale()) {
            this.writeAttribute(ATTR_BIDI, "t");
        }
        return true;
    }

    public void endRootElement() throws IOException, Exception {
        this.endElement();
    }

    protected Locale getLocale() {
        return null;
    }

    public boolean startCircleElement(double cx, double cy, double r) throws IOException, Exception {
        this.startElement("c");
        StringBuilder sb = DataviewUtils.getSharedStringBuilder();
        sb.append(this._roundDouble(cx)).append(',');
        sb.append(this._roundDouble(cy)).append(',');
        sb.append(this._roundDouble(r));
        this.writeAttribute("p", sb.toString());
        return true;
    }

    public boolean startCircleOrOvalElement(Rectangle rect) throws IOException, Exception {
        int rx = rect.width / 2;
        int ry = rect.height / 2;
        int cx = rect.x + rx;
        int cy = rect.y + ry;
        if (rx == ry) {
            return this.startCircleElement(cx, cy, rx);
        }
        return this.startOvalElement(cx, cy, rx, ry);
    }

    public boolean startCircleOrOvalElement(Arc2D arc) throws IOException, Exception {
        double angleExtent;
        double rx = arc.getWidth() / 2.0;
        double ry = arc.getHeight() / 2.0;
        double cx = arc.getX() + rx;
        double cy = arc.getY() + ry;
        boolean ret = false;
        ret = rx == ry ? this.startCircleElement(cx, cy, rx) : this.startOvalElement(cx, cy, rx, ry);
        if (ret && (angleExtent = arc.getAngleExtent()) < 360.0) {
            StringBuffer s = new StringBuffer().append(arc.getAngleStart()).append(',').append(angleExtent);
            this.writeAttribute(ATTR_ANG, s.toString());
            String sArcType = ImageViewExportXMLWriter.convertArcTypeToString(arc.getArcType());
            if (sArcType != null && !sArcType.equals("PIE")) {
                this.writeAttribute(ATTR_CLOSURE_TYPE, sArcType);
            }
        }
        return ret;
    }

    public boolean startLineElement(int x1, int y1, int x2, int y2) throws IOException, Exception {
        this.startElement("l");
        StringBuffer s = new StringBuffer().append(x1).append(',').append(y1).append(',').append(x2).append(',').append(y2);
        this.writeAttribute("p", s.toString());
        return true;
    }

    public boolean startLineElement(double x1, double y1, double x2, double y2) throws IOException, Exception {
        this.startElement("l");
        StringBuffer s = new StringBuffer().append(x1).append(',').append(y1).append(',').append(x2).append(',').append(y2);
        this.writeAttribute("p", s.toString());
        return true;
    }

    public boolean startOvalElement(double cx, double cy, double rx, double ry) throws IOException, Exception {
        this.startElement(ELEM_OVAL);
        StringBuilder sb = DataviewUtils.getSharedStringBuilder();
        sb.append(this._roundDouble(cx)).append(',');
        sb.append(this._roundDouble(cy)).append(',');
        sb.append(this._roundDouble(rx)).append(',');
        sb.append(this._roundDouble(ry));
        this.writeAttribute("p", sb.toString());
        return true;
    }

    public boolean startOvalElement(Rectangle rect) throws IOException, Exception {
        int rx = rect.width / 2;
        int ry = rect.height / 2;
        int cx = rect.x + rx;
        int cy = rect.y + ry;
        return this.startOvalElement(cx, cy, rx, ry);
    }

    public boolean startPathElement(Shape shape) throws IOException, Exception {
        boolean ret = false;
        if (shape != null) {
            String pathString = this.convertShapeToPath(shape);
            if (pathString != null && pathString.length() > 0) {
                this.startElement("p");
                this.writeAttribute(ATTR_D, pathString);
                ret = true;
            }
        } else if (this.m_eh != null) {
            this.m_eh.log("null Shape", this.getClass().getName(), "public boolean startPathElement(Shape shape)");
        }
        return ret;
    }

    @Override
    protected String convertShapeToPath(Shape shape) {
        if (shape != null) {
            PathIterator pi = shape.getPathIterator(null);
            if (pi != null) {
                StringBuilder sb = new StringBuilder();
                double prevX = -1.0;
                double prevY = -1.0;
                double x = -1.0;
                double y = -1.0;
                while (!pi.isDone()) {
                    double[] coords = new double[6];
                    int type = pi.currentSegment(coords);
                    switch (type) {
                        case 0: {
                            x = this._roundDouble(coords[0]);
                            y = this._roundDouble(coords[1]);
                            if (prevX == x && prevY == y) break;
                            sb.append('M');
                            sb.append(x);
                            sb.append(',');
                            sb.append(y);
                            break;
                        }
                        case 1: {
                            x = this._roundDouble(coords[0]);
                            y = this._roundDouble(coords[1]);
                            if (prevX == x && prevY == y) break;
                            sb.append('L');
                            sb.append(x);
                            sb.append(',');
                            sb.append(y);
                            break;
                        }
                        case 2: {
                            double x1 = this._roundDouble(coords[0]);
                            double y1 = this._roundDouble(coords[1]);
                            x = this._roundDouble(coords[2]);
                            y = this._roundDouble(coords[3]);
                            if (prevX == x && prevY == y) break;
                            sb.append('Q');
                            if (x1 == prevX) {
                                x1 += 0.001;
                            } else if (y1 == prevY) {
                                y1 += 0.001;
                            }
                            sb.append(x1);
                            sb.append(',');
                            sb.append(y1);
                            sb.append(',');
                            sb.append(x);
                            sb.append(',');
                            sb.append(y);
                            break;
                        }
                        case 3: {
                            double x1 = this._roundDouble(coords[0]);
                            double y1 = this._roundDouble(coords[1]);
                            double x2 = this._roundDouble(coords[2]);
                            double y2 = this._roundDouble(coords[3]);
                            x = this._roundDouble(coords[4]);
                            y = this._roundDouble(coords[5]);
                            if (prevX == x && prevY == y) break;
                            sb.append('C');
                            if (x1 == prevX) {
                                x1 += 0.001;
                            } else if (y1 == prevY) {
                                y1 += 0.001;
                            }
                            sb.append(x1);
                            sb.append(',');
                            sb.append(y1);
                            sb.append(',');
                            sb.append(x2);
                            sb.append(',');
                            sb.append(y2);
                            sb.append(',');
                            sb.append(x);
                            sb.append(',');
                            sb.append(y);
                            break;
                        }
                        case 4: {
                            sb.append('Z');
                        }
                    }
                    prevX = x;
                    prevY = y;
                    pi.next();
                }
                if (sb.length() > 0) {
                    return sb.toString();
                }
            } else if (this.m_eh != null) {
                this.m_eh.log("null PathIterator", this.getClass().getName(), "protected String convertShapeToPath(Shape shape)");
            }
        }
        return null;
    }

    public boolean startPolygonElement(int[] xCoords, int[] yCoords, int count) throws IOException, Exception {
        int numPoints = count;
        if (numPoints < 0) {
            numPoints = xCoords.length;
        }
        if (xCoords != null && yCoords != null && xCoords.length >= numPoints && yCoords.length >= numPoints) {
            this.startElement(ELEM_POLYGON);
            StringBuilder sb = DataviewUtils.getSharedStringBuilder();
            for (int i = 0; i < numPoints; ++i) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(xCoords[i]);
                sb.append(',');
                sb.append(yCoords[i]);
            }
            this.writeAttribute("p", sb.toString());
            return true;
        }
        if (this.m_eh != null) {
            this.m_eh.log("invalid polygon information", this.getClass().getName(), "public boolean startPolygonElement(int[] xCoords, int[] yCoords, int count)");
        }
        return false;
    }

    public boolean startPolygonElement(Polygon p) throws IOException, Exception {
        if (p != null) {
            return this.startPolygonElement(p.xpoints, p.ypoints, p.npoints);
        }
        if (this.m_eh != null) {
            this.m_eh.log("null Polygon", this.getClass().getName(), "public boolean startPolygonElement(Polygon p)");
        }
        return false;
    }

    public boolean startPolylineElement(Point[] points) throws IOException, Exception {
        if (points != null && points.length > 0) {
            this.startElement(ELEM_POLYLINE);
            StringBuilder sb = DataviewUtils.getSharedStringBuilder();
            for (int i = 0; i < points.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(points[i].getX());
                sb.append(',');
                sb.append(points[i].getY());
            }
            this.writeAttribute(ATTR_POINTS, sb.toString());
            return true;
        }
        if (this.m_eh != null) {
            this.m_eh.log("invalid polyline information", this.getClass().getName(), "public boolean startPolylineElement(Points[] points)");
        }
        return false;
    }

    public boolean startRectElement(int x, int y, int width, int height) throws IOException, Exception {
        this.startElement("r");
        StringBuffer s = new StringBuffer().append(x).append(',').append(y).append(',').append(width).append(',').append(height);
        this.writeAttribute("p", s.toString());
        return true;
    }

    public boolean startRectElement(Rectangle rect) throws IOException, Exception {
        if (rect != null) {
            return this.startRectElement(rect.x, rect.y, rect.width, rect.height);
        }
        if (this.m_eh != null) {
            this.m_eh.log("rect null", this.getClass().getName(), "public boolean startRectElement(Rectangle rect)");
        }
        return false;
    }

    public boolean startRectElement(Rectangle rect, int rx, int ry) throws IOException, Exception {
        if (rect != null) {
            boolean written = this.startRectElement(rect);
            if (written) {
                this.writeAttribute(ATTR_RX, rx / 2);
                this.writeAttribute(ATTR_RY, ry / 2);
            }
            return written;
        }
        if (this.m_eh != null) {
            this.m_eh.log("rect null", this.getClass().getName(), "public boolean startRectElement(Rectangle rect, int rx, int ry)");
        }
        return false;
    }

    public boolean startTextElement(int x, int y, int len) throws IOException, Exception {
        this.startElement("t");
        StringBuffer s = new StringBuffer().append(x).append(',').append(y).append(',').append(len);
        this.writeAttribute("p", s.toString());
        this.m_bOldAutomaticNewlines = this.isAutomaticNewlines();
        this.setAutomaticNewlines(false);
        return true;
    }

    public boolean startTextElement(int x, int y) throws IOException, Exception {
        this.startElement("t");
        StringBuffer s = new StringBuffer().append(x).append(',').append(y);
        this.writeAttribute("p", s.toString());
        this.m_bOldAutomaticNewlines = this.isAutomaticNewlines();
        this.setAutomaticNewlines(false);
        return true;
    }

    @Override
    protected void endElement(String name) throws IOException, Exception {
        super.endElement(name);
        if (name.equals("t") && this.m_bOldAutomaticNewlines) {
            this.setAutomaticNewlines(this.m_bOldAutomaticNewlines);
            this.println();
        }
    }

    private void writeFontElement(int fid, String font) throws IOException, Exception {
        this.startElement("f");
        this.writeAttribute(ATTR_ID, fid);
        this.writeAttribute(ATTR_FONT, font);
        this.endElement();
    }

    public int getFontID(String fontString) throws IOException, Exception {
        int fid = this.m_fontIndex.indexOf(fontString);
        if (fid == -1) {
            fid = this.m_fontIndex.size();
            this.m_fontIndex.add(fid, fontString);
            this.writeFontElement(fid, fontString);
        }
        return fid;
    }

    public void writeFontIndexAttribute(int fid) throws IOException, Exception {
        if (fid != this.m_currFontIndex) {
            this.writeAttribute(ATTR_FONT_INDEX, fid);
            this.m_currFontIndex = fid;
        }
    }

    public void writeShadowAttribute(Color shadowColor, Double distance, Double strength, Double angle, Double blurX, Double blurY, Integer quality, Integer inner, Integer knockout, Integer hide) throws IOException, Exception {
        StringBuilder shadow = DataviewUtils.getSharedStringBuilder();
        if (shadowColor != null && !shadowColor.equals(DEFAULT_SHADOW_COLOR)) {
            shadow.append(ImageViewExportXMLWriter.convertColorToAttributeValue(shadowColor, this.m_eh));
        }
        shadow.append(",");
        if (distance != null && distance != 4.0) {
            shadow.append(distance);
        }
        shadow.append(",");
        if (strength != null && strength != 1.0) {
            shadow.append(strength);
        }
        shadow.append(",");
        if (angle != null && angle != 45.0) {
            shadow.append(angle);
        }
        shadow.append(",");
        if (blurX != null && blurX != 4.0) {
            shadow.append(blurX);
        }
        shadow.append(",");
        if (blurY != null && blurY != 4.0) {
            shadow.append(blurY);
        }
        shadow.append(",");
        if (quality != null && quality != 1) {
            shadow.append(quality);
        }
        shadow.append(",");
        if (inner != null && inner != 0) {
            shadow.append(inner);
        }
        shadow.append(",");
        if (knockout != null && knockout != 0) {
            shadow.append(knockout);
        }
        shadow.append(",");
        if (hide != null && hide != 0) {
            shadow.append(hide);
        }
        this.writeCachedAttribute(ATTR_SHADOW, shadow.toString(), null);
    }

    public void writeBevelAttribute(Color highlightColor, Color shadowColor, Double distance, Double strength, Double angle, Double blurX, Double blurY, Integer quality, String type) throws IOException, Exception {
        StringBuilder bevel = DataviewUtils.getSharedStringBuilder();
        if (highlightColor != null && !highlightColor.equals(DEFAULT_BEVEL_HIGHLIGHT_COLOR)) {
            bevel.append(ImageViewExportXMLWriter.convertColorToAttributeValue(highlightColor, this.m_eh));
        }
        bevel.append(",");
        if (shadowColor != null && !shadowColor.equals(DEFAULT_BEVEL_SHADOW_COLOR)) {
            bevel.append(ImageViewExportXMLWriter.convertColorToAttributeValue(shadowColor, this.m_eh));
        }
        bevel.append(",");
        if (distance != null && distance != 4.0) {
            bevel.append(distance);
        }
        bevel.append(",");
        if (strength != null && strength != 1.0) {
            bevel.append(strength);
        }
        bevel.append(",");
        if (angle != null && angle != 45.0) {
            bevel.append(angle);
        }
        bevel.append(",");
        if (blurX != null && blurX != 4.0) {
            bevel.append(blurX);
        }
        bevel.append(",");
        if (blurY != null && blurY != 4.0) {
            bevel.append(blurY);
        }
        bevel.append(",");
        if (quality != null && quality != 1) {
            bevel.append(quality);
        }
        bevel.append(",");
        if (type != null && !type.equals(DEFAULT_BEVEL_TYPE)) {
            bevel.append(type);
        }
        this.writeAttribute(ATTR_BEVEL, bevel.toString());
    }

    public void writeGlowAttribute(Color highlightColor, Double blurX, Double blurY, Double strength, Integer quality, Integer inner, Integer knockout) throws IOException, Exception {
        StringBuilder glow = DataviewUtils.getSharedStringBuilder();
        if (highlightColor != null && !highlightColor.equals(DEFAULT_GLOW_HIGHLIGHT_COLOR)) {
            glow.append(ImageViewExportXMLWriter.convertColorToAttributeValue(highlightColor, this.m_eh));
        }
        glow.append(",");
        if (blurX != null && blurX != 6.0) {
            glow.append(blurX);
        }
        glow.append(",");
        if (blurY != null && blurY != 6.0) {
            glow.append(blurY);
        }
        glow.append(",");
        if (strength != null && strength != 2.0) {
            glow.append(strength);
        }
        glow.append(",");
        if (quality != null && quality != 1) {
            glow.append(quality);
        }
        glow.append(",");
        if (inner != null && inner != 0) {
            glow.append(inner);
        }
        glow.append(",");
        if (knockout != null && knockout != 0) {
            glow.append(knockout);
        }
        this.writeAttribute(ATTR_GLOW, glow.toString());
    }

    public void writeCachedAttribute(String attr, String value, String elemType) throws IOException, Exception {
        String key = attr;
        if (attr != null && elemType != null) {
            key = key + elemType;
        }
        String currentValue = this.m_cachedMap.get(key);
        boolean bValueChanged = false;
        if (value == null && currentValue != null || value != null && !value.equals(currentValue)) {
            bValueChanged = true;
        }
        if (value != null && bValueChanged) {
            this.writeAttribute(attr, value);
            this.m_cachedMap.put(key, value);
        }
    }

    public void writeCachedAttribute(String attr, int value, String elemType) throws IOException, Exception {
        this.writeCachedAttribute(attr, String.valueOf(value), elemType);
    }

    public void writeCachedAttribute(String attr, double value, String elemType) throws IOException, Exception {
        this.writeCachedAttribute(attr, String.valueOf(value), elemType);
    }

    public void writeCachedAttribute(String attr, boolean value, String elemType) throws IOException, Exception {
        this.writeCachedAttribute(attr, String.valueOf(value), elemType);
    }

    public void writeCachedAttribute(String attr, Color value, String elemType) throws IOException, Exception {
        this.writeCachedAttribute(attr, ImageViewExportXMLWriter.convertColorToAttributeValue(value, this.m_eh), elemType);
    }

    public static String getFontAttributes(Font font, Color c, boolean bUnderline, ErrorHandler eh) {
        String fontFamily;
        boolean bItalic;
        StringBuilder sb = DataviewUtils.getSharedStringBuilder();
        boolean bBold = (font.getStyle() & 1) == 1;
        boolean bl = bItalic = (font.getStyle() & 2) == 2;
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(font.getSize());
        String sColor = ImageViewExportXMLWriter.convertColorToAttributeValue(c, eh);
        if (sColor != null) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(sColor);
        }
        if ((fontFamily = ImageViewExportXMLWriter.getFontFamily(font.getName(), true)) != null) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(fontFamily);
        }
        if (bBold) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(ATTR_BOUNDING_BOX);
        }
        if (bItalic) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(DEFAULT_BEVEL_TYPE);
        }
        if (bUnderline) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append("u");
        }
        return sb.toString();
    }

    protected static String getFontFamily(String name, boolean bQuotes) {
        String ret = PresUtils.mapJavaFontToHTMLFont(name, true);
        if (bQuotes) {
            StringBuilder sb = DataviewUtils.getSharedStringBuilder2(ret);
            sb.insert(0, '\'');
            sb.append('\'');
            ret = sb.toString();
        }
        return ret;
    }

    @Override
    public void writeAttribute(String name, Color color) throws IOException, Exception {
        String s = ImageViewExportXMLWriter.convertColorToAttributeValue(color, this.m_eh);
        if (s != null) {
            this.writeAttribute(name, s);
        }
    }

    public boolean hasShapeAttributes() {
        return true;
    }

    public void writeShapeAttributesElement() throws IOException, Exception {
        String onClickJS;
        if (this.m_xmlCallback != null && (onClickJS = this.m_xmlCallback.getOnClickJavaScript()) != null) {
            this.startElement(ELEM_SHAPE_ATTRIBUTES);
            this.writeAttribute(ATTR_ON_CLICK, onClickJS);
            this.endElement();
        }
    }

    public boolean hasAlt() throws IOException, Exception {
        return false;
    }

    public void writeCustomPropertyAttribute() throws IOException, Exception {
        if (this.m_xmlCallback == null) {
            return;
        }
        String value = this.m_xmlCallback.getCustomProperty();
        if (value != null) {
            this.writeAttribute(ATTR_CUSTOM_PROPERTY, value);
        }
    }

    public void writeTooltipAttribute(String[] tooltipsArray) throws IOException, Exception {
        if (tooltipsArray != null && tooltipsArray.length > 0) {
            String tt = ImageViewExportXMLWriter._buildTooltipString(tooltipsArray);
            if (tt != null && tt.length() > 0) {
                this.writeAttribute("t", tt.toString());
            }
            this.writeCachedAttribute(ATTR_USE_TOOLTIP_TEMPLATE, "f", null);
        }
    }

    public void setUseDataIds(boolean b) {
        this.m_bUseDataIds = b;
    }

    public boolean isUseDataIds() {
        return this.m_bUseDataIds;
    }

    protected String getFontMap() {
        return null;
    }

    public boolean isActiveDataService() {
        return false;
    }

    public boolean isPPRAnimation() {
        return false;
    }

    public boolean isAnimationOnDisplay() {
        return false;
    }

    protected static String convertColorToAttributeValue(Color color, ErrorHandler eh) {
        if (color == null) {
            return "none";
        }
        String s = ImageViewExportXMLWriter.colorToHexWithAlpha(color);
        if (s != null) {
            return s;
        }
        if (eh != null) {
            eh.log("null hex string", ImageViewExportXMLWriter.class.toString(), "protected String convertColorToAttributeValue(Color color)");
        }
        return null;
    }

    protected static String convertArcTypeToString(int arcType) {
        switch (arcType) {
            case 1: {
                return "CHORD";
            }
            case 0: {
                return "OPEN";
            }
            case 2: {
                return "PIE";
            }
        }
        return null;
    }

    protected static String _buildTooltipString(String[] tooltipsArray) throws IOException, Exception {
        StringBuilder sb = DataviewUtils.getSharedStringBuilder();
        for (int i = 0; i < tooltipsArray.length; ++i) {
            if (tooltipsArray[i] == null || tooltipsArray[i].length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(LINE_SEP);
            }
            sb.append(tooltipsArray[i]);
        }
        return sb.toString();
    }

    protected static String _buildTooltipString(ArrayList<String> tooltipsArray) throws IOException, Exception {
        StringBuilder sb = DataviewUtils.getSharedStringBuilder();
        for (int i = 0; i < tooltipsArray.size(); ++i) {
            if (tooltipsArray.get(i) == null || tooltipsArray.get(i).length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(LINE_SEP);
            }
            sb.append(tooltipsArray.get(i));
        }
        return sb.toString();
    }

    public void writeAnimationAttributes() throws IOException, Exception {
    }

    public static FontMetrics getFontMetrics(Graphics g, Font f) {
        if (f == null) {
            return g.getFontMetrics();
        }
        FontMetrics cachedFontMetrics = fontMetricsMap.get(f);
        if (cachedFontMetrics == null) {
            cachedFontMetrics = g.getFontMetrics(f);
            fontMetricsMap.put(f, cachedFontMetrics);
        }
        return cachedFontMetrics;
    }

    public boolean writeMetadataElement(String elem, Map<String, String> metadata) throws IOException, Exception {
        String font = metadata.get("f");
        int fid = -1;
        if (font != null) {
            fid = this.getFontID(font);
            metadata.put("f", null);
        }
        this.startElement(elem);
        Set<Map.Entry<String, String>> entrySet = metadata.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            this.writeAttribute(entry.getKey(), entry.getValue());
        }
        if (fid >= 0) {
            this.writeFontIndexAttribute(fid);
        }
        this.endElement();
        return true;
    }

    public void startHandleElement(Map<String, String> metadata) throws IOException, Exception {
        this.startElement("h");
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            this.writeAttribute(entry.getKey(), entry.getValue());
        }
    }

    protected void writeGradientStopAttributes(GradientObj gradient) throws IOException, Exception {
        StringBuilder pos = DataviewUtils.getSharedStringBuilder();
        StringBuilder c = DataviewUtils.getSharedStringBuilder2();
        List<GradientStopObj> stopList = gradient.getStopList();
        for (GradientStopObj stop : stopList) {
            double offset = stop.getPosition();
            Color color = stop.getColor();
            pos.append(offset).append(",");
            c.append(ImageViewExportXMLWriter.colorToHexWithAlpha(color)).append(",");
        }
        pos.setLength(pos.length() - 1);
        c.setLength(c.length() - 1);
        this.writeCachedAttribute("p", pos.toString(), null);
        this.writeAttribute("c", c.toString());
    }

    protected boolean isBIDILocale() {
        String language;
        Locale loc = this.getLocale();
        return loc != null && ((language = loc.getLanguage()).equals("ar") || language.equals("he") || language.equals("iw"));
    }

    protected String generateEvent(String[][] eventParams) {
        if (this.m_xmlCallback == null) {
            return null;
        }
        String marshallerName = this.m_xmlCallback.getMarshallerFunctionName();
        if (marshallerName == null) {
            return null;
        }
        StringBuilder js = new StringBuilder(300);
        js.append(marshallerName).append("('");
        js.append(this.m_xmlCallback.getId()).append("',");
        boolean bDoneFirst = false;
        if (eventParams != null && eventParams.length > 0) {
            for (int i = 0; i < eventParams.length; ++i) {
                if (eventParams[i].length <= 1 || eventParams[i][0] == null || eventParams[i][1] == null) continue;
                if (!bDoneFirst) {
                    bDoneFirst = true;
                    js.append("{");
                } else {
                    js.append(",");
                }
                js.append(eventParams[i][0]);
                js.append(":");
                js.append("'");
                if (eventParams[i][1] != null) {
                    js.append(eventParams[i][1].toString());
                }
                js.append("'");
            }
        }
        if (bDoneFirst) {
            js.append("}");
        }
        js.append(");");
        return js.toString();
    }
}

