/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dss.dataView.CommonDataview;
import oracle.dss.dataView.Model;
import oracle.dss.dataView.TokenSubstitutionAdapter;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public class TokenSubstitutionExtendedAdapter
extends TokenSubstitutionAdapter {
    protected ViewPrinter m_viewprinter = null;

    public TokenSubstitutionExtendedAdapter(ViewPrinter printer, int item) {
        this.m_viewprinter = printer;
        this.m_dataview = printer.getDataview();
        this.m_item = item;
        this._init();
    }

    @Override
    protected String getParsedKey(String subStr) {
        String parsedStr = "";
        int dimCnt = 0;
        String dimMemSeparator = ":";
        String dimSeparator = ", ";
        String memSeparator = ", ";
        String dimMemPairSeparator = ", ";
        Object obj = null;
        if (subStr.equals("__PAGE__")) {
            return Integer.toString(this.m_viewprinter.getSequentialPageNumber());
        }
        if (subStr.equals("__DATE__") || subStr.equals("__TIME__")) {
            Locale loc = null;
            if (this.m_dataview != null) {
                loc = this.m_dataview.getLocale();
            }
            if (loc == null) {
                loc = Locale.getDefault();
            }
            Calendar cal = null;
            boolean bForceGregCal = loc.getLanguage().compareTo("th") == 0 && loc.getCountry().compareTo("TH") == 0;
            cal = bForceGregCal ? new GregorianCalendar(loc) : Calendar.getInstance(loc);
            DateFormat formatter = subStr.equals("__DATE__") ? (DateFormat)DateFormat.getDateInstance(3, loc).clone() : (DateFormat)DateFormat.getTimeInstance(3, loc).clone();
            if (bForceGregCal) {
                formatter.setCalendar(cal);
            }
            formatter.setTimeZone(TimeZone.getDefault());
            return formatter.format(cal.getTime());
        }
        if (subStr.equals("__D&M__")) {
            DataAccess dataAccess;
            Model model = this.m_dataview.getModel();
            if (model != null) {
                dataAccess = model.getDataAccess();
            } else if (this.m_dataview instanceof CommonDataview) {
                dataAccess = ((CommonDataview)this.m_dataview).getDataAccess();
            } else {
                return null;
            }
            if (dataAccess == null) {
                return null;
            }
            String layerLabelType = this.m_dataview.getLayerMetadataLabelType(2);
            String memberLabelType = this.m_dataview.getMemberMetadataLabelType(2);
            boolean bLayerTypeSupported = this.m_dataview.isLayerMetadataLabelTypeSupported(layerLabelType);
            boolean bMemberTypeSupported = this.m_dataview.isMemberMetadataLabelTypeSupported(memberLabelType);
            if (bLayerTypeSupported || bMemberTypeSupported) {
                try {
                    dimCnt = dataAccess.getLayerCount(2);
                    int[] context = dataAccess.getEdgeCurrentHPos(2);
                    for (int dim = 0; dim < dimCnt; ++dim) {
                        String dimStr = "";
                        if (bLayerTypeSupported) {
                            obj = dataAccess.getLayerMetadata(2, dim, layerLabelType);
                        }
                        if (obj != null) {
                            dimStr = obj.toString();
                        }
                        String memStr = "";
                        if (bMemberTypeSupported && context != null) {
                            obj = dataAccess.getMemberMetadata(2, context, dim, context[dim], memberLabelType);
                            if (obj != null) {
                                memStr = obj.toString();
                            }
                            memStr = dimMemSeparator + memStr;
                        }
                        parsedStr = parsedStr + dimStr + memStr;
                        if (dim + 1 >= dimCnt) continue;
                        parsedStr = parsedStr + dimMemPairSeparator;
                    }
                }
                catch (EdgeOutOfRangeException e) {
                    this.m_dataview.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getParsedVariablesStr");
                    return null;
                }
                catch (SliceOutOfRangeException e) {
                    this.m_dataview.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getParsedVariablesStr");
                    return null;
                }
                catch (LayerOutOfRangeException e) {
                    this.m_dataview.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getParsedVariablesStr");
                    return null;
                }
            }
        } else {
            String layerLabelType = this.m_dataview.getLayerMetadataLabelType(2);
            boolean bLayerTypeSupported = this.m_dataview.isLayerMetadataLabelTypeSupported(layerLabelType);
            if (subStr.equals("__DIM__") && bLayerTypeSupported) {
                DataAccess dataAccess;
                Model model = this.m_dataview.getModel();
                if (model != null) {
                    dataAccess = model.getDataAccess();
                } else if (this.m_dataview instanceof CommonDataview) {
                    dataAccess = ((CommonDataview)this.m_dataview).getDataAccess();
                } else {
                    return null;
                }
                if (dataAccess == null) {
                    return null;
                }
                try {
                    dimCnt = dataAccess.getLayerCount(2);
                    for (int dim = 0; dim < dimCnt; ++dim) {
                        String dimStr = null;
                        obj = dataAccess.getLayerMetadata(2, dim, layerLabelType);
                        if (obj != null) {
                            dimStr = obj.toString();
                        }
                        parsedStr = parsedStr + dimStr;
                        if (dim + 1 >= dimCnt) continue;
                        parsedStr = parsedStr + dimSeparator;
                    }
                }
                catch (EdgeOutOfRangeException e) {
                    this.m_dataview.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getParsedVariablesStr");
                    return null;
                }
                catch (LayerOutOfRangeException e) {
                    this.m_dataview.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getParsedVariablesStr");
                    return null;
                }
            }
            String memberLabelType = this.m_dataview.getMemberMetadataLabelType(2);
            boolean bMemberTypeSupported = this.m_dataview.isMemberMetadataLabelTypeSupported(memberLabelType);
            if (subStr.equals("__MEM__") && bMemberTypeSupported) {
                DataAccess dataAccess;
                Model model = this.m_dataview.getModel();
                if (model != null) {
                    dataAccess = model.getDataAccess();
                } else if (this.m_dataview instanceof CommonDataview) {
                    dataAccess = ((CommonDataview)this.m_dataview).getDataAccess();
                } else {
                    return null;
                }
                if (dataAccess == null) {
                    return null;
                }
                try {
                    dimCnt = dataAccess.getLayerCount(2);
                    int[] context = dataAccess.getEdgeCurrentHPos(2);
                    if (context != null) {
                        for (int dim = 0; dim < dimCnt; ++dim) {
                            String memStr = null;
                            obj = dataAccess.getMemberMetadata(2, context, dim, context[dim], memberLabelType);
                            if (obj != null) {
                                memStr = obj.toString();
                            }
                            parsedStr = parsedStr + memStr;
                            if (dim + 1 >= dimCnt) continue;
                            parsedStr = parsedStr + memSeparator;
                        }
                    }
                }
                catch (EdgeOutOfRangeException e) {
                    this.m_dataview.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getParsedVariablesStr");
                    return null;
                }
                catch (SliceOutOfRangeException e) {
                    this.m_dataview.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getParsedVariablesStr");
                    return null;
                }
                catch (LayerOutOfRangeException e) {
                    this.m_dataview.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getParsedVariablesStr");
                    return null;
                }
            }
        }
        return parsedStr;
    }
}

