/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.managers;

import java.util.Map;
import oracle.dss.dataView.CommonDataview;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.managers.ViewFormatCallback;
import oracle.dss.rules.Mergeable;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.Utility;
import oracle.dss.util.format.BaseViewFormat;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class ViewFormat
extends BaseViewFormat {
    private static final long serialVersionUID = 1L;
    protected DataviewCommon m_view = null;
    protected static final String s_numberType = "n";
    protected static final String s_thousandSeparator = "t";
    protected static final String s_decimalSeparator = "d";
    protected static final String s_currencySymbol = "c";
    protected static final String s_leadingZero = "l";
    protected static final String s_decimalDigit = "a";
    protected static final String s_posNumFmt = "e";
    protected static final String s_negNumFmt = "f";
    protected static final String s_posCurFmt = "g";
    protected static final String s_negCurFmt = "h";
    protected static final String s_scaleFactor = "s";
    protected static final String s_scaleDownThousands = "k";
    protected static final String s_scaleDownMillions = "m";
    protected static final String s_scaleDownBillions = "b";
    protected static final String s_scaleDownTrillions = "i";
    protected static final String s_scaleDownQuadrillions = "q";
    protected static final String s_javaDateFormat = "j";
    protected static final String s_oracleDateFormat = "o";
    protected static final String s_CustomFormatString = "cf";
    protected static final String s_numberTypeUsed = "nu";
    protected static final String s_thousandSeparatorUsed = "tu";
    protected static final String s_decimalSeparatorUsed = "du";
    protected static final String s_currencySymbolUsed = "cu";
    protected static final String s_leadingZeroUsed = "lu";
    protected static final String s_decimalDigitUsed = "au";
    protected static final String s_posNumFmtUsed = "eu";
    protected static final String s_negNumFmtUsed = "fu";
    protected static final String s_posCurFmtUsed = "gu";
    protected static final String s_negCurFmtUsed = "hu";
    protected static final String s_scaleFactorUsed = "su";
    protected static final String s_scaleDownThousandsUsed = "ku";
    protected static final String s_scaleDownMillionsUsed = "mu";
    protected static final String s_scaleDownBillionsUsed = "bu";
    protected static final String s_scaleDownTrillionsUsed = "iu";
    protected static final String s_scaleDownQuadrillionsUsed = "qu";
    protected static final String s_javaDateFormatUsed = "ju";
    protected static final String s_oracleDateFormatUsed = "ou";

    public ViewFormat() {
    }

    public ViewFormat(int numberType, char thousandSeparator, char decimalSeparator, String currencySymbol, boolean leadingZero, int decimalDigit, int posNumFmt, int negNumFmt, int posCurFmt, int negCurFmt, int scaleFactor, String scaleDownThousands, String scaleDownMillions, String scaleDownBillions, String scaleDownTrillions, String scaleDownQuadrillions, String dateFormat) {
        super(numberType, thousandSeparator, decimalSeparator, currencySymbol, leadingZero, decimalDigit, posNumFmt, negNumFmt, posCurFmt, negCurFmt, scaleFactor, scaleDownThousands, scaleDownMillions, scaleDownBillions, scaleDownTrillions, scaleDownQuadrillions, dateFormat);
    }

    public ViewFormat(String numberFormatString, int fmtStrType) {
        super(numberFormatString, fmtStrType);
    }

    public ViewFormat(BaseViewFormat baseViewFormat) {
        this(baseViewFormat.getNumberType(), baseViewFormat.getThousandSeparator(), baseViewFormat.getDecimalSeparator(), baseViewFormat.getCurrencySymbol(), baseViewFormat.isLeadingZero(), baseViewFormat.getDecimalDigit(), baseViewFormat.getPosNumFmt(), baseViewFormat.getNegNumFmt(), baseViewFormat.getPosCurFmt(), baseViewFormat.getNegCurFmt(), baseViewFormat.getScaleFactor(), baseViewFormat.getScaleDownThousands(), baseViewFormat.getScaleDownMillions(), baseViewFormat.getScaleDownBillions(), baseViewFormat.getScaleDownTrillions(), baseViewFormat.getScaleDownQuadrillions(), baseViewFormat.getOracleDateFormat());
        this.setView(null);
        this.setLocale(baseViewFormat.getLocale());
        this.setJavaDateFormat(baseViewFormat.getJavaDateFormat());
        this.setJavaDateFormatUsed(baseViewFormat.isJavaDateFormatUsed());
    }

    public Object clone() {
        ViewFormat viewFormatClone = new ViewFormat(this.getNumberType(), this.getThousandSeparator(), this.getDecimalSeparator(), this.getCurrencySymbol(), this.isLeadingZero(), this.getDecimalDigit(), this.getPosNumFmt(), this.getNegNumFmt(), this.getPosCurFmt(), this.getNegCurFmt(), this.getScaleFactor(), this.getScaleDownThousands(), this.getScaleDownMillions(), this.getScaleDownBillions(), this.getScaleDownTrillions(), this.getScaleDownQuadrillions(), this.getOracleDateFormat());
        viewFormatClone.setLocale(this.getLocale());
        viewFormatClone.merge((Mergeable)this);
        viewFormatClone.setView(this.m_view);
        viewFormatClone.setErrorHandler(this._getErrorHandler());
        viewFormatClone.setJavaDateFormat(this.getJavaDateFormat());
        viewFormatClone.setJavaDateFormatUsed(this.isJavaDateFormatUsed());
        return viewFormatClone;
    }

    public void setViewFormatCallback(ViewFormatCallback vfc) {
        this.m_vfCallback = vfc;
    }

    public void setViewFormatCallbackUsed(boolean useCallback) {
        this.m_bUseCallback = useCallback;
    }

    public boolean isViewFormatCallbackUsed() {
        return this.m_bUseCallback;
    }

    public void setView(DataviewCommon view) {
        this.m_view = view;
        if (this.m_view != null) {
            this.setErrorHandler(null);
        }
    }

    public DataviewCommon getView() {
        return this.m_view;
    }

    public String getDateFormat() {
        return this.getJavaDateFormat();
    }

    public boolean isDateFormatUsed() {
        return this.m_formatUsedFlags.get(16);
    }

    public void setDateFormat(String sDateFormat) {
        this.setJavaDateFormat(sDateFormat);
    }

    public void setDateFormatUsed(boolean bValue) {
        if (bValue) {
            this.m_formatUsedFlags.set(16);
        } else {
            this.m_formatUsedFlags.clear(16);
        }
    }

    public boolean contains(ViewFormat vf) {
        if (vf == null) {
            return false;
        }
        if (vf.isNumberTypeUsed() && this.getNumberType() != vf.getNumberType()) {
            return false;
        }
        if (vf.isThousandSeparatorUsed() && this.getThousandSeparator() != vf.getThousandSeparator()) {
            return false;
        }
        if (vf.isDecimalSeparatorUsed() && this.getDecimalSeparator() != vf.getDecimalSeparator()) {
            return false;
        }
        if (vf.isCurrencySymbolUsed() && !this.getCurrencySymbol().equals(vf.getCurrencySymbol())) {
            return false;
        }
        if (vf.isLeadingZeroUsed() && this.isLeadingZero() != vf.isLeadingZero()) {
            return false;
        }
        if (vf.isDecimalDigitUsed() && this.getDecimalDigit() != vf.getDecimalDigit()) {
            return false;
        }
        if (vf.isPosNumFmtUsed() && this.getPosNumFmt() != vf.getPosNumFmt()) {
            return false;
        }
        if (vf.isNegNumFmtUsed() && this.getNegNumFmt() != vf.getNegNumFmt()) {
            return false;
        }
        if (vf.isPosCurFmtUsed() && this.getPosCurFmt() != vf.getPosCurFmt()) {
            return false;
        }
        if (vf.isNegCurFmtUsed() && this.getNegCurFmt() != vf.getNegCurFmt()) {
            return false;
        }
        if (vf.isScaleFactorUsed() && this.getScaleFactor() != vf.getScaleFactor()) {
            return false;
        }
        if (vf.isScaleDownThousandsUsed() && !this.getScaleDownThousands().equals(vf.getScaleDownThousands())) {
            return false;
        }
        if (vf.isScaleDownMillionsUsed() && !this.getScaleDownMillions().equals(vf.getScaleDownMillions())) {
            return false;
        }
        if (vf.isScaleDownBillionsUsed() && !this.getScaleDownBillions().equals(vf.getScaleDownBillions())) {
            return false;
        }
        if (vf.isScaleDownTrillionsUsed() && !this.getScaleDownTrillions().equals(vf.getScaleDownTrillions())) {
            return false;
        }
        if (vf.isScaleDownQuadrillionsUsed() && !this.getScaleDownQuadrillions().equals(vf.getScaleDownQuadrillions())) {
            return false;
        }
        if (vf.isJavaDateFormatUsed() && !this.getJavaDateFormat().equals(vf.getJavaDateFormat())) {
            return false;
        }
        if (vf.isOracleDateFormatUsed() && !this.getOracleDateFormat().equals(vf.getOracleDateFormat())) {
            return false;
        }
        return !vf.isNegPctFmtUsed() || this.getNegPctFmt() == vf.getNegPctFmt();
    }

    protected ErrorHandler _getErrorHandler() {
        ErrorHandler errorHandler = super._getErrorHandler();
        if (errorHandler != null) {
            return errorHandler;
        }
        if (this.getView() != null && this.getView().getErrorHandler() != null) {
            return this.getView().getErrorHandler();
        }
        return null;
    }

    public void setStateAsObjectNode(ObjectNode node, ViewFormat baseState) {
        PropertyNode pNode;
        if (node == null) {
            return;
        }
        if (baseState == null) {
            baseState = new ViewFormat();
        }
        if ((pNode = node.getProperty(s_numberType)) != null) {
            this.setNumberType(pNode.getValueAsInteger());
        } else {
            this.setNumberType(baseState.getNumberType());
            pNode = node.getProperty(s_numberTypeUsed);
            if (pNode != null) {
                this.setNumberTypeUsed(Utility.getValueAsBoolean((PropertyNode)pNode));
            } else {
                this.setNumberTypeUsed(baseState.isNumberTypeUsed());
            }
        }
        pNode = node.getProperty(s_thousandSeparator);
        if (pNode != null) {
            this.setThousandSeparator(pNode.getValueAsCharacter());
        } else {
            this.setThousandSeparator(baseState.getThousandSeparator());
            pNode = node.getProperty(s_thousandSeparatorUsed);
            if (pNode != null) {
                this.setThousandSeparatorUsed(Utility.getValueAsBoolean((PropertyNode)pNode));
            } else {
                this.setThousandSeparatorUsed(baseState.isThousandSeparatorUsed());
            }
        }
        pNode = node.getProperty(s_decimalSeparator);
        if (pNode != null) {
            this.setDecimalSeparator(pNode.getValueAsCharacter());
        } else {
            this.setDecimalSeparator(baseState.getDecimalSeparator());
            pNode = node.getProperty(s_decimalSeparatorUsed);
            if (pNode != null) {
                this.setDecimalSeparatorUsed(Utility.getValueAsBoolean((PropertyNode)pNode));
            } else {
                this.setDecimalSeparatorUsed(baseState.isDecimalSeparatorUsed());
            }
        }
        pNode = node.getProperty(s_currencySymbol);
        if (pNode != null) {
            this.setCurrencySymbol(pNode.getValueAsString());
        } else {
            this.setCurrencySymbol(baseState.getCurrencySymbol());
            pNode = node.getProperty(s_currencySymbolUsed);
            if (pNode != null) {
                this.setCurrencySymbolUsed(Utility.getValueAsBoolean((PropertyNode)pNode));
            } else {
                this.setCurrencySymbolUsed(baseState.isCurrencySymbolUsed());
            }
        }
        pNode = node.getProperty(s_leadingZero);
        if (pNode != null) {
            this.setLeadingZero(Utility.getValueAsBoolean((PropertyNode)pNode));
        } else {
            this.setLeadingZero(baseState.isLeadingZero());
            pNode = node.getProperty(s_leadingZeroUsed);
            if (pNode != null) {
                this.setLeadingZeroUsed(Utility.getValueAsBoolean((PropertyNode)pNode));
            } else {
                this.setLeadingZeroUsed(baseState.isLeadingZeroUsed());
            }
        }
        pNode = node.getProperty(s_decimalDigit);
        if (pNode != null) {
            this.setDecimalDigit(pNode.getValueAsInteger());
        } else {
            this.setDecimalDigit(baseState.getDecimalDigit());
            pNode = node.getProperty(s_decimalDigitUsed);
            if (pNode != null) {
                this.setDecimalDigitUsed(Utility.getValueAsBoolean((PropertyNode)pNode));
            } else {
                this.setDecimalDigitUsed(baseState.isDecimalDigitUsed());
            }
        }
        pNode = node.getProperty(s_posNumFmt);
        if (pNode != null) {
            this.setPosNumFmt(pNode.getValueAsInteger());
        } else {
            this.setPosNumFmt(baseState.getPosNumFmt());
            pNode = node.getProperty(s_posNumFmtUsed);
            if (pNode != null) {
                this.setPosNumFmtUsed(Utility.getValueAsBoolean((PropertyNode)pNode));
            } else {
                this.setPosNumFmtUsed(baseState.isPosNumFmtUsed());
            }
        }
        pNode = node.getProperty(s_negNumFmt);
        if (pNode != null) {
            this.setNegNumFmt(pNode.getValueAsInteger());
        } else {
            this.setNegNumFmt(baseState.getNegNumFmt());
            pNode = node.getProperty(s_negNumFmtUsed);
            if (pNode != null) {
                this.setNegNumFmtUsed(Utility.getValueAsBoolean((PropertyNode)pNode));
            } else {
                this.setNegNumFmtUsed(baseState.isNegNumFmtUsed());
            }
        }
        pNode = node.getProperty(s_posCurFmt);
        if (pNode != null) {
            this.setPosCurFmt(pNode.getValueAsInteger());
        } else {
            this.setPosCurFmt(baseState.getPosCurFmt());
            pNode = node.getProperty(s_posCurFmtUsed);
            if (pNode != null) {
                this.setPosCurFmtUsed(Utility.getValueAsBoolean((PropertyNode)pNode));
            } else {
                this.setPosCurFmtUsed(baseState.isPosCurFmtUsed());
            }
        }
        pNode = node.getProperty(s_negCurFmt);
        if (pNode != null) {
            this.setNegCurFmt(pNode.getValueAsInteger());
        } else {
            this.setNegCurFmt(baseState.getNegCurFmt());
            pNode = node.getProperty(s_negCurFmtUsed);
            if (pNode != null) {
                this.setNegCurFmtUsed(Utility.getValueAsBoolean((PropertyNode)pNode));
            } else {
                this.setNegCurFmtUsed(baseState.isNegCurFmtUsed());
            }
        }
        pNode = node.getProperty(s_scaleFactor);
        if (pNode != null) {
            this.setScaleFactor(pNode.getValueAsInteger());
        } else {
            this.setScaleFactor(baseState.getScaleFactor());
            pNode = node.getProperty(s_scaleFactorUsed);
            if (pNode != null) {
                this.setScaleFactorUsed(Utility.getValueAsBoolean((PropertyNode)pNode));
            } else {
                this.setScaleFactorUsed(baseState.isScaleFactorUsed());
            }
        }
        pNode = node.getProperty(s_scaleDownThousands);
        if (pNode != null) {
            this.setScaleDownThousands(pNode.getValueAsString());
        } else {
            this.setScaleDownThousands(baseState.getScaleDownThousands());
            pNode = node.getProperty(s_scaleDownThousandsUsed);
            if (pNode != null) {
                this.setScaleDownThousandsUsed(Utility.getValueAsBoolean((PropertyNode)pNode));
            } else {
                this.setScaleDownThousandsUsed(baseState.isScaleDownThousandsUsed());
            }
        }
        pNode = node.getProperty(s_scaleDownMillions);
        if (pNode != null) {
            this.setScaleDownMillions(pNode.getValueAsString());
        } else {
            this.setScaleDownMillions(baseState.getScaleDownMillions());
            pNode = node.getProperty(s_scaleDownMillionsUsed);
            if (pNode != null) {
                this.setScaleDownMillionsUsed(Utility.getValueAsBoolean((PropertyNode)pNode));
            } else {
                this.setScaleDownMillionsUsed(baseState.isScaleDownMillionsUsed());
            }
        }
        pNode = node.getProperty(s_scaleDownBillions);
        if (pNode != null) {
            this.setScaleDownBillions(pNode.getValueAsString());
        } else {
            this.setScaleDownBillions(baseState.getScaleDownBillions());
            pNode = node.getProperty(s_scaleDownBillionsUsed);
            if (pNode != null) {
                this.setScaleDownBillionsUsed(Utility.getValueAsBoolean((PropertyNode)pNode));
            } else {
                this.setScaleDownBillionsUsed(baseState.isScaleDownBillionsUsed());
            }
        }
        pNode = node.getProperty(s_scaleDownTrillions);
        if (pNode != null) {
            this.setScaleDownTrillions(pNode.getValueAsString());
        } else {
            this.setScaleDownTrillions(baseState.getScaleDownTrillions());
            pNode = node.getProperty(s_scaleDownTrillionsUsed);
            if (pNode != null) {
                this.setScaleDownTrillionsUsed(Utility.getValueAsBoolean((PropertyNode)pNode));
            } else {
                this.setScaleDownTrillionsUsed(baseState.isScaleDownTrillionsUsed());
            }
        }
        pNode = node.getProperty(s_scaleDownQuadrillions);
        if (pNode != null) {
            this.setScaleDownQuadrillions(pNode.getValueAsString());
        } else {
            this.setScaleDownQuadrillions(baseState.getScaleDownQuadrillions());
            pNode = node.getProperty(s_scaleDownQuadrillionsUsed);
            if (pNode != null) {
                this.setScaleDownQuadrillionsUsed(Utility.getValueAsBoolean((PropertyNode)pNode));
            } else {
                this.setScaleDownQuadrillionsUsed(baseState.isScaleDownQuadrillionsUsed());
            }
        }
        pNode = node.getProperty(s_javaDateFormat);
        if (pNode != null) {
            this.setJavaDateFormat(pNode.getValueAsString());
        } else {
            this.setJavaDateFormat(baseState.getJavaDateFormat());
            pNode = node.getProperty(s_javaDateFormatUsed);
            if (pNode != null) {
                this.setJavaDateFormatUsed(Utility.getValueAsBoolean((PropertyNode)pNode));
            } else {
                this.setJavaDateFormatUsed(baseState.isJavaDateFormatUsed());
            }
        }
        pNode = node.getProperty(s_oracleDateFormat);
        if (pNode != null) {
            this.setOracleDateFormat(pNode.getValueAsString());
        } else {
            this.setOracleDateFormat(baseState.getOracleDateFormat());
            pNode = node.getProperty(s_oracleDateFormatUsed);
            if (pNode != null) {
                this.setOracleDateFormatUsed(Utility.getValueAsBoolean((PropertyNode)pNode));
            } else {
                this.setOracleDateFormatUsed(baseState.isOracleDateFormatUsed());
            }
        }
        pNode = node.getProperty(s_CustomFormatString);
        if (pNode != null) {
            this.setNumberFormatString(pNode.getValueAsString());
        } else {
            this.setNumberFormatString(baseState.getNumberFormatString());
        }
    }

    public ObjectNode getStateAsObjectNode(String nodeName, ViewFormat baseState) {
        if (baseState == null) {
            baseState = new ViewFormat();
        }
        ObjectNode node = new ObjectNode(nodeName);
        boolean nodeExists = false;
        if (this.isNumberTypeUsed() && baseState.getNumberType() != this.getNumberType()) {
            node.addProperty(s_numberType, this.getNumberType());
            nodeExists = true;
        } else if (baseState.isNumberTypeUsed() != this.isNumberTypeUsed()) {
            node.addProperty(s_numberTypeUsed, Utility.getBooleanAsChar((boolean)this.isNumberTypeUsed()));
            nodeExists = true;
        }
        if (this.isThousandSeparatorUsed() && baseState.getThousandSeparator() != this.getThousandSeparator()) {
            node.addProperty(s_thousandSeparator, this.getThousandSeparator());
            nodeExists = true;
        } else if (baseState.isThousandSeparatorUsed() != this.isThousandSeparatorUsed()) {
            node.addProperty(s_thousandSeparatorUsed, Utility.getBooleanAsChar((boolean)this.isThousandSeparatorUsed()));
            nodeExists = true;
        }
        if (this.isDecimalSeparatorUsed() && baseState.getDecimalSeparator() != this.getDecimalSeparator()) {
            node.addProperty(s_decimalSeparator, this.getDecimalSeparator());
            nodeExists = true;
        } else if (baseState.isDecimalSeparatorUsed() != this.isDecimalSeparatorUsed()) {
            node.addProperty(s_decimalSeparatorUsed, Utility.getBooleanAsChar((boolean)this.isDecimalSeparatorUsed()));
            nodeExists = true;
        }
        if (this.isCurrencySymbolUsed() && !baseState.getCurrencySymbol().equals(this.getCurrencySymbol())) {
            node.addProperty(s_currencySymbol, this.createStringLiteral(this.getCurrencySymbol()));
            nodeExists = true;
        } else if (baseState.isCurrencySymbolUsed() != this.isCurrencySymbolUsed()) {
            node.addProperty(s_currencySymbolUsed, Utility.getBooleanAsChar((boolean)this.isCurrencySymbolUsed()));
            nodeExists = true;
        }
        if (this.isLeadingZeroUsed() && baseState.isLeadingZero() != this.isLeadingZero()) {
            node.addProperty(s_leadingZero, this.isLeadingZero());
            nodeExists = true;
        } else if (baseState.isLeadingZeroUsed() != this.isLeadingZeroUsed()) {
            node.addProperty(s_leadingZeroUsed, Utility.getBooleanAsChar((boolean)this.isLeadingZeroUsed()));
            nodeExists = true;
        }
        if (this.isDecimalDigitUsed() && baseState.getDecimalDigit() != this.getDecimalDigit()) {
            node.addProperty(s_decimalDigit, this.getDecimalDigit());
            nodeExists = true;
        } else if (baseState.isDecimalDigitUsed() != this.isDecimalDigitUsed()) {
            node.addProperty(s_decimalDigitUsed, Utility.getBooleanAsChar((boolean)this.isDecimalDigitUsed()));
            nodeExists = true;
        }
        if (this.isPosNumFmtUsed() && baseState.getPosNumFmt() != this.getPosNumFmt()) {
            node.addProperty(s_posNumFmt, this.getPosNumFmt());
            nodeExists = true;
        } else if (baseState.isPosNumFmtUsed() != this.isPosNumFmtUsed()) {
            node.addProperty(s_posNumFmtUsed, Utility.getBooleanAsChar((boolean)this.isPosNumFmtUsed()));
            nodeExists = true;
        }
        if (this.isNegNumFmtUsed() && baseState.getNegNumFmt() != this.getNegNumFmt()) {
            node.addProperty(s_negNumFmt, this.getNegNumFmt());
            nodeExists = true;
        } else if (baseState.isNegNumFmtUsed() != this.isNegNumFmtUsed()) {
            node.addProperty(s_negNumFmtUsed, Utility.getBooleanAsChar((boolean)this.isNegNumFmtUsed()));
            nodeExists = true;
        }
        if (this.isPosCurFmtUsed() && baseState.getPosCurFmt() != this.getPosCurFmt()) {
            node.addProperty(s_posCurFmt, this.getPosCurFmt());
            nodeExists = true;
        } else if (baseState.isPosCurFmtUsed() != this.isPosCurFmtUsed()) {
            node.addProperty(s_posCurFmtUsed, Utility.getBooleanAsChar((boolean)this.isPosCurFmtUsed()));
            nodeExists = true;
        }
        if (this.isNegCurFmtUsed() && baseState.getNegCurFmt() != this.getNegCurFmt()) {
            node.addProperty(s_negCurFmt, this.getNegCurFmt());
            nodeExists = true;
        } else if (baseState.isNegCurFmtUsed() != this.isNegCurFmtUsed()) {
            node.addProperty(s_negCurFmtUsed, Utility.getBooleanAsChar((boolean)this.isNegCurFmtUsed()));
            nodeExists = true;
        }
        if (this.isScaleFactorUsed() && baseState.getScaleFactor() != this.getScaleFactor()) {
            node.addProperty(s_scaleFactor, this.getScaleFactor());
            nodeExists = true;
        } else if (baseState.isScaleFactorUsed() != this.isScaleFactorUsed()) {
            node.addProperty(s_scaleFactorUsed, Utility.getBooleanAsChar((boolean)this.isScaleFactorUsed()));
            nodeExists = true;
        }
        if (this.isScaleDownThousandsUsed() && !baseState.getScaleDownThousands().equals(this.getScaleDownThousands())) {
            node.addProperty(s_scaleDownThousands, this.getScaleDownThousands());
            nodeExists = true;
        } else if (baseState.isScaleDownThousandsUsed() != this.isScaleDownThousandsUsed()) {
            node.addProperty(s_scaleDownThousandsUsed, Utility.getBooleanAsChar((boolean)this.isScaleDownThousandsUsed()));
            nodeExists = true;
        }
        if (this.isScaleDownMillionsUsed() && !baseState.getScaleDownMillions().equals(this.getScaleDownMillions())) {
            node.addProperty(s_scaleDownMillions, this.getScaleDownMillions());
            nodeExists = true;
        } else if (baseState.isScaleDownMillionsUsed() != this.isScaleDownMillionsUsed()) {
            node.addProperty(s_scaleDownMillionsUsed, Utility.getBooleanAsChar((boolean)this.isScaleDownMillionsUsed()));
            nodeExists = true;
        }
        if (this.isScaleDownBillionsUsed() && !baseState.getScaleDownBillions().equals(this.getScaleDownBillions())) {
            node.addProperty(s_scaleDownBillions, this.getScaleDownBillions());
            nodeExists = true;
        } else if (baseState.isScaleDownBillionsUsed() != this.isScaleDownBillionsUsed()) {
            node.addProperty(s_scaleDownBillionsUsed, Utility.getBooleanAsChar((boolean)this.isScaleDownBillionsUsed()));
            nodeExists = true;
        }
        if (this.isScaleDownTrillionsUsed() && !baseState.getScaleDownTrillions().equals(this.getScaleDownTrillions())) {
            node.addProperty(s_scaleDownTrillions, this.getScaleDownTrillions());
            nodeExists = true;
        } else if (baseState.isScaleDownTrillionsUsed() != this.isScaleDownTrillionsUsed()) {
            node.addProperty(s_scaleDownTrillionsUsed, Utility.getBooleanAsChar((boolean)this.isScaleDownTrillionsUsed()));
            nodeExists = true;
        }
        if (this.isScaleDownQuadrillionsUsed() && !baseState.getScaleDownQuadrillions().equals(this.getScaleDownQuadrillions())) {
            node.addProperty(s_scaleDownQuadrillions, this.getScaleDownQuadrillions());
            nodeExists = true;
        } else if (baseState.isScaleDownQuadrillionsUsed() != this.isScaleDownQuadrillionsUsed()) {
            node.addProperty(s_scaleDownQuadrillionsUsed, Utility.getBooleanAsChar((boolean)this.isScaleDownQuadrillionsUsed()));
            nodeExists = true;
        }
        if (this.isJavaDateFormatUsed() && !baseState.getJavaDateFormat().equals(this.getJavaDateFormat())) {
            node.addProperty(s_javaDateFormat, this.getJavaDateFormat());
            nodeExists = true;
        } else if (baseState.isJavaDateFormatUsed() != this.isJavaDateFormatUsed()) {
            node.addProperty(s_javaDateFormatUsed, Utility.getBooleanAsChar((boolean)this.isJavaDateFormatUsed()));
            nodeExists = true;
        }
        if (this.isOracleDateFormatUsed() && !baseState.getOracleDateFormat().equals(this.getOracleDateFormat())) {
            node.addProperty(s_oracleDateFormat, this.getOracleDateFormat());
            nodeExists = true;
        } else if (baseState.isOracleDateFormatUsed() != this.isOracleDateFormatUsed()) {
            node.addProperty(s_oracleDateFormatUsed, Utility.getBooleanAsChar((boolean)this.isOracleDateFormatUsed()));
            nodeExists = true;
        }
        if (!Utility.compareObj((Object)baseState.getNumberFormatString(), (Object)this.getNumberFormatString())) {
            node.addProperty(s_CustomFormatString, this.getNumberFormatString());
            nodeExists = true;
        }
        return nodeExists ? node : null;
    }

    private String createStringLiteral(String inString) {
        if (inString == null) {
            return null;
        }
        int charCount = inString.length();
        StringBuilder outBuffer = new StringBuilder();
        block8: for (int i = 0; i < charCount; ++i) {
            char currChar = inString.charAt(i);
            switch (currChar) {
                case '\"': 
                case '\'': 
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append(currChar);
                    continue block8;
                }
                case '\b': {
                    outBuffer.append("\\b");
                    continue block8;
                }
                case '\n': {
                    outBuffer.append("\\n");
                    continue block8;
                }
                case '\f': {
                    outBuffer.append("\\f");
                    continue block8;
                }
                case '\t': {
                    outBuffer.append("\\t");
                    continue block8;
                }
                case '\r': {
                    outBuffer.append("\\r");
                    continue block8;
                }
                default: {
                    if (currChar > '\u0fff') {
                        outBuffer.append("\\u" + Integer.toHexString(currChar));
                        continue block8;
                    }
                    if (currChar > '\u00ff') {
                        outBuffer.append("\\u0" + Integer.toHexString(currChar));
                        continue block8;
                    }
                    if (currChar > '\u007f') {
                        outBuffer.append("\\x" + Integer.toHexString(currChar));
                        continue block8;
                    }
                    outBuffer.append(currChar);
                }
            }
        }
        return outBuffer.toString();
    }

    protected final Object getExternalDefault(String attributeName) {
        Map<Object, Object> context;
        if (this.m_view instanceof CommonDataview && (context = ((CommonDataview)this.m_view).getContext()) != null) {
            return context.get(attributeName);
        }
        return super.getExternalDefault(attributeName);
    }
}

