/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.pivot.PageItem;
import oracle.bali.ewt.pivot.PagingPivotEvent;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dss.dataView.BaseTitle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerAdapter;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.NonDataComponentHandle;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.gauge.Gauge;
import oracle.dss.gauge.GaugeController;
import oracle.dss.gauge.GaugeModel;
import oracle.dss.pagingControl.PageItemComponentHandle;
import oracle.dss.pagingControl.PagingComponent;
import oracle.dss.util.DataException;

public class GaugeControllerAdapter
extends ControllerAdapter
implements GaugeController,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    protected Gauge m_gauge = null;
    protected GaugeModel m_model = null;
    protected int m_selectedComponentHandle = -1;
    protected int m_currentComponentHandle;
    protected boolean m_isCursorOnResizeHandle;
    protected int m_resizeCursorValue;
    protected ComponentHandle m_currentHandle = null;
    protected ComponentHandle m_selectedObject = null;
    protected Cursor m_cursor = null;
    private boolean _m_selectingPageItem = false;

    public GaugeControllerAdapter(Gauge gauge, GaugeModel gaugeModel) {
        super(gauge);
        this.m_gauge = gauge;
        this.m_model = gaugeModel;
        this.m_isCursorOnResizeHandle = false;
        gauge.getPagingControl().addKeyListener(this);
        gauge.getPagingControl().addMouseListener(this);
        gauge.getPagingControl().addMouseMotionListener(this);
        gauge.getPagingControl().addFocusListener(this);
        gauge.getPagingControl().getPagingComponent().addPropertyChangeListener(this);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.processViewKeyEvent(e, null);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.processViewKeyEvent(e, null);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.processViewKeyEvent(e, null);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.processViewMouseEvent(e, null);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseEvent = e;
        if (e.getSource() instanceof ViewComponent) {
            final NonDataComponentHandle c = this.getNonDataComponent((ViewComponent)e.getSource());
            if (c.getID() == 6 || c.getID() == 7 || c.getID() == 8) {
                Component comp = (Component)e.getSource();
                if (!comp.isFocusable()) {
                    Component rootComponent = SwingUtilities.getRoot(comp);
                    rootComponent.requestFocus();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GaugeControllerAdapter.this.setSelectedObject(c);
                    }
                });
            }
            this.processViewMouseEvent(e, c);
        } else {
            boolean selected = this.m_gauge.selectObjectFromEvent(e);
            if (selected) {
                this.processViewMouseEvent(e, this.m_gauge.getSelectedObject());
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.processViewMouseEvent(e, null);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.processViewMouseEvent(e, null);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.processViewMouseEvent(e, null);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.processViewMouseMotionEvent(e, null);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.processViewMouseMotionEvent(e, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pivot(PagingPivotEvent e) {
        int flags = 0;
        try {
            int sourceIndex = e.getSourceIndex();
            int destinationIndex = e.getDestinationIndex();
            flags = sourceIndex < destinationIndex ? 3 : 2;
            this.setCursor(WindowUtils.getWindow((Component)this.m_gauge), this.getCursorType(2));
            if (this.m_gauge.getGaugeModel().getControllerActions().canPivot(this.m_gauge, 2, 2, sourceIndex, destinationIndex, flags)) {
                this.m_gauge.getGaugeModel().getControllerActions().pivotGestureHappened(this.m_gauge, 2, 2, sourceIndex, destinationIndex, flags);
            }
        }
        catch (DataException exception) {
            this.m_gauge.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "pivot");
        }
        finally {
            this.setCursor(WindowUtils.getWindow((Component)this.m_gauge), this.getCursorType(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swap(PagingPivotEvent e) {
        try {
            int sourceIndex = e.getSourceIndex();
            int destinationIndex = e.getDestinationIndex();
            this.setCursor(WindowUtils.getWindow((Component)this.m_gauge), this.getCursorType(2));
            if (this.m_gauge.getGaugeModel().getControllerActions().canPivot(this.m_gauge, 2, 2, sourceIndex, destinationIndex, 1)) {
                this.m_gauge.getGaugeModel().getControllerActions().pivotGestureHappened(this.m_gauge, 2, 2, sourceIndex, destinationIndex, 1);
            }
        }
        catch (DataException exception) {
            this.m_gauge.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "swap");
        }
        finally {
            this.setCursor(WindowUtils.getWindow((Component)this.m_gauge), this.getCursorType(0));
        }
    }

    protected void setCursor(Component component, Cursor c) {
        component.setCursor(c);
        if (component instanceof Container) {
            Container cont = (Container)component;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this.setCursor(cont.getComponent(i), c);
            }
        }
    }

    private static final void selectPageItem(Dataview view, long pi) {
        if (view.getPagingControl() != null && view.getPagingControl().getPagingComponent() != null && pi >= 0L) {
            view.getPagingControl().getPagingComponent().setSelectedItem(view.getPagingControl().getPagingComponent().getItem((int)pi));
        }
    }

    @Override
    public void setSelectedObject(ComponentHandle c) {
        this.m_selectedObject = c;
        this._m_selectingPageItem = true;
        this.changeTitleSelectedState(false);
        if (c != null && c.getComponent() instanceof BaseTitle) {
            ((BaseTitle)c.getComponent()).setSelected(true);
            this.fireComponentSelected(this.m_gauge, c);
        } else if (c instanceof PageItemComponentHandle) {
            PageItemComponentHandle pid = (PageItemComponentHandle)c;
            GaugeControllerAdapter.selectPageItem(this.m_gauge, pid.getPageItem());
            this.fireComponentSelected(this.m_gauge, c);
        }
        this._m_selectingPageItem = false;
    }

    @Override
    public ComponentHandle getSelectedObject() {
        return this.m_selectedObject;
    }

    @Override
    public void setCursorType(Cursor c, int type) {
        if (this.m_cursor != null && this.m_cursor.equals(this.getCursorType(type))) {
            this.m_cursor = c;
        }
        if (type < 0 || type > 16) {
            this.m_gauge.getErrorHandler().log("invalid cursor type", this.getClass().getName(), "setCursorType(Cursor c, int type)");
        } else {
            super.setCursorType(c, type);
        }
    }

    @Override
    public void setWaitCursorForced(boolean yesNo) {
        super.setWaitCursorForced(yesNo);
        this.setGaugeCursor(this.m_currentComponentHandle);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        PageItem pi;
        PagingComponent dpc;
        int index;
        if (!this._m_selectingPageItem && pce.getSource() instanceof PagingComponent && pce.getPropertyName() == "selectedIndex" && (index = (dpc = (PagingComponent)pce.getSource()).getIndex(pi = dpc.getSelectedItem())) != -1) {
            this.m_gauge.selectObject(new PageItemComponentHandle(4, "PageItem", dpc, index));
        }
    }

    public void setGaugeCursor(int id) {
        if (this.m_isWaitCursor) {
            if (!this.m_cursor.equals(this.m_waitCursor)) {
                this.m_cursor = this.m_waitCursor;
            }
            return;
        }
        if (this.m_cursor == null || !this.m_cursor.equals(this.m_defaultCursor)) {
            this.m_cursor = this.m_defaultCursor;
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_gauge.getPagingControl().removeKeyListener(this);
        this.m_gauge.getPagingControl().removeMouseListener(this);
        this.m_gauge.getPagingControl().removeMouseMotionListener(this);
        this.m_gauge.getPagingControl().removeFocusListener(this);
    }
}

