/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DVTResources;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.ImageViewExportXMLWriter;
import oracle.dss.dataView.NonDataComponentHandle;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.gauge.CommonGauge;
import oracle.dss.gauge.CustomShapesParser;
import oracle.dss.gauge.CustomToolTipCallback;
import oracle.dss.gauge.DialGauge;
import oracle.dss.gauge.DrawableObject;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.GaugeExportXMLWriter;
import oracle.dss.gauge.GaugeLayout;
import oracle.dss.gauge.GaugeRenderer;
import oracle.dss.gauge.GaugeSVGWriter;
import oracle.dss.gauge.GaugeType;
import oracle.dss.gauge.Graphics2DRenderer;
import oracle.dss.gauge.LEDGauge;
import oracle.dss.gauge.LabelGauge;
import oracle.dss.gauge.StatusMeterGauge;
import oracle.dss.gauge.ThresholdComponentHandle;
import oracle.dss.gauge.VennGauge;
import oracle.dss.gauge.VerticalStatusMeterGauge;
import oracle.dss.graph.ImagemapComponent;
import oracle.dss.presutil.PresUtils;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.format.DvtNumberConverter;

public class GaugeEngine {
    protected static final int DEFAULT_OBJECTLIST_SIZE = 15;
    public static int BORDER_ONLY = 1;
    public static int FILL_ONLY = 2;
    public static int FILL_AND_BORDER = 3;
    private GaugeType _gaugeType;
    private ArrayList _objList;
    private String _id;
    private Map _map;
    private Graphics2D _graphics;
    private ErrorHandler _eh;
    private ResourceBundle _gaugeBundle;
    private ResourceBundle _utilBundle;
    private Locale m_locale = null;
    private CustomShapesParser _csParser;
    protected Shape _gaugeSetClip;
    private double _min = 0.0;
    private double _max = 0.0;
    private boolean _isNullMetric = false;
    private Double[] _metric = null;
    private double _metricMin = 0.0;
    private double _metricMax = 0.0;
    private double _incr = 0.0;
    private double _minorIncr = 0.0;
    private int _numberOfSteps = 0;
    private int _minorNumberOfSteps = 0;
    private int _maxNumberOfSteps = 0;
    private Rectangle _outerBounds = null;
    private Rectangle _innerBounds = null;
    private Dimension _requiredSize = null;
    private DVTResources m_dvtResources = null;
    private int _maxNumSteps = 0;
    protected static double ASCENT_TEXT_HEIGHT = 0.7;
    private int _recalcState = 1;
    private static final int RECALC_STATE_READY = 0;
    private static final int RECALC_STATE_ALL = 1;
    private static final String _method_prepareObjects = "prepareObjects";
    private static final String _method_render = "render";
    private ViewFormat m_defTickLabelViewFormat = null;
    private ViewFormat m_defMetricLabelViewFormat = null;
    private static final int MAX_NUMBER_OF_GRIDS = 100;
    private static final int MAX_NUMBER_OF_MINOR_GRIDS = 500;
    private CommonGauge m_gauge = null;
    private int LABEL_COLLISION_FUDGE_FACTOR = 2;

    public GaugeEngine(Map propMap) {
        this(propMap, 0);
    }

    public GaugeEngine(Map propMap, int gaugeType, CommonGauge gauge) {
        this(propMap, gaugeType);
        this.m_gauge = gauge;
    }

    public GaugeEngine(Map propMap, int gaugeType) {
        this._map = propMap;
        if (this.m_defTickLabelViewFormat == null) {
            this.m_defTickLabelViewFormat = new ViewFormat();
        }
        if (this.m_defMetricLabelViewFormat == null) {
            this.m_defMetricLabelViewFormat = new ViewFormat();
        }
        Locale locale = (Locale)this._map.get("Locale");
        this.setLocale(locale);
        this._gaugeType = gaugeType == 1 ? new StatusMeterGauge(this) : (gaugeType == 2 ? new LEDGauge(this) : (gaugeType == 3 ? new VennGauge(this) : (gaugeType == 4 ? new VerticalStatusMeterGauge(this) : (gaugeType == 5 ? new LabelGauge(this) : new DialGauge(this)))));
        this._validateMinMax();
        for (int index = 0; index < this.getMetricSize(); ++index) {
            if ((this._map.get("ThresholdValues") == null || GaugeEngine.getIndicatorAttr(this._map, "IndicatorType", index) == null || (Integer)GaugeEngine.getIndicatorAttr(this._map, "IndicatorType", index) != 1) && this._gaugeType instanceof DialGauge) continue;
            GaugeEngine.putIndicatorAttr(this._map, "IndicatorType", GaugeDefaultValues.getIndicatorType(), index);
        }
    }

    public ErrorHandler getErrorHandler() {
        return this._eh;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this._eh = eh;
    }

    protected String getId() {
        return this._id;
    }

    protected void setId(String id) {
        this._id = id;
    }

    public String getIntlString(String key, ResourceBundle bundle) {
        String strTemp;
        if (this.m_dvtResources != null && this.m_dvtResources.getResourceString(key) != null) {
            return this.m_dvtResources.getResourceString(key);
        }
        if (bundle == null) {
            return key;
        }
        try {
            strTemp = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            this.getErrorHandler().log("missing resource \"" + key + "\" in " + bundle.getClass().getName(), this.getClass().getName(), "getIntlString(String key, ResourceBundle bundle)");
            return key;
        }
        return strTemp;
    }

    public String getIntlStringFromUtilBundle(String key) {
        return this.getIntlString(key, this._utilBundle);
    }

    public String getErrorIntlString(String key) {
        return this._gaugeBundle.getString(key);
    }

    public void setDVTResources(DVTResources res) {
        this.m_dvtResources = res;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale loc) {
        this.m_locale = loc;
        this.updateResourceBundle();
        if (loc != null) {
            if (this.m_defTickLabelViewFormat != null) {
                this.m_defTickLabelViewFormat.setLocale(this.m_locale);
            }
            if (this.m_defMetricLabelViewFormat != null) {
                this.m_defMetricLabelViewFormat.setLocale(this.m_locale);
            }
            if (this._gaugeType != null) {
                this._gaugeType.setLocale(loc);
            }
        }
    }

    public boolean isBIDILocale() {
        Locale loc = this.getLocale();
        if (loc != null) {
            String language = loc.getLanguage();
            return language.equals("ar") || language.equals("he") || language.equals("iw");
        }
        return false;
    }

    protected void updateResourceBundle() {
        try {
            if (this.m_locale != null) {
                this._gaugeBundle = ResourceBundle.getBundle("oracle.dss.gauge.resource.GaugeBundle", this.m_locale);
                this._utilBundle = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle", this.m_locale);
            } else {
                this._gaugeBundle = ResourceBundle.getBundle("oracle.dss.gauge.resource.GaugeBundle");
                this._utilBundle = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle");
            }
        }
        catch (MissingResourceException e) {
            this._gaugeBundle = null;
            this._utilBundle = null;
        }
    }

    public Object getAttribute(String name) {
        if (this._map == null) {
            return null;
        }
        return this._map.get(name);
    }

    public void setAttribute(String name, Object value) {
        if (this._map == null) {
            this._map = this._createHashMap();
        }
        this._map.put(name, value);
        this._setRecalcState(1);
    }

    public Dimension calcGaugeSize(Graphics2D g, Dimension maxSize) {
        Rectangle rect = new Rectangle(0, 0, maxSize.width, maxSize.height);
        this.autoLayout(g, rect);
        this._updateSteps();
        ViewFormat viewFmt = (ViewFormat)((Object)this._map.get("TickLabelViewFormat"));
        if (viewFmt == null || !viewFmt.isScaleFactorUsed() || !viewFmt.isDecimalDigitUsed()) {
            this.determineFormat(false);
        }
        if ((viewFmt = (ViewFormat)((Object)this._map.get("MetricLabelViewFormat"))) == null || !viewFmt.isScaleFactorUsed() || !viewFmt.isDecimalDigitUsed()) {
            this.determineFormat(true);
        }
        this._maxNumSteps = this.getMaxNumberOfSteps();
        this._requiredSize = this.autoLayout(g, rect);
        return this._requiredSize;
    }

    public String getToolTipText(Point pt) {
        String[] tooltips = null;
        if (this._objList != null && !this._objList.isEmpty()) {
            for (int objIndex = this._objList.size() - 1; objIndex >= 0; --objIndex) {
                DrawableObject obj = (DrawableObject)this._objList.get(objIndex);
                if (obj == null) continue;
                int compType = obj.getComponentType();
                int compIndex = obj.getComponentIndex();
                if (this._gaugeType instanceof DialGauge && compType == 11 && obj instanceof DrawableObject.Shape && ((DrawableObject.Shape)obj).getShape() instanceof Arc2D && ((DrawableObject.Shape)obj).getFillColor() == null || obj instanceof DrawableObject.Shape && ((DrawableObject.Shape)obj).getShape() instanceof Rectangle && ((DrawableObject.Shape)obj).getFillColor() == null || !obj.contains(pt.x, pt.y, false)) continue;
                switch (compType) {
                    case 13: {
                        tooltips = new String[]{"TickMark"};
                        break;
                    }
                    case 12: 
                    case 16: 
                    case 17: 
                    case 18: {
                        if (obj instanceof DrawableObject.Label) {
                            String lblText = ((DrawableObject.Label)obj).getTruncatedText();
                            if (lblText != null) {
                                tooltips = new String[]{((DrawableObject.Label)obj).getText()};
                                break;
                            }
                            tooltips = null;
                            break;
                        }
                        tooltips = null;
                        break;
                    }
                    case 11: 
                    case 14: 
                    case 15: 
                    case 19: 
                    case 20: 
                    case 21: {
                        tooltips = this._getPNGToolTipText(1, compType, compIndex);
                    }
                }
                break;
            }
        }
        return this._buildTooltipString(tooltips);
    }

    public boolean render(Graphics2D g) {
        boolean retCode = true;
        this.prepareObjects(g);
        Graphics2DRenderer renderer = new Graphics2DRenderer(g, this.getErrorHandler());
        retCode = this._renderObjList(renderer);
        return retCode;
    }

    public boolean render(Graphics2D g, GaugeSVGWriter writer, int mode) {
        boolean retCode = true;
        this.setGraphics(g);
        writer.setSvgMode(mode);
        retCode = this._renderObjList(writer);
        return retCode;
    }

    public boolean render(Graphics2D g, GaugeExportXMLWriter writer, int mode) {
        boolean retCode = true;
        if (this._map.get("LEDStyle") != null && (Integer)this._map.get("LEDStyle") == 1 && this._map.get("LEDStyleCallback") == null) {
            this._map.put("LEDStyle", new Integer(GaugeDefaultValues.getLEDStyle()));
        }
        this.setGraphics(g);
        writer.init(this);
        retCode = this._renderObjList(writer);
        return retCode;
    }

    public Graphics2D getGraphics() {
        return this._graphics;
    }

    private void setGraphics(Graphics2D g) {
        if (this._graphics == null && g == null || this._graphics == g) {
            return;
        }
        if (g == null) {
            this._graphics.dispose();
            this._graphics = null;
            return;
        }
        this._graphics = g;
        Rectangle clipBounds = this._graphics.getClipBounds();
        if (this._outerBounds == null || this._outerBounds.width != clipBounds.width || this._outerBounds.height != clipBounds.height) {
            this._setRecalcState(1);
        }
    }

    protected Rectangle getOuterBounds() {
        return this._outerBounds;
    }

    protected void setBackgroundClip(Shape clipShape) {
        this._gaugeSetClip = clipShape;
    }

    public int selectObject(Point pt) {
        int retType = -1;
        if (this._objList != null && !this._objList.isEmpty()) {
            int foundType = -1;
            boolean found = false;
            for (int objIndex = this._objList.size() - 1; objIndex >= 0; --objIndex) {
                DrawableObject obj = (DrawableObject)this._objList.get(objIndex);
                if (obj == null) continue;
                if (found) {
                    obj.setSelected(foundType == obj.getComponentType());
                    continue;
                }
                if (this._gaugeType instanceof DialGauge && obj.getComponentType() == 11 && obj instanceof DrawableObject.Shape && ((DrawableObject.Shape)obj).getShape() instanceof Arc2D && ((DrawableObject.Shape)obj).getFillColor() == null || obj instanceof DrawableObject.Shape && ((DrawableObject.Shape)obj).getShape() instanceof Rectangle && ((DrawableObject.Shape)obj).getFillColor() == null || !(found = obj.contains(pt.x, pt.y, false))) continue;
                obj.setSelected(true);
                foundType = obj.getComponentType();
                objIndex = this._objList.size() - 1;
            }
            if (found) {
                retType = foundType;
            }
        }
        return retType;
    }

    public boolean setSelectedObject(int type) {
        if (this._objList != null && !this._objList.isEmpty()) {
            for (int objIndex = 0; objIndex < this._objList.size(); ++objIndex) {
                DrawableObject obj = (DrawableObject)this._objList.get(objIndex);
                if (obj == null) {
                    int column;
                    int row;
                    if (this._map == null) {
                        row = -1;
                        column = -1;
                    } else {
                        Object rowObj = this._map.get("DS_ROW");
                        row = rowObj != null ? Integer.parseInt((String)rowObj) : -1;
                        Object colObj = this._map.get("DS_COLUMN");
                        column = colObj != null ? Integer.parseInt((String)colObj) : -1;
                    }
                    this._eh.log("Attempt made to process null DrawableObject on gauge " + row + "," + column, this.getClass().getName(), _method_render);
                }
                obj.setSelected(type == obj.getComponentType());
            }
            return true;
        }
        return false;
    }

    public static Rectangle trimRectToText(Graphics2D g, Font font, int x, int y, int width, int height) {
        FontMetrics fm = ImageViewExportXMLWriter.getFontMetrics(g, font);
        int baseline = y + (fm.getHeight() - fm.getDescent());
        int newHeight = (int)((double)fm.getAscent() * ASCENT_TEXT_HEIGHT);
        return new Rectangle(x, baseline - newHeight, width - 1, newHeight);
    }

    public Enumeration getImagemapEnumeration(Graphics2D g, int filter) {
        Boolean isScreenReader;
        if (this._getRecalcState() != 0) {
            this.prepareObjects(g);
        }
        Vector<ImagemapComponent> mapComps = new Vector<ImagemapComponent>(15);
        Vector<ImagemapComponent> imgComp = null;
        imgComp = this._createImagemapComponents(filter);
        if (imgComp != null) {
            mapComps.addAll(imgComp);
        }
        if ((isScreenReader = (Boolean)this._map.get("adaScreenReaderMode")) != null && isScreenReader.booleanValue() && (imgComp = this._createGaugeImagemapComponent()) != null) {
            mapComps.addAll(imgComp);
        }
        return mapComps.elements();
    }

    protected static String getCompNameForImagemapEnumeration(int compType) {
        switch (compType) {
            case 14: {
                return "Indicator";
            }
            case 30: {
                return "IndicatorBase";
            }
            case 12: {
                return "TickLabel";
            }
            case 16: {
                return "TopLabel";
            }
            case 17: {
                return "BottomLabel";
            }
            case 18: {
                return "MetricLabel";
            }
            case 13: {
                return "TickMark";
            }
            case 11: {
                return "PlotArea";
            }
            case 27: {
                return "LegendArea";
            }
            case 28: {
                return "LegendText";
            }
            case 9: {
                return "Gauge";
            }
            case 15: {
                return "Threshold";
            }
        }
        return null;
    }

    protected Dimension autoLayout(Graphics2D g, Rectangle rect) {
        if (this._outerBounds == null) {
            this._outerBounds = new Rectangle(rect);
        }
        Dimension reqSize = this._gaugeType.autoLayout(g, rect, this._map);
        this._innerBounds = this._gaugeType._innerBounds;
        return reqSize;
    }

    protected boolean prepareObjects(Graphics2D g) {
        Rectangle clip;
        this.setGraphics(g);
        if (this._getRecalcState() == 0) {
            return true;
        }
        if (this._objList != null) {
            this._objList.clear();
        }
        boolean metricAvailable = true;
        if (this._map.get("Metric") == null) {
            metricAvailable = false;
        }
        Double min = (Double)this._map.get("minValue");
        Double max = (Double)this._map.get("maxValue");
        if (metricAvailable) {
            for (int i = 0; i < this.getMetricSize(); ++i) {
                if (this.getMetric(i) == null) continue;
                if (min != null && this.getMetric(i) < min) {
                    this.getErrorHandler().log(this.getErrorIntlString("22002"), this.getClass().getName(), _method_prepareObjects);
                }
                if (max == null || !(this.getMetric(i) > max)) continue;
                this.getErrorHandler().log(this.getErrorIntlString("22001"), this.getClass().getName(), _method_prepareObjects);
            }
        }
        if ((clip = g.getClipBounds()) == null) {
            clip = new Rectangle(0, 0, 200, 150);
        }
        this._outerBounds = clip;
        this._gaugeType._layout = new GaugeLayout(new Dimension(clip.width, clip.height));
        this._addToDrawableList(this._gaugeType.getBackgroundObject(this._map, this._outerBounds, this._gaugeSetClip));
        this.autoLayout(g, clip);
        this._updateSteps();
        this.prepareViewFormats();
        Boolean drawRaised = (Boolean)this._map.get("GaugeFrameVisible");
        if (drawRaised == null) {
            drawRaised = GaugeDefaultValues.isGaugeFrameVisible();
        }
        if (drawRaised.booleanValue()) {
            this._addToDrawableList(this._gaugeType.getGaugeFrameObject(this._map));
        }
        int numberOfMetric = this.getMetricSize();
        boolean isFillTypeExist = false;
        for (int index = 0; index < numberOfMetric; ++index) {
            Integer indicatorType = (Integer)GaugeEngine.getIndicatorAttr(this._map, "IndicatorType", index);
            if (indicatorType == null || indicatorType != 1 || !(this._gaugeType instanceof DialGauge)) continue;
            isFillTypeExist = true;
            break;
        }
        if (isFillTypeExist) {
            this._addToDrawableList(this._gaugeType.getPlotAreaObject(this._map, FILL_ONLY));
        } else {
            this._addToDrawableList(this._gaugeType.getPlotAreaObject(this._map, FILL_AND_BORDER));
        }
        if (numberOfMetric == 0) {
            this._addToDrawableList(this._gaugeType.getIndicatorObject(this._map, 0));
        }
        for (int type = 0; type < 3; ++type) {
            for (int index = 0; index < numberOfMetric; ++index) {
                Integer indicatorType = (Integer)GaugeEngine.getIndicatorAttr(this._map, "IndicatorType", index);
                if (indicatorType == null || !(this._gaugeType instanceof DialGauge)) {
                    indicatorType = GaugeDefaultValues.getIndicatorType();
                }
                if (this.getMetric(index) == null || !(type == 0 && indicatorType == 1 || type == 1 && indicatorType == 2) && (type != 2 || indicatorType != 0)) continue;
                this._addToDrawableList(this._gaugeType.getIndicatorObject(this._map, index));
            }
        }
        if (this._gaugeType instanceof DialGauge) {
            this._addToDrawableList(((DialGauge)this._gaugeType).getIndicatorBaseObject(this._map));
        }
        if (isFillTypeExist) {
            this._addToDrawableList(this._gaugeType.getPlotAreaObject(this._map, BORDER_ONLY));
        }
        this._addToDrawableList(this._gaugeType.getTickMarkObjects(this._map));
        this._addToDrawableList(this._gaugeType.getLabelObjects(this._map, this._outerBounds));
        this._addToDrawableList(this._gaugeType.getTickLabelObjects(this._map));
        this._addToDrawableList(this._gaugeType.getOverlayEffectObjects(this._map));
        if (this._map.get("Link") != null) {
            this._addToDrawableList(this._gaugeType.getGaugeLinkObject(this._map, this._outerBounds));
        }
        this._setRecalcState(0);
        return true;
    }

    protected void prepareViewFormats() {
        ViewFormat viewFmt = (ViewFormat)((Object)this._map.get("TickLabelViewFormat"));
        if (viewFmt != null && viewFmt.getNumberConverter() instanceof DvtNumberConverter && this.m_defTickLabelViewFormat.getNumberConverter() == null) {
            this.m_defTickLabelViewFormat = viewFmt;
        }
        if (viewFmt == null || !viewFmt.isScaleFactorUsed() || !viewFmt.isDecimalDigitUsed()) {
            this.determineFormat(false);
        }
        if ((viewFmt = (ViewFormat)((Object)this._map.get("MetricLabelViewFormat"))) != null && viewFmt.getNumberConverter() instanceof DvtNumberConverter && this.m_defMetricLabelViewFormat.getNumberConverter() == null) {
            this.m_defMetricLabelViewFormat = viewFmt;
        }
        if (viewFmt == null || !viewFmt.isScaleFactorUsed() || !viewFmt.isDecimalDigitUsed()) {
            this.determineFormat(true);
        }
    }

    protected void setCustomShapesParser(CustomShapesParser parser) {
        this._csParser = parser;
        this._gaugeType.setCustomShapesParser(this._csParser);
    }

    private Vector<ImagemapComponent> _createGaugeImagemapComponent() {
        String text;
        Vector<ImagemapComponent> imgComp = new Vector<ImagemapComponent>();
        String[] tooltips = null;
        int compType = 9;
        String compName = GaugeEngine.getCompNameForImagemapEnumeration(9);
        int[] xpts = new int[]{this._outerBounds.x, this._outerBounds.x, this._outerBounds.x + this._outerBounds.width, this._outerBounds.x + this._outerBounds.width};
        int[] ypts = new int[]{this._outerBounds.y, this._outerBounds.y + this._outerBounds.height, this._outerBounds.y + this._outerBounds.height, this._outerBounds.y};
        Polygon poly = new Polygon(xpts, ypts, xpts.length);
        StringBuilder sb = new StringBuilder();
        int numberOfMetrics = this.getMetricSize();
        numberOfMetrics = numberOfMetrics == 0 ? 1 : numberOfMetrics;
        for (int metricIndex = 0; metricIndex < numberOfMetrics; ++metricIndex) {
            sb.append("Gauge value: ");
            sb.append(this.formatValue(this.getMetric(metricIndex), "MetricLabelViewFormat"));
            text = this._getMetricThresholdText(metricIndex);
            if (text == null) continue;
            sb.append(", ");
            sb.append(text);
        }
        text = this.getTopLabel();
        if (text != null) {
            sb.append(", top label: ");
            sb.append(text);
        }
        if ((text = this.getBottomLabel()) != null) {
            sb.append(", bottom label: ");
            sb.append(text);
        }
        sb.append(this._getThresholdsText());
        tooltips = new String[]{sb.toString()};
        imgComp.add(new ImagemapComponent(new NonDataComponentHandle(compType, compName, null), poly, tooltips));
        return imgComp;
    }

    private Vector<ImagemapComponent> _createImagemapComponents(int filter) {
        Vector<ImagemapComponent> imgComp = new Vector<ImagemapComponent>();
        Object tooltips = null;
        Polygon poly = null;
        for (int objIndex = this._objList.size() - 1; objIndex >= 0; --objIndex) {
            CustomToolTipCallback customToolTipCallback;
            boolean bScreenReader;
            poly = null;
            tooltips = null;
            DrawableObject obj = (DrawableObject)this._objList.get(objIndex);
            if (obj == null) {
                int row = this._getRow();
                int column = this._getColumn();
                this._eh.log("Attempt made to process null DrawableObject on gauge " + row + "," + column, this.getClass().getName(), _method_render);
                continue;
            }
            int compType = obj.getComponentType();
            if (compType == 30) {
                compType = 11;
            }
            int index = obj.getComponentIndex();
            boolean needsImagemap = false;
            if ((filter & 0x20) != 0) {
                if (compType == 16) {
                    needsImagemap = true;
                } else if (compType == 17) {
                    needsImagemap = true;
                } else if (compType == 18) {
                    needsImagemap = true;
                }
            }
            if ((filter & 1) != 0 && (compType == 11 || compType == 14 || compType == 15)) {
                needsImagemap = true;
            }
            if (!needsImagemap) continue;
            poly = GaugeEngine._processImagemapPolygon(obj);
            String compName = GaugeEngine.getCompNameForImagemapEnumeration(compType);
            ComponentHandle componentID = null;
            componentID = compType == 16 || compType == 17 || compType == 18 || compType == 19 || compType == 20 || compType == 21 || compType == 11 ? new DataComponentHandle(compType, compName, null, this._getRow(), this._getColumn()) : (compType == 14 ? new DataComponentHandle(compType, compName, null, GaugeEngine.getIndicatorRow(this._map, index), GaugeEngine.getIndicatorColumn(this._map, index)) : (compType == 15 ? new ThresholdComponentHandle(compType, compName, null, index, GaugeEngine.getThresholdRow(this._map, index), GaugeEngine.getThresholdColumn(this._map, index)) : new NonDataComponentHandle(compType, compName, null)));
            Boolean isScreenReader = (Boolean)this._map.get("adaScreenReaderMode");
            boolean bl = bScreenReader = isScreenReader != null && isScreenReader != false;
            if (!(compType != 11 && compType != 14 && compType != 15 && compType != 17 && compType != 16 || bScreenReader)) {
                tooltips = this._getPNGToolTipText(17, compType, index);
            }
            if (poly == null) continue;
            if (this.m_gauge != null && (customToolTipCallback = this.m_gauge.getCustomToolTipCallback()) != null) {
                String defaultTooltip = this._buildTooltipString((String[])tooltips);
                String tooltipText = customToolTipCallback.getToolTipText(defaultTooltip, componentID);
                tooltips = tooltipText == null ? null : new String[]{tooltipText};
            }
            imgComp.add(new ImagemapComponent(componentID, poly, (String[])tooltips));
        }
        return imgComp;
    }

    protected static Polygon _processImagemapPolygon(DrawableObject obj) {
        Polygon poly = null;
        if (obj instanceof DrawableObject.Label) {
            poly = PresUtils.rectToPoly(((DrawableObject.Label)obj).getBounds());
        } else if (obj instanceof DrawableObject.Shape && ((DrawableObject.Shape)obj).getShape() instanceof Line2D) {
            Line2D line = (Line2D)((DrawableObject.Shape)obj).getShape();
            poly = PresUtils.lineToPoly(line);
        } else if (obj instanceof DrawableObject.Shape && (((DrawableObject.Shape)obj).getShape() instanceof Rectangle2D || ((DrawableObject.Shape)obj).getShape() instanceof RoundRectangle2D)) {
            poly = PresUtils.rectToPoly(((DrawableObject.Shape)obj).getShape().getBounds());
        } else if (obj instanceof DrawableObject.Shape) {
            Shape s = ((DrawableObject.Shape)obj).getShape();
            poly = PresUtils.shapeToPoly(s);
        }
        return poly;
    }

    private int _getRow() {
        int row = this._map == null ? -1 : (this._map.get("Metric_row") != null ? ((Integer)this._map.get("Metric_row")).intValue() : ((Integer)this._map.get("DS_ROW")).intValue());
        return row;
    }

    private int _getColumn() {
        int column = this._map == null ? -1 : (this._map.get("Metric_col") != null ? ((Integer)this._map.get("Metric_col")).intValue() : ((Integer)this._map.get("DS_COLUMN")).intValue());
        return column;
    }

    protected static int getIndicatorRow(Map map, int index) {
        int row = -1;
        if (map == null) {
            return row;
        }
        Integer[] rows = (Integer[])map.get("RowForIndex");
        if (index < 0) {
            index = 0;
        }
        row = rows != null && index < rows.length ? rows[index] : (map.get("Metric_row") != null ? ((Integer)map.get("Metric_row")).intValue() : ((Integer)map.get("DS_ROW")).intValue());
        return row;
    }

    protected static int getIndicatorColumn(Map map, int index) {
        int column = -1;
        if (map == null) {
            return column;
        }
        Integer[] cols = (Integer[])map.get("ColForIndex");
        if (index < 0) {
            index = 0;
        }
        column = cols != null && index < cols.length ? cols[index] : (map.get("Metric_col") != null ? ((Integer)map.get("Metric_col")).intValue() : ((Integer)map.get("DS_COLUMN")).intValue());
        return column;
    }

    protected static int getThresholdRow(Map map, int index) {
        Integer[] rows;
        int row = -1;
        if (map == null) {
            return row;
        }
        if (index < 0) {
            index = 0;
        }
        if ((rows = (Integer[])map.get("RowForThresholdIndex")) != null && index < rows.length && rows[index] != null) {
            row = rows[index];
        }
        return row;
    }

    protected static int getThresholdColumn(Map map, int index) {
        Integer[] cols;
        int column = -1;
        if (map == null) {
            return column;
        }
        if (index < 0) {
            index = 0;
        }
        if ((cols = (Integer[])map.get("ColForThresholdIndex")) != null && index < cols.length && cols[index] != null) {
            column = cols[index];
        }
        return column;
    }

    protected String[] _getFlashToolTipText(int filter, int compType, int compIndex) {
        return this._getToolTipText(filter, true, compType, compIndex);
    }

    protected String[] _getPNGToolTipText(int filter, int compType, int compIndex) {
        return this._getToolTipText(filter, false, compType, compIndex);
    }

    private String[] _getToolTipText(int filter, boolean isFlashFormat, int compType, int compIndex) {
        String[] tooltips = null;
        if (this._gaugeType.getGaugeType() == 3) {
            tooltips = this._getVennTooltips(filter);
        } else {
            Object position = null;
            if (compType == 11) {
                tooltips = this.getPlotAreaToolTip(filter, isFlashFormat);
            } else if (compType == 14) {
                tooltips = compIndex >= 0 ? this.getIndicatorToolTip(filter, compIndex, isFlashFormat) : this.getPlotAreaToolTip(filter, isFlashFormat);
            } else if (compType == 15) {
                if (compIndex >= 0) {
                    tooltips = new String[]{this.getThresholdToolTipByIndex(compIndex, true)};
                }
            } else if (compType == 16) {
                String topLabel = this._gaugeType.getTopLabelToolTip();
                if (topLabel != null) {
                    tooltips = new String[]{topLabel};
                }
            } else if (compType == 17) {
                String bottomLabel = this._gaugeType.getBottomLabelToolTip();
                if (bottomLabel != null) {
                    tooltips = new String[]{bottomLabel};
                }
            } else {
                tooltips = null;
            }
        }
        return tooltips;
    }

    private String[] getPlotAreaToolTip(int filter, boolean isFlashFormat) {
        int numberOfMetric;
        ArrayList<String> toolTipList = new ArrayList<String>();
        String topLabel = this.getTopLabel();
        if ((filter & 0x10) != 0 && topLabel != null) {
            toolTipList.add(topLabel);
        }
        numberOfMetric = (numberOfMetric = this.getMetricSize()) == 0 ? 1 : numberOfMetric;
        for (int metricIndex = 0; metricIndex < numberOfMetric; ++metricIndex) {
            String rowLabel = this.getMetricToolTip(filter, metricIndex);
            String thresholdLabel = this.getThresholdToolTipByMetric(filter, metricIndex, isFlashFormat);
            StringBuffer label = new StringBuffer();
            if (rowLabel != null) {
                label.append(rowLabel);
                if (thresholdLabel != null && thresholdLabel.length() > 0) {
                    label.append(' ').append(thresholdLabel);
                }
            }
            toolTipList.add(label.toString());
        }
        String[] tooltips = new String[toolTipList.size()];
        for (int index = 0; index < toolTipList.size(); ++index) {
            tooltips[index] = (String)toolTipList.get(index);
        }
        return tooltips;
    }

    private String[] getIndicatorToolTip(int filter, int metricIndex, boolean isFlashFormat) {
        String[] tooltips = new String[1];
        String rowLabel = this.getMetricToolTip(filter, metricIndex);
        String thresholdLabel = this.getThresholdToolTipByMetric(filter, metricIndex, isFlashFormat);
        StringBuffer label = new StringBuffer();
        if (rowLabel != null) {
            label.append(rowLabel);
            if (thresholdLabel != null && thresholdLabel.length() > 0) {
                label.append(thresholdLabel);
            }
        }
        tooltips[0] = label.toString();
        return tooltips;
    }

    private String getMetricToolTip(int filter, int metricIndex) {
        String[] metricNames;
        if (metricIndex < 0) {
            metricIndex = 0;
        }
        boolean includeMetric = !this.isNullMetric();
        String bottomLabel = this.getBottomLabelOverride();
        if (bottomLabel == null) {
            bottomLabel = (String)this._map.get("BottomLabelText");
        }
        if (bottomLabel == null) {
            bottomLabel = this.getBottomLabel();
        }
        if ((metricNames = (String[])this._map.get("MetricName")) != null && metricNames.length > 1 && metricIndex < metricNames.length) {
            bottomLabel = MessageFormat.format(this.getIntlString("af_dvt_gauge.LABEL_TOOLTIP_METRICNAME_VALUELABEL", this._gaugeBundle), metricNames[metricIndex], bottomLabel);
        }
        String row = null;
        row = (filter & 1) != 0 && includeMetric && this.getMetric(metricIndex) != null ? this.formatValue(this.getMetric(metricIndex), "MetricLabelViewFormat") : (!includeMetric ? this.getIntlString("af_dvt_util.NO_DATA", this._utilBundle) : this.getIntlString("af_dvt_util.NULL", this._utilBundle));
        String rowLabel = null;
        rowLabel = (filter & 0x10) != 0 && bottomLabel != null ? MessageFormat.format(this.getIntlString("af_dvt_gauge.LABEL_TOOLTIP_LABEL_VALUE", this._gaugeBundle), bottomLabel, row) : MessageFormat.format(this.getIntlString("af_dvt_gauge.LABEL_VALUE", this._gaugeBundle), row);
        return rowLabel;
    }

    private String getThresholdToolTipByMetric(int filter, int metricIndex, boolean isFlashFormat) {
        if (metricIndex < 0) {
            metricIndex = 0;
        }
        boolean includeMetric = !this.isNullMetric();
        StringBuilder thresholdValuesBuffer = new StringBuilder();
        String thresholdValues = null;
        if ((filter & 1) != 0 && includeMetric && this.getMetric(metricIndex) != null && this._map.get("ThresholdValues") != null) {
            double[] array = (double[])this._map.get("ThresholdValues");
            int index = -1;
            for (int i = 0; i < array.length; ++i) {
                if (!(this.getMetric(metricIndex) <= array[i])) continue;
                index = i;
                break;
            }
            thresholdValues = this.getThresholdToolTipByIndex(index, false);
        }
        thresholdValuesBuffer.append(thresholdValues);
        if (thresholdValues == null) {
            return null;
        }
        return thresholdValuesBuffer.toString();
    }

    private String getThresholdToolTipByIndex(int thresholdIndex, boolean isThresholdComp) {
        HashMap tMap;
        ArrayList tList;
        String thresholdName = null;
        double[] array = (double[])this._map.get("ThresholdValues");
        if (thresholdIndex == -1) {
            thresholdIndex = array.length;
        }
        if ((tList = (ArrayList)this._map.get("THRESHOLD_ATTRIBUTES")) != null && thresholdIndex < tList.size() && (tMap = (HashMap)tList.get(thresholdIndex)) != null) {
            thresholdName = (String)tMap.get("ThresholdText");
        }
        String thresholdDescription = null;
        if (isThresholdComp) {
            if (thresholdIndex == 0) {
                double value = array[0];
                Object[] args = new String[]{this.formatValue(value, "TickLabelViewFormat")};
                thresholdDescription = MessageFormat.format(this.getIntlString("af_dvt_gauge.LABEL_BELOW_THRESHOLD", this._gaugeBundle), args);
            } else if (thresholdIndex == array.length) {
                double value = array[array.length - 1];
                Object[] args = new String[]{this.formatValue(value, "TickLabelViewFormat")};
                thresholdDescription = MessageFormat.format(this.getIntlString("af_dvt_gauge.LABEL_ABOVE_THRESHOLD", this._gaugeBundle), args);
            } else {
                double firstValue = array[thresholdIndex - 1];
                double secondValue = array[thresholdIndex];
                Object[] args = new String[]{this.formatValue(firstValue, "TickLabelViewFormat"), this.formatValue(secondValue, "TickLabelViewFormat")};
                thresholdDescription = MessageFormat.format(this.getIntlString("af_dvt_gauge.LABEL_BETWEEN_THRESHOLD", this._gaugeBundle), args);
            }
        }
        if (!isThresholdComp) {
            if (thresholdName == null) {
                return null;
            }
            return MessageFormat.format(this.getIntlString("af_dvt_gauge.LABEL_TOOLTIP_THRESHOLD_PARENTHESIS", this._gaugeBundle), thresholdName);
        }
        if (thresholdName == null) {
            return thresholdDescription;
        }
        return MessageFormat.format(this.getIntlString("af_dvt_gauge.LABEL_TOOLTIP_THRESHOLD_VALUE", this._gaugeBundle), thresholdName, thresholdDescription);
    }

    private String[] _getVennTooltips(int filter) {
        int count = 0;
        StringBuilder topBuffer = null;
        Object obj = this._map.get("ElementATopLabel");
        if (obj != null) {
            topBuffer = new StringBuilder(obj.toString());
            ++count;
        }
        StringBuilder bottomBuffer = null;
        obj = this._map.get("ElementABottomLabel");
        if (obj != null) {
            bottomBuffer = new StringBuilder(obj.toString());
            ++count;
        }
        obj = this._map.get("ElementAValue");
        String valueLabel = null;
        valueLabel = obj != null && obj instanceof Double ? MessageFormat.format(this.getIntlString("af_dvt_gauge.LABEL_VALUE", this._gaugeBundle), this.formatValue((double)((Double)obj), null)) : this.getIntlString("af_dvt_util.NO_DATA", this._utilBundle);
        int lineNum = 0;
        String[] tooltips = new String[++count];
        if (topBuffer != null) {
            tooltips[lineNum++] = topBuffer.toString();
        }
        if (bottomBuffer != null) {
            tooltips[lineNum++] = bottomBuffer.toString();
        }
        if (valueLabel != null) {
            tooltips[lineNum] = valueLabel;
        }
        return tooltips;
    }

    private String _buildTooltipString(String[] tooltipsArray) {
        if (tooltipsArray == null) {
            return null;
        }
        StringBuilder tooltip = new StringBuilder();
        for (int i = 0; i < tooltipsArray.length; ++i) {
            tooltip.append(tooltipsArray[i]);
            if (i >= tooltipsArray.length - 1) continue;
            tooltip.append(System.getProperty("line.separator"));
        }
        return tooltip.toString();
    }

    private boolean _isLabelColliding(DrawableObject.Label lblObj, ArrayList savedRects) {
        boolean isColliding = false;
        Rectangle rect = lblObj.getBounds();
        rect = new Rectangle(rect.x + this.LABEL_COLLISION_FUDGE_FACTOR, rect.y + this.LABEL_COLLISION_FUDGE_FACTOR, rect.width - 2 * this.LABEL_COLLISION_FUDGE_FACTOR, rect.height - 2 * this.LABEL_COLLISION_FUDGE_FACTOR);
        int numRects = savedRects.size();
        for (int rectIndex = 0; rectIndex < numRects; ++rectIndex) {
            Rectangle savedRect = (Rectangle)savedRects.get(rectIndex);
            if (!rect.intersects(savedRect)) continue;
            return true;
        }
        return isColliding;
    }

    private boolean _renderObjList(GaugeRenderer renderer) {
        boolean retCode = true;
        this.prepareObjects(this.getGraphics());
        if (this._objList != null && !this._objList.isEmpty()) {
            ArrayList<Rectangle> rectList = new ArrayList<Rectangle>();
            for (int objIndex = 0; objIndex < this._objList.size(); ++objIndex) {
                DrawableObject obj = (DrawableObject)this._objList.get(objIndex);
                if (obj == null) {
                    int column;
                    int row;
                    if (this._map == null) {
                        row = -1;
                        column = -1;
                    } else {
                        Object rowObj = this._map.get("DS_ROW");
                        row = rowObj != null ? Integer.parseInt((String)rowObj) : -1;
                        Object colObj = this._map.get("DS_COLUMN");
                        column = colObj != null ? Integer.parseInt((String)colObj) : -1;
                    }
                    this._eh.log("Attempt made to process null DrawableObject on gauge " + row + "," + column, this.getClass().getName(), _method_render);
                    retCode = false;
                }
                if (obj instanceof DrawableObject.TickLabel || this._gaugeType.getGaugeType() == 3 && obj instanceof DrawableObject.Label) {
                    DrawableObject.Label lblObj = (DrawableObject.Label)obj;
                    Rectangle bounds = lblObj.getBounds();
                    boolean doNotRender = false;
                    doNotRender = this._isLabelColliding(lblObj, rectList);
                    if (doNotRender) continue;
                    rectList.add(bounds);
                } else if (obj instanceof DrawableObject.Label) {
                    DrawableObject.Label lblObj = (DrawableObject.Label)obj;
                    Rectangle bounds = lblObj.getBounds();
                    rectList.add(bounds);
                }
                obj.render(renderer);
            }
            if (rectList != null) {
                rectList.clear();
            }
        }
        return retCode;
    }

    public double getMin() {
        return this._min;
    }

    public double getMax() {
        return this._max;
    }

    protected boolean isNullMetric() {
        return this._isNullMetric;
    }

    protected Double getMetric() {
        return this.getMetric(0);
    }

    protected Double[] getMetrics() {
        return this._metric;
    }

    protected Double getMetric(int i) {
        if (this._metric != null && this._metric.length > i) {
            return this._metric[i];
        }
        return null;
    }

    protected int getMetricSize() {
        if (this._metric != null) {
            return this._metric.length;
        }
        return 0;
    }

    protected double getMetricMax() {
        return this._metricMax;
    }

    protected double getMetricMin() {
        return this._metricMin;
    }

    protected double getIncrement() {
        return this._incr;
    }

    protected double getMinorIncrement() {
        return this._minorIncr;
    }

    protected int getMinorNumberOfSteps() {
        return this._minorNumberOfSteps;
    }

    protected int getNumberOfSteps() {
        return this._numberOfSteps;
    }

    protected int getMaxNumberOfSteps() {
        return this._numberOfSteps;
    }

    protected static void putIndicatorAttr(Map map, String attr, Object value, int index) {
        Object innerObj = map.get(attr);
        ArrayList<Object> innerList = null;
        if (innerObj != null && innerObj instanceof ArrayList || innerObj == null) {
            if (innerObj != null) {
                innerList = (ArrayList<Object>)innerObj;
            }
            if (innerList == null) {
                innerList = new ArrayList<Object>();
            }
            if (innerList.size() <= index) {
                for (int i = innerList.size(); i <= index; ++i) {
                    innerList.add(null);
                }
            }
            innerList.set(index, value);
            map.put(attr, innerList);
        } else {
            map.put(attr, value);
        }
    }

    protected static Object getIndicatorAttr(Map map, String attr, int index) {
        Object innerObj = map.get(attr);
        if (innerObj instanceof ArrayList) {
            ArrayList innerList = (ArrayList)map.get(attr);
            if (innerList != null && innerList.size() > index) {
                return innerList.get(index);
            }
        } else {
            return innerObj;
        }
        return null;
    }

    protected Object getIndicatorAttr(String attr, int index) {
        return GaugeEngine.getIndicatorAttr(this._map, attr, index);
    }

    protected int _getPowerOfTen(double dValue) {
        int power;
        block4: {
            double testValue;
            block3: {
                power = 0;
                if (testValue < 1.0E-15) {
                    return 0;
                }
                if (!(testValue >= 10.0)) break block3;
                for (testValue = dValue >= 0.0 ? dValue : -dValue; testValue >= 10.0; testValue /= 10.0) {
                    ++power;
                }
                break block4;
            }
            if (!(testValue < 1.0)) break block4;
            while (testValue < 1.0) {
                --power;
                testValue *= 10.0;
            }
        }
        return power;
    }

    private void _addToDrawableList(Collection objects) {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        if (this._objList == null) {
            this._objList = new ArrayList(15);
        }
        Object[] drawObjects = objects.toArray();
        for (int obj = 0; obj < drawObjects.length; ++obj) {
            if (drawObjects[obj] instanceof Collection) {
                Object[] subObjList = ((Collection)drawObjects[obj]).toArray();
                for (int subobj = 0; subobj < subObjList.length; ++subobj) {
                    this._objList.add(subObjList[subobj]);
                }
                continue;
            }
            this._objList.add(drawObjects[obj]);
        }
    }

    private double _calcTickStep() {
        double minValue = this.getMin();
        double maxValue = this.getMax();
        boolean includeMetric = !this.isNullMetric();
        double metricValueMin = includeMetric ? this.getMetricMin() : 0.0;
        double metricValueMax = includeMetric ? this.getMetricMax() : 0.0;
        double tickStep = 0.0;
        boolean minMax = false;
        boolean threshold = false;
        boolean increments = false;
        boolean metric = false;
        double thresholdStep = 0.0;
        double minMaxStep = 0.0;
        double metricStep = 0.0;
        double incrStep = this.getIncrement();
        if (this._map.get("TickLabelContent") == null) {
            minMax = true;
            increments = true;
            if (this._map.get("ThresholdValues") != null) {
                threshold = true;
            }
        } else {
            int content = (Integer)this._map.get("TickLabelContent");
            if ((content & 3) != 0) {
                minMax = true;
            }
            if ((content & 4) != 0) {
                increments = true;
            }
            if ((content & 8) != 0) {
                threshold = true;
            }
            if ((content & 0x10) != 0 && includeMetric) {
                metric = true;
            }
        }
        if (minMax) {
            minMaxStep = maxValue - minValue;
        }
        if (threshold && this._map.get("ThresholdValues") == null) {
            threshold = false;
        }
        if (threshold) {
            double[] array = (double[])this._map.get("ThresholdValues");
            int startIndex = 0;
            int count = array.length;
            while (array[startIndex] < minValue && ++startIndex < count) {
            }
            while (array[count - 1] > maxValue && --count > 0) {
            }
            for (int i = startIndex; i <= count; ++i) {
                double diff = 0.0;
                double start = 0.0;
                double end = 0.0;
                start = i == startIndex ? minValue : array[i - 1];
                end = i == count ? maxValue : array[i];
                diff = end - start;
                if (i == 0) {
                    thresholdStep = diff;
                }
                if (thresholdStep == 0.0 && diff != 0.0) {
                    thresholdStep = diff;
                }
                if (metric && metricValueMin > start && metricValueMax < end) {
                    if (metricValueMin - start < diff) {
                        diff = metricValueMin - start;
                    }
                    if (end - metricValueMax < diff) {
                        diff = end - metricValueMax;
                    }
                }
                if (!(diff < thresholdStep) || diff == 0.0) continue;
                thresholdStep = diff;
            }
        }
        if (increments && metric) {
            int steps = this.getNumberOfSteps();
            double diff = 0.0;
            double newIncr = incrStep;
            for (int i = 0; i <= steps; ++i) {
                diff = Math.abs(metricValueMin - (double)i * incrStep);
                if (diff == 0.0 || !(diff < newIncr)) continue;
                newIncr = diff;
            }
            incrStep = newIncr;
        }
        if (metric) {
            if (metricValueMin == minValue || metricValueMax == maxValue) {
                metricStep = minMaxStep;
            } else {
                metricStep = metricValueMin - minValue;
                if (metricStep > maxValue - metricValueMax) {
                    metricStep = maxValue - metricValueMax;
                }
            }
        }
        if (threshold && increments && metric) {
            tickStep = incrStep;
            if (thresholdStep < tickStep) {
                tickStep = thresholdStep;
            }
            if (metricStep < tickStep) {
                tickStep = metricStep;
            }
        } else if (threshold && increments) {
            tickStep = incrStep;
            if (thresholdStep < tickStep) {
                tickStep = thresholdStep;
            }
        } else if (increments && minMax || increments && metric) {
            tickStep = incrStep;
        } else if (threshold && minMax || threshold && metric) {
            tickStep = thresholdStep;
        } else if (metric) {
            tickStep = metricStep;
        } else if (minMax) {
            tickStep = minMaxStep;
        }
        return tickStep;
    }

    protected void determineFormat(boolean metricLabel) {
        double minValue = this.getMin();
        double maxValue = this.getMax();
        boolean includeMetric = !this.isNullMetric();
        double metricValueMin = includeMetric ? this.getMetricMin() : 0.0;
        double metricValueMax = includeMetric ? this.getMetricMax() : 0.0;
        double tickStep = 0.0;
        ViewFormat viewFmt = metricLabel ? (this._map.get("MetricLabelViewFormat") == null ? this.m_defMetricLabelViewFormat : (ViewFormat)((Object)this._map.get("MetricLabelViewFormat"))) : (this._map.get("TickLabelViewFormat") == null ? this.m_defTickLabelViewFormat : (ViewFormat)((Object)this._map.get("TickLabelViewFormat")));
        if (includeMetric && metricLabel) {
            if (metricValueMin == minValue || metricValueMax == maxValue) {
                tickStep = maxValue - minValue;
            } else {
                tickStep = metricValueMin - minValue;
                if (tickStep > maxValue - metricValueMax) {
                    tickStep = maxValue - metricValueMax;
                }
            }
        } else {
            tickStep = this._calcTickStep();
        }
        Object numberType = null;
        numberType = metricLabel ? this._map.get("MetricLabelNumberType") : this._map.get("TickLabelNumberType");
        if (numberType != null && (Integer)numberType == 1) {
            minValue = (minValue - this.getMin()) / (this.getMax() - this.getMin());
            maxValue = (maxValue - this.getMin()) / (this.getMax() - this.getMin());
            tickStep = (tickStep - this.getMin()) / (this.getMax() - this.getMin());
            return;
        }
        boolean bUseDefaultScaleFactor = !viewFmt.isScaleFactorUsed();
        boolean bUseDefaultDecimalDigit = !viewFmt.isDecimalDigitUsed();
        DvtNumberConverter converter = null;
        if (viewFmt.getNumberConverter() != null && viewFmt.getNumberConverter() instanceof DvtNumberConverter) {
            converter = (DvtNumberConverter)viewFmt.getNumberConverter();
        }
        double absMax = minValue < 0.0 && -minValue > maxValue ? -minValue : maxValue;
        int power = this._getPowerOfTen(absMax);
        int scaleFactor = viewFmt.getScaleFactor();
        int decimalPlaces = converter == null ? viewFmt.getDecimalDigit() : 2;
        int significantDigits = 0;
        if (bUseDefaultScaleFactor) {
            if (power <= 1) {
                scaleFactor = 0;
            } else if (power >= 16) {
                scaleFactor = 5;
            } else {
                int scaleFactorPower = power / 3 * 3;
                significantDigits = power % 3;
                switch (scaleFactorPower) {
                    case 3: {
                        scaleFactor = 1;
                        break;
                    }
                    case 6: {
                        scaleFactor = 2;
                        break;
                    }
                    case 9: {
                        scaleFactor = 3;
                        break;
                    }
                    case 12: {
                        scaleFactor = 4;
                        break;
                    }
                    case 15: {
                        scaleFactor = 5;
                        break;
                    }
                    default: {
                        scaleFactor = 0;
                    }
                }
            }
        }
        if (bUseDefaultDecimalDigit) {
            double scaledMinVal;
            int tickStepPowerOfTen;
            int scaleFactorPowerOfTen = this._getScaleFactorPowerOfTen(scaleFactor);
            decimalPlaces = scaleFactorPowerOfTen - (tickStepPowerOfTen = this._getPowerOfTen(tickStep));
            if (decimalPlaces < 0) {
                decimalPlaces = 0;
            }
            double scaledTickStep = tickStep;
            double d = scaledMinVal = minValue < maxValue ? minValue : maxValue;
            if (scaleFactorPowerOfTen > 0) {
                scaledTickStep *= Math.pow(10.0, -scaleFactorPowerOfTen);
                scaledMinVal *= Math.pow(10.0, -scaleFactorPowerOfTen);
            }
            double targetLevOfPrec = 1.0;
            if (decimalPlaces > 0) {
                targetLevOfPrec = Math.pow(10.0, -decimalPlaces);
            }
            double nearestStepAtTLOP = Math.rint(scaledTickStep / targetLevOfPrec) * targetLevOfPrec;
            double deltaIncrementAndNearestNumAtTLOP = scaledTickStep - nearestStepAtTLOP;
            double nearestStartAtTLOP = Math.rint(scaledMinVal / targetLevOfPrec) * targetLevOfPrec;
            double deltaStartAndNearestNumAtTLOP = scaledMinVal - nearestStartAtTLOP;
            if (Math.abs(deltaStartAndNearestNumAtTLOP) >= 0.1 * targetLevOfPrec) {
                ++decimalPlaces;
            } else if (Math.abs(deltaIncrementAndNearestNumAtTLOP) >= 0.001 * targetLevOfPrec) {
                int numTicks;
                double error;
                double axisRange = maxValue - minValue;
                if (minValue > maxValue) {
                    axisRange = minValue - maxValue;
                }
                if ((error = Math.abs(deltaIncrementAndNearestNumAtTLOP * (double)(numTicks = (int)Math.floor(axisRange / tickStep)) + deltaStartAndNearestNumAtTLOP)) >= 0.1 * targetLevOfPrec) {
                    ++decimalPlaces;
                }
            }
            if (bUseDefaultScaleFactor) {
                if (scaleFactor != 0) {
                    if (significantDigits == 2) {
                        decimalPlaces = 0;
                    }
                    if (significantDigits == 1 && decimalPlaces > 1) {
                        decimalPlaces = 1;
                    }
                    if (significantDigits == 0 && decimalPlaces > 2) {
                        decimalPlaces = 2;
                    }
                }
                if (absMax <= 1.0 && decimalPlaces >= 3) {
                    decimalPlaces = 3;
                } else if (decimalPlaces >= 2) {
                    decimalPlaces = 2;
                }
                if (scaleFactor == 0) {
                    if (tickStepPowerOfTen >= 1) {
                        decimalPlaces = 0;
                    } else if (tickStepPowerOfTen == 0 && decimalPlaces > 1) {
                        decimalPlaces = 1;
                    }
                    if (power >= 2 && decimalPlaces >= 1) {
                        decimalPlaces = 0;
                    }
                }
            }
        }
        if (bUseDefaultScaleFactor) {
            viewFmt.setScaleFactor(scaleFactor);
        }
        if (bUseDefaultDecimalDigit) {
            decimalPlaces = decimalPlaces >= 0 ? decimalPlaces : 0;
            viewFmt.setDecimalDigit(decimalPlaces);
        }
        if (metricLabel) {
            this.m_defMetricLabelViewFormat = viewFmt;
        }
        if (!metricLabel) {
            this.m_defTickLabelViewFormat = viewFmt;
        }
    }

    private int _getRecalcState() {
        return this._recalcState;
    }

    private int _getScaleFactorPowerOfTen(int scaleFactor) {
        switch (scaleFactor) {
            case 1: {
                return 3;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 9;
            }
            case 4: {
                return 12;
            }
            case 5: {
                return 15;
            }
        }
        return 0;
    }

    private void _setRecalcState(int state) {
        this._recalcState = state;
    }

    private void _updateSteps() {
        double spread;
        int power;
        int maxMinorTickCount = 0;
        Integer minorTickCount = (Integer)this._map.get("MinorTickCount");
        Double minorTickStep = (Double)this._map.get("MinorTickStep");
        Integer majorTickCount = (Integer)this._map.get("MajorTickCount");
        Double majorTickStep = (Double)this._map.get("MajorTickStep");
        if (minorTickStep != null && minorTickStep > 0.0) {
            this._minorIncr = minorTickStep;
        }
        if (majorTickStep != null || majorTickCount != null) {
            if (majorTickStep != null) {
                if (majorTickStep <= 0.0) {
                    this._numberOfSteps = 0;
                    return;
                }
                if (majorTickStep < this._max - this._min) {
                    this._incr = majorTickStep;
                    this._numberOfSteps = (int)Math.ceil((this._max - this._min) / majorTickStep);
                } else {
                    this._incr = this._max - this._min;
                    this._numberOfSteps = 1;
                }
            } else {
                this._maxNumberOfSteps = majorTickCount <= 1 ? 1 : majorTickCount - 1;
                this._incr = (this._max - this._min) / (double)this._maxNumberOfSteps;
                this._numberOfSteps = this._maxNumberOfSteps;
            }
            if (this._numberOfSteps > 100) {
                this._numberOfSteps = 100;
                this._incr = (this._max - this._min) / (double)this._numberOfSteps;
            }
            if (minorTickStep == null && minorTickCount != null && minorTickCount >= 1) {
                this._minorIncr = this._incr / (double)(minorTickCount + 1);
            }
            if (this._minorIncr > 0.0) {
                this._minorNumberOfSteps = (int)Math.ceil(this._incr / this._minorIncr) - 1;
            }
            if (this._minorNumberOfSteps > (maxMinorTickCount = 500 / this._numberOfSteps - 1)) {
                this._minorNumberOfSteps = maxMinorTickCount;
                this._minorIncr = this._incr / (double)(this._minorNumberOfSteps + 1);
            }
            return;
        }
        this._maxNumberOfSteps = this._gaugeType.getMaxNumberOfSteps();
        if (this._maxNumberOfSteps > GaugeDefaultValues.getMaxIncrements()) {
            this._maxNumberOfSteps = GaugeDefaultValues.getMaxIncrements();
        }
        if (this._maxNumberOfSteps < GaugeDefaultValues.getMinIncrements()) {
            this._maxNumberOfSteps = GaugeDefaultValues.getMinIncrements();
        }
        if ((power = this._getPowerOfTen(spread = this.getMin() - this.getMax())) < 0) {
            spread = power == -1 ? (spread *= Math.pow(10.0, 2.0)) : (spread *= Math.pow(10.0, 3.0));
        } else {
            int significantDigits = power % 3;
            int maxDecimalDigits = 2 - significantDigits;
            int scaleFactorPower = power / 3 * 3;
            spread *= Math.pow(10.0, maxDecimalDigits);
            spread /= Math.pow(10.0, scaleFactorPower);
        }
        boolean done = false;
        while (!done) {
            for (int i = this._maxNumberOfSteps; i >= GaugeDefaultValues.getMinIncrements(); --i) {
                int reminder = (int)spread % i;
                if (reminder != 0) continue;
                done = true;
                this._maxNumberOfSteps = i;
                break;
            }
            if (done) continue;
            if (this._maxNumberOfSteps % 2 != 0) {
                --this._maxNumberOfSteps;
            }
            done = true;
        }
        this._incr = (this._max - this._min) / (double)this._maxNumberOfSteps;
        this._numberOfSteps = this._maxNumberOfSteps;
        if (minorTickStep == null && minorTickCount != null && minorTickCount >= 1) {
            this._minorIncr = this._incr / (double)(minorTickCount + 1);
        }
        if (this._minorIncr > 0.0) {
            this._minorNumberOfSteps = (int)Math.ceil(this._incr / this._minorIncr) - 1;
        }
        if (this._minorNumberOfSteps > (maxMinorTickCount = 500 / this._numberOfSteps - 1)) {
            this._minorNumberOfSteps = maxMinorTickCount;
            this._minorIncr = this._incr / (double)(this._minorNumberOfSteps + 1);
        }
    }

    private void _validateMinMax() {
        double minVal = 0.0;
        double maxVal = 0.0;
        boolean minAuto = true;
        boolean maxAuto = true;
        Double min = (Double)this._map.get("minValue");
        Double max = (Double)this._map.get("maxValue");
        Double[] metricsList = null;
        Object obj = this._map.get("Metric");
        if (obj instanceof Double[]) {
            metricsList = (Double[])obj;
        } else if (obj instanceof Double) {
            metricsList = new Double[]{(Double)obj};
        }
        int metricSize = 0;
        if (metricsList != null) {
            for (int i = 0; i < metricsList.length; ++i) {
                if (metricsList[i] == null) continue;
                ++metricSize;
            }
        }
        boolean bl = this._isNullMetric = metricsList == null || metricSize == 0;
        if (min != null) {
            minVal = min;
            minAuto = false;
        } else if (this._isNullMetric) {
            minVal = 0.0;
        }
        if (max != null) {
            maxVal = max;
            maxAuto = false;
        } else if (this._isNullMetric) {
            maxVal = 100.0;
        }
        this._min = minVal;
        this._max = maxVal;
        if (!this._isNullMetric) {
            Object objNumType;
            int numType;
            this._metric = metricsList;
            double[] metricWithoutNull = new double[metricSize];
            int index1 = 0;
            for (int index2 = 0; index2 < metricsList.length; ++index2) {
                if (metricsList[index2] == null) continue;
                metricWithoutNull[index1++] = metricsList[index2];
            }
            this._metricMin = metricWithoutNull[0];
            this._metricMax = metricWithoutNull[0];
            if (metricWithoutNull.length > 0) {
                for (int i = 1; i < metricWithoutNull.length; ++i) {
                    if (metricWithoutNull[i] > this._metricMax) {
                        this._metricMax = metricWithoutNull[i];
                        continue;
                    }
                    if (!(metricWithoutNull[i] < this._metricMin)) continue;
                    this._metricMin = metricWithoutNull[i];
                }
            }
            if (minAuto && this._metricMin >= 0.0) {
                this._min = GaugeDefaultValues.getMin();
                minAuto = false;
            }
            if (maxAuto && this._metricMax < 0.0) {
                this._max = GaugeDefaultValues.getMin();
                maxAuto = false;
            }
            int n = numType = (objNumType = this._map.get("TickLabelNumberType")) != null ? (Integer)objNumType : GaugeDefaultValues.getNumberType();
            if (numType == 0) {
                if (maxAuto && this._metricMin >= 0.0 && this._metricMax <= 100.0) {
                    this._max = GaugeDefaultValues.getMax();
                    maxAuto = false;
                }
                if (minAuto && this._metricMax < 0.0 && this._metricMin >= -100.0) {
                    this._min = GaugeDefaultValues.getNegativeMin();
                    minAuto = false;
                }
                if (maxAuto || minAuto) {
                    double power = StrictMath.log10(Math.abs(this._metricMax));
                    power = Math.ceil(power);
                    if (this._metricMin >= 0.0) {
                        this._max = Math.pow(10.0, power);
                    } else {
                        this._min = -Math.pow(10.0, power);
                    }
                }
            } else {
                if (minAuto) {
                    this._min = GaugeDefaultValues.getPercentMin();
                }
                if (maxAuto) {
                    this._max = GaugeDefaultValues.getPercentMax();
                }
            }
        }
    }

    private String _getMetricThresholdText(int metricIndex) {
        String thresholdValues = null;
        if (this._map.get("ThresholdValues") != null) {
            HashMap tMap;
            ArrayList tList;
            double[] array = (double[])this._map.get("ThresholdValues");
            int index = -1;
            for (int i = 0; i < array.length; ++i) {
                Double metricValue = this.getMetric(metricIndex);
                if (metricValue == null || !(metricValue <= array[i])) continue;
                index = i;
                break;
            }
            if (index == -1) {
                index = array.length;
            }
            if ((tList = (ArrayList)this._map.get("THRESHOLD_ATTRIBUTES")) != null && index < tList.size() && (tMap = (HashMap)tList.get(index)) != null) {
                thresholdValues = (String)tMap.get("ThresholdText");
            }
            if (thresholdValues == null) {
                double firstValue = 0.0;
                firstValue = index == 0 ? this.getMin() : array[index - 1];
                double secondValue = 0.0;
                secondValue = index == array.length ? this.getMax() : array[index];
                String[] args = new String[]{this.formatValue(firstValue, "TickLabelViewFormat"), this.formatValue(secondValue, "TickLabelViewFormat")};
                thresholdValues = "between " + args[0] + " to " + args[1];
            }
        }
        return thresholdValues;
    }

    private String _getThresholdsText() {
        StringBuilder sb = new StringBuilder();
        if (this._map.get("ThresholdValues") != null) {
            double[] array = (double[])this._map.get("ThresholdValues");
            String threshold = this.formatValue(this.getMin(), "TickLabelViewFormat");
            for (int i = 0; i < array.length; ++i) {
                sb.append(", threshold ");
                sb.append(i + 1);
                sb.append(": ");
                sb.append(threshold);
                sb.append(" to ");
                threshold = this.formatValue(array[i], "TickLabelViewFormat");
                sb.append(threshold);
            }
            sb.append(", threshold ");
            sb.append(array.length + 1);
            sb.append(": ");
            sb.append(threshold);
            sb.append(" to ");
            sb.append(this.formatValue(this.getMax(), "TickLabelViewFormat"));
        }
        return sb.toString();
    }

    protected String formatValue(Double data, String viewFormatKey) {
        String fmtStr = "";
        if (data != null) {
            if (viewFormatKey == null) {
                return String.valueOf(data);
            }
            ViewFormat viewFmt = (ViewFormat)((Object)this._map.get(viewFormatKey));
            if (viewFmt == null) {
                viewFmt = viewFormatKey.equals("TickLabelViewFormat") || viewFormatKey.equals("LegendTextPercentViewFormat") ? this.m_defTickLabelViewFormat : this.m_defMetricLabelViewFormat;
            }
            Integer numberType = null;
            int origNumberType = viewFmt.getNumberType();
            boolean isNumberTypeUsed = viewFmt.isNumberTypeUsed();
            int origScaleFactor = viewFmt.getScaleFactor();
            if (viewFormatKey.equals("TickLabelViewFormat")) {
                numberType = (Integer)this._map.get("TickLabelNumberType");
            } else if (viewFormatKey.equals("MetricLabelViewFormat")) {
                numberType = (Integer)this._map.get("MetricLabelNumberType");
            } else if (viewFormatKey.equals("LegendTextPercentViewFormat") && (numberType = (Integer)this._map.get("LegendTextNumberType")) == 1) {
                viewFmt.setNumberType(2);
            }
            boolean isPercentType = false;
            if (numberType != null && numberType == 1) {
                data = (data - this.getMin()) / (this.getMax() - this.getMin());
                isPercentType = true;
                viewFmt.setScaleFactor(0);
                viewFmt.setNumberType(2);
            }
            fmtStr = data == 0.0 && !isPercentType ? String.valueOf(0) : viewFmt.DoubleToString(data);
            if (isPercentType) {
                viewFmt.setScaleFactor(origScaleFactor);
            }
            viewFmt.setNumberType(origNumberType);
            viewFmt.setNumberTypeUsed(isNumberTypeUsed);
        }
        return fmtStr;
    }

    private Map _createHashMap() {
        return new HashMap(8);
    }

    protected void setInnerBounds(Rectangle innerBounds) {
        this._innerBounds = innerBounds;
    }

    public String getTopLabel() {
        String topLabel = this.getTopLabelOverride();
        if (topLabel == null) {
            topLabel = (String)this._map.get("TopLabel");
        }
        return topLabel;
    }

    public String getBottomLabel() {
        String btmLabel = this.getBottomLabelOverride();
        if (btmLabel == null) {
            btmLabel = (String)this._map.get("BottomLabel");
        }
        return btmLabel;
    }

    private String getTopLabelOverride() {
        Map labelMap = (Map)this._map.get("TopLabelMap");
        return this.getIndexedLabel(labelMap);
    }

    private String getBottomLabelOverride() {
        Map labelMap = (Map)this._map.get("BottomLabelMap");
        return this.getIndexedLabel(labelMap);
    }

    private String getIndexedLabel(Map labelMap) {
        Object indexObj;
        String label = null;
        if (labelMap != null && (indexObj = this._map.get("DS_INDEX")) != null && indexObj instanceof Integer) {
            int index = (Integer)indexObj;
            Object labelObj = labelMap.get(index);
            label = labelObj != null ? labelObj.toString() : null;
        }
        return label;
    }
}

