/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Image;
import java.util.HashMap;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class Alert
extends BaseGraphComponent {
    private boolean m_url = false;

    public Alert(CommonGraph graph, Object xValue, Object yValue) {
        super(graph);
        this.m_identObj = this.m_pfj.createAlert(xValue, yValue);
    }

    @Override
    public boolean selectObject(int series, int group) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    public void setXValue(Object value) {
        this.m_pfj.setAlertXValue(this.m_identObj, value);
    }

    public Object getXValue() {
        return this.m_pfj.getAlertXValue(this.m_identObj);
    }

    public void setYValue(Object value) {
        if (value instanceof String) {
            this.m_pfj.setAlertYValue(this.m_identObj, Double.valueOf((String)value));
        } else {
            this.m_pfj.setAlertYValue(this.m_identObj, (Double)value);
        }
    }

    public Object getYValue() {
        return this.m_pfj.getAlertYValue(this.m_identObj);
    }

    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj);
    }

    public void setVisible(boolean yesNo) {
        this.m_pfj.setDisplay(this.m_identObj, yesNo);
    }

    public String getText() {
        return this.m_pfj.getTextString(this.m_identObj);
    }

    public void setText(String str) {
        this.m_pfj.setTextString(this.m_identObj, str);
    }

    public void setImageSource(Image image) {
        this.m_pfj.setTextureURL(this.m_identObj, "alert", image);
        this.m_url = false;
    }

    public String getImageSource() {
        String str = "";
        if (this.m_url) {
            str = this.m_pfj.getTexture(this.m_identObj);
        }
        return str;
    }

    public void setImageSource(String url) {
        if (url == null) {
            this.m_commonGraph.getErrorHandler().log("invalid URL", this.getClass().getName(), "setTextureURL");
            return;
        }
        this.m_pfj.setTextureURL(this.m_identObj, url);
        this.m_url = true;
    }

    public void setImageSource(String url, Image image) {
        this.m_pfj.setTextureURL(this.m_identObj, url, image);
        this.m_url = true;
    }

    public void setYValueAssignment(int axis) {
        this.m_pfj.setAlertYAssignment(this.m_identObj, axis);
    }

    public int getYValueAssignment() {
        return this.m_pfj.getAlertYAssignment(this.m_identObj);
    }

    public int getID() {
        return this.m_identObj.getMiscID();
    }

    @Override
    protected String getComponentName() {
        return "Alert";
    }

    protected ObjectNode getXML(boolean allProperties, boolean allOverriddenProperties) {
        ObjectNode node = new ObjectNode(this.getComponentName());
        boolean nodeExists = false;
        Object val = this.m_pfj.getAlertXValue(this.m_identObj);
        if (val != null || allProperties) {
            nodeExists = true;
            if (val instanceof Number) {
                node.addProperty("xValue", ((Number)val).doubleValue());
            } else {
                node.addProperty("xValue", val.toString());
            }
        }
        if ((val = this.m_pfj.getAlertYValue(this.m_identObj)) != null || allProperties) {
            node.addProperty("yValue", ((Double)val).doubleValue());
            nodeExists = true;
        }
        if ((val = Integer.valueOf(this.m_pfj.getAlertYAssignment(this.m_identObj))) != null || allProperties) {
            String yValue = "Y1AXIS";
            if ((Integer)val == 51) {
                yValue = "Y2AXIS";
            }
            node.addProperty("yValueAssignment", yValue);
            nodeExists = true;
        }
        if ((val = this.m_pfj.getTextString(this.m_identObj)) != null || allProperties) {
            node.addProperty("text", (String)val);
            nodeExists = true;
        }
        if ((val = this.m_pfj.getTexture(this.m_identObj)) != null || allProperties) {
            node.addProperty("imageSource", (String)val);
            nodeExists = true;
        }
        if ((val = this.m_pfj.getDisplayObj(this.m_identObj)) != null || allProperties) {
            node.addProperty("visible", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        return nodeExists ? node : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setXML(ObjectNode node, HashMap map) {
        this.m_jsfHashMap = map;
        try {
            this.setXML(node);
        }
        finally {
            this.m_jsfHashMap = null;
        }
    }

    @Override
    public void setXML(ObjectNode node) {
        PropertyNode pNode;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.m_jsfHashMap != null) {
            this.m_jsfHashMap.put(new Integer(this.getID()), map);
        }
        if ((pNode = node.getProperty("xValue")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("xValue", new Double(pNode.getValueAsDouble()));
            } else {
                this.setXValue(new Double(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("yValue")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("yValue", new Double(pNode.getValueAsDouble()));
            } else {
                this.setYValue(new Double(pNode.getValueAsDouble()));
            }
        }
        if ((pNode = node.getProperty("yValueAssignment")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("yValueAssignment", new Integer(pNode.getValueAsInteger()));
            } else {
                this.setYValueAssignment(Alert.convertAssociationToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("text")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("text", pNode.getValueAsString());
            } else {
                this.setText(pNode.getValueAsString());
            }
        }
        if ((pNode = node.getProperty("imageSource")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("imageSource", pNode.getValueAsString());
            } else {
                this.setImageSource(pNode.getValueAsString());
            }
        }
        if ((pNode = node.getProperty("visible")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("rendered", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("rendered")) != null) {
            if (this.m_jsfHashMap != null) {
                map.put("rendered", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
    }
}

