/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Rectangle;
import oracle.dss.dataView.VerticalAlignment;
import oracle.dss.graph.BaseTitle;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.Rect;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public abstract class BaseGraphTitle
extends BaseTitle
implements VerticalAlignment,
Rect {
    public BaseGraphTitle(CommonGraph graph) {
        super(graph);
    }

    @Override
    public int getVerticalAlignment() {
        return this.m_pfj.getTextJustVert(this.m_identObj);
    }

    @Override
    public void setVerticalAlignment(int a) {
        if (a == 1 || a == 0 || a == 3) {
            this.m_pfj.setTextJustVert(this.m_identObj, a);
        } else {
            this.m_commonGraph.getErrorHandler().log("invalid vertical aligment", this.getClass().toString(), "setVerticalAlignment(alignment)");
        }
    }

    @Override
    public Rectangle getRect() {
        Rectangle pfjRect = this.m_pfj.getRect(this.m_identObj);
        if (pfjRect != null) {
            Rectangle rect = new Rectangle(pfjRect);
            rect.y += rect.height;
            return rect;
        }
        return null;
    }

    @Override
    public void setRect(Rectangle loc) {
        Rectangle temp = new Rectangle(loc);
        temp.y -= temp.height;
        this.m_pfj.setRect(this.m_identObj, temp);
    }

    @Override
    public void resetStyle() {
        this.setVerticalAlignment(1);
        this.setRect(new Rectangle(12, 12, 12, 12));
        super.resetStyle();
    }

    private void setRectXML(ObjectNode node) {
        Rectangle rect = this.getRect();
        PropertyNode pNode = node.getProperty("height");
        if (pNode != null) {
            rect.height = pNode.getValueAsInteger();
        }
        if ((pNode = node.getProperty("width")) != null) {
            rect.width = pNode.getValueAsInteger();
        }
        if ((pNode = node.getProperty("x")) != null) {
            rect.x = pNode.getValueAsInteger();
        }
        if ((pNode = node.getProperty("y")) != null) {
            rect.y = pNode.getValueAsInteger();
        }
        this.setRect(rect);
    }

    private ObjectNode getRectXML(boolean allProperties) {
        ObjectNode node = new ObjectNode("Rect");
        boolean nodeExists = false;
        Rectangle rect = this.getRect();
        if (rect != null) {
            node.addProperty("height", rect.height);
            node.addProperty("width", rect.width);
            node.addProperty("x", rect.x);
            node.addProperty("y", rect.y);
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    @Override
    public void setStyleXML(ObjectNode node) {
        ObjectNode rectXML;
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("verticalAlignment");
        if (pNode != null) {
            String tmp = pNode.getValueAsString();
            int alignment = BaseGraphTitle.convertVerticalAlignmentToInt(tmp);
            this.setVerticalAlignment(alignment);
        }
        if ((rectXML = node.getPropertyValueAsObjectNode("Rect", true)) != null) {
            this.setRectXML(rectXML);
        }
    }

    @Override
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        ObjectNode rectXML;
        boolean nodeExists = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getTextJustVertObj(this.m_identObj);
        if (val != null) {
            int tmp = (Integer)val;
            String alignment = BaseGraphTitle.convertVerticalAlignmentToString(tmp);
            node.addProperty("verticalAlignment", alignment);
            nodeExists = true;
        }
        if ((rectXML = this.getRectXML(allProperties)) != null) {
            node.addProperty(rectXML);
            nodeExists = true;
        }
        return nodeExists;
    }
}

