/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import oracle.dss.dataView.AttributeFormatUtils;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.DataFilterImpl;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.WaitData;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class DataCallback
extends DataFilterImpl {
    private boolean m_changeDefaultKeys = false;
    private int m_timeAxisLayer = 0;
    protected CommonGraph m_commonGraph;
    protected boolean m_stringType = false;
    protected HashMap m_jsfHashMap = null;
    public static final String name = "DataFilter";
    public static final String a_totalMeasures = "totalMeasures";
    public static final String a_scatterMeasures = "scatterMeasures";
    public static final String a_scatterLabelsMeasures = "scatterLabelsMeasures";
    public static final String a_bubbleMeasures = "bubbleMeasures";
    public static final String a_bubbleLabelsMeasures = "bubbleLabelsMeasures";
    public static final String a_OHLCVMeasures = "OHLCVMeasures";
    public static final String a_OHLCMeasures = "OHLCMeasures";
    public static final String a_HLVMeasures = "HLVMeasures";
    public static final String a_OCVMeasures = "OCVMeasures";
    public static final String a_OCMeasures = "OCMeasures";
    public static final String a_HLMeasures = "HLMeasures";
    public static final String a_HLCMeasures = "HLCMeasures";
    public static final String a_HLCVMeasures = "HLCVMeasures";
    public static final String a_funnelMeasures = "funnelMeasures";

    public DataCallback(CommonGraph commonGraph) {
        this.m_commonGraph = commonGraph;
        this.m_isDirtyFlag = true;
    }

    public Object columnLabel(int col) {
        if (this.isExcelOrDeskTop()) {
            if (this.m_dataModelType == 1) {
                if (!this.m_seriesAreRows) {
                    return this._getLabelForExcelOrDesktop(0, this.getDataAccessColumn(col + 1));
                }
                return this._getLabelForExcelOrDesktop(0, this.getDataAccessColumn(col));
            }
            if (!this.m_seriesAreRows) {
                return this._getLabelForExcelOrDesktop(0, this.getDataAccessColumn(col * 2)) + ", " + this._getLabelForExcelOrDesktop(0, this.getDataAccessColumn(col * 2 + 1));
            }
            return this._getLabelForExcelOrDesktop(0, this.getDataAccessColumn(col));
        }
        return this._getLabel(0, col);
    }

    public Object rowLabel(int row) {
        if (this.isExcelOrDeskTop()) {
            if (this.m_dataModelType == 1) {
                if (!this.m_seriesAreRows) {
                    return this._getLabelForExcelOrDesktop(1, this.getDataAccessRow(row));
                }
                return this._getLabelForExcelOrDesktop(1, this.getDataAccessRow(row + 1));
            }
            if (!this.m_seriesAreRows) {
                return this._getLabelForExcelOrDesktop(1, this.getDataAccessRow(row));
            }
            return this._getLabelForExcelOrDesktop(1, this.getDataAccessRow(row * 2)) + ", " + this._getLabelForExcelOrDesktop(1, this.getDataAccessRow(row * 2 + 1));
        }
        return this._getLabel(1, row);
    }

    public void setGroupLabelType(boolean stringType) {
        this.m_stringType = stringType;
    }

    public String getSliceLabel(int edge, int slice) {
        DataAccess da = this.getDataAccess();
        String measureLabel = null;
        String labelType = this.m_commonGraph.getMemberMetadataLabelType(edge);
        int layerCount = 0;
        try {
            layerCount = da.getLayerCount(edge);
        }
        catch (EdgeOutOfRangeException e) {
            // empty catch block
        }
        if (layerCount > 1) {
            try {
                measureLabel = (String)da.getMemberMetadata(edge, layerCount - 1, slice, labelType);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return measureLabel;
    }

    public String[] getLayers(int edge) {
        DataAccess da = this.getDataAccess();
        int layerCount = 0;
        String labelType = this.m_commonGraph.getLayerMetadataLabelType(edge);
        boolean initialized = false;
        try {
            layerCount = da.getLayerCount(edge);
        }
        catch (EdgeOutOfRangeException e) {
            // empty catch block
        }
        String[] layerNames = new String[layerCount];
        int layerMax = layerCount;
        for (int i = 0; i < layerMax; ++i) {
            try {
                String layerName = (String)da.getLayerMetadata(edge, i, labelType);
                if (layerName == null) continue;
                layerNames[i] = layerName.toString();
                initialized = true;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (initialized) {
            return layerNames;
        }
        return null;
    }

    public Object getParentDate() {
        try {
            if (this.m_commonGraph.isMetadataDrillParentDateSupported()) {
                int edge = this.m_seriesAreRows ? 0 : 1;
                return this.getDataAccess().getMemberMetadata(edge, 0, 0, "drillParentDate");
            }
            return null;
        }
        catch (DataException e) {
            return null;
        }
    }

    public Object getParentDateSpan() {
        try {
            if (this.m_commonGraph.isMetadataDrillParentDateSpanSupported()) {
                int edge = this.m_seriesAreRows ? 0 : 1;
                return this.getDataAccess().getMemberMetadata(edge, 0, 0, "drillParentDateSpan");
            }
            return null;
        }
        catch (DataException e) {
            return null;
        }
    }

    public Object getDateSpan() {
        try {
            if (this.m_commonGraph.isMetadataDateSpanSupported()) {
                int edge = this.m_seriesAreRows ? 0 : 1;
                return this.getDataAccess().getMemberMetadata(edge, 0, 0, "dateSpan");
            }
            return null;
        }
        catch (DataException e) {
            return null;
        }
    }

    public int getDataAccessRow(int row, int col) {
        int r = row;
        if (this.isExcelOrDeskTop()) {
            r = this.m_dataModelType == 1 ? (!this.m_seriesAreRows ? row / 2 : (col % 2 == 0 ? 0 : row + 1)) : (!this.m_seriesAreRows ? row / 2 : row * 2 + col % 2);
        }
        return this.getDataAccessRow(r);
    }

    public int getDataAccessColumn(int row, int col) {
        int c = col;
        if (this.isExcelOrDeskTop()) {
            c = this.m_dataModelType == 1 ? (!this.m_seriesAreRows ? (row % 2 == 0 ? 0 : col + 1) : col / 2) : (!this.m_seriesAreRows ? col * 2 + row % 2 : col / 2);
        }
        return this.getDataAccessColumn(c);
    }

    @Override
    public Object getValue(int row, int col) {
        return this.getValue(row, col, "dataValue");
    }

    public Object getValue(int row, int col, String type) {
        int dArow = this.getDataAccessRow(row, col);
        int dAcol = this.getDataAccessColumn(row, col);
        try {
            boolean isAnalyticLayer;
            Object value = null;
            boolean isDataUnformatted = type != null && (type == "dataValue" || type.equals("dataValue"));
            boolean bl = isAnalyticLayer = type != null && !isDataUnformatted;
            if (isDataUnformatted && this.m_commonGraph.isDataUnformattedSupported() || isAnalyticLayer) {
                if (this.m_commonGraph.getWaitDataForRow(dArow) != null) {
                    WaitData wd = this.m_commonGraph.getWaitDataForRow(dArow);
                    this.m_commonGraph.getPFJ().setLazyDataFetchMessage(wd.getCellMessage());
                    this.m_commonGraph.repaint();
                    return null;
                }
                value = this.getDataAccess().getValue(dArow, dAcol, type);
                if (value instanceof WaitData) {
                    WaitData wd = (WaitData)value;
                    this.m_commonGraph.setWaitDataForRow(dArow, wd);
                    this.m_commonGraph.getPFJ().setLazyDataFetchMessage(wd.getCellMessage());
                    this.m_commonGraph.repaint();
                    return null;
                }
            }
            if (isAnalyticLayer) {
                return value;
            }
            if (value instanceof Date) {
                return value;
            }
            if (value instanceof Double && (((Double)value).isNaN() || ((Double)value).isInfinite()) || value instanceof Float && (((Float)value).isNaN() || ((Float)value).isInfinite()) || !(value instanceof Number)) {
                return null;
            }
            return value;
        }
        catch (DataException e) {
            this.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getValue");
            return null;
        }
    }

    public void setValue(int row, int col, Object value) {
        try {
            DataAccess dataAccess = this.getDataAccess();
            dataAccess.setValue(value, this.getDataAccessRow(row, col), this.getDataAccessColumn(row, col), "dataValue");
        }
        catch (DataException e) {
            this.getErrorHandler().error((Throwable)e, this.getClass().getName(), "setValue");
            return;
        }
    }

    public String getY1AxisTitle() {
        return this.m_commonGraph.getY1Title().getText();
    }

    public String getY2AxisTitle() {
        return this.m_commonGraph.getY2Title().getText();
    }

    public String getO1AxisTitle() {
        return this.m_commonGraph.getO1Title().getText();
    }

    public String getO2AxisTitle() {
        return this.m_commonGraph.getZTitle().getText();
    }

    public String getX1AxisTitle() {
        return this.m_commonGraph.getX1Title().getText();
    }

    public String getFootnote() {
        return this.m_commonGraph.getFootnote().getText();
    }

    public String getTitle() {
        return this.m_commonGraph.getTitle().getText();
    }

    public String getSubtitle() {
        return this.m_commonGraph.getSubtitle().getText();
    }

    public void setMetadataLabelFlag(boolean changeDefaultKeys) {
        this.m_changeDefaultKeys = changeDefaultKeys;
    }

    public void setMetadataValueSupported(boolean valueSupported) {
        this.m_commonGraph.setMetadataValueSupported(valueSupported);
    }

    @Override
    protected void needRec() {
        this.m_commonGraph.getPFJ().needRecalc();
    }

    @Override
    protected DataAccess getDataAccess() {
        return this.m_commonGraph.getDataAccess();
    }

    @Override
    protected ErrorHandler getErrorHandler() {
        return this.m_commonGraph.getErrorHandler();
    }

    private Object _getLabelForExcelOrDesktop(int edge, int slice) {
        String label = null;
        try {
            int extent = this.getDataAccess().getEdgeExtent(edge);
            if (slice >= extent) {
                return "";
            }
            String memberLabelType = this.m_commonGraph.getMemberMetadataLabelType(edge);
            if (this.m_commonGraph.isMemberMetadataLabelTypeSupported(memberLabelType)) {
                Object metadata = AttributeFormatUtils.getAttributeFormattedSliceValue(this.m_commonGraph, edge, slice, memberLabelType);
                if (metadata == null) {
                    metadata = this.getDataAccess().getSliceLabel(edge, slice, memberLabelType);
                }
                label = metadata.toString();
            }
        }
        catch (DataException e) {
            this.getErrorHandler().error((Throwable)e, this.getClass().getName(), "_getLabelForExcelOrDesktop");
            label = null;
        }
        if (label != null) {
            return label;
        }
        return "";
    }

    private Object _getLabel(int edge, int slice) {
        String label = null;
        boolean bValidSlice = true;
        boolean bMultSlicesPerGroup = false;
        boolean bGroup = edge == 0 && this.m_seriesAreRows || edge == 1 && !this.m_seriesAreRows;
        try {
            int slicesPerGroup;
            if (bGroup && (slicesPerGroup = this.m_commonGraph.getPFJ().getNumColumnsInGroup()) > 1) {
                bMultSlicesPerGroup = true;
                int lastSliceIndex = 0;
                lastSliceIndex = edge == 0 ? this.getColumns() - 1 : this.getRows() - 1;
                if ((slice *= slicesPerGroup) > lastSliceIndex) {
                    bValidSlice = false;
                }
            }
            if (bValidSlice) {
                slice = edge == 0 ? this.getDataAccessColumn(slice) : this.getDataAccessRow(slice);
                String memberLabelType = null;
                memberLabelType = this.m_changeDefaultKeys ? "value" : this.m_commonGraph.getMemberMetadataLabelType(edge);
                if (this.m_commonGraph.isMemberMetadataLabelTypeSupported(memberLabelType)) {
                    label = "";
                    int layerCount = this.getDataAccess().getLayerCount(edge);
                    if (bGroup && layerCount > 1) {
                        int memDepth;
                        int layer;
                        int maxLayer = layerCount - 1;
                        if (bMultSlicesPerGroup) {
                            maxLayer = layerCount - 2;
                        }
                        boolean bOuterLayersHaveSingleMember = true;
                        for (layer = 0; layer < maxLayer; ++layer) {
                            if (this.getDataAccess().getMemberExtent(edge, layer, 0) == this.getDataAccess().getEdgeExtent(edge)) continue;
                            bOuterLayersHaveSingleMember = false;
                        }
                        for (layer = 0; layer <= maxLayer; layer += memDepth) {
                            String member = null;
                            Object metadata = null;
                            if (!this.m_oneGrpLabel && !this.m_stringType && bOuterLayersHaveSingleMember) {
                                if (this.m_commonGraph.isMetadataDateSupported() && !this.m_changeDefaultKeys) {
                                    metadata = this.getDataAccess().getMemberMetadata(edge, layer, slice, "date");
                                }
                                if (metadata == null) {
                                    metadata = this.getDataAccess().getMemberMetadata(edge, layer, slice, "value");
                                }
                                if (metadata != null && !(metadata instanceof Date)) {
                                    metadata = AttributeFormatUtils.getAttributeFormattedMemberMetadataValue(this.m_commonGraph, edge, slice, layer);
                                }
                                if (metadata == null) {
                                    metadata = this.getDataAccess().getMemberMetadata(edge, layer, slice, memberLabelType);
                                }
                            } else {
                                metadata = AttributeFormatUtils.getAttributeFormattedMemberMetadataValue(this.m_commonGraph, edge, slice, layer);
                                if (metadata == null) {
                                    metadata = this.getDataAccess().getMemberMetadata(edge, layer, slice, memberLabelType);
                                }
                            }
                            if (metadata != null && metadata instanceof Date && bOuterLayersHaveSingleMember) {
                                this.m_timeAxisLayer = layer;
                                return metadata;
                            }
                            if (metadata != null) {
                                member = metadata.toString();
                            }
                            if (member != null && member.length() > 0) {
                                label = label.length() > 0 ? label + " " + member : label + member;
                            }
                            memDepth = this.getDataAccess().getMemberDepth(edge, layer, slice);
                        }
                    } else {
                        Object metadata = null;
                        if (bGroup && !this.m_oneGrpLabel && !this.m_stringType) {
                            if (this.m_commonGraph.isMetadataDateSupported() && !this.m_changeDefaultKeys) {
                                metadata = this.getDataAccess().getMemberMetadata(edge, 0, slice, "date");
                            }
                            if (metadata == null) {
                                metadata = this.getDataAccess().getMemberMetadata(edge, 0, slice, "value");
                            }
                            if (metadata != null && !(metadata instanceof Date)) {
                                metadata = AttributeFormatUtils.getAttributeFormattedSliceValue(this.m_commonGraph, edge, slice, memberLabelType);
                            }
                            if (metadata == null) {
                                metadata = this.getDataAccess().getSliceLabel(edge, slice, memberLabelType);
                            }
                        } else {
                            metadata = AttributeFormatUtils.getAttributeFormattedSliceValue(this.m_commonGraph, edge, slice, memberLabelType);
                            if (metadata == null) {
                                metadata = this.getDataAccess().getSliceLabel(edge, slice, memberLabelType);
                            }
                        }
                        if (metadata != null && metadata instanceof Date) {
                            this.m_timeAxisLayer = 0;
                            return metadata;
                        }
                        if (metadata != null) {
                            label = metadata.toString();
                        }
                    }
                }
            }
        }
        catch (DataException e) {
            this.getErrorHandler().error((Throwable)e, this.getClass().getName(), "_getLabel");
            label = null;
        }
        if (label != null) {
            return label;
        }
        return "";
    }

    public int getTimeAxisLayer() {
        return this.m_timeAxisLayer;
    }

    public String getGroupSliceId(int group) {
        int slicesPerGroup;
        int edge = 0;
        if (!this.m_seriesAreRows) {
            edge = 1;
        }
        if ((slicesPerGroup = this.m_commonGraph.getPFJ().getNumColumnsInGroup()) == 1 && this.m_commonGraph.getPFJ().isContinuousTimeAxis() && (this.m_commonGraph.getTimeAxisType() == 3 || this.m_commonGraph.getTimeAxisType() == 6)) {
            slicesPerGroup = 2;
        }
        int startSlice = group * slicesPerGroup;
        int endSlice = startSlice + slicesPerGroup - 1;
        StringBuilder sb = new StringBuilder("");
        for (int i = startSlice; i <= endSlice; ++i) {
            String sliceId;
            if (sb.length() > 0) {
                sb.append(";");
            }
            if ((sliceId = this.getSliceId(edge, i)) == null) continue;
            sb.append(sliceId);
        }
        return sb.toString();
    }

    public String getSeriesSliceId(int series) {
        String sliceId;
        int edge = 1;
        if (!this.m_seriesAreRows) {
            edge = 0;
        }
        if ((sliceId = this.getSliceId(edge, series)) == null) {
            sliceId = "";
        }
        return sliceId;
    }

    public String getSliceId(int edge, int slice) {
        String label = null;
        boolean bValidSlice = true;
        try {
            int lastSliceIndex = 0;
            lastSliceIndex = edge == 0 ? this.getColumns() - 1 : this.getRows() - 1;
            if (slice > lastSliceIndex) {
                bValidSlice = false;
            }
            if (bValidSlice) {
                slice = edge == 0 ? this.getDataAccessColumn(slice) : this.getDataAccessRow(slice);
                String memberLabelType = "value";
                if (this.m_commonGraph.isMemberMetadataLabelTypeSupported(memberLabelType)) {
                    Object metadata = AttributeFormatUtils.getAttributeFormattedSliceValue(this.m_commonGraph, edge, slice, memberLabelType);
                    if (metadata == null) {
                        metadata = this.getDataAccess().getSliceLabel(edge, slice, memberLabelType);
                    }
                    if (metadata != null) {
                        label = metadata.toString();
                    }
                }
            }
        }
        catch (DataException e) {
            this.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getSliceId");
            label = null;
        }
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setXML(ObjectNode node, HashMap map) {
        this.m_jsfHashMap = map;
        try {
            this.setXML(node);
        }
        finally {
            this.m_jsfHashMap = null;
        }
    }

    protected void setXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty(a_totalMeasures);
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_totalMeasures, new Integer(pNode.getValueAsInteger()));
            } else {
                this.m_totalMeasures = pNode.getValueAsInteger();
            }
        }
        if ((pNode = node.getProperty(a_scatterMeasures)) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_scatterMeasures, this.convertStringtoArray2(pNode, 0));
            } else {
                this.convertStringtoArray1(pNode, 0);
            }
        }
        if ((pNode = node.getProperty(a_scatterLabelsMeasures)) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_scatterLabelsMeasures, this.convertStringtoArray2(pNode, 1));
            } else {
                this.convertStringtoArray1(pNode, 1);
            }
        }
        if ((pNode = node.getProperty(a_bubbleMeasures)) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_bubbleMeasures, this.convertStringtoArray2(pNode, 2));
            } else {
                this.convertStringtoArray1(pNode, 2);
            }
        }
        if ((pNode = node.getProperty(a_bubbleLabelsMeasures)) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_bubbleLabelsMeasures, this.convertStringtoArray2(pNode, 3));
            } else {
                this.convertStringtoArray1(pNode, 3);
            }
        }
        if ((pNode = node.getProperty(a_OHLCVMeasures)) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_OHLCVMeasures, this.convertStringtoArray2(pNode, 4));
            } else {
                this.convertStringtoArray1(pNode, 4);
            }
        }
        if ((pNode = node.getProperty(a_OHLCMeasures)) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_OHLCMeasures, this.convertStringtoArray2(pNode, 5));
            } else {
                this.convertStringtoArray1(pNode, 5);
            }
        }
        if ((pNode = node.getProperty(a_HLVMeasures)) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_HLVMeasures, this.convertStringtoArray2(pNode, 6));
            } else {
                this.convertStringtoArray1(pNode, 6);
            }
        }
        if ((pNode = node.getProperty(a_OCVMeasures)) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_OCVMeasures, this.convertStringtoArray2(pNode, 7));
            } else {
                this.convertStringtoArray1(pNode, 7);
            }
        }
        if ((pNode = node.getProperty(a_OCMeasures)) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_OCMeasures, this.convertStringtoArray2(pNode, 8));
            } else {
                this.convertStringtoArray1(pNode, 8);
            }
        }
        if ((pNode = node.getProperty(a_HLMeasures)) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_HLMeasures, this.convertStringtoArray2(pNode, 9));
            } else {
                this.convertStringtoArray1(pNode, 9);
            }
        }
        if ((pNode = node.getProperty(a_HLCMeasures)) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_HLCMeasures, this.convertStringtoArray2(pNode, 10));
            } else {
                this.convertStringtoArray1(pNode, 10);
            }
        }
        if ((pNode = node.getProperty(a_HLCVMeasures)) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_HLCVMeasures, this.convertStringtoArray2(pNode, 11));
            } else {
                this.convertStringtoArray1(pNode, 11);
            }
        }
        if ((pNode = node.getProperty(a_funnelMeasures)) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_funnelMeasures, this.convertStringtoArray2(pNode, 12));
            } else {
                this.convertStringtoArray1(pNode, 12);
            }
        }
    }

    protected ObjectNode getXML(boolean allProperties) {
        ObjectNode node = new ObjectNode(name);
        boolean nodeExists = false;
        if (allProperties || this.m_totalMeasures != this.d_totalMeasures) {
            node.addProperty(a_totalMeasures, this.m_totalMeasures);
            nodeExists = true;
        }
        if (allProperties || this.m_measuresArrays[0] != null) {
            node.addProperty(a_scatterMeasures, this.convertArrayToStr(this.m_measuresArrays[0]));
            nodeExists = true;
        }
        if (allProperties || this.m_measuresArrays[1] != null) {
            node.addProperty(a_scatterLabelsMeasures, this.convertArrayToStr(this.m_measuresArrays[1]));
            nodeExists = true;
        }
        if (allProperties || this.m_measuresArrays[2] != null) {
            node.addProperty(a_bubbleMeasures, this.convertArrayToStr(this.m_measuresArrays[2]));
            nodeExists = true;
        }
        if (allProperties || this.m_measuresArrays[3] != null) {
            node.addProperty(a_bubbleLabelsMeasures, this.convertArrayToStr(this.m_measuresArrays[3]));
            nodeExists = true;
        }
        if (allProperties || this.m_measuresArrays[4] != null) {
            node.addProperty(a_OHLCVMeasures, this.convertArrayToStr(this.m_measuresArrays[4]));
            nodeExists = true;
        }
        if (allProperties || this.m_measuresArrays[5] != null) {
            node.addProperty(a_OHLCMeasures, this.convertArrayToStr(this.m_measuresArrays[5]));
            nodeExists = true;
        }
        if (allProperties || this.m_measuresArrays[6] != null) {
            node.addProperty(a_HLVMeasures, this.convertArrayToStr(this.m_measuresArrays[6]));
            nodeExists = true;
        }
        if (allProperties || this.m_measuresArrays[7] != null) {
            node.addProperty(a_OCVMeasures, this.convertArrayToStr(this.m_measuresArrays[7]));
            nodeExists = true;
        }
        if (allProperties || this.m_measuresArrays[8] != null) {
            node.addProperty(a_OCMeasures, this.convertArrayToStr(this.m_measuresArrays[8]));
            nodeExists = true;
        }
        if (allProperties || this.m_measuresArrays[9] != null) {
            node.addProperty(a_HLMeasures, this.convertArrayToStr(this.m_measuresArrays[9]));
            nodeExists = true;
        }
        if (allProperties || this.m_measuresArrays[10] != null) {
            node.addProperty(a_HLCMeasures, this.convertArrayToStr(this.m_measuresArrays[10]));
            nodeExists = true;
        }
        if (allProperties || this.m_measuresArrays[11] != null) {
            node.addProperty(a_HLCVMeasures, this.convertArrayToStr(this.m_measuresArrays[11]));
            nodeExists = true;
        }
        if (allProperties || this.m_measuresArrays[12] != null) {
            node.addProperty(a_funnelMeasures, this.convertArrayToStr(this.m_measuresArrays[12]));
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    private String convertArrayToStr(int[] measures) {
        if (measures == null) {
            return "";
        }
        StringBuilder measureBuff = new StringBuilder();
        for (int i = 0; i < measures.length; ++i) {
            measureBuff.append(measures[i]);
            if (measures.length - 1 == i) continue;
            measureBuff.append(" ");
        }
        return measureBuff.toString();
    }

    private int[] convertStringtoArray2(PropertyNode pNode, int graphCategory) {
        String str = pNode.getValueAsString();
        int groupSize = this.getGroupSize(graphCategory);
        if (str == null || str.equals("")) {
            return null;
        }
        int[] measures = new int[groupSize];
        StringTokenizer tokens = new StringTokenizer(str, " ", false);
        int i = 0;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            measures[i] = Integer.parseInt(token);
            ++i;
        }
        return measures;
    }

    private void convertStringtoArray1(PropertyNode pNode, int graphCategory) {
        String str = pNode.getValueAsString();
        int groupSize = this.getGroupSize(graphCategory);
        if (str == null) {
            return;
        }
        if (str.equals("")) {
            this.m_measuresArrays[graphCategory] = null;
            if (this.m_graphCategory == graphCategory) {
                this.m_currentArray = null;
                this.m_filterOn = false;
            }
            return;
        }
        int[] measures = this.convertStringtoArray2(pNode, graphCategory);
        int i = measures.length;
        if (i != groupSize) {
            this.getErrorHandler().log("array size is not equal to the Group size", this.getClass().getName(), "setXML(ObjectNode node)");
        } else if (i > this.m_totalMeasures) {
            this.getErrorHandler().log("measure array size is greater than the total number of measures", this.getClass().getName(), "setXML(ObjectNode node)");
        } else {
            this.m_measuresArrays[graphCategory] = measures;
            if (this.m_graphCategory == graphCategory) {
                this.m_currentArray = this.m_measuresArrays[this.m_graphCategory];
                this.m_filterOn = true;
            }
        }
    }
}

