/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.RectangularShape;
import java.awt.image.PixelGrabber;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.FillObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class FillColorObj
extends FillObj {
    private static final long serialVersionUID = 1L;
    private Color m_color;

    public FillColorObj() {
    }

    public FillColorObj(Color c) {
        this.m_color = c;
    }

    @Override
    public void copy(FillObj fo) {
        this.m_color = ((FillColorObj)fo).m_color;
    }

    public boolean equals(Object obj) {
        boolean bEqual;
        if (obj instanceof FillColorObj) {
            FillColorObj fco = (FillColorObj)obj;
            bEqual = this.m_color.equals(fco.m_color);
        } else {
            bEqual = false;
        }
        return bEqual;
    }

    @Override
    public void fillOval(Graphics g, Perspective c, int x, int y, int width, int height) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.m_color);
        g.fillOval(x, y, width, height);
    }

    @Override
    public void fillPolygon(Graphics g, Perspective c, Polygon p) {
        g.setColor(this.m_color);
        g.fillPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    @Override
    public void fillPolygon(Graphics g, Perspective c, GeneralPath p, Rectangle r) {
        g.setColor(this.m_color);
        Graphics2D g2 = (Graphics2D)g;
        g2.fill(p);
    }

    @Override
    public void fillPolygon(Graphics g, Perspective c, Area area) {
        g.setColor(this.m_color);
        Graphics2D g2 = (Graphics2D)g;
        g2.fill(area);
    }

    @Override
    public void fillPolygon(Graphics g, Perspective c, RectangularShape shape) {
        g.setColor(this.m_color);
        Graphics2D g2 = (Graphics2D)g;
        g2.fill(shape);
    }

    @Override
    public void fillPolygon(Graphics g, Perspective c, int[] nXPoints, int[] nYPoints, int nPoints) {
        g.setColor(this.m_color);
        g.fillPolygon(nXPoints, nYPoints, nPoints);
    }

    @Override
    public void fillRect(Graphics g, Perspective c, int x, int y, int width, int height) {
        g.setColor(this.m_color);
        g.fillRect(x, y, width, height);
    }

    @Override
    public void fillText(Graphics g, Perspective c, String szText, Rectangle rBounds, Rectangle rInnerBounds, Color dropShadowColor, Dimension dropShadowOffset, TextStyleObj textStyle, VC vc, Color backgroundColor, int nBackgroundFillType, boolean bPrintingInProgress) {
        g.setColor(this.m_color);
        if (textStyle.getRotationAngle() == 0) {
            textStyle.draw(g, c, szText, rInnerBounds, dropShadowColor, dropShadowOffset, vc);
        } else {
            this.fillTextRotated(g, c, szText, rBounds, dropShadowColor, dropShadowOffset, textStyle, vc, backgroundColor, nBackgroundFillType, bPrintingInProgress);
        }
    }

    public void fillTextRotated(Graphics g, Perspective c, String szText, Rectangle rectBoundsDC, Color dropShadowColor, Dimension dropShadowOffset, TextStyleObj textStyle, VC vc, Color backgroundColor, int nBackgroundFillType, boolean bPrintingInProgress) {
        if (rectBoundsDC.width <= 0 || rectBoundsDC.height <= 0) {
            return;
        }
        Rectangle rTextDC = null;
        rTextDC = !c.isFunnel() && (textStyle.getRotationAngle() == 270 || textStyle.getRotationAngle() == 90) ? new Rectangle(0, 0, rectBoundsDC.height, rectBoundsDC.width) : new Rectangle(0, 0, rectBoundsDC.width, rectBoundsDC.height);
        Rectangle rBoundsDC = new Rectangle(rectBoundsDC.x, rectBoundsDC.y, rectBoundsDC.width, rectBoundsDC.height);
        if (textStyle != null && textStyle.getWordWrap()) {
            Dimension dimTextDC = textStyle.preDraw(g, szText, rTextDC, vc, dropShadowOffset, c.getFontMetricsResolver());
            rTextDC.width = Math.max(rTextDC.width, dimTextDC.width);
            rTextDC.height = Math.max(rTextDC.height, dimTextDC.height);
        }
        if (rTextDC.width <= 1 || rTextDC.height <= 1) {
            return;
        }
        if (!(c.isFunnel() || textStyle.getRotationAngle() != 270 && textStyle.getRotationAngle() != 90)) {
            rBoundsDC.height = rTextDC.width;
            rBoundsDC.width = rTextDC.height;
        }
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform saveXform = g2d.getTransform();
        AffineTransform rotate = new AffineTransform();
        int oldw = rBoundsDC.width;
        int oldh = rBoundsDC.height;
        if (!(c.isFunnel() || textStyle.getRotationAngle() != 270 && textStyle.getRotationAngle() != 90)) {
            int width = rBoundsDC.width;
            rBoundsDC.width = rBoundsDC.height;
            rBoundsDC.height = width;
            rBoundsDC.y = rBoundsDC.y + oldh / 2 - oldw / 2;
            rBoundsDC.x = rBoundsDC.x - oldh / 2 + oldw / 2;
        } else if (c.isChartOrientHorz()) {
            rBoundsDC.y = rBoundsDC.y + oldw / 2 - oldh / 2;
            rBoundsDC.x = rBoundsDC.x - oldw / 2 + oldh / 2;
        }
        if (textStyle.getRotationAngle() == 270) {
            rotate.rotate(Math.toRadians(90.0), rBoundsDC.x + rBoundsDC.width / 2, rBoundsDC.y + rBoundsDC.height / 2);
        } else if (textStyle.getRotationAngle() == 90) {
            rotate.rotate(Math.toRadians(270.0), rBoundsDC.x + rBoundsDC.width / 2, rBoundsDC.y + rBoundsDC.height / 2);
        } else if (textStyle.getRotationAngle() != 0) {
            int rotationAngle = textStyle.getRotationAngle();
            int actualRotationAngle = 360 - rotationAngle;
            if (!c.isChartOrientHorz()) {
                double angle = this.getInclinationAngle(textStyle.getRotationAngle());
                double actualHeight = (double)rBoundsDC.height * Math.sin(Math.toRadians(angle));
                rotate.rotate(Math.toRadians(actualRotationAngle), rBoundsDC.x + rBoundsDC.width / 2, (double)(rBoundsDC.y + rBoundsDC.height) - actualHeight / 2.0);
            } else {
                rotate.rotate(Math.toRadians(actualRotationAngle), rBoundsDC.x + rBoundsDC.width / 2, rBoundsDC.y + rBoundsDC.height / 2);
            }
        }
        g2d.setTransform(rotate);
        textStyle.draw(g2d, c, szText, rBoundsDC, dropShadowColor, dropShadowOffset, vc);
        g2d.setTransform(saveXform);
    }

    private void drawImageJDKPatch(Graphics g, Image img, int x, int y, int nWidth, int nHeight) {
        int[] pixelBuf = new int[nWidth * nHeight];
        PixelGrabber pixelGrab = new PixelGrabber(img, 0, 0, nWidth, nHeight, pixelBuf, 0, nWidth);
        try {
            pixelGrab.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("Interrupted waiting for pixels in drawImageJDKPatch!");
            return;
        }
        if ((pixelGrab.getStatus() & 0x80) != 0) {
            System.err.println("Image fetch aborted or errored in drawImageJDKPatch!");
            return;
        }
        for (int j = 0; j < nHeight; ++j) {
            for (int i = 0; i < nWidth; ++i) {
                int X = x + i;
                int Y = y + j;
                int nPixel = pixelBuf[j * nWidth + i];
                int nAlpha = nPixel >> 24 & 0xFF;
                int nRed = nPixel >> 16 & 0xFF;
                int nGreen = nPixel >> 8 & 0xFF;
                int nBlue = nPixel & 0xFF;
                Color savedColor = g.getColor();
                g.setColor(new Color(nRed, nGreen, nBlue));
                g.drawLine(X, Y, X, Y);
                g.setColor(savedColor);
            }
        }
    }

    private double getInclinationAngle(double rotationAngle) {
        double angle = rotationAngle;
        if (rotationAngle > 0.0 && rotationAngle <= 90.0) {
            angle = rotationAngle;
        } else if (rotationAngle > 90.0 && rotationAngle <= 180.0) {
            angle = 90.0 - (rotationAngle - 90.0);
        } else if (rotationAngle > 180.0 && rotationAngle <= 270.0) {
            angle = rotationAngle - 180.0;
        } else if (rotationAngle > 270.0 && rotationAngle <= 360.0) {
            angle = 90.0 - (rotationAngle - 270.0);
        }
        return angle;
    }

    @Override
    public Color getColor() {
        return this.m_color;
    }

    public void setColor(int r, int g, int b, int a) {
        this.m_color = new Color(r, g, b, a);
    }
}

