/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.legend.shared.util;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import oracle.bali.share.nls.LocaleUtils;
import oracle.dss.legend.shared.LegendListItem;
import oracle.dss.legend.shared.LegendSection;
import oracle.dss.legend.shared.marker.BuiltInMarker;
import oracle.dss.legend.shared.marker.CustomShapeMarker;
import oracle.dss.legend.shared.marker.ImageMarker;
import oracle.dss.legend.shared.marker.LegendMarker;
import oracle.dss.legend.shared.marker.MarkerShape;
import oracle.dss.legend.shared.text.ListLabelText;
import oracle.dss.presutil.FontMetricsResolver;
import oracle.dss.presutil.PresUtils;
import oracle.dss.util.containers.Marker;
import oracle.dss.util.shapes.Container;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Ellipse;
import oracle.dss.util.shapes.Path;
import oracle.dss.util.shapes.Rectangle;

public class LegendUtils {
    public static void addEmptyLegendText(LegendSection section, String emptyText) {
        LegendListItem listItem = LegendUtils.getTextListItem(emptyText);
        section.addUniqueItem(listItem);
    }

    public static LegendListItem getListItem(LegendMarker marker, String labelString) {
        ListLabelText label = new ListLabelText(labelString);
        LegendListItem item = new LegendListItem(marker, label);
        return item;
    }

    public static LegendListItem getBuiltInMarkerListItem(MarkerShape shape, Color color, int pattern, double opacity, String label) {
        BuiltInMarker marker = new BuiltInMarker(shape, color, pattern, opacity);
        return LegendUtils.getListItem(marker, label);
    }

    public static LegendListItem getCustomMarkerListItem(Marker drawableMarker, Color color, int pattern, double opacity, String label) {
        CustomShapeMarker marker = new CustomShapeMarker(drawableMarker, color, pattern, opacity);
        return LegendUtils.getListItem(marker, label);
    }

    public static LegendListItem getImageMarkerListItem(String path, String url, String label) {
        ImageMarker marker = LegendUtils.getImageMarker(path, url);
        return LegendUtils.getListItem(marker, label);
    }

    public static BuiltInMarker getBuiltInMarker(MarkerShape shape, Color color, int pattern, double opacity) {
        BuiltInMarker marker = new BuiltInMarker(shape, color, pattern, opacity);
        return marker;
    }

    public static ImageMarker getImageMarker(String path, String url) {
        ImageMarker imageMarker = new ImageMarker(path, url);
        return imageMarker;
    }

    public static LegendListItem getTextListItem(String labelString) {
        ListLabelText label = new ListLabelText(labelString);
        LegendListItem item = new LegendListItem(label);
        return item;
    }

    public static boolean isBiDiLocale(Locale loc) {
        int directionForLocale = LocaleUtils.getReadingDirectionForLocale((Locale)loc);
        return 2 == directionForLocale;
    }

    public static Color applyOpacity(Color color, double opacity) {
        int opacityInt = new Double(opacity * 255.0).intValue();
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), opacityInt);
    }

    public static void transformDrawables(List<DrawableObject> drawables, AffineTransform transform) {
        for (DrawableObject drawable : drawables) {
            if (drawable instanceof Container) {
                Container container = (Container)drawable;
                LegendUtils.transformDrawables(container.getDrawables(), transform);
                continue;
            }
            Shape shape = drawable.getShape();
            if (drawable.getTransform() != null) {
                shape = drawable.getTransform().createTransformedShape(shape);
            }
            if (transform != null) {
                shape = transform.createTransformedShape(shape);
            }
            drawable.setShape(shape);
            drawable.setTransform(AffineTransform.getTranslateInstance(0.0, 0.0));
        }
    }

    public static Shape scaleAndTranslate(Shape shape, int cx, int cy, double scaleX, double scaleY) {
        int width = (int)(shape.getBounds().getWidth() * scaleX);
        int height = (int)(shape.getBounds().getHeight() * scaleY);
        int x = cx - width / 2;
        int y = cy - height / 2;
        Rectangle2D.Double markerBounds = new Rectangle2D.Double(x, y, width - 1, height - 1);
        double scaleFactorX = ((RectangularShape)markerBounds).getWidth() / (double)shape.getBounds().width;
        double scaleFactorY = ((RectangularShape)markerBounds).getHeight() / (double)shape.getBounds().height;
        AffineTransform scale = AffineTransform.getScaleInstance(scaleFactorX, scaleFactorY);
        Shape marker = scale.createTransformedShape(shape);
        Rectangle2D scaledMarkerBounds = marker.getBounds2D();
        double tx = markerBounds.getCenterX() - scaledMarkerBounds.getCenterX();
        double ty = markerBounds.getCenterY() - scaledMarkerBounds.getCenterY();
        AffineTransform translate = AffineTransform.getTranslateInstance(tx, ty);
        marker = translate.createTransformedShape(marker);
        return marker;
    }

    public static Shape scaleAndTranslateToSize(Shape shape, int cx, int cy, int width, int height) {
        int x = cx - width / 2;
        int y = cy - height / 2;
        Rectangle2D.Double markerBounds = new Rectangle2D.Double(x, y, width - 1, height - 1);
        double scaleFactor = (((RectangularShape)markerBounds).getWidth() + ((RectangularShape)markerBounds).getHeight()) / (double)(shape.getBounds().width + shape.getBounds().height);
        AffineTransform scale = AffineTransform.getScaleInstance(scaleFactor, scaleFactor);
        Shape marker = scale.createTransformedShape(shape);
        Rectangle2D scaledMarkerBounds = marker.getBounds2D();
        double tx = markerBounds.getCenterX() - scaledMarkerBounds.getCenterX();
        double ty = markerBounds.getCenterY() - scaledMarkerBounds.getCenterY();
        AffineTransform translate = AffineTransform.getTranslateInstance(tx, ty);
        marker = translate.createTransformedShape(marker);
        return marker;
    }

    private static Shape _sizeAndTranslate(Shape shape, int cx, int cy, double width, double height) {
        int x = (int)((double)cx - width / 2.0);
        int y = (int)((double)cy - height / 2.0);
        Rectangle2D.Double markerBounds = new Rectangle2D.Double(x, y, width - 1.0, height - 1.0);
        double scaleFactor = (((RectangularShape)markerBounds).getWidth() + ((RectangularShape)markerBounds).getHeight()) / (double)(shape.getBounds().width + shape.getBounds().height);
        AffineTransform scale = AffineTransform.getScaleInstance(scaleFactor, scaleFactor);
        Shape marker = scale.createTransformedShape(shape);
        Rectangle2D scaledMarkerBounds = marker.getBounds2D();
        double tx = markerBounds.getCenterX() - scaledMarkerBounds.getCenterX();
        double ty = markerBounds.getCenterY() - scaledMarkerBounds.getCenterY();
        AffineTransform translate = AffineTransform.getTranslateInstance(tx, ty);
        marker = translate.createTransformedShape(marker);
        return marker;
    }

    public static Marker getBuiltInMarker(String name, int x, int y, double scaleX, double scaleY) {
        Marker m = name.equals("square") ? LegendUtils.getSquareMarker(x, y, scaleX, scaleY) : (name.equals("circle") ? LegendUtils.getCircleMarker(x, y, scaleX, scaleY) : (name.equals("diamond") ? LegendUtils.getDiamondMarker(x, y, scaleX, scaleY) : (name.equals("plus") ? LegendUtils.getPlusMarker(x, y, scaleX, scaleY) : (name.equals("triangleDown") ? LegendUtils.getTriangleDownMarker(x, y, scaleX, scaleY) : (name.equals("triangleUp") ? LegendUtils.getTriangleUpMarker(x, y, scaleX, scaleY) : (name.equals("human") ? LegendUtils.getHumanMarker(x, y, scaleX, scaleY) : null))))));
        return m;
    }

    public static Marker getHumanMarker(int x, int y, double scaleX, double scaleY) {
        Shape human = LegendUtils._sizeAndTranslate(Marker.HUMAN_DEF, x, y, Marker.DEF_SIZE, Marker.DEF_SIZE);
        human = LegendUtils.scaleAndTranslate(human, x, y, scaleX, scaleY);
        Marker marker = new Marker("h");
        marker.add(new Path(human));
        return marker;
    }

    public static Marker getPlusMarker(int x, int y, double scaleX, double scaleY) {
        Marker marker = new Marker("p");
        Polygon polygon = new Polygon();
        int width = (int)(scaleX * (double)Marker.DEF_SIZE);
        int height = (int)(scaleY * (double)Marker.DEF_SIZE);
        int depth = 1;
        boolean done = false;
        int side = Math.max(width, height);
        while (!done) {
            if (side >= (depth += 2) * 3 + 2) continue;
            done = true;
            depth -= 2;
        }
        int halfDepth = (depth + 1) / 2;
        polygon.addPoint(x - halfDepth, y - height / 2);
        polygon.addPoint(x + halfDepth, y - height / 2);
        polygon.addPoint(x + halfDepth, y - halfDepth);
        polygon.addPoint(x + width / 2, y - halfDepth);
        polygon.addPoint(x + width / 2, y + halfDepth);
        polygon.addPoint(x + halfDepth, y + halfDepth);
        polygon.addPoint(x + halfDepth, y + height / 2);
        polygon.addPoint(x - halfDepth, y + height / 2);
        polygon.addPoint(x - halfDepth, y + halfDepth);
        polygon.addPoint(x - width / 2, y + halfDepth);
        polygon.addPoint(x - width / 2, y - halfDepth);
        polygon.addPoint(x - halfDepth, y - halfDepth);
        polygon.addPoint(x - halfDepth, y - height / 2);
        marker.add(new Path(polygon));
        return marker;
    }

    public static Marker getDiamondMarker(int x, int y, double scaleX, double scaleY) {
        Marker marker = new Marker("d");
        int width = (int)(scaleX * (double)Marker.DEF_SIZE);
        int height = (int)(scaleY * (double)Marker.DEF_SIZE);
        Polygon polygon = new Polygon();
        polygon.addPoint(x + width / 2, y);
        polygon.addPoint(x, y - height / 2);
        polygon.addPoint(x - width / 2, y);
        polygon.addPoint(x, y + height / 2);
        marker.add(new Path(polygon));
        return marker;
    }

    public static Marker getSquareMarker(int x, int y, double scaleX, double scaleY) {
        Marker marker = new Marker("s");
        int width = (int)(scaleX * (double)Marker.DEF_SIZE);
        int height = (int)(scaleY * (double)Marker.DEF_SIZE);
        marker.add(new Rectangle(x - width / 2, y - height / 2, width, height));
        return marker;
    }

    public static Marker getTriangleUpMarker(int x, int y, double scaleX, double scaleY) {
        Marker marker = new Marker("tu");
        int width = (int)(scaleX * (double)Marker.DEF_SIZE);
        int height = (int)(scaleY * (double)Marker.DEF_SIZE);
        int skewTip = (int)Math.round((double)height * 0.6);
        int skewBtm = (int)Math.round((double)height * 0.4);
        Polygon polygon = new Polygon();
        polygon.addPoint(x, y - skewTip);
        polygon.addPoint(x + width / 2, y + skewBtm);
        polygon.addPoint(x - width / 2, y + skewBtm);
        polygon.addPoint(x, y - skewTip);
        marker.add(new Path(polygon));
        return marker;
    }

    public static Marker getTriangleDownMarker(int x, int y, double scaleX, double scaleY) {
        Marker marker = new Marker("td");
        int width = (int)(scaleX * (double)Marker.DEF_SIZE);
        int height = (int)(scaleY * (double)Marker.DEF_SIZE);
        int skewTip = (int)Math.round((double)height * 0.6);
        int skewBtm = (int)Math.round((double)height * 0.4);
        Polygon polygon = new Polygon();
        polygon.addPoint(x, y + skewTip);
        polygon.addPoint(x + width / 2, y - skewBtm);
        polygon.addPoint(x - width / 2, y - skewBtm);
        polygon.addPoint(x, y + skewTip);
        marker.add(new Path(polygon));
        return marker;
    }

    public static Marker getCircleMarker(int x, int y, double scaleX, double scaleY) {
        Marker marker = new Marker("c");
        int width = (int)(scaleX * (double)Marker.DEF_SIZE);
        int height = (int)(scaleY * (double)Marker.DEF_SIZE);
        marker.add(new Ellipse(x - width / 2, y - height / 2, width, height));
        return marker;
    }

    public static class TextWrapper {
        private boolean m_textTrunc = true;
        private boolean m_bTruncated = false;
        private Locale m_locale = null;

        public TextWrapper(Locale m_locale) {
            this.m_locale = m_locale;
        }

        public int extractLinesWordWrap(String strText, List strLines, int nMaxWidth, FontMetrics fm, FontMetricsResolver resolver, int stopAtLine) {
            int nNumLines = 0;
            strLines.clear();
            int spaceWidth = resolver.charWidth(' ', fm);
            if (strText != null) {
                int colPos = 0;
                String separators = " \t\n\r\f";
                String line = "";
                StringTokenizer tokenizer = new StringTokenizer(strText, separators, true);
                while (tokenizer.hasMoreTokens()) {
                    boolean firstWord;
                    String word = tokenizer.nextToken();
                    if (separators.indexOf(word) != -1) {
                        if (!word.equals("\n")) continue;
                        if (this.m_textTrunc) {
                            if (!this.truncateText(strLines, line, nMaxWidth, fm, true, resolver, stopAtLine)) continue;
                            return strLines.size();
                        }
                        colPos = 0;
                        strLines.add(line);
                        line = "";
                        continue;
                    }
                    int width = resolver.stringWidth(word, fm);
                    boolean bl = firstWord = line.length() == 0;
                    if (!firstWord) {
                        colPos += spaceWidth;
                    }
                    if ((colPos += width) > nMaxWidth) {
                        if (!firstWord) {
                            if (this.m_textTrunc) {
                                if (this.truncateText(strLines, line, nMaxWidth, fm, true, resolver, stopAtLine)) {
                                    return strLines.size();
                                }
                            } else {
                                strLines.add(line);
                            }
                        }
                        line = word;
                        colPos = width;
                        continue;
                    }
                    if (!firstWord) {
                        line = line + ' ';
                    }
                    line = line + word;
                }
                if (this.m_textTrunc) {
                    if (this.truncateText(strLines, line, nMaxWidth, fm, false, resolver, stopAtLine)) {
                        return strLines.size();
                    }
                } else {
                    strLines.add(line);
                }
            }
            nNumLines = strLines.size();
            return nNumLines;
        }

        private boolean truncateText(List strLines, String line, int nMaxWidth, FontMetrics fm, boolean moreWords, FontMetricsResolver resolver, int stopAtLine) {
            if (strLines.size() == stopAtLine - 1 && moreWords) {
                line = PresUtils.isBIDILocale(this.m_locale) ? "...".concat(line) : line.concat("...");
                this.m_bTruncated = true;
            }
            if (resolver.stringWidth(line, fm) <= nMaxWidth) {
                strLines.add(line);
                return strLines.size() == stopAtLine;
            }
            if (!this.m_bTruncated || !PresUtils.isBIDILocale(this.m_locale)) {
                this.m_bTruncated = true;
                line = PresUtils.truncateText(line, fm, 0, nMaxWidth, resolver, this.m_locale);
            }
            strLines.add(line);
            return strLines.size() == stopAtLine;
        }

        public boolean isTruncated() {
            return this.m_bTruncated;
        }
    }

    public static enum ATTRIBUTE_TYPE {
        COLOR,
        SHAPE,
        PATTERN,
        SCALE_X,
        SCALE_Y,
        OPACITY,
        IMAGE,
        SHAPE_PATH;

    }
}

