/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.sparkChart;

import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.GraphConstants;
import oracle.dss.graph.SampleDataSource;
import oracle.dss.graph.pfj.SparkchartUtils;
import oracle.dss.sparkChart.ReferenceArea;
import oracle.dss.sparkChart.ReferenceLine;
import oracle.dss.sparkChart.ReferenceObject;
import oracle.dss.sparkChart.SparkItem;
import oracle.dss.sparkChart.Threshold;
import oracle.dss.util.DataAccess;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BIParseException;
import oracle.dss.util.xml.BISAXException;

public class CommonSparkChart {
    private final CommonGraph m_graph;
    private final List<ReferenceObject> m_referenceObjects = new ArrayList<ReferenceObject>();
    private Threshold m_threshold;
    private List<SparkItem> m_data;

    public CommonSparkChart() {
        this.m_graph = new CommonGraph();
        this.m_graph.getPFJ().setFormFactor(GraphConstants.FormFactor.SPARKCHART);
    }

    public void setValue(List<SparkItem> data) {
        this.m_data = data;
    }

    private void preRender() {
        this.m_graph.setDataAccess(this.getData());
    }

    private DataAccess getData() {
        if (this.m_data != null) {
            return SparkchartUtils.convertCollectionModelToDataModel(this.m_graph, this.m_data, this.getType());
        }
        return new SampleDataSource(this.m_graph);
    }

    public void exportToPNG(OutputStream os) throws IOException, Exception {
        this.preRender();
        this.m_graph.exportToPNGWithException(os);
    }

    public void exportToSVG(OutputStream os) throws IOException, Exception {
        this.preRender();
        this.m_graph.exportToSVGWithException(os, -1, null);
    }

    public String getXML() {
        return this.m_graph.getXMLAsString();
    }

    public void setXML(String xml) throws BIIOException, BISAXException, BIParseException {
        this.m_graph.setXML(xml, 0);
    }

    public GraphConstants.AxisScaledFromBaseline getAxisScaledFromBaseline() {
        boolean value = this.m_graph.getY1Axis().isAxisAutoScaledFromZero();
        if (value) {
            return GraphConstants.AxisScaledFromBaseline.ON;
        }
        return GraphConstants.AxisScaledFromBaseline.OFF;
    }

    public void setAxisScaledFromBaseline(GraphConstants.AxisScaledFromBaseline value) {
        if (value == GraphConstants.AxisScaledFromBaseline.ON) {
            this.m_graph.getY1Axis().setAxisAutoScaledFromZero(true);
        } else if (value == GraphConstants.AxisScaledFromBaseline.OFF) {
            this.m_graph.getY1Axis().setAxisAutoScaledFromZero(false);
        }
    }

    public Color getBackgroundColor() {
        return this.m_graph.getGraphBackground().getFillColor();
    }

    public void setBackgroundColor(Color color) {
        this.m_graph.getGraphBackground().setFillColor(color);
    }

    public Color getColor() {
        return this.m_graph.getSeries().getDefaultColor();
    }

    public void setColor(Color color) {
        this.m_graph.getSeries().setDefaultColor(color);
    }

    public Dimension getImageSize() {
        return this.m_graph.getImageSize();
    }

    public void setImageSize(Dimension size) {
        this.m_graph.setImageSize(size);
    }

    public EnumSet<GraphConstants.Markers> getMarkers() {
        return this.m_graph.getPFJ().getDefaultMarkers();
    }

    public void setMarkers(EnumSet<GraphConstants.Markers> markers) {
        this.m_graph.getPFJ().setDefaultMarkers(markers);
    }

    public Color getFirstMarkerColor() {
        return this.m_graph.getPFJ().getDefaultMarkerColor(GraphConstants.Markers.FIRST);
    }

    public void setFirstMarkerColor(Color color) {
        this.m_graph.getPFJ().setDefaultMarkerColor(GraphConstants.Markers.FIRST, color);
    }

    public Color getLastMarkerColor() {
        return this.m_graph.getPFJ().getDefaultMarkerColor(GraphConstants.Markers.LAST);
    }

    public void setLastMarkerColor(Color color) {
        this.m_graph.getPFJ().setDefaultMarkerColor(GraphConstants.Markers.LAST, color);
    }

    public Color getHighMarkerColor() {
        return this.m_graph.getPFJ().getDefaultMarkerColor(GraphConstants.Markers.HIGH);
    }

    public void setHighMarkerColor(Color color) {
        this.m_graph.getPFJ().setDefaultMarkerColor(GraphConstants.Markers.HIGH, color);
    }

    public Color getLowMarkerColor() {
        return this.m_graph.getPFJ().getDefaultMarkerColor(GraphConstants.Markers.LOW);
    }

    public void setLowMarkerColor(Color color) {
        this.m_graph.getPFJ().setDefaultMarkerColor(GraphConstants.Markers.LOW, color);
    }

    public String getNoDataErrorText() {
        return this.m_graph.getNoDataErrorText();
    }

    public void setNoDataErrorText(String text) {
        this.m_graph.setNoDataErrorText(text);
    }

    public Type getType() {
        int graphType = this.m_graph.getGraphType();
        return Type.convertIntToEnum(graphType);
    }

    public void setType(Type type) {
        int graphType = Type.convertEnumToInt(type);
        this.m_graph.setGraphType(graphType);
    }

    public ReferenceArea createReferenceArea() {
        ReferenceArea obj = new ReferenceArea(this.m_graph);
        this.m_referenceObjects.add(obj);
        return obj;
    }

    public ReferenceLine createReferenceLine() {
        ReferenceLine obj = new ReferenceLine(this.m_graph);
        this.m_referenceObjects.add(obj);
        return obj;
    }

    public void destroyReferenceObjects() {
        this.m_referenceObjects.clear();
        this.m_graph.destroyReferenceObjects(87);
    }

    public List<ReferenceObject> getReferenceObjects() {
        return Collections.unmodifiableList(this.m_referenceObjects);
    }

    public Threshold getThreshold() {
        if (this.m_threshold == null) {
            this.m_threshold = new Threshold(this.m_graph);
        }
        return this.m_threshold;
    }

    public static enum Type {
        AREA,
        BAR,
        FLOATING_BAR,
        LINE;


        private static int convertEnumToInt(Type type) {
            if (type == BAR) {
                return 17;
            }
            if (type == LINE) {
                return 41;
            }
            if (type == AREA) {
                return 31;
            }
            if (type == FLOATING_BAR) {
                return 95;
            }
            return 17;
        }

        private static Type convertIntToEnum(int type) {
            if (type == 17) {
                return BAR;
            }
            if (type == 41) {
                return LINE;
            }
            if (type == 31) {
                return AREA;
            }
            if (type == 95) {
                return FLOATING_BAR;
            }
            return BAR;
        }
    }
}

