/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.button;

import java.awt.LayoutManager;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.button.ArrowKeyHandler;
import oracle.bali.ewt.layout.EqualColumnLayout;
import oracle.bali.ewt.layout.EqualLayout;
import oracle.bali.ewt.layout.EqualRowLayout;

public class ButtonBar
extends LWComponent
implements Accessible {
    private int _alignment;
    private int _orientation;

    public ButtonBar() {
        this(0);
    }

    public ButtonBar(int orientation) {
        this._setOrientation(orientation);
        ArrowKeyHandler.registerActions(this);
    }

    public void setOrientation(int orientation) {
        if (this._orientation != orientation) {
            int old = this._orientation;
            this._setOrientation(orientation);
            this._setAlignment(this.getAlignment());
            this.firePropertyChange("orientation", old, orientation);
            this.revalidate();
        }
    }

    public int getOrientation() {
        return this._orientation;
    }

    public int getAlignment() {
        return this._alignment;
    }

    public void setAlignment(int newAlignment) {
        if (newAlignment != this._alignment) {
            int old = this._alignment;
            this._alignment = newAlignment;
            this._setAlignment(newAlignment);
            this.firePropertyChange("alignment", old, newAlignment);
            this.revalidate();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleTitledPane();
        }
        return this.accessibleContext;
    }

    private void _setAlignment(int newAlignment) {
        LayoutManager layout = this.getLayout();
        if (layout instanceof EqualLayout) {
            switch (newAlignment) {
                case 1: 
                case 2: 
                case 10: {
                    newAlignment = 0;
                    break;
                }
                case 3: 
                case 4: 
                case 11: {
                    newAlignment = 2;
                    break;
                }
                case 0: {
                    newAlignment = 1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            ((EqualLayout)layout).setLayoutAlignment(newAlignment);
        }
    }

    private void _setOrientation(int newOrientation) {
        this._orientation = newOrientation;
        switch (newOrientation) {
            case 0: {
                this.setLayout(new EqualRowLayout(5));
                break;
            }
            case 1: {
                this.setLayout(new EqualColumnLayout(3));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected class AccessibleTitledPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleTitledPane() {
            super(ButtonBar.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

