/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.ImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.chooser.color.ColorGrid;
import oracle.bali.ewt.chooser.color.ColorPickerUtils;
import oracle.bali.ewt.chooser.color.CustomColorPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;

public class ColorPickerPane
extends LWComponent
implements Accessible {
    public static final int RGB_TOOLTIP = 0;
    public static final int RGB_HEX_TOOLTIP = 1;
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 2;
    public static final String PROPERTY_COLOR_PALETTE = "customColorPalette";
    public static final String PROPERTY_CUSTOM_COLOR_NAMES = "customColorNames";
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    public static final String PROPERTY_DEFAULT_SELECTED = "defaultSelected";
    public static final String PROPERTY_AUTOMATIC_SELECTED = "automaticSelected";
    private static final String _RESOURCE_FILE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _KEY_TITLE = "COLORPICKERPANE.TITLE";
    private static final String _KEY_COLOR_LABEL = "COLORPICKERPANE.COLOR_LABEL";
    private static final String _KEY_DEFAULT = "COLORCHOICE.DEFAULT";
    private static final String _KEY_AUTOMATIC = "COLORCHOICE.AUTOMATIC";
    private static final String _KEY_TRANSPARENT = "COLORCHOICE.NO_COLOR";
    private static final String _KEY_NONE = "COLORCHOICE.NONE";
    private static final String _KEY_CUSTOM_COLOR = "COLORCHOICE.EDIT_COLOR";
    private static final String _KEY_NO_COLOR_TIP = "COLORPALETTE.NO_COLOR";
    private static final String _KEY_DEFAULT_TIP = "COLORCHOICE.DEFAULT_TOOLTIP";
    private static final String _KEY_CUSTOM_TIP = "COLORCHOICE.CUSTOM_TOOLTIP";
    private static final String _ICON_NO_COLOR = "images/trans_icon.gif";
    private static final String _ICON_AUTO = "images/auto_icon.gif";
    private static final String _ICON_DEFAULT = "images/default_icon.gif";
    private static final Color _DEFAULT_COLOR_TO_CHANGE = Color.white;
    private static final int _MIN_COL_COUNT = 5;
    private static final int _MIN_ROW_COUNT = 3;
    private static final int _CUSTOM_ROW_COUNT = 2;
    private static final int _COLOR_LABEL = 1;
    private static final int _DEFAULT_BUTTON = 2;
    private static final int _TRANSPARENT_BUTTON = 3;
    private static final int _PALETTE = 4;
    private static final int _CUSTOM_BUTTON = 5;
    private static final Dimension _EMPTY_SIZE = new Dimension();
    private static final String _TRANSPARENT_NAME = "Transparent_Button";
    private static final String _DEFAULT_NAME = "Default_Button";
    private static final String _AUTOMATIC_NAME = "Automatic_Button";
    private static final String _CUSTOM_NAME = "Custom_Button";
    private static final String _GRID_NAME = "ColorPalette_Grid";
    private static final String _CUSTOM_GRID_NAME = "CustomColorPalette_Grid";
    private static Image _sDefaultButtonImage;
    private static ImageIcon _sAutomaticIcon;
    private static ImageIcon _sTransparentIcon;
    private boolean _initialized;
    private boolean _ignoreEvents;
    private EventHandler _eventHandler = new EventHandler();
    private JLabel _colorLabel;
    private JToggleButton _defaultButton;
    private boolean _defaultSelected;
    private Color _defaultColor;
    private ImageFilter _defaultImageFilter;
    private Color _firstPaletteColor;
    private JToggleButton _automaticButton;
    private boolean _automaticSelected;
    private JToggleButton _transparentButton;
    private boolean _isTransparentLabel = true;
    private ColorGrid _colorGrid;
    private ColorGrid _customGrid;
    private JScrollPane _scrollPane;
    private JButton _customButton;
    private Icon _customIcon;
    private Color _customColor;
    private CustomColorPane _customColorPane;
    private boolean _customPaletteDirty;
    private boolean _customNamesDirty;
    private boolean _updateCustomPalette = true;
    private boolean _updateCustomNames = true;
    private boolean _focusCycleDirty = true;
    private List _focusCycle;
    private Color _selectedColor;

    public ColorPickerPane() {
        this(null, null, null);
    }

    public ColorPickerPane(Color selected) {
        this(null, null, selected);
    }

    public ColorPickerPane(TwoDModel palette, Color selected) {
        this(palette, null, selected);
    }

    public ColorPickerPane(TwoDModel palette, TwoDModel customPalette, Color selected) {
        this._createAndLayoutUI();
        this.setToolTipMode(0);
        this.setColorPalette(palette);
        this.setCustomColorPalette(customPalette);
        this.setSelectedColor(selected);
        this._initialized = true;
    }

    public static int showDialog(Component parent, ColorPickerPane pane) {
        return ColorPickerPane.showDialog(parent, pane, null, false);
    }

    public static int showDialog(Component parent, ColorPickerPane pane, String dialogTitle, boolean resizable) {
        if (pane == null) {
            throw new IllegalArgumentException("ColorPickerPane must be non-null");
        }
        Locale l = LocaleUtils.getDefaultableLocale((Component)pane);
        if (dialogTitle == null) {
            ResourceBundle b = pane._getResourceBundle(l);
            dialogTitle = b.getString(_KEY_TITLE);
        }
        JEWTDialog d = JEWTDialog.createDialog(parent, dialogTitle, 7);
        d.setLocale(l);
        d.setContent(pane);
        d.setCenterOver(parent);
        d.setResizable(resizable);
        d.setInitialFocus(pane._getInitialFocus());
        int ret = d.runDialog() ? 1 : 2;
        d.dispose();
        return ret;
    }

    public void setDefaultAllowed(boolean allowed) {
        if (allowed != this.isDefaultAllowed()) {
            if (allowed) {
                this.setAutomaticAllowed(false);
            }
            if (this._defaultButton == null) {
                this._createAndLayoutDefaultButton();
                this.revalidate();
                this.repaint();
            }
            this._defaultButton.setVisible(allowed);
            this._updateColorLabelFor();
            this._focusCycleDirty = true;
        }
    }

    public boolean isDefaultAllowed() {
        return this._defaultButton != null && this._defaultButton.isVisible();
    }

    public void setDefaultColor(Color color) {
        Color old = this.getDefaultColor();
        this._defaultColor = color;
        if (old == null || !old.equals(color)) {
            if (this._defaultButton != null) {
                this._updateDefaultButtonIcon();
                this._updateButtonTips(2);
            }
            if (this.isDefaultSelected()) {
                this.firePropertyChange(PROPERTY_SELECTED_COLOR, old, this._defaultColor);
            }
        }
    }

    public Color getDefaultColor() {
        if (this._defaultColor == null) {
            TwoDModel colors;
            if (this._firstPaletteColor == null && (colors = this.getColorPalette()) != null && colors.getColumnCount() > 0 && colors.getRowCount() > 0) {
                this._firstPaletteColor = (Color)colors.getData(0, 0);
            }
            return this._firstPaletteColor;
        }
        return this._defaultColor;
    }

    public void setDefaultSelected(boolean selected) {
        if (selected != this.isDefaultSelected()) {
            this._ignoreEvents = true;
            this._setDefaultSelected(selected);
            if (selected) {
                this._setAutomaticSelected(false);
                this._setTransparentSelected(false);
                this._setSelectedColorInPalette(null);
            } else if (this._selectedColor == null) {
                this._setTransparentSelected(true);
            } else {
                this._setSelectedColorInPalette(this._selectedColor);
            }
            this._ignoreEvents = false;
            Color defaultColor = this.getDefaultColor();
            this.firePropertyChange(PROPERTY_SELECTED_COLOR, selected ? this._selectedColor : defaultColor, selected ? defaultColor : this._selectedColor);
        }
    }

    public boolean isDefaultSelected() {
        return this._defaultSelected;
    }

    public void setAutomaticAllowed(boolean allowed) {
        if (allowed != this.isAutomaticAllowed()) {
            if (allowed) {
                this.setDefaultAllowed(false);
            }
            if (this._automaticButton == null) {
                this._createAndLayoutAutomaticButton();
                this.revalidate();
                this.repaint();
            }
            this._automaticButton.setVisible(allowed);
            this._updateColorLabelFor();
            this._focusCycleDirty = true;
        }
    }

    public boolean isAutomaticAllowed() {
        return this._automaticButton != null && this._automaticButton.isVisible();
    }

    public void setAutomaticSelected(boolean selected) {
        if (selected != this.isAutomaticSelected()) {
            this._ignoreEvents = true;
            Color old = this._selectedColor;
            this._selectedColor = null;
            this._setAutomaticSelected(selected);
            if (selected) {
                this._setDefaultSelected(false);
                this._setTransparentSelected(false);
                this._setSelectedColorInPalette(null);
            } else {
                this._setTransparentSelected(true);
            }
            this._ignoreEvents = false;
            this.firePropertyChange(PROPERTY_SELECTED_COLOR, old, this._selectedColor);
        }
    }

    public boolean isAutomaticSelected() {
        return this._automaticSelected;
    }

    public void setTransparentAllowed(boolean allowed) {
        if (allowed != this.isTransparentAllowed()) {
            if (this._transparentButton == null) {
                this._createAndLayoutTransparentButton();
                this.revalidate();
                this.repaint();
            }
            this._transparentButton.setVisible(allowed);
            this._updateColorLabelFor();
            this._focusCycleDirty = true;
        }
    }

    public boolean isTransparentAllowed() {
        return this._transparentButton != null && this._transparentButton.isVisible();
    }

    public void setTransparentLabelUsed(boolean transparent) {
        if (transparent != this.isTransparentLabelUsed()) {
            this._isTransparentLabel = transparent;
            if (this._transparentButton != null) {
                this._updateTransparentText(this._getResourceBundle(null));
            }
        }
    }

    public boolean isTransparentLabelUsed() {
        return this._isTransparentLabel;
    }

    public void setCustomizationAllowed(boolean allowed) {
        if (allowed != this.isCustomizationAllowed()) {
            if (this._customButton == null) {
                this._createAndLayoutCustomButton();
                this.revalidate();
                this.repaint();
            }
            this._customButton.setVisible(allowed);
            if (allowed) {
                this._updateCustomButtonIcon();
                this._updateButtonTips(5);
            }
            this._focusCycleDirty = true;
        }
    }

    public boolean isCustomizationAllowed() {
        return this._customButton != null && this._customButton.isVisible();
    }

    public void setColorPalette(TwoDModel colorPalette) {
        this._colorGrid.setColorPalette(colorPalette);
    }

    public TwoDModel getColorPalette() {
        return this._colorGrid.getColorPalette();
    }

    public void setCustomColorPalette(TwoDModel colorPalette) {
        boolean visible;
        boolean bl = visible = colorPalette != null && colorPalette.getColumnCount() > 0 && colorPalette.getRowCount() > 0;
        if (visible != this._customGrid.isVisible()) {
            this._customGrid.setVisible(visible);
            this._focusCycleDirty = true;
        }
        this._customGrid.setColorPalette(colorPalette);
    }

    public TwoDModel getCustomColorPalette() {
        return this._customGrid.getColorPalette();
    }

    public void setCustomColorNames(TwoDModel colorNames) {
        TwoDModel oldNames = this._customGrid.__getColorNames();
        if (oldNames != colorNames) {
            this._customGrid.__setColorNames(colorNames);
            this._updateCustomNames = true;
            this.firePropertyChange(PROPERTY_CUSTOM_COLOR_NAMES, oldNames, colorNames);
        }
    }

    public TwoDModel getCustomColorNames() {
        return this._customGrid.__getColorNames();
    }

    public String getCustomColorName() {
        if (!this._customGrid.isVisible()) {
            return null;
        }
        TwoDModel colorNames = this.getCustomColorNames();
        if (colorNames != null) {
            Object data;
            int col = this._customGrid.__getSelectedColumn();
            int row = this._customGrid.__getSelectedRow();
            if (col != -1 && row != -1 && col < colorNames.getColumnCount() && row < colorNames.getRowCount() && (data = colorNames.getData(col, row)) instanceof String) {
                return (String)data;
            }
        }
        return null;
    }

    public void setSelectedColor(Color color) {
        this._ignoreEvents = true;
        Color old = this._selectedColor;
        this._selectedColor = color;
        this._setDefaultSelected(false);
        if (this._selectedColor != null) {
            this._setAutomaticSelected(false);
            this._setTransparentSelected(false);
        } else if (!this.isAutomaticSelected()) {
            this._setTransparentSelected(true);
        }
        this._setSelectedColorInPalette(this._selectedColor);
        this._ignoreEvents = false;
        this.firePropertyChange(PROPERTY_SELECTED_COLOR, old, this._selectedColor);
    }

    public Color getSelectedColor() {
        if (this.isDefaultSelected()) {
            return this.getDefaultColor();
        }
        return this._selectedColor;
    }

    public void setToolTipMode(int mode) {
        if (mode != this.getToolTipMode()) {
            this._colorGrid.setToolTipMode(mode);
            this._customGrid.setToolTipMode(mode);
            if (this._defaultButton != null) {
                this._updateButtonTips(2);
            }
            if (this.isCustomizationAllowed()) {
                this._updateButtonTips(5);
            }
        }
    }

    public int getToolTipMode() {
        return this._colorGrid.getToolTipMode();
    }

    public CustomColorPane getCustomColorPane() {
        if (this._customColorPane == null) {
            this._customColorPane = new CustomColorPane();
        }
        this._configureCustomColorPane(this._customColorPane);
        return this._customColorPane;
    }

    public void dispose() {
        if (this._eventHandler == null) {
            return;
        }
        this._colorLabel = null;
        if (this._defaultButton != null) {
            this.__unregisterButtonActions(this._defaultButton);
            this._defaultButton = null;
        }
        if (this._automaticButton != null) {
            this.__unregisterButtonActions(this._automaticButton);
            this._automaticButton = null;
        }
        if (this._transparentButton != null) {
            this.__unregisterButtonActions(this._transparentButton);
            this._transparentButton = null;
        }
        if (this._customButton != null) {
            this.__unregisterCustomButtonActions(this._customButton);
            this._customButton = null;
        }
        this._colorGrid.removePropertyChangeListener(this._eventHandler);
        this._colorGrid.dispose();
        this._colorGrid = null;
        this._customGrid.removePropertyChangeListener(this._eventHandler);
        this._customGrid.dispose();
        this._customGrid = null;
        this._scrollPane = null;
        if (this._customColorPane != null) {
            this._customColorPane.dispose();
            this._customColorPane = null;
        }
        if (this._focusCycle != null) {
            this._focusCycle.clear();
            this._focusCycle = null;
        }
        this._eventHandler = null;
    }

    public void updateUI() {
        super.updateUI();
        if (this._customColorPane != null) {
            SwingUtilities.updateComponentTreeUI(this._customColorPane);
        }
    }

    public void setLayout(LayoutManager layout) {
        throw new IllegalArgumentException("setLayout() not supported");
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (this._colorLabel != null) {
            this._colorLabel.setEnabled(enable);
        }
        if (this._defaultButton != null) {
            this._defaultButton.setEnabled(enable);
        }
        if (this._automaticButton != null) {
            this._automaticButton.setEnabled(enable);
        }
        if (this._transparentButton != null) {
            this._transparentButton.setEnabled(enable);
        }
        this._colorGrid.setEnabled(enable);
        this._customGrid.setEnabled(enable);
        if (this._customButton != null) {
            this._customButton.setEnabled(enable);
        }
    }

    public void addNotify() {
        super.addNotify();
        this._updateLabels(this.getLocale());
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._initialized) {
            this._updateLabels(locale);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleColorPickerPane();
        }
        return this.accessibleContext;
    }

    JLabel __createColorLabel() {
        return new JLabel();
    }

    void __registerButtonActions(JToggleButton toggleButton) {
        toggleButton.addItemListener(this._eventHandler);
    }

    void __unregisterButtonActions(JToggleButton toggleButton) {
        toggleButton.removeItemListener(this._eventHandler);
    }

    void __registerCustomButtonActions(JButton button) {
        button.addActionListener(this._eventHandler);
    }

    void __unregisterCustomButtonActions(JButton button) {
        button.removeActionListener(this._eventHandler);
    }

    JButton __getCustomButton() {
        return this._customButton;
    }

    ColorGrid __getStandardGrid() {
        return this._colorGrid;
    }

    ColorGrid __getCustomGrid() {
        return this._customGrid;
    }

    CustomColorPane __getCustomColorPane() {
        return this.getCustomColorPane();
    }

    void __launchCustomColorPane() {
        CustomColorPane pane = this.__getCustomColorPane();
        if (pane == null) {
            return;
        }
        this._configureCustomColorPane(pane);
        pane.addPropertyChangeListener(this._eventHandler);
        this._customPaletteDirty = false;
        this._customNamesDirty = false;
        if (this.__showPaneInDialog(pane)) {
            TwoDModel customPalette;
            if (this._customPaletteDirty && (customPalette = this.getCustomColorPalette()) != null) {
                ColorPickerUtils.copyModel(pane.getCustomColorPalette(), customPalette);
                this.firePropertyChange(PROPERTY_COLOR_PALETTE, null, customPalette);
            }
            if (this._customNamesDirty) {
                TwoDModel customNames;
                TwoDModel paneCustomNames = pane.getCustomColorNames();
                TwoDModel newNames = customNames = this.getCustomColorNames();
                if (paneCustomNames != null) {
                    int colCount = paneCustomNames.getColumnCount();
                    int rowCount = paneCustomNames.getRowCount();
                    if (customNames == null) {
                        newNames = new ArrayTwoDModel(colCount, rowCount);
                    } else {
                        int cols = customNames.getColumnCount();
                        int rows = customNames.getRowCount();
                        if (colCount > cols || rowCount > rows) {
                            cols = Math.max(cols, colCount);
                            rows = Math.max(rows, rowCount);
                            newNames = new ArrayTwoDModel(cols, rows);
                            ColorPickerUtils.copyModel(customNames, newNames);
                        }
                    }
                    ColorPickerUtils.copyModel(paneCustomNames, newNames);
                }
                if (newNames != customNames) {
                    this.setCustomColorNames(newNames);
                } else {
                    this.firePropertyChange(PROPERTY_CUSTOM_COLOR_NAMES, null, newNames);
                }
            }
            this.setSelectedColor(pane.getSelectedColor());
        }
        pane.removePropertyChangeListener(this._eventHandler);
        this._updateCustomPalette = this._customPaletteDirty;
        this._updateCustomNames = this._customNamesDirty;
    }

    boolean __showPaneInDialog(CustomColorPane pane) {
        return CustomColorPane.showDialog(this, pane) == 1;
    }

    List __getFocusCycle() {
        if (!this._focusCycleDirty && this._focusCycle != null) {
            return this._focusCycle;
        }
        this._focusCycle = new ArrayList(1);
        if (this.isDefaultAllowed()) {
            this._focusCycle.add(this._defaultButton);
        } else if (this.isAutomaticAllowed()) {
            this._focusCycle.add(this._automaticButton);
        }
        if (this.isTransparentAllowed()) {
            this._focusCycle.add(this._transparentButton);
        }
        this._focusCycle.add(this._colorGrid);
        if (this._customGrid.isVisible()) {
            this._focusCycle.add(this._customGrid);
        }
        if (this.isCustomizationAllowed()) {
            this._focusCycle.add(this._customButton);
        }
        this._focusCycleDirty = false;
        return this._focusCycle;
    }

    private void _createAndLayoutUI() {
        super.setLayout(new PaneLayout(5));
        this._createAndLayoutColorLabel();
        this._createAndLayoutGridPanel();
        this._updateColorLabelFor();
    }

    private void _createAndLayoutColorLabel() {
        this._colorLabel = this.__createColorLabel();
        if (this._colorLabel != null) {
            this.add(this._colorLabel);
        }
    }

    private void _updateColorLabelText(ResourceBundle b) {
        String text = b.getString(_KEY_COLOR_LABEL);
        this._colorLabel.setText(StringUtils.stripMnemonic((String)text));
        this._colorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)text));
    }

    private void _updateColorLabelFor() {
        if (this._colorLabel != null) {
            JComponent comp = this._colorGrid;
            if (this.isDefaultAllowed()) {
                comp = this._defaultButton;
            } else if (this.isAutomaticAllowed()) {
                comp = this._automaticButton;
            } else if (this.isTransparentAllowed()) {
                comp = this._transparentButton;
            }
            this._colorLabel.setLabelFor(comp);
        }
    }

    private void _createAndLayoutDefaultButton() {
        this._defaultButton = new ColorToggleButton();
        this._defaultButton.setSelected(this.isDefaultSelected());
        this._defaultButton.setName(_DEFAULT_NAME);
        this._defaultButton.setHorizontalAlignment(10);
        this._updateDefaultText(this._getResourceBundle(null));
        this._updateDefaultButtonIcon();
        this._updateButtonTips(2);
        this.__registerButtonActions(this._defaultButton);
        this.add(this._defaultButton);
    }

    private void _updateDefaultText(ResourceBundle b) {
        String text = b.getString(_KEY_DEFAULT);
        this._defaultButton.setText(StringUtils.stripMnemonic((String)text));
        if (this._colorLabel == null) {
            this._defaultButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        }
    }

    private void _updateDefaultButtonIcon() {
        Icon icon = this._defaultButton.getIcon();
        if (!(icon instanceof ImageIcon)) {
            icon = new ImageIcon();
            this._defaultButton.setIcon(icon);
        }
        if (_sDefaultButtonImage == null) {
            _sDefaultButtonImage = ImageUtils.getImageResource(ColorPickerPane.class, _ICON_DEFAULT);
        }
        if (this._defaultImageFilter == null) {
            this._defaultImageFilter = ColorPickerUtils.createColorFilter(_DEFAULT_COLOR_TO_CHANGE);
        }
        ImageIcon imageIcon = (ImageIcon)icon;
        Image image = _sDefaultButtonImage;
        Color defaultColor = this.getDefaultColor();
        Image filteredImage = ColorPickerUtils.createFilteredImage(image, this._defaultImageFilter, defaultColor);
        imageIcon.setImage(filteredImage);
        Icon disableIcon = this._defaultButton.getDisabledIcon();
        if (!(disableIcon instanceof ImageIcon)) {
            disableIcon = new ImageIcon();
            this._defaultButton.setDisabledIcon(disableIcon);
        }
        ImageIcon disableImageIcon = (ImageIcon)disableIcon;
        disableImageIcon.setImage(ImageUtils.createDisabledImage(filteredImage));
        this._defaultButton.repaint();
    }

    private void _createAndLayoutAutomaticButton() {
        this._automaticButton = new ColorToggleButton();
        this._automaticButton.setSelected(this.isAutomaticSelected());
        this._automaticButton.setName(_AUTOMATIC_NAME);
        this._automaticButton.setHorizontalAlignment(10);
        this._updateAutomaticText(this._getResourceBundle(null));
        if (_sAutomaticIcon == null) {
            _sAutomaticIcon = new ImageIcon(ImageUtils.getImageResource(ColorPickerPane.class, _ICON_AUTO));
        }
        this._automaticButton.setIcon(_sAutomaticIcon);
        this.__registerButtonActions(this._automaticButton);
        this.add(this._automaticButton);
    }

    private void _updateAutomaticText(ResourceBundle b) {
        String text = b.getString(_KEY_AUTOMATIC);
        this._automaticButton.setText(StringUtils.stripMnemonic((String)text));
        if (this._colorLabel == null) {
            this._automaticButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        }
    }

    private void _createAndLayoutTransparentButton() {
        this._transparentButton = new ColorToggleButton();
        this._transparentButton.setSelected(this.getSelectedColor() == null && !this.isAutomaticSelected());
        this._transparentButton.setName(_TRANSPARENT_NAME);
        this._transparentButton.setHorizontalAlignment(10);
        this._updateTransparentText(this._getResourceBundle(null));
        if (_sTransparentIcon == null) {
            _sTransparentIcon = new ImageIcon(ImageUtils.getImageResource(ColorPickerPane.class, _ICON_NO_COLOR));
        }
        this._transparentButton.setIcon(_sTransparentIcon);
        this.__registerButtonActions(this._transparentButton);
        this.add(this._transparentButton);
    }

    private void _updateTransparentText(ResourceBundle b) {
        String text = this.isTransparentLabelUsed() ? b.getString(_KEY_TRANSPARENT) : b.getString(_KEY_NONE);
        this._transparentButton.setText(StringUtils.stripMnemonic((String)text));
        if (this._colorLabel == null) {
            this._transparentButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        }
    }

    private void _createAndLayoutGridPanel() {
        this._colorGrid = new ColorGrid();
        this._colorGrid.setName(_GRID_NAME);
        this._colorGrid.setOpaque(false);
        this._colorGrid.addPropertyChangeListener(this._eventHandler);
        this._customGrid = new ColorGrid(true);
        this._customGrid.setName(_CUSTOM_GRID_NAME);
        this._customGrid.setOpaque(false);
        this._customGrid.addPropertyChangeListener(this._eventHandler);
        JPanel gridPanel = new JPanel(new BorderLayout(0, 5));
        gridPanel.add((Component)this._colorGrid, "West");
        gridPanel.add((Component)this._customGrid, "South");
        gridPanel.setOpaque(false);
        this._scrollPane = new JScrollPane(gridPanel);
        this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this._scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        this._scrollPane.setOpaque(false);
        this._scrollPane.getViewport().setOpaque(false);
        FocusUtils.setFocusable(this._scrollPane.getHorizontalScrollBar(), false);
        FocusUtils.setFocusable(this._scrollPane.getVerticalScrollBar(), false);
        FocusUtils.setFocusable(this._scrollPane, false);
        int colWidth = this._colorGrid.getDefaultColumnWidth();
        int rowHeight = this._colorGrid.getDefaultRowHeight();
        Dimension size = this._colorGrid.convertInnerToOuterSize(colWidth * 5, rowHeight * 3);
        this._scrollPane.getViewport().setMinimumSize(size);
        this.add(this._scrollPane);
    }

    private void _createAndLayoutCustomButton() {
        this._customButton = new CustomButton();
        this._customButton.setName(_CUSTOM_NAME);
        this._updateCustomText(this._getResourceBundle(null));
        this.__registerCustomButtonActions(this._customButton);
        this.add(this._customButton);
    }

    private void _updateCustomText(ResourceBundle b) {
        String text = b.getString(_KEY_CUSTOM_COLOR);
        this._customButton.setText(StringUtils.stripMnemonic((String)text));
        this._customButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
    }

    private void _updateCustomButtonIcon() {
        Color color = this._getCustomColor();
        if (color == null) {
            this._customButton.setIcon(null);
        } else {
            if (this._customIcon == null) {
                this._customIcon = new PainterIcon(this._customButton, ColorPickerUtils.getSelectedColorPainter());
            }
            this._customButton.setIcon(this._customIcon);
        }
    }

    private void _updateButtonTips(int button) {
        if (button != 2 && button != 5) {
            return;
        }
        boolean defaultButton = button == 2;
        Color color = defaultButton ? this.getDefaultColor() : this._getCustomColor();
        Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
        String tipText = null;
        int mode = this.getToolTipMode();
        if (color != null && mode == 1) {
            tipText = ColorUtils.colorToHTML(color).toUpperCase(locale);
        } else {
            ResourceBundle b = this._getResourceBundle(locale);
            if (color == null && defaultButton) {
                tipText = b.getString(_KEY_NO_COLOR_TIP);
            } else if (color != null) {
                String key = defaultButton ? _KEY_DEFAULT_TIP : _KEY_CUSTOM_TIP;
                String text = b.getString(key);
                Object[] args = new Object[]{IntegerUtils.getInteger((int)color.getRed()), IntegerUtils.getInteger((int)color.getGreen()), IntegerUtils.getInteger((int)color.getBlue())};
                tipText = MessageFormat.format(text, args);
            }
        }
        if (defaultButton) {
            this._defaultButton.setToolTipText(tipText);
            this._defaultButton.getAccessibleContext().setAccessibleName(tipText);
        } else {
            this._customButton.setToolTipText(tipText);
            this._customButton.getAccessibleContext().setAccessibleName(tipText);
        }
    }

    private void _updateLabels(Locale locale) {
        if (locale == null) {
            Locale.getDefault();
        }
        ResourceBundle b = this._getResourceBundle(locale);
        if (this._colorLabel != null) {
            this._updateColorLabelText(b);
        }
        if (this._defaultButton != null) {
            this._updateDefaultText(b);
            this._updateButtonTips(2);
        }
        if (this._automaticButton != null) {
            this._updateAutomaticText(b);
        }
        if (this._transparentButton != null) {
            this._updateTransparentText(b);
        }
        if (this._customButton != null) {
            this._updateCustomText(b);
            this._updateButtonTips(5);
        }
        this._colorGrid.setLocale(locale);
        this._customGrid.setLocale(locale);
    }

    private ResourceBundle _getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = LocaleUtils.getDefaultableLocale((Component)this);
        }
        return ResourceBundle.getBundle(_RESOURCE_FILE, locale);
    }

    private Component _getInitialFocus() {
        if (this.isDefaultAllowed() && this.isDefaultSelected()) {
            return this._defaultButton;
        }
        if (this.isAutomaticAllowed() && this.isAutomaticSelected()) {
            return this._automaticButton;
        }
        if (this._selectedColor == null && this.isTransparentAllowed()) {
            return this._transparentButton;
        }
        if (this.isCustomizationAllowed() && this._getCustomColor() != null) {
            return this._customButton;
        }
        if (this._customGrid.isVisible() && this._customGrid.__getSelectedColumn() != -1 && this._customGrid.__getSelectedRow() != -1) {
            return this._customGrid;
        }
        return this._colorGrid;
    }

    private void _setDefaultSelected(boolean selected) {
        if (selected != this.isDefaultSelected()) {
            this._defaultSelected = selected;
            if (this._defaultButton != null) {
                this._defaultButton.setSelected(selected);
            }
            this.firePropertyChange(PROPERTY_DEFAULT_SELECTED, !selected, selected);
        }
    }

    private void _setAutomaticSelected(boolean selected) {
        if (selected != this.isAutomaticSelected()) {
            this._automaticSelected = selected;
            if (this._automaticButton != null) {
                this._automaticButton.setSelected(selected);
            }
            this.firePropertyChange(PROPERTY_AUTOMATIC_SELECTED, !selected, selected);
        }
    }

    private void _setTransparentSelected(boolean selected) {
        if (this._transparentButton != null) {
            this._transparentButton.setSelected(selected);
        }
    }

    private void _setSelectedColorInPalette(Color color) {
        try {
            this._colorGrid.setSelectedColor(color);
            this._customGrid.setSelectedColor(null);
            this._setCustomColor(null);
        }
        catch (IllegalArgumentException e) {
            this._colorGrid.setSelectedColor(null);
            if (this._customGrid.isVisible()) {
                try {
                    this._customGrid.setSelectedColor(color);
                    this._setCustomColor(null);
                }
                catch (IllegalArgumentException ee) {
                    this._customGrid.setSelectedColor(null);
                    this._setCustomColor(color);
                }
            }
            this._setCustomColor(color);
        }
    }

    private void _setCustomColor(Color color) {
        Color old = this._getCustomColor();
        if (old != color) {
            this._customColor = color;
            if (this.isCustomizationAllowed()) {
                this._updateCustomButtonIcon();
                this._updateButtonTips(5);
            }
        }
    }

    private Color _getCustomColor() {
        return this._customColor;
    }

    private void _selectedColorChanged(Object source, boolean selected, Color newColor) {
        if (!this._ignoreEvents) {
            this._ignoreEvents = true;
            Color oldColor = this.getSelectedColor();
            if (selected) {
                if (source == this._defaultButton) {
                    this._setDefaultSelected(true);
                } else {
                    this._setDefaultSelected(false);
                }
                if (source == this._automaticButton) {
                    this._selectedColor = null;
                    this._setAutomaticSelected(true);
                } else {
                    this._setAutomaticSelected(false);
                }
                if (source == this._transparentButton) {
                    this._selectedColor = null;
                    this._setTransparentSelected(true);
                } else {
                    this._setTransparentSelected(false);
                }
                if (source == this._colorGrid) {
                    this._selectedColor = newColor;
                } else {
                    this._colorGrid.setSelectedColor(null);
                }
                if (source == this._customGrid) {
                    this._selectedColor = newColor;
                } else {
                    this._customGrid.setSelectedColor(null);
                }
                this._setCustomColor(null);
                this.firePropertyChange(PROPERTY_SELECTED_COLOR, oldColor, this.getSelectedColor());
            } else if (source instanceof JToggleButton) {
                ((JToggleButton)source).setSelected(true);
            }
            this._ignoreEvents = false;
        }
    }

    private void _configureCustomColorPane(CustomColorPane pane) {
        pane.setLocale(LocaleUtils.getDefaultableLocale((Component)this));
        pane.setToolTipMode(this.getToolTipMode());
        pane.setColorPalette(this.getColorPalette());
        TwoDModel custom = this.getCustomColorPalette();
        if (this._updateCustomPalette) {
            if (custom != null) {
                int columns = custom.getColumnCount();
                int rows = custom.getRowCount();
                ArrayTwoDModel newCustom = new ArrayTwoDModel(columns, rows);
                ColorPickerUtils.copyModel(custom, newCustom);
                custom = newCustom;
            }
            pane.setCustomColorPalette(custom);
            this._updateCustomPalette = false;
        }
        if (this._updateCustomNames) {
            TwoDModel colorNames = this.getCustomColorNames();
            if (colorNames != null) {
                int columns = colorNames.getColumnCount();
                int rows = colorNames.getRowCount();
                ArrayTwoDModel newNames = new ArrayTwoDModel(columns, rows);
                ColorPickerUtils.copyModel(colorNames, newNames);
                colorNames = newNames;
            }
            pane.setCustomColorNames(colorNames);
            this._updateCustomNames = false;
        }
        Color selected = this.getSelectedColor();
        pane.setCurrentColor(selected);
        pane.setSelectedColor(selected);
    }

    private class EventHandler
    implements ItemListener,
    ActionListener,
    PropertyChangeListener {
        private EventHandler() {
        }

        public void itemStateChanged(ItemEvent ie) {
            Object source = ie.getSource();
            boolean selected = ie.getStateChange() == 1;
            ColorPickerPane.this._selectedColorChanged(source, selected, null);
        }

        public void actionPerformed(ActionEvent ae) {
            if (ae.getSource() == ColorPickerPane.this._customButton) {
                ColorPickerPane.this.__launchCustomColorPane();
            }
        }

        public void propertyChange(PropertyChangeEvent pe) {
            String name = pe.getPropertyName();
            Object source = pe.getSource();
            if (source instanceof ColorGrid) {
                Color color;
                if ("model".equals(name)) {
                    if (source == ColorPickerPane.this._colorGrid) {
                        ColorPickerPane.this._firstPaletteColor = null;
                        if (ColorPickerPane.this._defaultColor == null && ColorPickerPane.this._defaultButton != null) {
                            ColorPickerPane.this._updateDefaultButtonIcon();
                            ColorPickerPane.this._updateButtonTips(2);
                        }
                    } else {
                        ColorPickerPane.this._updateCustomPalette = true;
                        ColorPickerPane.this.firePropertyChange(ColorPickerPane.PROPERTY_COLOR_PALETTE, pe.getOldValue(), pe.getNewValue());
                    }
                    ColorPickerPane.this.revalidate();
                    ColorPickerPane.this.repaint();
                } else if (ColorPickerPane.PROPERTY_SELECTED_COLOR.equals(name) && (color = (Color)pe.getNewValue()) != null) {
                    ColorPickerPane.this._selectedColorChanged(source, true, color);
                }
            } else if (source == ColorPickerPane.this._customColorPane) {
                if (ColorPickerPane.PROPERTY_COLOR_PALETTE.equals(name)) {
                    ColorPickerPane.this._customPaletteDirty = true;
                } else if (ColorPickerPane.PROPERTY_CUSTOM_COLOR_NAMES.equals(name)) {
                    ColorPickerPane.this._customNamesDirty = true;
                }
            }
        }
    }

    private class AccessibleColorPickerPane
    extends JComponent.AccessibleJComponent {
        private AccessibleColorPickerPane() {
            super(ColorPickerPane.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COLOR_CHOOSER;
        }
    }

    private class PaneLayout
    implements LayoutManager {
        private int _vGap;

        public PaneLayout(int rowGap) {
            this._vGap = rowGap;
        }

        public void addLayoutComponent(String constr, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this._getSize(parent, true);
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this._getSize(parent, false);
        }

        public void layoutContainer(Container parent) {
            Component custom;
            Dimension paletteSize;
            Component defaultButton;
            Insets insets = parent.getInsets();
            int x = insets.left;
            int y = insets.top;
            int parentWidth = parent.getWidth() - (insets.left + insets.right);
            int parentHeight = parent.getHeight() - (insets.top + insets.bottom);
            Component label = this._getComponent(1);
            if (label != null) {
                Dimension size = label.getPreferredSize();
                label.setBounds(x, y, parentWidth, size.height);
                y += size.height + this._vGap;
            }
            Dimension defaultSize = (defaultButton = this._getComponent(2)) != null ? defaultButton.getPreferredSize() : _EMPTY_SIZE;
            Component transparent = this._getComponent(3);
            Dimension transparentSize = transparent != null ? transparent.getPreferredSize() : _EMPTY_SIZE;
            Component palettes = this._getComponent(4);
            if (palettes instanceof JScrollPane) {
                JScrollPane scroll = (JScrollPane)palettes;
                scroll.setHorizontalScrollBarPolicy(31);
                scroll.setVerticalScrollBarPolicy(21);
            }
            Dimension dimension = paletteSize = palettes != null ? palettes.getPreferredSize() : _EMPTY_SIZE;
            if (palettes instanceof JScrollPane) {
                JScrollPane scroll = (JScrollPane)palettes;
                scroll.setHorizontalScrollBarPolicy(30);
                scroll.setVerticalScrollBarPolicy(20);
            }
            Dimension customSize = (custom = this._getComponent(5)) != null ? custom.getPreferredSize() : _EMPTY_SIZE;
            int width = Math.max(transparentSize.width, defaultSize.width);
            width = Math.max(width, paletteSize.width);
            width = Math.min(width, parentWidth);
            if (defaultButton != null) {
                defaultButton.setBounds(x, y, width, defaultSize.height);
                y += defaultSize.height;
            }
            if (transparent != null) {
                transparent.setBounds(x, y, width, transparentSize.height);
                y += transparentSize.height;
            }
            if (palettes != null) {
                if (defaultButton != null || transparent != null) {
                    y += this._vGap;
                }
                int paletteY = custom == null ? y : y + this._vGap + customSize.height;
                int paletteHeight = parentHeight - paletteY;
                paletteHeight = Math.min(paletteHeight, paletteSize.height);
                palettes.setBounds(x, y, width, paletteHeight);
                y += paletteHeight;
            }
            if (custom != null) {
                x = Math.max(x, x + width - customSize.width);
                custom.setBounds(x, y += this._vGap, customSize.width, customSize.height);
            }
        }

        private Dimension _getSize(Container parent, boolean minimum) {
            Component custom;
            Component palettes;
            Component transparent;
            Component defaultButton;
            Dimension size = new Dimension();
            Component label = this._getComponent(1);
            if (label != null) {
                Dimension d = label.getPreferredSize();
                size.width = Math.max(size.width, d.width);
                size.height += d.height + this._vGap;
            }
            if ((defaultButton = this._getComponent(2)) != null) {
                Dimension d = defaultButton.getPreferredSize();
                size.width = Math.max(size.width, d.width);
                size.height += d.height;
            }
            if ((transparent = this._getComponent(3)) != null) {
                Dimension d = transparent.getPreferredSize();
                size.width = Math.max(size.width, d.width);
                size.height += d.height;
            }
            if ((palettes = this._getComponent(4)) != null) {
                if (defaultButton != null || transparent != null) {
                    size.height += this._vGap;
                }
                if (palettes instanceof JScrollPane) {
                    JScrollPane scroll = (JScrollPane)palettes;
                    scroll.setHorizontalScrollBarPolicy(31);
                    scroll.setVerticalScrollBarPolicy(21);
                }
                Dimension d = palettes.getPreferredSize();
                if (palettes instanceof JScrollPane) {
                    JScrollPane scroll = (JScrollPane)palettes;
                    scroll.setHorizontalScrollBarPolicy(30);
                    scroll.setVerticalScrollBarPolicy(20);
                }
                if (minimum) {
                    Dimension min = palettes.getMinimumSize();
                    d.width = Math.min(d.width, min.width);
                    d.height = Math.min(d.width, min.width);
                }
                size.width = Math.max(size.width, d.width);
                size.height += d.height;
            }
            if ((custom = this._getComponent(5)) != null) {
                size.height += this._vGap;
                Dimension d = custom.getPreferredSize();
                size.width = Math.max(size.width, d.width);
                size.height += d.height;
            }
            Insets insets = parent.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }

        private Component _getComponent(int rowIndex) {
            JComponent c = null;
            switch (rowIndex) {
                case 1: {
                    c = ColorPickerPane.this._colorLabel;
                    break;
                }
                case 2: {
                    c = ColorPickerPane.this.isDefaultAllowed() ? ColorPickerPane.this._defaultButton : (ColorPickerPane.this.isAutomaticAllowed() ? ColorPickerPane.this._automaticButton : null);
                    break;
                }
                case 3: {
                    c = ColorPickerPane.this._transparentButton;
                    break;
                }
                case 4: {
                    c = ColorPickerPane.this._scrollPane;
                    break;
                }
                case 5: {
                    c = ColorPickerPane.this._customButton;
                }
            }
            if (c != null && c.isVisible()) {
                return c;
            }
            return null;
        }
    }

    private class PainterIcon
    implements Icon {
        private Painter _iconPainter;
        private PaintContext _paintContext;

        public PainterIcon(JComponent comp, Painter painter) {
            this._paintContext = new PaintCtxt(comp);
            this._iconPainter = painter;
        }

        public int getIconWidth() {
            return this._iconPainter.getPreferredSize((PaintContext)this._paintContext).width;
        }

        public int getIconHeight() {
            return this._iconPainter.getPreferredSize((PaintContext)this._paintContext).height;
        }

        public void paintIcon(Component comp, Graphics g, int x, int y) {
            Dimension size = this._iconPainter.getPreferredSize(this._paintContext);
            this._iconPainter.paint(this._paintContext, g, x, y, size.width, size.height);
        }

        private class PaintCtxt
        extends JPaintContext {
            public PaintCtxt(JComponent comp) {
                super(comp);
            }

            public Color getPaintForeground() {
                return ColorPickerPane.this._getCustomColor();
            }
        }
    }

    private class CustomButton
    extends JButton {
        private CustomButton() {
        }

        public void updateUI() {
            super.updateUI();
            this.setMargin(ColorPickerUtils.getDefaultButtonMargin());
        }
    }

    private class ColorToggleButton
    extends JToggleButton {
        private ColorToggleButton() {
        }

        public void updateUI() {
            super.updateUI();
            this.setMargin(ColorPickerUtils.getDefaultButtonMargin());
        }
    }
}

