/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeDecoration;
import oracle.bali.ewt.dTree.DTreeDragSource;
import oracle.bali.ewt.dTree.DTreeDropTarget;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemEvent;
import oracle.bali.ewt.dTree.DTreeRange;
import oracle.bali.ewt.dTree.DTreeRootItem;
import oracle.bali.ewt.dTree.DTreeSelection;
import oracle.bali.ewt.dTree.DTreeSelectionManager;
import oracle.bali.ewt.elaf.EWTTreeUI;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextProxy;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.util.IntegerUtils;

public abstract class DTreeBaseItem
extends PaintContextProxy
implements DTreeItem {
    private transient DTreeItem _parent;
    private transient int _index;
    private transient boolean _paintSelected;
    private transient boolean _paintFocused;
    private static final String _CLIENTPROP_EDITOR_KEY = "dTreeBaseItemEditor";
    static final int _ACTION_COUNT = 6;
    static final int _ACTION_ACTIVATE = 0;
    static final int _ACTION_TOGGLE_EXPAND = 1;
    static final int _ACTION_TOGGLE_SELECTED = 2;
    static final int _ACTION_EDIT = 3;
    static final int _ACTION_COMMIT_EDIT = 4;
    static final int _ACTION_CANCEL_EDIT = 5;
    static final String _ACCESSIBILITY_BUNDLE = "oracle.bali.ewt.resource.AccessibilityBundle";
    static final String _LEVEL_LABEL = "DTREEITEM_LEVEL_LABEL";
    static final String _LEVEL_TYPE_LABEL = "DTREEITEM_LEVEL_TYPE_LABEL";
    private transient AccessibleContext _accessibleContext;
    private String _accessibleType;

    public void activate() {
        DTree tree = this.getTree();
        tree.dispatchEvent(new DTreeItemEvent(tree, 2004, this));
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public AccessibleContext getAccessibleContext() {
        if (this._accessibleContext == null) {
            this._accessibleContext = this.createAccessibleContext();
        }
        return this._accessibleContext;
    }

    protected AccessibleContext createAccessibleContext() {
        return new AccessibleItem();
    }

    public String getAccessibleType() {
        return this._accessibleType;
    }

    public void setAccessibleType(String type) {
        if (this._accessibleType != type) {
            String oldName = this._accessibleContext == null ? null : this._accessibleContext.getAccessibleName();
            this._accessibleType = type;
            if (this._accessibleContext != null) {
                this._accessibleContext.firePropertyChange("AccessibleName", oldName, this._accessibleContext.getAccessibleName());
            }
        }
    }

    public DTreeDragSource getDragSource() {
        if (this instanceof DTreeDragSource) {
            return (DTreeDragSource)((Object)this);
        }
        return null;
    }

    public DTreeDropTarget getDropTarget() {
        if (this instanceof DTreeDropTarget) {
            return (DTreeDropTarget)((Object)this);
        }
        return null;
    }

    public Rectangle getEditBounds() {
        DTree tree = this.getTree();
        EWTTreeUI treeUI = tree.getUI();
        return treeUI.getEditBounds(tree, this, this);
    }

    public abstract String getLabel();

    public Dimension getSize() {
        if (this.getParent() == null) {
            return new Dimension(0, 0);
        }
        DTree tree = this.getTree();
        EWTTreeUI treeUI = tree.getUI();
        Painter itemPainter = treeUI.getItemPainter(tree, this);
        return itemPainter.getPreferredSize(this);
    }

    public final int getHeight() {
        return this.getSize().height;
    }

    public int getIndex() {
        return this._index;
    }

    public DTreeItem getItem(int index) {
        return null;
    }

    public DTreeItem getItemAt(int x, int y) {
        if (y < this.getSize().height) {
            return this;
        }
        return null;
    }

    public int getItemCount() {
        return 0;
    }

    public DTreeItem getNextExpandedChild(DTreeItem child) {
        return null;
    }

    public DTreeItem getParent() {
        return this._parent;
    }

    public int getSubTreeHeight() {
        return this.getSize().height;
    }

    public int getSubTreeWidth() {
        return this.getSize().width;
    }

    public int getSubTreeX() {
        return this.getX();
    }

    public int getSubTreeY() {
        return this.getY();
    }

    public DTree getTree() {
        DTreeItem parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getTree();
    }

    public int getX() {
        int depth = 0;
        for (DTreeItem parent = this.getParent(); parent != null; parent = parent.getParent()) {
            ++depth;
        }
        DTree tree = this.getTree();
        if (tree == null) {
            return 0;
        }
        int indentWidth = tree.getIndentWidth();
        int rootIndentWidth = this._getRootIndentWidth(tree, indentWidth);
        if (depth == 0) {
            return rootIndentWidth;
        }
        return (depth - 1) * indentWidth + rootIndentWidth;
    }

    public final int getWidth() {
        return this.getSize().width;
    }

    public boolean isExpandable() {
        return this.getItemCount() > 0;
    }

    public boolean isExpanded() {
        return false;
    }

    public void itemAdded(DTreeItem parent, int index) {
        this._parent = parent;
        this._index = index;
        DTree tree = this.getTree();
        if (tree != null) {
            tree.__fireAccessibleEvent("AccessibleChild", null, this);
        }
    }

    public void itemRemoved() {
        DTree tree = this.getTree();
        if (tree != null) {
            tree.__fireAccessibleEvent("AccessibleChild", this, null);
        }
        this._parent = null;
    }

    public void paint(Graphics g, boolean isSelected, boolean isFocused, int itemWidth, int itemHeight) {
        DTree tree = this.getTree();
        EWTTreeUI treeUI = tree.getUI();
        Painter itemPainter = treeUI.getItemPainter(tree, this);
        this._paintSelected = isSelected;
        this._paintFocused = isFocused;
        Font font = g.getFont();
        Color color = g.getColor();
        g.setColor(this.getPaintForeground());
        g.setFont(this.getPaintFont());
        itemPainter.paint(this, g, 0, 0, itemWidth, itemHeight);
        g.setColor(color);
        g.setFont(font);
    }

    public void processKeyEvent(KeyEvent evt) {
        switch (evt.getID()) {
            case 401: {
                this.keyPressed(evt);
                break;
            }
            case 402: {
                this.keyReleased(evt);
            }
        }
    }

    public void processMouseEvent(MouseEvent evt) {
        switch (evt.getID()) {
            case 501: {
                this.mousePressed(evt);
            }
        }
    }

    public void setExpanded(boolean isExpanded) {
    }

    public void setIndex(int index) {
        this._index = index;
    }

    public Component startEdit() {
        DTree tree = this.getTree();
        if (!this.isEditable() || tree == null) {
            return null;
        }
        JTextField editor = (JTextField)tree.getClientProperty(_CLIENTPROP_EDITOR_KEY);
        if (editor == null) {
            editor = new KeyHandlerEditor();
            editor.setBorder(UIManager.getBorder("Tree.editorBorder"));
            editor.setFont(this.getPaintFont());
            tree.putClientProperty(_CLIENTPROP_EDITOR_KEY, editor);
        }
        editor.setText(this.getLabel());
        editor.selectAll();
        return editor;
    }

    protected Icon getIcon() {
        return null;
    }

    protected boolean isEditable() {
        DTree tree = this.getTree();
        if (tree != null) {
            return tree.isEditable();
        }
        return false;
    }

    protected PaintContext getPaintContext() {
        return this.getTree().getPaintContext();
    }

    protected void keyPressed(KeyEvent evt) {
        switch (evt.getKeyCode()) {
            case 37: {
                if (!this.isExpandable() || !this.isExpanded()) break;
                this.setExpanded(false);
                evt.consume();
                break;
            }
            case 39: {
                if (!this.isExpandable() || this.isExpanded()) break;
                this.setExpanded(true);
                evt.consume();
                break;
            }
            case 10: {
                if (evt.getModifiers() != 0) break;
                evt.consume();
            }
        }
    }

    protected void keyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && evt.getModifiers() == 0) {
            evt.consume();
            this.activate();
            if (this.isExpandable()) {
                this.setExpanded(!this.isExpanded());
            }
        }
    }

    protected void mousePressed(MouseEvent evt) {
        DTree tree = this.getTree();
        int x = evt.getX() + tree.getCanvasOriginX();
        if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() % 2 == 0 && x > 0 && x < this.getSize().width) {
            this.activate();
            if (this.isExpandable()) {
                this.setExpanded(!this.isExpanded());
            }
            evt.consume();
        }
    }

    private int _getDepth() {
        if (this.getTree() == null) {
            return 0;
        }
        DTreeRootItem root = this.getTree().getRoot();
        if (root == null) {
            return 0;
        }
        int depth = -1;
        DTreeItem item = this;
        while (item != root && item != null) {
            item = item.getParent();
            ++depth;
        }
        return depth;
    }

    private int _getRootIndentWidth(DTree tree, int indentWidth) {
        DTreeDecoration decoration = tree.getDecoration();
        ImmInsets insets = decoration.getDecorationInsets(tree);
        if (insets != null) {
            return insets.left;
        }
        return 0;
    }

    protected AccessibleContext accessAccessibleContext() {
        return this._accessibleContext;
    }

    public float getInteriorAlignmentX() {
        return 0.0f;
    }

    public float getInteriorAlignmentY() {
        return 0.5f;
    }

    public Object getPaintData(Object key) {
        if (key == null || key == PaintContext.LABEL_KEY) {
            return this.getLabel();
        }
        if (key == PaintContext.ICON_KEY) {
            return this.getIcon();
        }
        return super.getPaintData(key);
    }

    public int getPaintState() {
        DTree tree = this.getTree();
        PaintContext context = tree.getPaintContext();
        int paintState = context.getPaintState();
        if (this._paintSelected) {
            paintState |= 0x20;
        }
        paintState = this._paintFocused ? (paintState |= 0x40) : (paintState &= 0xFFFFFFBF);
        return paintState;
    }

    private class AccessibleItem
    extends AccessibleContext
    implements AccessibleAction,
    AccessibleSelection,
    AccessibleComponent {
        private AccessibleItem() {
        }

        public String getAccessibleName() {
            String name = this.accessibleName;
            if (name == null || "".equals(name)) {
                String type = DTreeBaseItem.this.getAccessibleType();
                String level = IntegerUtils.getString((int)DTreeBaseItem.this._getDepth());
                String label = DTreeBaseItem.this.getLabel();
                if (label == null) {
                    name = null;
                } else if (type == null) {
                    String text = this._getTranslatedString(DTreeBaseItem._LEVEL_LABEL);
                    MessageFormat form = new MessageFormat(text);
                    Object[] args = new Object[]{level, label};
                    name = form.format(args);
                } else {
                    String text = this._getTranslatedString(DTreeBaseItem._LEVEL_TYPE_LABEL);
                    MessageFormat form = new MessageFormat(text);
                    Object[] args = new Object[]{level, type, label};
                    name = form.format(args);
                }
            }
            return name;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = new AccessibleStateSet();
            DTree tree = DTreeBaseItem.this.getTree();
            DTreeBaseItem item = DTreeBaseItem.this;
            DTreeItem focusItem = tree == null ? null : tree.getFocusedItem();
            states.add(AccessibleState.TRANSIENT);
            states.add(AccessibleState.VISIBLE);
            if (this.isShowing()) {
                states.add(AccessibleState.SHOWING);
            }
            if (tree != null && tree.isEnabled()) {
                states.add(AccessibleState.ENABLED);
            }
            states.add(AccessibleState.FOCUSABLE);
            if (tree != null && focusItem == item) {
                states.add(AccessibleState.FOCUSED);
            }
            states.add(AccessibleState.SELECTABLE);
            if (tree != null && tree.getSelectionManager().isSelected(item)) {
                states.add(AccessibleState.SELECTED);
            }
            if (DTreeBaseItem.this.isExpandable()) {
                states.add(AccessibleState.EXPANDABLE);
            }
            if (DTreeBaseItem.this.isExpanded()) {
                states.add(AccessibleState.EXPANDED);
            } else if (DTreeBaseItem.this.isExpandable()) {
                states.add(AccessibleState.COLLAPSED);
            }
            if (item == focusItem) {
                states.add(AccessibleState.ACTIVE);
            }
            return states;
        }

        public Accessible getAccessibleParent() {
            DTreeItem parent = DTreeBaseItem.this.getParent();
            if (parent != null) {
                return parent;
            }
            return DTreeBaseItem.this.getTree();
        }

        public int getAccessibleIndexInParent() {
            return DTreeBaseItem.this.getIndex();
        }

        public int getAccessibleChildrenCount() {
            return DTreeBaseItem.this.getItemCount();
        }

        public Accessible getAccessibleChild(int index) {
            if (index < 0 || index >= DTreeBaseItem.this.getItemCount()) {
                return null;
            }
            return DTreeBaseItem.this.getItem(index);
        }

        public Locale getLocale() {
            return DTreeBaseItem.this.getTree().getLocale();
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 6;
        }

        public String getAccessibleActionDescription(int i) {
            String key = null;
            switch (i) {
                case 0: {
                    key = "ACTIVATE";
                    break;
                }
                case 1: {
                    key = "TOGGLE_EXPAND";
                    break;
                }
                case 2: {
                    key = "TOGGLE_SELECTED";
                    break;
                }
                case 3: {
                    key = "EDIT";
                    break;
                }
                case 4: {
                    key = "COMMIT_EDIT";
                    break;
                }
                case 5: {
                    key = "CANCEL_EDIT";
                }
            }
            return key == null ? null : this._getTranslatedString(key);
        }

        public boolean doAccessibleAction(int i) {
            boolean performed = false;
            DTree tree = DTreeBaseItem.this.getTree();
            DTreeBaseItem item = DTreeBaseItem.this;
            switch (i) {
                case 0: {
                    DTreeBaseItem.this.activate();
                    performed = true;
                    break;
                }
                case 1: {
                    if (!DTreeBaseItem.this.isExpandable()) break;
                    boolean oldExpanded = DTreeBaseItem.this.isExpanded();
                    DTreeBaseItem.this.setExpanded(!oldExpanded);
                    if (DTreeBaseItem.this.isExpanded() == oldExpanded) break;
                    performed = true;
                    break;
                }
                case 2: {
                    try {
                        tree.getSelectionManager().toggleItem(item);
                    }
                    catch (PropertyVetoException e) {}
                    break;
                }
                case 3: {
                    if (!tree.isEditable()) break;
                    performed = tree.startEdit(item);
                    break;
                }
                case 4: {
                    if (!tree.isEditing()) break;
                    tree.commitEdit();
                    performed = true;
                    break;
                }
                case 5: {
                    if (!tree.isEditing()) break;
                    tree.cancelEdit();
                    performed = true;
                }
            }
            return performed;
        }

        public int getAccessibleSelectionCount() {
            DTree tree = DTreeBaseItem.this.getTree();
            DTreeBaseItem item = DTreeBaseItem.this;
            DTreeSelectionManager selectionManager = tree.getSelectionManager();
            DTreeSelection selection = selectionManager.getSelection();
            int rangeCount = selection.getCount();
            int count = 0;
            for (int i = 0; i < rangeCount; ++i) {
                DTreeRange range = selection.getRange(i);
                if (range.getParent() == item) {
                    count += range.getCount();
                    continue;
                }
                if (count > 0) break;
            }
            return count;
        }

        public Accessible getAccessibleSelection(int index) {
            DTree tree = DTreeBaseItem.this.getTree();
            DTreeBaseItem item = DTreeBaseItem.this;
            DTreeSelectionManager selectionManager = tree.getSelectionManager();
            DTreeSelection selection = selectionManager.getSelection();
            int rangeCount = selection.getCount();
            for (int i = 0; i < rangeCount; ++i) {
                DTreeRange range = selection.getRange(i);
                if (range.getParent() != item) continue;
                int count = range.getCount();
                if (index < count) {
                    return DTreeBaseItem.this.getItem(range.getStartIndex() + index);
                }
                index -= count;
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int index) {
            DTree tree = DTreeBaseItem.this.getTree();
            DTreeBaseItem item = DTreeBaseItem.this;
            DTreeSelectionManager selectionManager = tree.getSelectionManager();
            return selectionManager.isSelected(DTreeBaseItem.this.getItem(index));
        }

        public void addAccessibleSelection(int index) {
            DTreeItem childItem;
            DTree tree = DTreeBaseItem.this.getTree();
            DTreeSelectionManager selectionManager = tree.getSelectionManager();
            if (!selectionManager.isSelected(childItem = DTreeBaseItem.this.getItem(index))) {
                try {
                    selectionManager.toggleItem(childItem);
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
            }
        }

        public void removeAccessibleSelection(int index) {
            DTreeItem childItem;
            DTree tree = DTreeBaseItem.this.getTree();
            DTreeSelectionManager selectionManager = tree.getSelectionManager();
            if (selectionManager.isSelected(childItem = DTreeBaseItem.this.getItem(index))) {
                try {
                    selectionManager.toggleItem(childItem);
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
            }
        }

        public void clearAccessibleSelection() {
            DTree tree = DTreeBaseItem.this.getTree();
            DTreeBaseItem item = DTreeBaseItem.this;
            DTreeSelectionManager selectionManager = tree.getSelectionManager();
            DTreeSelection selection = selectionManager.getSelection();
            int rangeCount = selection.getCount();
            DTreeSelection newSelection = new DTreeSelection();
            for (int i = 0; i < rangeCount; ++i) {
                DTreeRange range = selection.getRange(i);
                if (range.getParent() == item) continue;
                newSelection.addRange(range);
            }
            try {
                selectionManager.setSelection(newSelection);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }

        public void selectAllAccessibleSelection() {
            DTree tree = DTreeBaseItem.this.getTree();
            DTreeSelectionManager selectionManager = tree.getSelectionManager();
            DTreeSelection selection = selectionManager.getSelection();
            DTreeRange range = new DTreeRange(DTreeBaseItem.this, 0, DTreeBaseItem.this.getItemCount());
            selection.addRange(range);
            try {
                selectionManager.setSelection(selection);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }

        public Color getBackground() {
            return DTreeBaseItem.this.getPaintBackground();
        }

        public void setBackground(Color c) {
        }

        public Color getForeground() {
            return DTreeBaseItem.this.getPaintForeground();
        }

        public void setForeground(Color c) {
        }

        public Cursor getCursor() {
            return DTreeBaseItem.this.getTree().getCursor();
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return DTreeBaseItem.this.getPaintFont();
        }

        public void setFont(Font f) {
        }

        public FontMetrics getFontMetrics(Font f) {
            return DTreeBaseItem.this.getFontMetrics(f);
        }

        public boolean isEnabled() {
            return (DTreeBaseItem.this.getPaintState() & 1) == 0;
        }

        public void setEnabled(boolean b) {
        }

        public boolean isVisible() {
            return true;
        }

        public void setVisible(boolean b) {
        }

        public boolean isShowing() {
            DTree tree = DTreeBaseItem.this.getTree();
            if (tree == null) {
                return false;
            }
            return tree.isShowing() && DTree.isItemVisible(DTreeBaseItem.this);
        }

        public boolean contains(Point p) {
            Dimension size = this.getSize();
            if (size == null) {
                return false;
            }
            return p.x >= 0 && p.x < size.width && p.y >= 0 && p.y < size.height;
        }

        public Point getLocationOnScreen() {
            if (this.isShowing()) {
                Point location = DTreeBaseItem.this.getTree().getLocationOnScreen();
                location.x += DTreeBaseItem.this.getX();
                location.y += DTreeBaseItem.this.getY();
                return location;
            }
            return null;
        }

        public Point getLocation() {
            DTreeItem parent = DTreeBaseItem.this.getParent();
            if (parent == null) {
                return new Point(0, 0);
            }
            return new Point(DTreeBaseItem.this.getX() - parent.getX(), DTreeBaseItem.this.getY() - parent.getY());
        }

        public void setLocation(Point p) {
        }

        public Rectangle getBounds() {
            if (!this.isShowing()) {
                return null;
            }
            Dimension d = this.getSize();
            DTreeItem parent = DTreeBaseItem.this.getParent();
            int parentX = 0;
            int parentY = 0;
            if (parent != null) {
                parentX = parent.getX();
                parentY = parent.getY();
            }
            return new Rectangle(DTreeBaseItem.this.getX() - parentX, DTreeBaseItem.this.getY() - parentY, d.width, d.height);
        }

        public void setBounds(Rectangle r) {
        }

        public Dimension getSize() {
            return DTreeBaseItem.this.getSize();
        }

        public void setSize(Dimension d) {
        }

        public Accessible getAccessibleAt(Point p) {
            DTree tree = DTreeBaseItem.this.getTree();
            Point itemPos = this.getLocation();
            DTreeItem child = tree.getItemAt(itemPos.x + p.x, itemPos.y + p.y);
            if (DTree.isItemDescendent(child, DTreeBaseItem.this)) {
                return child;
            }
            return null;
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public void requestFocus() {
            if (this.isFocusTraversable()) {
                DTree tree = DTreeBaseItem.this.getTree();
                tree.requestFocus();
                tree.setFocusedItem(DTreeBaseItem.this);
            }
        }

        public void addFocusListener(FocusListener l) {
        }

        public void removeFocusListener(FocusListener l) {
        }

        private String _getTranslatedString(String key) {
            ResourceBundle bundle = ResourceBundle.getBundle(DTreeBaseItem._ACCESSIBILITY_BUNDLE, LocaleUtils.getDefaultableLocale((Component)DTreeBaseItem.this.getTree()));
            return bundle.getString(key);
        }
    }

    private class KeyHandlerEditor
    extends JTextField {
        private KeyHandlerEditor() {
        }

        public void processComponentKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                e.consume();
            }
        }
    }
}

