/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTextField;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeBaseItem;
import oracle.bali.ewt.dTree.DTreeChildManager;
import oracle.bali.ewt.dTree.DTreeDeferredParent;
import oracle.bali.ewt.dTree.DTreeDeferringParent;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemFactory;
import oracle.bali.ewt.dTree.DTreeRootItem;
import oracle.bali.ewt.dTree.DTreeSparseChildManager;
import oracle.bali.ewt.elaf.EWTTreeUI;
import oracle.bali.ewt.model.EmptyOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.OneDModelEvent;
import oracle.bali.ewt.model.OneDModelListener;

public class DTreeDeferringRoot
extends DTreeBaseItem
implements DTreeDeferringParent,
DTreeRootItem,
OneDModelListener {
    private OneDModel _datasrc;
    private DTreeItemFactory _factory;
    private DTree _tree;
    private DTreeChildManager _childmgr;
    private String _label;
    private Icon _icon;
    private int _y;
    private boolean _expanded;

    public DTreeDeferringRoot(String label, Icon icon, OneDModel model, DTreeItemFactory itemFactory) {
        if (model == null) {
            model = EmptyOneDModel.getOneDModel();
        }
        this._label = label;
        this._icon = icon;
        this._datasrc = model;
        this._factory = itemFactory;
        this._childmgr = this.createChildManager();
        this._datasrc.addModelListener(this);
    }

    public void childExpansionChanged(DTreeItem child) {
        this._childmgr.childExpansionChanged(this, child);
    }

    public boolean commitEdit(Component editor) {
        this.setLabel(((JTextField)editor).getText());
        return true;
    }

    public Object getChildData(int index) {
        return this._datasrc.getData(index);
    }

    public int getChildHeight() {
        DTree tree = this.getTree();
        EWTTreeUI treeUI = tree.getUI();
        return treeUI.getDeferredChildHeight(tree, this.getPaintContext(), this, this.getChildIconHeight());
    }

    public int getChildX(int index) {
        return this._childmgr.getChildX(this, index);
    }

    public int getChildY(int index) {
        return this._childmgr.getChildY(this, index);
    }

    public OneDModel getModel() {
        return this._datasrc;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public DTreeItem getItem(int index) {
        return this._childmgr.getItem(this, index);
    }

    public DTreeItem getItemAt(int x, int y) {
        return this._childmgr.getItemAt(this, x, y);
    }

    public int getItemCount() {
        return this._datasrc.getItemCount();
    }

    public DTreeItemFactory getItemFactory() {
        return this._factory;
    }

    public String getLabel() {
        return this._label;
    }

    public DTreeItem getNextExpandedChild(DTreeItem child) {
        return this._childmgr.getNextExpandedChild(this, child);
    }

    public DTreeItem getNextInstantiatedChild(DTreeItem child) {
        return this._childmgr.getNextInstantiatedChild(this, child);
    }

    public int getSubTreeHeight() {
        if (this.isExpanded()) {
            return this._childmgr.getSubTreeHeight(this);
        }
        return this.getSize().height;
    }

    public int getSubTreeWidth() {
        DTree tree = this.getTree();
        if (tree != null) {
            return tree.getCanvasSize().width - this.getX();
        }
        return 0;
    }

    public DTree getTree() {
        DTreeItem parent = this.getParent();
        if (parent != null) {
            return parent.getTree();
        }
        return this._tree;
    }

    public int getY() {
        return this._y;
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public void layout(int x, int y) {
        this._y = y;
        this._childmgr.layout(this, x, y);
    }

    public void setModel(OneDModel model) {
        if (model == null) {
            model = EmptyOneDModel.getOneDModel();
        }
        OneDModel oldModel = this.getModel();
        int oldCount = this.getItemCount();
        if (oldCount > 0) {
            this.itemsRemoved(new OneDModelEvent(oldModel, 2002, 0, oldCount));
        }
        oldModel.removeModelListener(this);
        this._datasrc = model;
        int newCount = model.getItemCount();
        if (newCount > 0) {
            this.itemsAdded(new OneDModelEvent(model, 2001, 0, newCount));
        }
        model.addModelListener(this);
    }

    public void setExpanded(boolean isExpanded) {
        DTree tree = this.getTree();
        if (isExpanded == this.isExpanded()) {
            return;
        }
        if (!DTreeDeferredParent.__fireExpansionChanging(tree, isExpanded, this)) {
            this._expanded = isExpanded;
            DTreeDeferredParent.__fireExpansionChanged(tree, isExpanded, this);
        }
    }

    public void setIcon(Icon icon) {
        if (icon != this._icon) {
            this._icon = icon;
            DTree tree = this.getTree();
            if (tree != null) {
                tree.itemsInvalidated(this.getParent(), this.getIndex(), 1);
            }
        }
    }

    public void setLabel(String label) {
        if (label != this._label) {
            this._label = label;
            DTree tree = this.getTree();
            if (tree != null) {
                tree.itemsInvalidated(this.getParent(), this.getIndex(), 1);
            }
        }
    }

    public void setTree(DTree tree) {
        this._tree = tree;
    }

    public void itemsAdded(OneDModelEvent evt) {
        DTree tree;
        int startIndex = evt.getStartIndex();
        int count = evt.getItemCount();
        if (this._childmgr != null) {
            this._childmgr.itemsAdded(this, startIndex, count);
        }
        if ((tree = this.getTree()) != null) {
            tree.itemsAdded(this, startIndex, count);
        }
    }

    public void itemsRemoved(OneDModelEvent evt) {
        DTree tree;
        int startIndex = evt.getStartIndex();
        int count = evt.getItemCount();
        if (this._childmgr != null) {
            this._childmgr.itemsRemoved(this, startIndex, count);
        }
        if ((tree = this.getTree()) != null) {
            tree.itemsRemoved(this, startIndex, count);
        }
    }

    public void invalidateItems(OneDModelEvent evt) {
        int startIndex = evt.getStartIndex();
        int count = evt.getItemCount();
        DTree tree = this.getTree();
        if (tree != null) {
            tree.itemsInvalidated(this, startIndex, count);
        }
    }

    protected DTreeChildManager createChildManager() {
        return new DTreeSparseChildManager();
    }

    protected int getChildIconHeight() {
        return 18;
    }
}

