/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import oracle.bali.ewt.dTree.DTreeItem;

public class DTreeRange {
    private DTreeItem _parent;
    private int _start;
    private int _count;

    public DTreeRange(DTreeItem parent, int startIndex, int count) {
        this._parent = parent;
        this._start = startIndex;
        this._count = count;
    }

    public boolean contains(DTreeItem parent, int index) {
        return parent == this._parent && index >= this._start && index < this._start + this._count;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DTreeRange)) {
            return false;
        }
        DTreeRange range = (DTreeRange)obj;
        return range.getParent() == this.getParent() && range.getStartIndex() == this.getStartIndex() && range.getCount() == this.getCount();
    }

    public DTreeItem getParent() {
        return this._parent;
    }

    public int getStartIndex() {
        return this._start;
    }

    public int getCount() {
        return this._count;
    }

    public final boolean isItemDescendent(DTreeItem item) {
        DTreeItem parent = this.getParent();
        while (item != null && item.getParent() != parent) {
            item = item.getParent();
        }
        if (item == null) {
            return false;
        }
        return this.contains(item.getParent(), item.getIndex());
    }
}

