/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.util.ImmInsets;

class WindowsPivotCellBorderPainter
extends AbstractBorderPainter {
    private static final ImmInsets _INSETS = new ImmInsets(2, 2, 2, 2);
    private static final ImmInsets[] _FILL_INSETS = new ImmInsets[]{new ImmInsets(1, 1, 1, 1), new ImmInsets(2, 2, 2, 2)};
    private static BorderPainter _sVertical;
    private static BorderPainter _sHorizontal;
    private boolean _horizontal;

    public static BorderPainter getBorderPainter(boolean horizontal) {
        if (horizontal) {
            if (_sHorizontal == null) {
                _sHorizontal = new WindowsPivotCellBorderPainter(true);
            }
            return _sHorizontal;
        }
        if (_sVertical == null) {
            _sVertical = new WindowsPivotCellBorderPainter(false);
        }
        return _sVertical;
    }

    protected ImmInsets getOwnInsets(PaintContext context) {
        return _INSETS;
    }

    protected ImmInsets getOwnFillInsets(PaintContext context) {
        int state = context.getPaintState();
        int fillIndex = 0;
        if ((state & 2) == 0) {
            ++fillIndex;
        }
        return _FILL_INSETS[fillIndex];
    }

    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        Color savedColor = g.getColor();
        Object data = context.getPaintData(PivotTable.KEY_DRAW_RAISED);
        boolean raised = data instanceof Boolean ? (Boolean)data : true;
        int bottom = y + --height;
        int right = x + --width;
        Color darkShadow = defaults.getColor(LookAndFeel.CONTROL_SHADOW);
        if (raised) {
            Color lightHighLight = defaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
            Color highlight = defaults.getColor(LookAndFeel.CONTROL_HIGHLIGHT);
            g.setColor(lightHighLight);
            g.drawLine(x, y, x, --bottom);
            g.drawLine(x, y, --right, y);
            g.setColor(highlight);
            g.drawLine(++x, ++y, x, --bottom);
            g.drawLine(x, y, --right, y);
        }
        g.setColor(savedColor);
    }

    protected boolean isBorderTransparent(PaintContext context) {
        return false;
    }

    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 1 | 4 | 2 | 0x40 | 0x400 | 0x80;
    }

    private WindowsPivotCellBorderPainter(boolean horizontal) {
        this._horizontal = horizontal;
    }
}

