/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class WindowsSeparatorPainter
extends AbstractPainter {
    private static Painter _sHorizInstance;
    private static Painter _sVertInstance;
    private static final int _WIDTH = 2;
    private static final int _HEIGHT = 2;
    private boolean _isHorizontal;

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if ("HorizInsetSeparatorPainter".equals(key) || "HorizOutsetSeparatorPainter".equals(key)) {
            return WindowsSeparatorPainter._getHorizontalInstance();
        }
        if ("VertInsetSeparatorPainter".equals(key) || "VertOutsetSeparatorPainter".equals(key)) {
            return WindowsSeparatorPainter._getVerticalInstance();
        }
        return null;
    }

    public WindowsSeparatorPainter(boolean isHorizontal) {
        this._isHorizontal = isHorizontal;
    }

    public final Dimension getMinimumSize(PaintContext context) {
        return new Dimension(2, 2);
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color savedColor = g.getColor();
        UIDefaults defaults = context.getPaintUIDefaults();
        Color shadow = defaults.getColor(LookAndFeel.CONTROL_SHADOW);
        Color lightHighlight = defaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
        g.setColor(shadow);
        int endX = x;
        int endY = y;
        int xIncrement = 0;
        int yIncrement = 0;
        if (this._isHorizontal) {
            y += (height - 2) / 2;
            endX = x + width - 1;
            yIncrement = 1;
        } else {
            x += (width - 2) / 2;
            endY = y + height - 1;
            xIncrement = 1;
        }
        g.setColor(shadow);
        g.drawLine(x, y, endX, endY);
        g.setColor(lightHighlight);
        g.drawLine(x += xIncrement, y += yIncrement, endX += xIncrement, endY += yIncrement);
        g.setColor(savedColor);
    }

    private static Painter _getHorizontalInstance() {
        if (_sHorizInstance == null) {
            _sHorizInstance = new WindowsSeparatorPainter(true);
        }
        return _sHorizInstance;
    }

    private static Painter _getVerticalInstance() {
        if (_sVertInstance == null) {
            _sVertInstance = new WindowsSeparatorPainter(false);
        }
        return _sVertInstance;
    }
}

