/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.graphics;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import oracle.bali.ewt.graphics.HitTestMask;
import oracle.bali.ewt.graphics.ImageLoader;
import oracle.bali.ewt.graphics.ImageSet;
import oracle.bali.ewt.graphics.TransparencyTester;

public class ImageStrip
implements ImageSet {
    private static final int _COMPUTING_TRANSPARENCY = -1;
    private static final int _IS_NOT_TRANSPARENT = 0;
    private static final int _IS_TRANSPARENT = 1;
    private transient boolean _imageLoaded;
    private transient int _width;
    private transient int _height;
    private transient int _isTransparent = -1;
    private int _suppliedImagesMask;
    private Image _baseImage;
    private transient byte[] _imageIndices;
    private transient HitTestMask _hitTester;

    public ImageStrip(Image baseImage) {
        this(baseImage, 0);
    }

    public ImageStrip(Image baseImage, int suppliedImagesMask) {
        if (baseImage == null) {
            throw new IllegalArgumentException();
        }
        this._baseImage = baseImage;
        this._suppliedImagesMask = suppliedImagesMask;
    }

    public Dimension getSize() {
        this._loadImageIfNecessary();
        return new Dimension(this._width, this._height);
    }

    public void paintImage(int imageState, Graphics g, int x, int y, ImageObserver observer) {
        this._loadImageIfNecessary();
        byte imageIndex = this._imageIndices[imageState & 0x3F];
        g.drawImage(this._baseImage, x, y, x + this._width, y + this._height, 0, this._height * imageIndex, this._width, this._height * (imageIndex + 1), observer);
    }

    public boolean contains(int x, int y) {
        if (x >= 0 && y >= 0 && x < this._width && y < this._height) {
            if (this.isTransparent()) {
                if (this._hitTester == null) {
                    byte imageIndex = this._imageIndices[16];
                    this._hitTester = new HitTestMask(new FilteredImageSource(this._baseImage.getSource(), new CropImageFilter(0, this._height * imageIndex, this._width, this._height)));
                }
                return this._hitTester.contains(x, y);
            }
            return true;
        }
        return false;
    }

    public boolean isTransparent() {
        if (this._isTransparent == -1) {
            TransparencyTester transparencyTester = new TransparencyTester(new FilteredImageSource(this._baseImage.getSource(), new CropImageFilter(0, 0, this._width, this._height)));
            this._isTransparent = transparencyTester.isTransparent() ? 1 : 0;
        }
        return this._isTransparent != 0;
    }

    public int getAvailableImageFlags() {
        return this._suppliedImagesMask;
    }

    private void _loadImageIfNecessary() {
        if (!this._imageLoaded) {
            Image baseImage = this._baseImage;
            ImageLoader loader = new ImageLoader(baseImage);
            loader.start();
            this._imageLoaded = loader.waitFor();
            int suppliedImagesMask = this._suppliedImagesMask;
            int numImages = ImageStrip._numImages(suppliedImagesMask);
            this._width = baseImage.getWidth(loader);
            this._height = baseImage.getHeight(loader) / numImages;
            int notMask = ~suppliedImagesMask;
            this._imageIndices = new byte[64];
            byte imageIndex = 0;
            for (int imageSetIndex = 0; imageSetIndex < 64; imageSetIndex = (int)((byte)(imageSetIndex + 1))) {
                if (((notMask ^ imageSetIndex) & notMask) == notMask) {
                    this._imageIndices[imageSetIndex] = imageIndex;
                    imageIndex = (byte)(imageIndex + 1);
                    continue;
                }
                this._imageIndices[imageSetIndex] = this._imageIndices[imageSetIndex & suppliedImagesMask];
            }
        }
    }

    private static int _numImages(int mask) {
        int numBits = 0;
        while (mask != 0) {
            if ((mask & 1) != 0) {
                ++numBits;
            }
            mask >>= 1;
        }
        return 1 << numBits;
    }
}

